#define NAND_TO_BUF  0
#define BUF_TO_NAND  1

#define MODULE Module_0
#define APB_DMA 0
#define TRUE                    1
#define FALSE                   0


#define ptflash	((volatile FTNAND020_T *)NAND_CONTROL_BASE)
typedef unsigned int BOOLEAN; 
typedef unsigned char INT8U;    /* 1 byte */
typedef unsigned short INT16U;  /* 2 bytes */
typedef unsigned int INT32U;    /* 4 bytes */
typedef signed char INT8S;              /* 1 byte */
typedef signed short INT16S;            /* 2 bytes */
typedef signed int INT32S;              /* 4 bytes */
typedef unsigned int    UINT32;
typedef int     INT32;
typedef unsigned short  UINT16;
typedef short   INT16;        
typedef unsigned char   UINT8;
typedef char    INT8;         
typedef unsigned char   BOOL; 


typedef struct {
	INT32U ST;				// 0x00
	INT32U CTRL;				// 0x04
	INT32U LOWADDR;				// 0x08
	INT32U HIGHADDR;			// 0x0C
	INT32U CFG1;				// 0x10
	INT32U CFG2;				// 0x14
	INT32U CFG3;				// 0x18
	INT32U CFG4;				// 0x1C
	INT32U DATA;				// 0x20
	INT32U DATA_LENGTH;			// 0x24
	INT32U DMA_FIFO;			// 0x28
	INT32U AC_TIMING1;			// 0x2C
	INT32U AC_TIMING2;			// 0x30
	INT32U IOBUS_CTRL;			// 0x34
	INT32U SF_RST;				// 0x38
	INT32U INTCLR;				// 0x3C
	INT32U INTENABLEMASK;			// 0x40

	INT32U REVERSED44;			// 0x44
	INT32U REVERSED48;			// 0x48
	INT32U REVERSED4C;			// 0x4C

	INT32U MAINAREAECC1;			// 0x50
	INT32U MAINAREAECC2;			// 0x54
	INT32U MAINAREAECC3;			// 0x58
	INT32U MAINAREAECC4;			// 0x5C
	INT32U LSNECC1;				// 0x60
	INT32U LSNECC2;				// 0x64
	INT32U LSNECC3;				// 0x68
	INT32U LSNECC4;				// 0x6C

	INT32U REVERSED70;			// 0x70
	INT32U REVERSED74;			// 0x74
	INT32U REVERSION;			// 0x78
	INT32U CONFIG;				// 0x7C      
} FTNAND020_T;


typedef struct {
	INT32U u16blocks_in_disk;			// Block number in Card
	INT32U u8blocks_in_disk_exp2;		// Block number in Card
	INT32U u8pages_in_block;			// Pages/blk
	INT32U u8pages_in_block_exp2;		// Pages/blk

	INT32U u16bytes_in_page;			// Bytes/page
	INT32U u8bytes_in_page_exp2;		// Bytes/page
} NANDStruct;


//global variables //-cwz (
//NANDStruct tCurrentFlash;
//INT32U u32NextNANDstartAddr;
//global variables //-cwz )

#define mNANDIs2KPage()				(tCurrentFlash.u8bytes_in_page_exp2 == 11)

//extern UINT32 Module_base;
//extern UINT32 current_module;
//extern UINT32 Disable_spare_rw;  // disable read/write spare area
//extern UINT32 Use_APBDMA;

#define BIT0			                0x00000001
#define BIT1			                0x00000002
#define BIT2			                0x00000004
#define BIT3			                0x00000008
#define BIT4			                0x00000010
#define BIT5			                0x00000020
#define BIT6			                0x00000040
#define BIT7			                0x00000080

#define BIT8			                0x00000100
#define BIT9			                0x00000200
#define BIT10			                0x00000400
#define BIT11			                0x00000800
#define BIT12			                0x00001000
#define BIT13			                0x00002000
#define BIT14			                0x00004000
#define BIT15			                0x00008000	

#define BIT16			                0x00010000
#define BIT17			                0x00020000
#define BIT18			                0x00040000
#define BIT19			                0x00080000
#define BIT20			                0x00100000
#define BIT21			                0x00200000
#define BIT22			                0x00400000
#define BIT23			                0x00800000	
#define BIT24			                0x01000000
#define BIT25			                0x02000000
#define BIT26			                0x04000000
#define BIT27			                0x08000000
#define BIT28			                0x10000000
#define BIT29			                0x20000000
#define BIT30			                0x40000000
#define BIT31			                0x80000000

/*  -------------------------------------------------------------------------------
 *   SMC Controllers
 *  -------------------------------------------------------------------------------
 */

/* SMC Register Offset Definitions */
#define NANDC_CONTROL_STATUS            0x0
#define NANDC_ACCESS_CONTROL            0x4
#define NANDC_ADDRESS_LOW               0x8    //modified
#define NANDC_ADDRESS_HIGH              0xC    //new
#define NANDC_MODULE0_CONFIG            0x10
#define NANDC_MODULE1_CONFIG            0x14
#define NANDC_MODULE2_CONFIG            0x18  
#define NANDC_MODULE3_CONFIG            0x1C  
#define NANDC_DATA                      0x20
#define NANDC_DATA_LEN                  0x24
#define NANDC_DMA_FIFO		            0x28  
#define NANDC_AC1_CONTROL               0x2C  
#define NANDC_AC2_CONTROL               0x30  
#define NANDC_IO_BUS                    0x34  //new
#define NANDC_SW_RESET                  0x38
#define NANDC_INT_CLEAR                 0x3C  
#define NANDC_INT                       0x40  
#define NANDC_ECC                       0x50  
#define NANDC_LSN_ECC                   0x60  
#define NANDC_REVISION                  0x78  
#define NANDC_CONFIG               	    0x7C  

/* SMC Controller Status register 0x00*/
#define NANDC_INT_DN                    BIT31
#define NANDC_MASK_ECC_ERR              BIT30
#define NANDC_MASK_CMD                  BIT29
#define NANDC_MASK_LSN_ECC_ERR          BIT28  //new
#define NANDC_MASK_FIFO                 BIT27
#define NANDC_ECC_ERR_INTR              BIT26
#define NANDC_COMPLETE_INTR             BIT25
#define NANDC_LSN_ECC_ERR_INTR          BIT24  //new
#define NANDC_FIFO_INTR                 BIT23
#define NANDC_NAND_READ_STATUS          0x0000FF00
//#define NANDC_READ_STATUS_FAIL          BIT7
#define NANDC_BUSY_B                    BIT6
#define NANDC_FIFO_THRESH               BIT5
#define NANDC_CE                        BIT4
#define NANDC_FIFO_FULL                 BIT3
#define NANDC_FIFO_EMPTY                BIT2
#define NANDC_ALE                       BIT1
#define NANDC_CLE                       BIT0  

/* SMC Access Control Register 0x04 */
#define mNANDCtl_CmdTy16b(value)  	(((INT32U)value) << 16)
#define NANDC_CMD                       BIT15		// It is cmd_launch on datasheet
//#define NANDC_RANDOM_CMD			    BIT14  //remove
//#define NANDC_BUSY_READ_STATUS		BIT13  //remove
#define NANDC_SKIP_BUSY                 BIT14  //new
#define NANDC_SPARE_RW_DISABLE          BIT13  //new
#define NANDC_WP                        BIT12
#define NANDC_CMD_FOR_BUSY              BIT8  //new
#define NANDC_COM_TYPE                  0xFFFF0000
#define NANDC_BUSY_COM_TYPE             0x000000FF

#define NAND_CTL_TIMEOUT_CMD_FINISH   	0xFF
#define NAND_CTL_TIMEOUT_BUSY         	0xFF
#define NAND_CTL_TIMEOUT_NOT_EMPTY    	0x80

//normal command
#define NANDC_READ1_00_S                          (0x00000000) //small : read 1(00)
#define NANDC_READ1_01_S                          (0x01000000) //small : read 1(01) 
#define NANDC_READ_L                              (0x00300000) //large : read
#define NANDC_READ_CACHE_START_L                  (0x00310000) //large : read cache start
#define NANDC_READ_COPYBACK_L                     (0x00350000) //large : read for copy back
#define NANDC_COPYBACK_PHASE1_T_S                 (0x008A0000) //small : copy back program phase 1 (TRUE)
#define NANDC_COPYBACK_PHASE1_D_S                 (0x038A0000) //small : copy back program phase 1 (Dummy)
#define NANDC_RANDOM_DATA_OUTPUT_L                (0x05E00000) //large : Random Data Output
#define NANDC_UNLOCK_START_AREA                   (0x23000000) //Unlock Start Area
#define NANDC_UNLOCK_END_AREA                     (0x24000000) //Unlock End Area
#define NANDC_LOCK_BLOCK                          (0x2A000000) //Lock Block
#define NANDC_LOCK_TIGHT                          (0x2C000000) //Lock Tight
#define NANDC_READ_CAHE_EXIT_L                    (0x34000000) //large : Read Cache Exit
#define NANDC_READ2_S                             (0x50000000) //small : Read 2
#define NANDC_TWO_PLANE_BLOCK_ERASE_L             (0x60600000) //large : Two-Plane Block Erase
#define NANDC_MULTI_PLANE_BLOCK_ERASE_S           (0x60610000) //small : Multi-Plane Block Erase
#define NANDC_BLOCK_ERASE                         (0x60D00000) //Block Erase
//v2.0 #define NANDC_READ_STATUS                         (0x70000000) //Read Status
//v2.0 #define NANDC_READ_MULTI_PLANE_STATUS_S           (0x71000000) //small : Read Multi-Plane Status
//v2.0 #define NANDC_EXTENDED_READ_STATUS72_L            (0x72000000) //large : Extended Read Status
//v2.0 #define NANDC_EXTENDED_READ_STATUS73_L            (0x73000000) //large : Extended Read Status
//v2.0 #define NANDC_EXTENDED_READ_STATUS74_L            (0x74000000) //large : Extended Read Status
//v2.0 #define NANDC_EXTENDED_READ_STATUS75_L            (0x75000000) //large : Extended Read Status
#define NANDC_READ_LOCK_STATUS                    (0x7A000000) //Read Lock Status
//v2.0 #define NANDC_READ_EDC_STATUS_L                   (0x7B000000) //large : Read EDC Status
#define NANDC_PAGE_PROGRAM_RANDOM_IN_L            (0x80000000) //large : Page Program for random IN
#define NANDC_PROGRAM_PAGE                        (0x80100000) //Page Program
#define NANDC_TWO_PLANE_PAGE_PROGRAM_PHASE1_L     (0x80110000) //large : Two-Plane Page Program phase 1, small : Page Program (dummy)
#define NANDC_PAGE_PROGRAM_D_S                    (0x80110000)
#define NANDC_CACHE_PROGRAM_L                     (0x80150000) //large : Cache Program, small : Multi Block Program
#define NANDC_MULTI_BLOCK_PROGRAM_S               (0x80150000)
#define NANDC_TWO_PLANE_PAGE_PROGRAM_PHASE_2_L    (0x81100000) //large : Two-Plane Page Program phase 2
#define NANDC_TWO_PLANE_COPYBACK_PROGRAM_PHASE2_L (0x81110000) //large : Two-Plane Copy-Back Program phase 2
#define NANDC_RANDOM_DATA_INPUT_L                 (0x85000000) //large : Random Data Input
#define NANDC_COPYBACK_PROGRAM_FIRST_L            (0x85010000) //JOHN ADD
#define NANDC_COPYBACK_PROGRAM_L                  (0x85100000) //large : Copy-Back Program/Last Random Data Input
#define NANDC_TWO_PLANE_COPYBACK_PROGRAM_PHASE1_L (0x85110000) //large : Two-Plane Copy-Back Program phase 1
#define NANDC_COPYBACK_PROGRAM_FINAL_L            (0x85120000) //JOHN ADD
#define NANDC_COPY_PROGRAM_PHASE2_T_S             (0x8A000000) //small : Copy-Back Program phase 2 (True)
#define NANDC_COPY_PROGRAM_PHASE22_T_S            (0x8A100000) //small : Copy-Back Program phase 2 (True)
#define NANDC_COPYBACK_PROGRAM_PHASE2_D_S         (0x8A110000) //small : Copy-Back Program phase 2 (Dummy)
#define NANDC_READ_ID                             (0x90000000) //Read ID
#define NANDC_READ_ID2_S                          (0x91000000) //small : Read ID 2
//v2.0 #define NANDC_READ_CHIP1_STATUS_L                 (0xF1000000) //large : Read Chip 1 Status
//v2.0 #define NANDC_READ_CHIP2_STATUS_L                 (0xF2000000) //large : Read Chip 2 Status
#define NANDC_RESET                               (0xFF000000) //Reset 

// Busy status command
#define NANDC_BUSY_READ_STATUS                    (0x00000070) //read status
#define NANDC_BUSY_READ_EDC_STATUS                (0x0000007B) //read EDC status
//v2.0 #define NANDC_BUSY_RESET                          (0x000000FF) //read status
#define NANDC_BUSY_READ_MULTI_PLANE_STATUS        (0x00000071) //read status
#define NANDC_BUSY_READ_CHIP1_STATUS              (0x000000F1) //read status
#define NANDC_BUSY_READ_CHIP2_STATUS              (0x000000F2) //read status
#define NANDC_BUSY_EXTENDED_READ_STATUS72         (0x00000072) //read status
#define NANDC_BUSY_EXTENDED_READ_STATUS73         (0x00000073) //read status
#define NANDC_BUSY_EXTENDED_READ_STATUS74         (0x00000074) //read status
#define NANDC_BUSY_EXTENDED_READ_STATUS75         (0x00000075) //read status

/* SMC Module Config Register 0x10, 0x14, 0x18, 0x1C */
#define NANDC_BASE_ADDR                 (0xFFF<<20)
//#define NANDC_ID_NUMBER_2               (0x00<<16)  //remove
//#define NANDC_ID_NUMBER_3               (0x01<<16)  //remove
//#define NANDC_ID_NUMBER_4               (0x10<<16)  //remove
//#define NANDC_ID_NUMBER_5               (0x11<<16)  //remove
#define NANDC_SPARE_EN                  BIT14
#define NANDC_ADDR_PHASE_3              (0x00<<12)
#define NANDC_ADDR_PHASE_4              (0x01<<12)
#define NANDC_ADDR_PHASE_5              (0x10<<12)
#define NANDC_MEM_SIZE_128              (0x000<<8)
#define NANDC_MEM_SIZE_256              (0x001<<8)
#define NANDC_MEM_SIZE_512              (0x001<<8)
#define NANDC_MEM_SIZE_1024             (0x011<<8)
#define NANDC_MEM_SIZE_2048             (0x100<<8)
#define NANDC_MEM_SIZE_4096             (0x101<<8)
#define NANDC_MEM_SIZE_8192             (0x110<<8)
#define NANDC_MEM_SIZE_16384            (0x111<<8)
#define NANDC_BLK_SIZE_16               (0x00<<6)
#define NANDC_BLK_SIZE_32               (0x01<<6)
#define NANDC_BLK_SIZE_64               (0x10<<6)
#define NANDC_BLK_SIZE_128              (0x11<<6)
#define NANDC_PAGE_SIZE_512B            (0x00<<4)
#define NANDC_PAGE_SIZE_2KB             (0x01<<4)
#define NANDC_MODE_ENABLE               0x1

/* SMC DMA and FIFO control register 0x24 */
#define NANDC_DMA_MODE			        (1<<15)
#define NANDC_PIO_MODE			        (0<<15)
#define NANDC_FIFO_THRESHOLD_16         0xF
#define NANDC_FIFO_THRESHOLD_15         0xE
#define NANDC_FIFO_THRESHOLD_14         0xD
#define NANDC_FIFO_THRESHOLD_13         0xC
#define NANDC_FIFO_THRESHOLD_12         0xB
#define NANDC_FIFO_THRESHOLD_11         0xA
#define NANDC_FIFO_THRESHOLD_10         0x9
#define NANDC_FIFO_THRESHOLD_9          0x8
#define NANDC_FIFO_THRESHOLD_8          0x7
#define NANDC_FIFO_THRESHOLD_7          0x6
#define NANDC_FIFO_THRESHOLD_6          0x5
#define NANDC_FIFO_THRESHOLD_5          0x4
#define NANDC_FIFO_THRESHOLD_4          0x3
#define NANDC_FIFO_THRESHOLD_3          0x2
#define NANDC_FIFO_THRESHOLD_2          0x1
#define NANDC_FIFO_THRESHOLD_1          0x0

/* SMC AC Timing Register 0x28, 0x2C */
/*
#define NANDC_WRITE_CYC_6			    (0x00<<18)
#define NANDC_WRITE_CYC_4			    (0x01<<18)
#define NANDC_WRITE_CYC_3			    (0x10<<18)
#define NANDC_WRITE_CYC_2			    (0x11<<18)
#define NANDC_READ_CYC_6			    (0x00<<16)
#define NANDC_READ_CYC_4			    (0x01<<16)
#define NANDC_READ_CYC_3			    (0x10<<16)
#define NANDC_READ_CYC_2			    (0x11<<16)
*/

/* SMC Interrupt Status Clear register 0x54 */
#define NANDC_ECC_ERR_CLR               BIT19
#define NANDC_COMPLETE_CLR              BIT18 
#define NANDC_LSN_ECC_ERR_CLR           BIT17   //new
#define NANDC_FIFO_CLR                  BIT16 

/* SMC Interrupt Enable and Mask register 0x44 */

#define NANDC_INT_DISABLE               BIT31
#define NANDC_Mask_ECC_ERR_INT          BIT3
#define NANDC_Mask_CMD_INT              BIT2
#define NANDC_Mask_LSN_ECC_ERR_INT      BIT1    //new
#define NANDC_Mask_FIFO_INT             BIT0

#define NANDC_IO_BUS_16                 0
#define NANDC_IO_BUS_8                  BIT0

