#include <common.h>

#if defined(CONFIG_CMD_NAND)
#if !defined(CFG_NAND_LEGACY)

#include <nand.h>

#define NAND_CONTROL_BASE		CFG_NAND0_BASE

#undef CFG_NANDC020_DEBUG1
#undef CFG_NANDC020_DEBUG2
#undef CFG_NANDC020_DEBUG3

#ifdef CFG_NANDC020_DEBUG1
# define NANDC020_DEBUG1(fmt, args...) printf(fmt, ##args)
#else
# define NANDC020_DEBUG1(fmt, args...)
#endif

#ifdef CFG_NANDC020_DEBUG2
# define NANDC020_DEBUG2(fmt, args...) printf(fmt, ##args)
#else
# define NANDC020_DEBUG2(fmt, args...)
#endif

#ifdef CFG_NANDC020_DEBUG3
# define NANDC020_DEBUG3(fmt, args...) printf(fmt, ##args)
#else
# define NANDC020_DEBUG3(fmt, args...)
#endif

#include "nandc_flash.h"
#define NDSR ptflash->ST
#define NDSR_WRDREQ 1

#define ST_NANDC_FIFO_NOT_EMPTY	1
#define ST_NANDC_CMD_DONE	2
//+cwz{
INT32 gSTATUSReg;
INT32 gSTATUSRegValid;
NANDStruct tCurrentFlash;
INT32U u32NextNANDstartAddr;
//+cwz}
/* These really don't belong here, as they are specific to the NAND Model */
static uint8_t scan_ff_pattern[] = { 0xff, 0xff };

static struct nand_bbt_descr bbt_descr = {
    .options = 0,
    .offs = 0,
    .len = 1,
    .pattern = scan_ff_pattern
};

static struct nand_ecclayout oob_descr_512 = {
    .eccbytes = 3,
    .eccpos = {6, 7, 8},
    .oobfree = {
                {.offset = 0, .length = 5},
                {.offset = 11, .length = 5},
               }
};

static struct nand_ecclayout oob_descr_2048 = {
    .eccbytes = 12,		//including 3 ECC
    .eccpos = {
	       8, 9, 10,
	       24, 25, 26,
	       40, 41, 42,
	       56, 57, 58,
	       },
    .oobfree = {
		{.offset = 1, .length = 7},
		{.offset = 13, .length = 3},
		{.offset = 17, .length = 7},
		{.offset = 29, .length = 3},
		{.offset = 33, .length = 7},
		{.offset = 45, .length = 3},
		{.offset = 49, .length = 7},
		{.offset = 61,.length = 3},
		}
};

#if 0
ff 99 00 00 00 99 99 99
3f 33 ff ff ff 99 99 99
ff 99 01 00 00 99 99 99
66 56 59 aa fe 99 99 99
ff 99 02 00 00 99 99 99
ff ff ff 9a fe 99 99 99
ff 99 03 00 00 99 99 99
ff ff ff cf ff 99 99 99
#endif
INT32U fLib_NANDC_ReadReg(INT32U Offset)
{
    INT32U val;

    val = *((volatile INT32U *) (NAND_CONTROL_BASE + Offset));
    return val;
}

void fLib_NANDC_WriteReg(INT32U Offset, INT32U RegValue)
{
    *((volatile INT32U *) (NAND_CONTROL_BASE + Offset)) = RegValue;
}

void fLib_NANDC_Cmd_Busy_Complete(UINT32 count)
{
	UINT32 i, STATUSReg;

	// quick check
	for (i = 0; i < count / 4; i++);
	STATUSReg = *((volatile UINT32 *) (NAND_CONTROL_BASE + NANDC_ACCESS_CONTROL));
	if ((STATUSReg & NANDC_CMD_FOR_BUSY) == 0)
		return;

	do {
		for (i = 0; i < 200; i++);
			STATUSReg = *((volatile UINT32 *) (NAND_CONTROL_BASE + NANDC_ACCESS_CONTROL));
		NANDC020_DEBUG1("%s:Wait Again!!!! \n", __FUNCTION__);
	} while ((STATUSReg & NANDC_CMD_FOR_BUSY) != 0);
}


void fLib_NANDC_Cmd_Complete(UINT32 count)
{
    UINT32 i, STATUSReg, DMA_FIFO_Reg;

    //wait
    for (i = 0; i < count / 4; i++);
    STATUSReg =
	*((volatile UINT32 *) (NAND_CONTROL_BASE + NANDC_ACCESS_CONTROL));
    if ((STATUSReg & NANDC_CMD) == 0)
	return;

    do {
	for (i = 0; i < 200; i++);
	STATUSReg =
	    *((volatile UINT32 *) (NAND_CONTROL_BASE +
				   NANDC_ACCESS_CONTROL));
	NANDC020_DEBUG1("%s:Wait Again!!!! \n", __FUNCTION__);
    } while ((STATUSReg & NANDC_CMD) != 0);

    //select DMA/PIO & FIFO
    DMA_FIFO_Reg = fLib_NANDC_ReadReg(NANDC_DMA_FIFO);
    fLib_NANDC_WriteReg(NANDC_DMA_FIFO,
			NANDC_PIO_MODE | NANDC_FIFO_THRESHOLD_1);
    fLib_NANDC_WriteReg(NANDC_ACCESS_CONTROL,
			NANDC_CMD_FOR_BUSY | NANDC_SPARE_RW_DISABLE |
			NANDC_BUSY_READ_STATUS);
    fLib_NANDC_Cmd_Busy_Complete(1);

    STATUSReg = fLib_NANDC_ReadReg(NANDC_CONTROL_STATUS);
    STATUSReg = (STATUSReg & 0xFF00) >> 8;

    fLib_NANDC_WriteReg(NANDC_DMA_FIFO, DMA_FIFO_Reg);
    if (STATUSReg & 0x1)
	while (1);
}


BOOLEAN bNANDCtl_WaitNotEmpty(void)
{
    unsigned long u32timeout;

    u32timeout = NAND_CTL_TIMEOUT_BUSY;
    while (1) {
	if ((ptflash->ST & NANDC_FIFO_EMPTY) == 0)
	    return TRUE;
	if (0 == --u32timeout) {
	    return FALSE;
	}
    }
}


/*
 * Write buf to the NANDC020 Controller Data Buffer
 */
static void nandc020_write_buf(struct mtd_info *mtd, const u_char * buf,
			       int len)
{
    unsigned long bytes_multi = len & 0xfffffffc;
    unsigned long rest = len & 0x3;
    unsigned long *long_buf;
    int i;

    if ((unsigned long) buf & 0x3)
	printf
	    ("%s:**** buf address is not word alignment, and something maybe wrong ***\n",
	     __FUNCTION__);

    NANDC020_DEBUG2
	("nandc020_write_buf: writing %d bytes starting with 0x%x.\n", len,
	 ((unsigned long *) buf));
    if (bytes_multi) {
	for (i = 0; i < bytes_multi; i += 4) {
	    long_buf = (unsigned long *) &buf[i];
	    ptflash->DATA = *long_buf;
	}
    }
    if (rest) {
	printf
	    ("nandc020_write_buf: ERROR, writing non 4-byte aligned data.\n");
    }
    return;
}


/*
 * These functions are quite problematic for the NANDC020. Luckily they are
 * not used in the current nand code, except for nand_command, which
 * we've defined our own anyway. The problem is, that we always need
 * to write 4 bytes to the NANDC020 Data Buffer, but in these functions we
 * don't know if to buffer the bytes/half words until we've gathered 4
 * bytes or if to send them straight away.
 *
 * Solution: Don't use these with NANDC020 and complain loudly.
 */
static void nandc020_cmd_ctrl(struct mtd_info *mtd, int dat,
			      unsigned int ctrl)
{
//      printf("%s: WARNING, this function does not implement with the NANDC020!\n",__FUNCTION__);
}

/* The original:
 * static void nandc020_read_buf(struct mtd_info *mtd, const u_char *buf, int len)
 *
 * Shouldn't this be "u_char * const buf" ?
 */
static void nandc020_read_buf(struct mtd_info *mtd, u_char * const buf,
			      int len)
{
    int i = 0, j;

    /* we have to be carefull not to overflow the buffer if len is
     * not a multiple of 4 */
    unsigned long bytes_multi = len & 0xfffffffc;
    unsigned long rest = len & 0x3;
    unsigned long *long_buf;

    if ((unsigned long) buf & 0x3)
	printf
	    ("%s:**** buf address is not word alignment, and something maybe wrong ***\n",
	     __FUNCTION__);

    NANDC020_DEBUG3("nandc020_read_buf: reading %d bytes. buf=0x%x\n", len,
		    buf);

    /* if there are any, first copy multiple of 4 bytes */
    if (bytes_multi) {
	for (i = 0; i < bytes_multi; i += 4) {
	    long_buf = (unsigned long *) &buf[i];
	    while(ptflash->ST & NANDC_FIFO_EMPTY);
	    *long_buf = ptflash->DATA;
	}
    }

    /* ...then the rest */
    if (rest) {
	unsigned long rest_data;

	while(ptflash->ST & NANDC_FIFO_EMPTY);
	rest_data = ptflash->DATA;
	for (j = 0; j < rest; j++)
	    buf[i + j] = (u_char) ((rest_data >> j) & 0xff);
    }
#if CONFIG_NAND_NO_OOBR
    if (len == mtd->writesize || len == mtd->writesize + mtd->oobsize || len == mtd->oobsize)	//maybe 1st read:2048 bytes; 2nd read:64 bytes to anothor buf
#else
    if (len == mtd->writesize + mtd->oobsize || len == mtd->oobsize)	//maybe 1st read:2048 bytes; 2nd read:64 bytes to anothor buf
#endif
	fLib_NANDC_Cmd_Complete(1);
    return;
}

/*
 * read a word. Not implemented as not used in NAND code.
 */
static u16 nandc020_read_word(struct mtd_info *mtd)
{
    printf("%s: UNIMPLEMENTED.\n", __FUNCTION__);
    return 0;
}

/* global var, too bad: mk@tbd: move to ->priv pointer */
static unsigned long read_buf = 0;
static int bytes_read = -1;
static int ecc_step = -1;

/*
 * read a byte from ptflash->DATA Because we can only read 4 bytes from ptflash->DATA at
 * a time, we buffer the remaining bytes. The buffer is reset when a
 * new command is sent to the chip.
 *
 */
static u_char nandc020_read_byte(struct mtd_info *mtd)
{
    unsigned char byte;

    if (gSTATUSRegValid) {
	gSTATUSRegValid = 0;
	byte = (unsigned char) gSTATUSReg;
	return byte;
    }

    if (bytes_read < 0) {
	read_buf = ptflash->DATA;
	bytes_read = 0;
    }
    byte = (unsigned char) (read_buf >> (8 * bytes_read++));
    NANDC020_DEBUG2("nandc020_read_byte: byte %u: 0x%x of (0x%x).\n",
		    bytes_read - 1, byte, read_buf);
    if (bytes_read >= 4)
	bytes_read = -1;

    return byte;
}


static unsigned long nandc020_wait_event(unsigned long event)
{
    unsigned long status;

    if (!event)
	return 0xff000000;

    switch (event) {
    case ST_NANDC_FIFO_NOT_EMPTY:
	return bNANDCtl_WaitNotEmpty();
	break;
    case ST_NANDC_CMD_DONE:
	return TRUE;
	break;
    default:
	fLib_NANDC_Cmd_Complete(1);
	return TRUE;
	;
    }

    if (!event)
	return 0xff000000;

    while (1) {
	status = NDSR;
	if (status & event) {
	    NDSR |= event;
	    break;
	}

    }
    return status;
}

/* this function is called nandc020 Programm and Erase Operations to
 * check for success or failure */
static int nandc020_wait(struct mtd_info *mtd, struct nand_chip *this)
{

	int state = this->state;

    if (state == FL_WRITING) {
	return 0;
    } else if (state == FL_ERASING) {
	unsigned long STATUSReg;
	fLib_NANDC_Cmd_Complete(1);
	fLib_NANDC_WriteReg(NANDC_ACCESS_CONTROL,
			    NANDC_CMD_FOR_BUSY | NANDC_SPARE_RW_DISABLE |
			    NANDC_BUSY_READ_STATUS);
	fLib_NANDC_Cmd_Busy_Complete(1);

	STATUSReg = fLib_NANDC_ReadReg(NANDC_CONTROL_STATUS);
	STATUSReg = (STATUSReg & 0xFF00) >> 8;

	return STATUSReg;	//check by nand_erase_nand()
    }
    return 0;
}

void mdelay(int ms)
{
	volatile unsigned int hz = 540;
	while(ms-- > 0)
	{
		while(hz--);
	}
}

static void nandc020_clear_fifo(void)
{
	unsigned int dummy;

	while(!(ptflash->ST & NANDC_FIFO_EMPTY))
		dummy = ptflash->DATA;
}

/* cmdfunc send commands to the NANDC020 */
static void nandc020_cmdfunc(struct mtd_info *mtd, unsigned command,
			     int column, int page_addr)
{
    /* register struct nand_chip *this = mtd->priv; */
    unsigned long cmd = 0, event = 0;

    /* clear the ugly byte read buffer */
    ecc_step = -1;
    bytes_read = -1;
    read_buf = 0;

    switch (command) {
    case NAND_CMD_READ0:
	NANDC020_DEBUG2
	    ("nandc020_cmdfunc: NAND_CMD_READ0, page_addr: 0x%x, column: 0x%x.\n",
	     page_addr, (column >> 1));

	nandc020_clear_fifo();
	
	fLib_NANDC_WriteReg(NANDC_ADDRESS_LOW, page_addr << 12);	/* large page 2*page size */
	fLib_NANDC_WriteReg(NANDC_ADDRESS_HIGH, 0);
#if CONFIG_NAND_NO_OOBR
	fLib_NANDC_WriteReg(NANDC_DATA_LEN, mtd->writesize);
#else
	fLib_NANDC_WriteReg(NANDC_DATA_LEN, mtd->writesize+mtd->oobsize);
#endif
	fLib_NANDC_WriteReg(NANDC_DMA_FIFO,
			    NANDC_PIO_MODE | NANDC_FIFO_THRESHOLD_8);
#if CONFIG_NAND_NO_OOBR
	cmd = NANDC_CMD | NANDC_SPARE_RW_DISABLE | NANDC_READ_L;
#else
	cmd = NANDC_CMD | NANDC_READ_L;
#endif
	event = ST_NANDC_CMD_DONE;
	goto write_cmd;
    case NAND_CMD_READ1:
	printf("nandc020_cmdfunc: NAND_CMD_READ1 unimplemented!\n");
	goto end;
    case NAND_CMD_READOOB:
	NANDC020_DEBUG2
	    ("nandc020_cmdfunc: NAND_CMD_READOOB, page_addr: 0x%x, column: 0x%x.\n",
	     page_addr, (column >> 1));
	nandc020_clear_fifo();
	fLib_NANDC_WriteReg(NANDC_ADDRESS_LOW, (2 * (page_addr) + 1) << 11);	/* large page 2*page size *//* 2k(1+2n) */
	fLib_NANDC_WriteReg(NANDC_ADDRESS_HIGH, 0);
	fLib_NANDC_WriteReg(NANDC_DATA_LEN, 0x40);
	fLib_NANDC_WriteReg(NANDC_DMA_FIFO,
			    NANDC_PIO_MODE | NANDC_FIFO_THRESHOLD_8);
	cmd = NANDC_CMD | NANDC_READ_L;
	event = ST_NANDC_CMD_DONE;
	goto write_cmd;
    case NAND_CMD_READID:
	NANDC020_DEBUG2("nandc020_cmdfunc: NAND_CMD_READID.\n");
	nandc020_clear_fifo();
	cmd = NANDC_READ_ID;
	event = ST_NANDC_FIFO_NOT_EMPTY;
	goto write_cmd;
    case NAND_CMD_PAGEPROG:
	/* sent as a multicommand in NAND_CMD_SEQIN */
	NANDC020_DEBUG2
	    ("nandc020_cmdfunc: NAND_CMD_PAGEPROG empty due to multicmd.\n");
	fLib_NANDC_Cmd_Complete(1);
	goto end;
    case NAND_CMD_ERASE1:
	NANDC020_DEBUG2
	    ("nandc020_cmdfunc: NAND_CMD_ERASE1,  page_addr: 0x%x.\n",
	     page_addr);

	fLib_NANDC_WriteReg(NANDC_ADDRESS_LOW, page_addr << 12);	/* large page 2*page size */
	fLib_NANDC_WriteReg(NANDC_ADDRESS_HIGH, 0);
	cmd = (NANDC_BLOCK_ERASE);
	cmd |= NANDC_CMD;
	ptflash->CTRL = cmd;
	goto end;
    case NAND_CMD_ERASE2:
	NANDC020_DEBUG2
	    ("nandc020_cmdfunc: NAND_CMD_ERASE2 empty due to multicmd.\n");
	goto end;
    case NAND_CMD_SEQIN:
	/* send PAGE_PROG command(0x1080) */

	NANDC020_DEBUG2
	    ("nandc020_cmdfunc: NAND_CMD_SEQIN/PAGE_PROG,  page_addr: 0x%x, column: 0x%x.\n",
	     page_addr, (column >> 1));
	if (column == mtd->writesize)	//write OOB
	{
	    fLib_NANDC_WriteReg(NANDC_ADDRESS_LOW, (2 * (page_addr) + 1) << 11);	/* large page 2*page size *//* 2k(1+2n) */
	    fLib_NANDC_WriteReg(NANDC_ADDRESS_HIGH, 0);

	    fLib_NANDC_WriteReg(NANDC_DATA_LEN, mtd->oobsize);
	} else {
	    fLib_NANDC_WriteReg(NANDC_ADDRESS_LOW, page_addr << 12);
	    fLib_NANDC_WriteReg(NANDC_ADDRESS_HIGH, 0);
#if CONFIG_NAND_NO_OOBW
	    fLib_NANDC_WriteReg(NANDC_DATA_LEN,
				mtd->writesize);
#else	// #if CONFIG_NAND_NO_OOBW
	    fLib_NANDC_WriteReg(NANDC_DATA_LEN,
				mtd->writesize + mtd->oobsize);
#endif	// #if CONFIG_NAND_NO_OOBW
	}
	//PIO write
	// select DMA/PIO & FIFO
	fLib_NANDC_WriteReg(NANDC_DMA_FIFO,
			    NANDC_PIO_MODE | NANDC_FIFO_THRESHOLD_8);
//              fLib_NANDC_WriteReg(NANDC_ACCESS_CONTROL,NANDC_CMD | NANDC_SPARE_RW_DISABLE | NANDC_PROGRAM_PAGE);                                        
//              cmd= NANDC_SPARE_RW_DISABLE | NANDC_PROGRAM_PAGE;                                         
	cmd = NANDC_PROGRAM_PAGE;

	event = NDSR_WRDREQ;
//              goto write_cmd;
	cmd |= NANDC_CMD;
	ptflash->CTRL = cmd;
	goto end;
    case NAND_CMD_STATUS:
	NANDC020_DEBUG2("nandc020_cmdfunc: NAND_CMD_STATUS.\n");
	
	{
	    fLib_NANDC_WriteReg(NANDC_ACCESS_CONTROL,
				NANDC_CMD_FOR_BUSY | NANDC_SPARE_RW_DISABLE
				| NANDC_BUSY_READ_STATUS);
	    fLib_NANDC_Cmd_Busy_Complete(1);

	    gSTATUSReg = fLib_NANDC_ReadReg(NANDC_CONTROL_STATUS);
	    gSTATUSReg = (gSTATUSReg & 0xFF00) >> 8;
	    gSTATUSRegValid = 1;
	}
	goto end;
    case NAND_CMD_RESET:
	NANDC020_DEBUG2("nandc020_cmdfunc: NAND_CMD_RESET.\n");

	while (1) {
	    fLib_NANDC_WriteReg(NANDC_ACCESS_CONTROL,
				NANDC_CMD_FOR_BUSY | NANDC_SPARE_RW_DISABLE
				| NANDC_BUSY_READ_STATUS);
	    fLib_NANDC_Cmd_Busy_Complete(1);

	    if (((fLib_NANDC_ReadReg(NANDC_CONTROL_STATUS) & 0xff00) >> 8)
		& 0x40)
		goto end;
	}
    default:
	printf("nandc020_cmdfunc: error, unsupported command (0x%x).\n",
	       command);
	goto end;
    }

  write_cmd:
    cmd |= NANDC_CMD;
    ptflash->CTRL = cmd;

    /*  wait_event: */
    nandc020_wait_event(event);
  end:
    return;
}

/**
 * nand_verify_buf32 - [DEFAULT] Verify chip data against buffer
 * @mtd:	MTD device structure
 * @buf:	buffer containing the data to compare
 * @len:	number of bytes to compare
 *
 * Default verify function for 32bit buswith
 */
#define	EFAULT 14
static int nand_verify_buf32(struct mtd_info *mtd, const u_char * buf,
			     int len)
{
    int i;
//    struct nand_chip *this = mtd->priv;
    u32 *p = (u32 *) buf;
    int len_org;
    len_org = len;
    len >>= 2;

    for (i = 0; i < len; i++) {
	while(ptflash->ST & NANDC_FIFO_EMPTY);
	if (p[i] != ptflash->DATA)
	    return -EFAULT;
    }

    if (len_org == mtd->writesize)	//drain OOB bytes
    {
#if !CONFIG_NAND_NO_OOBR
	for (i = 0; i < mtd->oobsize / 4; i++) {
	    while(ptflash->ST & NANDC_FIFO_EMPTY);
	    ptflash->DATA;
	}
#endif
    } else
	printf("buf=0x%x,len=%d\n", (unsigned int)buf, (unsigned int)len_org);

    return 0;
}

static void hwctl(struct mtd_info *mtd, int mode)
{
    switch(mode) {
	case NAND_ECC_READ:
		ecc_step++;
		break;
	case NAND_ECC_WRITE:
		ecc_step++;
		break;
	default:
		BUG();
		break;
    }
}

static int calculate(struct mtd_info *mtd, const uint8_t * dat,
		     uint8_t * ecc_code)
{
    unsigned int ecc;

    ecc = fLib_NANDC_ReadReg(NANDC_ECC + (ecc_step << 2));
    *ecc_code++ = (ecc >>  0) & 0xff;
    *ecc_code++ = (ecc >>  8) & 0xff;
    *ecc_code++ = (ecc >> 16) & 0xff;

    return 0;
}

static int correct(struct mtd_info *mtd, uint8_t * dat, uint8_t * read_ecc,
		   uint8_t * calc_ecc)
{
#if CONFIG_NAND_NO_OOBR || CONFIG_NAND_NO_OOBW
    return 0;
#else
    unsigned int diff0, diff1, diff2;

    diff0 = read_ecc[0] ^ calc_ecc[0];
    diff1 = read_ecc[1] ^ calc_ecc[1];
    diff2 = read_ecc[2] ^ calc_ecc[2];

    if (diff0 == 0 && diff1 == 0 && diff2 == 0)
	return 0;

    /* TODO: Do the ECC software correct.....but HOW? */
    printk("ECC check error: rd %02x%02x%02x calc %02x%02x%02x diff %02x%02x%02x\n",
           read_ecc[0], read_ecc[1], read_ecc[2],
           calc_ecc[0], calc_ecc[1], calc_ecc[2],
           diff0, diff1, diff2);

    return -1;
#endif
}

/*
 * Board-specific NAND initialization. The following members of the
 * argument are board-specific (per include/linux/mtd/nand_new.h):
 * - IO_ADDR_R?: address to read the 8 I/O lines of the flash device
 * - IO_ADDR_W?: address to write the 8 I/O lines of the flash device
 * - hwcontrol: hardwarespecific function for accesing control-lines
 * - dev_ready: hardwarespecific function for  accesing device ready/busy line
 * - enable_hwecc?: function to enable (reset)  hardware ecc generator. Must
 *   only be provided if a hardware ECC is available
 * - eccmode: mode of ecc, see defines
 * - chip_delay: chip dependent delay for transfering data from array to
 *   read regs (tR)
 * - options: various chip options. They can partly be set to inform
 *   nand_scan about special functionality. See the defines for further
 *   explanation
 * Members with a "?" were not set in the merged testing-NAND branch,
 * so they are not set here either.
 */
int board_nand_init(struct nand_chip *nand)
{
    ptflash->SF_RST = 0;

    nand->waitfunc = nandc020_wait;
    nand->read_byte = nandc020_read_byte;
    nand->read_word = nandc020_read_word;
    nand->read_buf = nandc020_read_buf;
    nand->write_buf = nandc020_write_buf;

    nand->cmdfunc = nandc020_cmdfunc;

    nand->ecc.mode = NAND_ECC_HW;
    nand->ecc.calculate = calculate;
    nand->ecc.correct = correct;
    nand->ecc.hwctl = hwctl;
    nand->ecc.size = 512;	//per 512Bytes Data has 3 Bytes ECC for NAND020
    nand->ecc.bytes = 3;
    nand->ecc.layout = &oob_descr_2048;


    nand->badblock_pattern = &bbt_descr;	//at start, u-boot try to scan all block with this pattern
    nand->verify_buf = nand_verify_buf32;
    nand->cmd_ctrl = nandc020_cmd_ctrl;

    ptflash->SF_RST = 1;

    return 0;
}
#else
#error "U-Boot legacy NAND support not available for NANDC020."
#endif
#endif

//nand_get_flash_type:mtd->writesize=0x800,mtd->oobsize=0x40,mtd->erasesize=0x20000
