/*
 * Board specific setup info
 *
 * (C) Copyright 2009, Faraday Tech Corp.
 * KJ Lin, <fred@faraday-tech.com>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <config.h>
#include <version.h>

.global reset_cpu
reset_cpu:
	ldr     r0,WDT_BASE
	mov     r1,#0
	str     r1,[r0]

	mov     r1,#1
	str     r1,[r0,#4]

	ldr     r1,WDT_RESET
	str     r1,[r0,#8]

	mov     r1,#3
	str     r1,[r0,#0xc]

reset_failed:
	b       reset_failed

WDT_BASE: 
	.word	0x98500000
WDT_RESET: 
	.word	0x5ab9

#ifndef CONFIG_SKIP_LOWLEVEL_INIT

/*
 * Setup DDR controller registers
 *
 *      r0 - DDR controller base address
 *      r1 - DDR configure table
 */
set_ddrconf:
        ldr     r4, [r1], #4

0:      ldr     r2, [r1], #4
        ldr     r3, [r1], #4
        str     r3, [r0, r2]
        subs    r4, r4, #1
        bne     0b

        ldr     r3, =0x1
        str     r3, [r0, #0x04]
1:      ldr     r3, [r0, #0x04]         // wait for stable
        cmp     r3, #0x100
        bne     1b

        mov     pc, lr

        .type   ddr0_config,#object
ddr0_config:
        .word   14
        .word   0x00, 0x00005C02
        .word   0x08, 0x00400642
        .word   0x0C, 0x00000000
        .word   0x10, 0x10003333        // 0x00000000/128MB will be modified after remap
        .word   0x18, 0x216D4F63
        .word   0x1C, 0x006C7230
        .word   0x20, 0x0C801042
        .word   0x24, 0x00000004
        .word   0x28, 0x00000420
        .word   0x30, 0x00000000
        .word   0x34, 0x88888888
        .word   0x38, 0x00000001
        .word   0x40, 0x00000000
        .word   0x48, 0x000000FF
        .size   ddr0_config, . - ddr0_config

        .type   ddr1_config,#object
ddr1_config:
        .word   14
        .word   0x00, 0x00005C02
        .word   0x08, 0x00400642
        .word   0x0C, 0x00000000
        .word   0x10, 0x20003333        // 0x10000000/128MB
        .word   0x18, 0x216D4F63
        .word   0x1C, 0x006C7230
        .word   0x20, 0x0C801042
        .word   0x24, 0x00000004
        .word   0x28, 0x00000420
        .word   0x30, 0x00000000
        .word   0x34, 0x88888888
        .word   0x38, 0x00000001
        .word   0x40, 0x00000000
        .word   0x48, 0x000000FF
        .size   ddr1_config, . - ddr1_config

        .type   ddr2_config,#object
ddr2_config:
        .word   14
        .word   0x00, 0x00005C02
        .word   0x08, 0x00400642
        .word   0x0C, 0x00000000
        .word   0x10, 0x28003333        // 0x10000000/128MB
        .word   0x18, 0x216D4F63
        .word   0x1C, 0x006C7230
        .word   0x20, 0x0C801042
        .word   0x24, 0x00000004
        .word   0x28, 0x00000420
        .word   0x30, 0x00000000
        .word   0x34, 0x88888888
        .word   0x38, 0x00000001
        .word   0x40, 0x00000000
        .word   0x48, 0x000000FF
        .size   ddr2_config, . - ddr2_config

/* Initial AHB bus to default */
init_ahbbus:
	/* Initial DDR0 base on AHBC7 bus */
	ldr     r0, =0x72800000
        ldr     r1, =0x00080000		// DDR0 512MB
        ldr     r2, =0x10080000
        str     r1, [r0, #0x10]		// SMC
        str     r2, [r0, #0x18]		// DDR0

	/* Configure DDR0/DDR1/DDR2 base on AHBC0 ~ AHBC6 bus */
	ldr     r0, =0x72000000
        mov     r3, #7
0:      add     r0, r0, #0x100000
        ldr     r1, =0x00070000                 // DDR0 128MB
        ldr     r2, =0x20070000                 // DDR1 128MB
        ldr     r4, =0x28070000                 // DDR2 128MB
        str     r1, [r0, #0x18]
        str     r2, [r0, #0x14]
        str     r4, [r0, #0x1C]
        subs    r3, r3, #1
        bne     0b

	mov     pc, lr

/* Set up the platform, once the cpu has been initialized */
.globl lowlevel_init
lowlevel_init:
	/* If U-Boot has been run after the ARM boot monitor
	 * then all the necessary actions have been done
	 * otherwise we are running from user flash mapped to 0x00000000
	 * --- DO NOT REMAP BEFORE THE CODE HAS BEEN RELOCATED --
	 * Changes to the (possibly soft) reset defaults of the processor
	 * itself should be performed in cpu/arm<>/start.S
	 * This function affects only the core module or board settings
	 */
	mov     r13, lr

#ifdef BOOT_DEBUG
	/* enable UART for early debug trace */
	LDR     r1, =0x98200008
	LDR     r2, =0x35
	STR     r2, [r1]

	LDR     r1, =0x9820000C
	LDR     r2, =0x083
	STR     r2, [r1]

	LDR     r1, =0x98200000
	LDR     r2, =0x07;//01E
	STR     r2, [r1]

	LDR     r1, =0x9820000C
	LDR     r2, =0x003
	STR     r2, [r1]

	LDR     r1, =0x98200000
	LDR     r2, =0x030		/* write '0' */
	STR     r2, [r1]
#endif
	/* set clock */
        ldr     r0, =0x98100038		/* AHB clock */
        ldr     r1, =0x307A6A00
        str     r1, [r0]

	ldr     r0, =0x9810003C		/* APB clock */
        ldr     r1, =0x80020
        str     r1, [r0]

	ldr     r0, =0x98100108		/* multi-function clock */
        ldr     r1, =0x0a8540ff
        str     r1, [r0]

	ldr     r0, =0x98100100		/* pin mux function */
        ldr     r1, =0x0
        str     r1, [r0]

	ldr     r0, =0x98100028		/* video codec async mode */
        ldr     r1, =0x80
        str     r1, [r0]

	ldr     r0, =0x9810010C		/* PLL3 clock */
        ldr     r1, =0x288A
        str     r1, [r0]

        bl      init_ahbbus

	/* Configure DDR0 */
        ldr     r0, =0x99100000
        adr     r1, ddr0_config
        bl      set_ddrconf

	/* Configure DDR1 */
        ldr     r0, =0x99200000
        adr     r1, ddr1_config
        bl      set_ddrconf

	/* Configure DDR2 */
        ldr     r0, =0x99300000
        adr     r1, ddr2_config
        bl      set_ddrconf

#ifndef CONFIG_NAND
        /* Flash parameter */
        ldr     r0, =0x70400000
        ldr     r1, =0x10000051
        str     r1, [r0]

        ldr     r0, =0x70400004
        ldr     r1, =0x7F0F1
        str     r1, [r0]
#endif

	/* relocate uboot to RAM for remap */
	ldr	r0, =0x00000000         /* r0 <- current position of code */
	ldr	r2, __stext
	ldr	r3, __sbss
	sub	r2, r3, r2              /* r2 <- size of armboot */
	ldr	r1, =0x10000000         /* r1 <- destination address */
	add	r2, r0, r2              /* r2 <- source end address */

	/*
	 * r0 = source address
	 * r1 = target address
	 * r2 = source end address
	 */
copy_remap:
	ldmia	r0!, {r3-r10}
	stmia	r1!, {r3-r10}
	cmp	r0, r2
	ble	copy_remap

	/* Fix DDR0 register for remap */
	ldr     r0, =0x99100010
	ldr	r1, =0x00003333
	str	r1, [r0]

	/* Remap slave4 & slave6 on AHBC0 bus */
	ldr	r0, =0x72800000
	ldr	r1, [r0, #0x88]
	orr	r1, r1, #0x1
	str	r1, [r0, #0x88]
	nop
	nop

	/* Fix DDR0/DDR1/DDR2 base on AHBC7 bus after remap */
	ldr	r0, =0x72800000
	ldr	r1, =0x00070000
	ldr	r2, =0x20070000
	ldr	r4, =0x28070000
	str	r1, [r0, #0x18]
	str	r2, [r0, #0x14]
	str	r4, [r0, #0x1C]

	/*
         * mask all IRQs by clearing all bits in the INTMRs
         */
        mov     r1, #0x00
        ldr     r0, =(CONFIG_INTC_BASE+0x04)
        str     r1, [r0]

        ldr     r0, =(CONFIG_INTC_BASE+0x24)
        str     r1, [r0]

	mov     lr, r13
	mov	pc, lr

__stext:
        .word   TEXT_BASE

__sbss:
        .word   __bss_start

#endif
