/*
 * (C) Copyright 2006
 * Faraday Technology Corp, <www.faraday-tech.com>
 * Fred Chien <fred@faraday-tech.com>
 *
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include "../../drivers/net/ftmac110.h"
extern u16 ftmac110_read_phy_register(unsigned char phyaddr, unsigned char phyreg);

static void flash__init (void);
//static void ether__init (void);
void peripheral_power_enable (void);

#if defined(CONFIG_SHOW_BOOT_PROGRESS)
void show_boot_progress(int progress)
{
	printf("Boot reached stage %d\n", progress);
}
#endif

#define COMP_MODE_ENABLE ((unsigned int)0x0000EAEF)

/*
 * Miscellaneous platform dependent initialisations
 */

int board_init (void)
{
	DECLARE_GLOBAL_DATA_PTR;

	/* arch number of Integrator Board */
	gd->bd->bi_arch_number = MACH_TYPE_FARADAY;

	/* adress of boot parameters */
	gd->bd->bi_boot_params = 0x00000100;

	gd->flags = 0;
	gd->baudrate=CONFIG_BAUDRATE;

#ifdef CONFIG_CM_REMAP
extern void cm_remap(void);
	cm_remap();	/* remaps writeable memory to 0x00000000 */
#endif
	icache_enable ();
//	nandc_init ();
//	ether__init ();
	return 0;
}

/* cwz */
//int nand_init(void)
//{
/*
	nandc_init ();
*/
//        nand_probe(NANDC_FLASH_BASE);
/*        if (nand_dev_desc[0].ChipID != NAND_ChipID_UNKNOWN) {
                print_size(nand_dev_desc[0].totlen, "\n");
        }
*/

//}
	
int board_eth_init(bd_t *bis)
{
	int ret;
	u16 value;
	
#ifdef CONFIG_FTGMAC100	
	ret= ftgmac100_initialize(bis);
#else		
	ret= ftmac110_initialize(bis);

	//	return ftmac110_initialize(bis);
	value=0;
	value=ftmac110_read_phy_register(0, 1);
#ifdef FTMAC_DEBUG
	printf("PHY reg(0x01)=%x\n",value);
	if(value &0x0020)
		printf("Auto-negotiation process completed\n");
	else
		printf("Auto-negotiation process NOT completed\n");
#endif
#endif
	return ret;
}

int misc_init_r (void)
{
	setenv("verify", "n");
	return (0);
}

/******************************
 Routine:
 Description: The nc6012 uses  CFI flash.
 In order for the CFI commands to work we must ensure that
 the flash is accessible.
 Also sets up the number of banks for a later check against
 include/configs/nc6012.h
******************************/
int nbanks	= 0xDEADBABE;
int sizeIndex	= 0xCAFEBABE;
static void flash__init (void)
{
}
/******************************
 Routine:
 Description: Check Integrator/CP control
							register settings against
				configs header.
******************************/
/*
void flash_check(void) {
	unsigned int sizes[] =	{0x01000000, 0x02000000};
	if(nbanks != CFG_MAX_FLASH_BANKS){
		printf(	"The board control register indicates %d flash banks, "
			"<U-Boot root>/include/configs/integratorcp.h::"
			"CFG_MAX_FLASH_BANKS is set to %d\n" \
			,nbanks, CFG_MAX_FLASH_BANKS);
	}

	if(PHYS_FLASH_SIZE != sizes[sizeIndex]){
		printf(	"The board control register indicates 0x%08x bytes of "
			"flash, <U-Boot root>/include/configs/integratorcp.h"
			"::PHYS_FLASH_SIZE is set to 0x%08x\n" \
			,sizes[sizeIndex], PHYS_FLASH_SIZE);
	}
}
*/
/*************************************************************
 Routine:ether__init
 Description: take the Ethernet controller out of reset and wait
				for the EEPROM load to complete.
*************************************************************/
static void ether__init (void)
{
}

/******************************
 Routine:
 Description:
******************************/
int dram_init (void)
{
	DECLARE_GLOBAL_DATA_PTR;

	gd->bd->bi_dram[0].start = PHYS_SDRAM;
	gd->bd->bi_dram[0].size	 = PHYS_SDRAM_SIZE;

#ifdef CONFIG_CM_SPD_DETECT
		{
extern void dram_query(void);
	unsigned long cm_reg_sdram;
	unsigned long sdram_shift;

	dram_query();	/* Assembler accesses to CM registers */
			/* Queries the SPD values */

	/* Obtain the SDRAM size from the CM SDRAM register */

	cm_reg_sdram = *(volatile ulong *)(CM_BASE + OS_SDRAM);
	/*	 Register				SDRAM size
	 *
	 *	 0xXXXXXXbbb000bb	 16 MB
	 *	 0xXXXXXXbbb001bb	 32 MB
	 *	 0xXXXXXXbbb010bb	 64 MB
	 *	 0xXXXXXXbbb011bb	128 MB
	 *	 0xXXXXXXbbb100bb	256 MB
	 *
	 */
	sdram_shift		 = ((cm_reg_sdram & 0x0000001C)/4)%4;
	gd->bd->bi_dram[0].size	 = 0x01000000 << sdram_shift;

		}
#endif /* CM_SPD_DETECT */

	return 0;
}

/* The Integrator/CP timer1 is clocked at 1MHz
 * can be divided by 16 or 256
 * and can be set up as a 32-bit timer
 */
/* U-Boot expects a 32 bit timer, running at CFG_HZ */
/* Keep total timer count to avoid losing decrements < div_timer */
static unsigned long long total_count = 0;
static unsigned long long lastdec;	 /* Timer reading at last call */
static unsigned long long div_clock = 1; /* Divisor applied to timer clock */
static unsigned long long div_timer = 1; /* Divisor to convert timer reading
					  * change to U-Boot ticks
					  */
/* CFG_HZ = CFG_HZ_CLOCK/(div_clock * div_timer) */
static ulong timestamp;		/* U-Boot ticks since startup */

#define TIMER_LOAD_VAL (CFG_HZ_CLOCK)
#define READ_TIMER (*(volatile ulong *)(CFG_TIMERBASE))

/* all function return values in U-Boot ticks i.e. (1/CFG_HZ) sec
 *	- unless otherwise stated
 */

/* starts up a counter
 * - the Integrator/CP timer can be set up to issue an interrupt */
int interrupt_init (void)
{
	/* Load timer with initial value */
	*(volatile ulong *)(CFG_TIMERBASE + 0) = CFG_HZ_CLOCK;
	/* Set timer to be
	 *	enabled			1
	 *	periodic		1
	 *	no interrupts		0
	 *	X			0
	 *	divider 1	 00 == less rounding error
	 *	32 bit			1
	 *	wrapping		0
	 */
//	*(volatile ulong *)(CFG_TIMERBASE + 8) = 0x000000C2;
	*(volatile ulong *)(CFG_TIMERBASE + 4) = CFG_HZ_CLOCK;//0xffffffff;
	*(volatile ulong *)(CFG_TIMERBASE + 8) = 0;
	*(volatile ulong *)(CFG_TIMERBASE + 0x30) = 0x00000001;
	/* init the timestamp */
	total_count = 0ULL;
	reset_timer_masked();

	div_timer	= (unsigned long long)(CFG_HZ_CLOCK / CFG_HZ); /* each u-boot tick need how much timer tick */
	div_timer /= div_clock;

	return (0);
}

/*
 * timer without interrupts
 */
void reset_timer (void)
{
	reset_timer_masked ();
}

ulong get_timer (ulong base_ticks)
{
	return get_timer_masked () - base_ticks;
}

void set_timer (ulong ticks)
{
	timestamp = ticks;
	total_count = (unsigned long long)ticks * div_timer;
}

/* delay usec useconds */
void udelay (unsigned long usec)
{
	ulong tmo, tmp;

	/* Convert to U-Boot ticks */
//	tmo	= usec * CFG_HZ;
//	tmo /= (1000000L);
	tmo	= usec * (CFG_HZ_CLOCK /1000000L);  /* need how much timer ticks */
        tmo/=div_timer; /* need how much u-boot ticks */

	tmp = get_timer_masked();	/* get current timestamp */
	tmo += tmp;			/* form target timestamp */

	while (get_timer_masked () < tmo) {/* loop till event */
		/*NOP*/;
	}
}

void reset_timer_masked (void)
{
	/* capure current decrementer value */
	lastdec		= (unsigned long long)READ_TIMER;
	/* start "advancing" time stamp from 0 */
	timestamp = 0L;
}

/* converts the timer reading to U-Boot ticks */
/* the timestamp is the number of ticks since reset */
ulong get_timer_masked (void)
{
	/* get current count */
	unsigned long long now = (unsigned long long)READ_TIMER;

	if(now > lastdec) {
		/* Must have wrapped */
		total_count += lastdec + TIMER_LOAD_VAL + 1 - now;
	} else {
		total_count += lastdec - now;
	}
	lastdec = now;
	timestamp = (ulong)(total_count/div_timer); /* convert to u-boot ticks */
//printf("<%x>",timestamp);
	return timestamp;
}

/* waits specified delay value and resets timestamp */
void udelay_masked (unsigned long usec)
{
	udelay(usec);
}

/*
 * This function is derived from PowerPC code (read timebase as long long).
 * On ARM it just returns the timer value.
 */
unsigned long long get_ticks(void)
{
	return (unsigned long long)get_timer(0);
}

/*
 * Return the timebase clock frequency
 * i.e. how often the timer decrements
 */
ulong get_tbclk (void)
{
//	return (ulong)(((unsigned long long)CFG_HZ_CLOCK)/div_clock);
//	return (ulong)((unsigned long long)div_timer);
	return (ulong)((unsigned long long)CFG_HZ);
}

