#define TRUE			1
#define FALSE			0
#define DONT_CARE		0

#ifndef NULL
#define NULL			0x00
#endif

#define FIE3420_APBBRG_BASE			(0x90500000)
#define APBBRG_CHANNEL_TX			(FIE3420_APBBRG_BASE + 0x80)
#define APBBRG_CHANNEL_RX			(FIE3420_APBBRG_BASE + 0x90)
#define APBBRG_REG_SRC				(0x0)	
#define APBBRG_REG_DST				(0x4)
#define APBBRG_REG_CYCLE			(0x8)
#define APBBRG_REG_CMD				(0xC)
#define APBBRG_DMA_FININTENB		0x4
#define APBBRG_DMA_FININTSTS		0x2
#define APBBRG_DMA_ERRINTENB		0x20
#define APBBRG_DMA_ERRINTSTS		0x10


#define USE_INLINE

#ifdef USE_INLINE
	__inline INT32U inw(INT32U *port)
#else
	INT32U inw(INT32U *port)
#endif
{
	return *((volatile INT32U *)port);
}

#ifdef USE_INLINE
	__inline void outw(INT32U *port, INT32U data)
#else
	void outw(INT32U *port, INT32U data)
#endif
{
 	*((volatile INT32U *)port) = data;
}

