/*
 * (C) Copyright 2006
 * Faraday Technology Corp, <www.faraday-tech.com>
 * Fred Chien <fred@faraday-tech.com>
 *
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include "define.h"
#include "../../drivers/net/ftmac110.h"
extern u16 ftmac110_read_phy_register(unsigned char phyaddr, unsigned char phyreg);

static void flash__init (void);
//static void ether__init (void);
void peripheral_power_enable (void);

#if defined(CONFIG_SHOW_BOOT_PROGRESS)
void show_boot_progress(int progress)
{
	printf("Boot reached stage %d\n", progress);
}
#endif

#define COMP_MODE_ENABLE ((unsigned int)0x0000EAEF)

/*
 * Miscellaneous platform dependent initialisations
 */

int board_init (void)
{
	DECLARE_GLOBAL_DATA_PTR;

	/* arch number of Integrator Board */
	gd->bd->bi_arch_number = MACH_TYPE_FARADAY;

	/* adress of boot parameters */
	gd->bd->bi_boot_params = 0x00000100;

	gd->flags = 0;
	gd->baudrate=CONFIG_BAUDRATE;

#ifdef CONFIG_CM_REMAP
extern void cm_remap(void);
	cm_remap();	/* remaps writeable memory to 0x00000000 */
#endif
	icache_enable ();
//	nandc_init ();
//	ether__init ();
	return 0;
}

/* cwz */
//int nand_init(void)
//{
/*
	nandc_init ();
*/
//        nand_probe(NANDC_FLASH_BASE);
/*        if (nand_dev_desc[0].ChipID != NAND_ChipID_UNKNOWN) {
                print_size(nand_dev_desc[0].totlen, "\n");
        }
*/

//}

int board_eth_init(bd_t *bis)
{
	int ret;
	u16 value;

	*(volatile ulong *)(CONFIG_PMU_BASE + 0x38) &= ~(1<<8);
	*(volatile ulong *)(CONFIG_PMU_BASE + 0x6c) |= (1<<16);

#ifdef CONFIG_FTGMAC100
	ret= ftgmac100_initialize(bis);
#else
	ret= ftmac110_initialize(bis);

	//	return ftmac110_initialize(bis);
	value=0;
	value=ftmac110_read_phy_register(0, 1);
#ifdef FTMAC_DEBUG
	printf("PHY reg(0x01)=%x\n",value);
	if(value &0x0020)
		printf("Auto-negotiation process completed\n");
	else
		printf("Auto-negotiation process NOT completed\n");
#endif
#endif
	return ret;
}

int misc_init_r (void)
{
	setenv("verify", "n");
	return (0);
}

/******************************
 Routine:
 Description: The nc6012 uses  CFI flash.
 In order for the CFI commands to work we must ensure that
 the flash is accessible.
 Also sets up the number of banks for a later check against
 include/configs/nc6012.h
******************************/
int nbanks	= 0xDEADBABE;
int sizeIndex	= 0xCAFEBABE;
static void flash__init (void)
{
}
/******************************
 Routine:
 Description: Check Integrator/CP control
							register settings against
				configs header.
******************************/
/*
void flash_check(void) {
	unsigned int sizes[] =	{0x01000000, 0x02000000};
	if(nbanks != CFG_MAX_FLASH_BANKS){
		printf(	"The board control register indicates %d flash banks, "
			"<U-Boot root>/include/configs/integratorcp.h::"
			"CFG_MAX_FLASH_BANKS is set to %d\n" \
			,nbanks, CFG_MAX_FLASH_BANKS);
	}

	if(PHYS_FLASH_SIZE != sizes[sizeIndex]){
		printf(	"The board control register indicates 0x%08x bytes of "
			"flash, <U-Boot root>/include/configs/integratorcp.h"
			"::PHYS_FLASH_SIZE is set to 0x%08x\n" \
			,sizes[sizeIndex], PHYS_FLASH_SIZE);
	}
}
*/
/*************************************************************
 Routine:ether__init
 Description: take the Ethernet controller out of reset and wait
				for the EEPROM load to complete.
*************************************************************/
static void ether__init (void)
{
}

/******************************
 Routine:
 Description:
******************************/
int dram_init (void)
{
	DECLARE_GLOBAL_DATA_PTR;

	gd->bd->bi_dram[0].start = PHYS_SDRAM;
	gd->bd->bi_dram[0].size	 = PHYS_SDRAM_SIZE;

#ifdef CONFIG_CM_SPD_DETECT
		{
extern void dram_query(void);
	unsigned long cm_reg_sdram;
	unsigned long sdram_shift;

	dram_query();	/* Assembler accesses to CM registers */
			/* Queries the SPD values */

	/* Obtain the SDRAM size from the CM SDRAM register */

	cm_reg_sdram = *(volatile ulong *)(CM_BASE + OS_SDRAM);
	/*	 Register				SDRAM size
	 *
	 *	 0xXXXXXXbbb000bb	 16 MB
	 *	 0xXXXXXXbbb001bb	 32 MB
	 *	 0xXXXXXXbbb010bb	 64 MB
	 *	 0xXXXXXXbbb011bb	128 MB
	 *	 0xXXXXXXbbb100bb	256 MB
	 *
	 */
	sdram_shift		 = ((cm_reg_sdram & 0x0000001C)/4)%4;
	gd->bd->bi_dram[0].size	 = 0x01000000 << sdram_shift;

		}
#endif /* CM_SPD_DETECT */

	return 0;
}

/* The Integrator/CP timer1 is clocked at 1MHz
 * can be divided by 16 or 256
 * and can be set up as a 32-bit timer
 */
/* U-Boot expects a 32 bit timer, running at CFG_HZ */
/* Keep total timer count to avoid losing decrements < div_timer */
static unsigned long long total_count = 0;
static unsigned long long lastdec;	 /* Timer reading at last call */
static unsigned long long div_clock = 1; /* Divisor applied to timer clock */
static unsigned long long div_timer = 1; /* Divisor to convert timer reading
					  * change to U-Boot ticks
					  */
/* CFG_HZ = CFG_HZ_CLOCK/(div_clock * div_timer) */
static ulong timestamp;		/* U-Boot ticks since startup */

#define TIMER_LOAD_VAL (CFG_HZ_CLOCK)
#define READ_TIMER (*(volatile ulong *)(CFG_TIMERBASE))

/* all function return values in U-Boot ticks i.e. (1/CFG_HZ) sec
 *	- unless otherwise stated
 */

/* starts up a counter
 * - the Integrator/CP timer can be set up to issue an interrupt */
int interrupt_init (void)
{
	/* Load timer with initial value */
	*(volatile ulong *)(CFG_TIMERBASE + 0) = CFG_HZ_CLOCK;
	/* Set timer to be
	 *	enabled			1
	 *	periodic		1
	 *	no interrupts		0
	 *	X			0
	 *	divider 1	 00 == less rounding error
	 *	32 bit			1
	 *	wrapping		0
	 */
//	*(volatile ulong *)(CFG_TIMERBASE + 8) = 0x000000C2;
	*(volatile ulong *)(CFG_TIMERBASE + 4) = CFG_HZ_CLOCK;//0xffffffff;
	*(volatile ulong *)(CFG_TIMERBASE + 8) = 0;
	*(volatile ulong *)(CFG_TIMERBASE + 0x30) = 0x00000001;
	/* init the timestamp */
	total_count = 0ULL;
	reset_timer_masked();

	div_timer	= (unsigned long long)(CFG_HZ_CLOCK / CFG_HZ); /* each u-boot tick need how much timer tick */
	div_timer /= div_clock;

	return (0);
}

/*
 * timer without interrupts
 */
void reset_timer (void)
{
	reset_timer_masked ();
}

ulong get_timer (ulong base_ticks)
{
	return get_timer_masked () - base_ticks;
}

void set_timer (ulong ticks)
{
	timestamp = ticks;
	total_count = (unsigned long long)ticks * div_timer;
}

/* delay usec useconds */
void udelay (unsigned long usec)
{
	ulong tmo, tmp;

	/* Convert to U-Boot ticks */
//	tmo	= usec * CFG_HZ;
//	tmo /= (1000000L);
	tmo	= usec * (CFG_HZ_CLOCK /1000000L);  /* need how much timer ticks */
        tmo/=div_timer; /* need how much u-boot ticks */

	tmp = get_timer_masked();	/* get current timestamp */
	tmo += tmp;			/* form target timestamp */

	while (get_timer_masked () < tmo) {/* loop till event */
		/*NOP*/;
	}
}

void reset_timer_masked (void)
{
	/* capure current decrementer value */
	lastdec		= (unsigned long long)READ_TIMER;
	/* start "advancing" time stamp from 0 */
	timestamp = 0L;
}

/* converts the timer reading to U-Boot ticks */
/* the timestamp is the number of ticks since reset */
ulong get_timer_masked (void)
{
	/* get current count */
	unsigned long long now = (unsigned long long)READ_TIMER;

	if(now > lastdec) {
		/* Must have wrapped */
		total_count += lastdec + TIMER_LOAD_VAL + 1 - now;
	} else {
		total_count += lastdec - now;
	}
	lastdec = now;
	timestamp = (ulong)(total_count/div_timer); /* convert to u-boot ticks */
//printf("<%x>",timestamp);
	return timestamp;
}

/* waits specified delay value and resets timestamp */
void udelay_masked (unsigned long usec)
{
	udelay(usec);
}

/*
 * This function is derived from PowerPC code (read timebase as long long).
 * On ARM it just returns the timer value.
 */
unsigned long long get_ticks(void)
{
	return (unsigned long long)get_timer(0);
}

/*
 * Return the timebase clock frequency
 * i.e. how often the timer decrements
 */
ulong get_tbclk (void)
{
//	return (ulong)(((unsigned long long)CFG_HZ_CLOCK)/div_clock);
//	return (ulong)((unsigned long long)div_timer);
	return (ulong)((unsigned long long)CFG_HZ);
}

#ifndef CONFIG_SKIP_LOWLEVEL_INIT

#define SYS_CLK		12000000
#define VGA_CONFIG	0	// default vga setting = 1024x768

struct vga_setting {
	uint ns;
	uint ms;
	char resolution[10];
};

struct vga_setting vgs[] =
{
	{54,  1, "1024x768"},
	{63,  1, "1280x800"},
	{135, 2, "1280x960"},
	{54,  1, "1280x1024"},
	{72,  1, "1360x768"},
	{99,  2, "720P"},
	{99,  2, "1080I"},
	{63,  1, "800x600"},
	{0,   0, ""}
};

uint vga_res = VGA_CONFIG;

uint u32PMU_ReadPLL1CLK(void)
{
    uint mul, div;

    mul = (inw(CONFIG_PMU_BASE+0x30) >>  4) & 0xff;
    div = (inw(CONFIG_PMU_BASE+0x30) >> 12) & 0xff;

    return (SYS_CLK * mul / div);
}

uint u32PMU_ReadPLL2CLK(void)
{
	uint mul, div;

	mul = (inw(CONFIG_PMU_BASE+0x34) >> 20) & 0xff;
	div = (inw(CONFIG_PMU_BASE+0x34) >> 28) & 0x0f;

	return (SYS_CLK * mul / div);
}

uint u32PMU_ReadPLL3CLK(void)
{
	uint mul, div;

	mul = (inw(CONFIG_PMU_BASE+0x34) >>  4) & 0xff;
	div = (inw(CONFIG_PMU_BASE+0x34) >> 12) & 0x0f;

	return (SYS_CLK * mul / div);
}

uint u32PMU_ReadDDRCLK(void)
{
    uint pll1_out;
    uint cpu3x;

    cpu3x = (inw(CONFIG_PMU_BASE+0x30) >> 24) & 0x3;

    pll1_out = u32PMU_ReadPLL1CLK();

    if(cpu3x == 0)
    	return pll1_out / 1;
    else if(cpu3x == 1)
        return pll1_out / 2;
    else if(cpu3x == 2)
    	return pll1_out / 3;
    else {
		if (GET_PLAT_ID() == GPLAT_8181_ID)
	        return u32PMU_ReadPLL3CLK();
    }
}

uint u32PMU_ReadCPUCLK(void)
{
    uint pll1_out;
    uint cpu3x;

    cpu3x = (inw(CONFIG_PMU_BASE+0x30) >> 28) & 0x3;

    pll1_out = u32PMU_ReadPLL1CLK();

    if(cpu3x == 0)
    	return pll1_out / 1;
    else if(cpu3x == 1)
        return pll1_out / 2;
    else if(cpu3x == 2)
    	return pll1_out / 3;
    else {
		if (GET_PLAT_ID() == GPLAT_8181_ID)
	        return pll1_out / 6;
		else
			return pll1_out / 3 * 2;
	}
}

uint u32PMU_ReadHCLK(void)
{
    uint pll1_out;
    uint cpu3x;

    cpu3x = (inw(CONFIG_PMU_BASE+0x30) >> 26) & 0x3;

    pll1_out = u32PMU_ReadPLL1CLK();

    if(cpu3x == 0)
    	return pll1_out / 1;
    else if(cpu3x == 1)
    	return pll1_out / 2;
    else if(cpu3x == 2)
    	return pll1_out / 3;
    else {
		if (GET_PLAT_ID() == GPLAT_8181_ID)
    		return pll1_out / 6;
		else
			return pll1_out / 4;
	}
}

uint u32PMU_ReadPCLK(void)
{
    return (u32PMU_ReadHCLK() >> 1);
}

uint u32PMU_ReadJpegCLK(void)
{
    uint div,clk;
    clk = inw(CONFIG_PMU_BASE+0x28);
    if(clk & BIT9)
		return u32PMU_ReadHCLK();

    div = (inw(CONFIG_PMU_BASE+0x74) >> 8) & 0xf;
    return (u32PMU_ReadPLL3CLK() / (div + 1));
}

uint u32PMU_ReadH264encCLK(void)
{
    uint div,clk;
    clk = inw(CONFIG_PMU_BASE+0x28);
    if(clk & BIT11)
		return u32PMU_ReadHCLK();

    div = (inw(CONFIG_PMU_BASE+0x74) >> 0) & 0xf;
    return (u32PMU_ReadPLL3CLK() / (div + 1));
}

uint u32PMU_ReadH264decCLK(void)
{
    uint div,clk;
    clk = inw(CONFIG_PMU_BASE+0x28);
    if(clk & BIT10)
		return u32PMU_ReadHCLK();

    div = (inw(CONFIG_PMU_BASE+0x74) >> 4) & 0xf;
    return (u32PMU_ReadPLL3CLK() / (div + 1));
}

void display_sys_freq(void)
{
	printf("\n  ----------------------------------------------------------------------------\n");
	printf("   PLL1:%4d MHz       PLL2:%4d MHz       PLL3:%4d MHz       DDR:%4d MHz\n",
		u32PMU_ReadPLL1CLK()/1000000, u32PMU_ReadPLL2CLK()/1000000,
		u32PMU_ReadPLL3CLK()/1000000, u32PMU_ReadDDRCLK()/1000000);
	printf("   CPU :%4d MHz       HCLK:%4d MHz       PCLK:%4d MHz\n",
		u32PMU_ReadCPUCLK()/1000000, u32PMU_ReadHCLK()/1000000, u32PMU_ReadPCLK()/1000000);
	printf("   JPEG:%4d MHz  H.264 enc:%4d MHz  H.264 dec:%4d MHz\n",
		u32PMU_ReadJpegCLK()/1000000, u32PMU_ReadH264encCLK()/1000000, u32PMU_ReadH264decCLK()/1000000);
	printf("   VGA : %s\n",
		vgs[vga_res].resolution);
	printf("  ----------------------------------------------------------------------------\n");
}

uint cal_pvalue(uint wclk)
{
	uint ret = 0, pll3clk;

	pll3clk = u32PMU_ReadPLL3CLK();

	ret = pll3clk/wclk;
	if ((pll3clk/ret) > wclk)
		ret++;
	ret -= 1;

	return ret;
}

void calculate_codec_clock(void)
{
	uint data;

	if (GET_PLAT_ID() == GPLAT_8181_ID) {
		/* Re-calculate CLOCK PVALUE of IPs */
		data = cal_pvalue(84000000); // IDE CLK PVALUE
		outw(CONFIG_PMU_BASE+0x70, (inw(CONFIG_PMU_BASE+0x70)&~0x1F)|data);
		data = cal_pvalue(33000000); // PCI CLK PVALUE
		outw(CONFIG_PMU_BASE+0x70, (inw(CONFIG_PMU_BASE+0x70)&~(0x1F<<15))|(data<<15));
		data = cal_pvalue(162000000); // JPEG(MCP100) CLK PVALUE
		outw(CONFIG_PMU_BASE+0x74, (inw(CONFIG_PMU_BASE+0x74)&~(0xF<<8))|(data<<8));
		data = cal_pvalue(162000000); // H264DEC(MCP220) CLK PVALUE
		outw(CONFIG_PMU_BASE+0x74, (inw(CONFIG_PMU_BASE+0x74)&~(0xF<<4))|(data<<4));
		data = cal_pvalue(216000000); // H264ENC(MCP210) CLK PVALUE
		outw(CONFIG_PMU_BASE+0x74, (inw(CONFIG_PMU_BASE+0x74)&~0xF)|data);
	} else {
		data = cal_pvalue(84000000); // IDE CLK PVALUE
		outw(CONFIG_PMU_BASE+0x70, (inw(CONFIG_PMU_BASE+0x70)&~0x1F)|data);
		data = cal_pvalue(33000000); // PCI CLK PVALUE
		outw(CONFIG_PMU_BASE+0x70, (inw(CONFIG_PMU_BASE+0x70)&~(0x1F<<15))|(data<<15));
		data = cal_pvalue(202500000); // JPEG(MCP100) CLK PVALUE
		outw(CONFIG_PMU_BASE+0x74, (inw(CONFIG_PMU_BASE+0x74)&~(0xF<<8))|(data<<8));
		data = cal_pvalue(250000000); // H264DEC(MCP220) CLK PVALUE
		outw(CONFIG_PMU_BASE+0x74, (inw(CONFIG_PMU_BASE+0x74)&~(0xF<<4))|(data<<4));
		data = cal_pvalue(290000000); // H264ENC(MCP210) CLK PVALUE
		outw(CONFIG_PMU_BASE+0x74, (inw(CONFIG_PMU_BASE+0x74)&~0xF)|data);
	}
}

void init_sys_freq(void)
{
	uint data;

	/* Configure AHBC01 for LCD priority high */
	if (GET_PLAT_ID() == GPLAT_8181_ID)
		outw(CONFIG_AHBC01_BASE+0x80, 0x00000002);
	else
		outw(CONFIG_AHBC06_BASE+0x80, 0x00000010);
	/* Configure AHBC04/AHBC05 for Capture0-7 priority high */
	outw(CONFIG_AHBC04_BASE+0x80, 0x000001FE);
	outw(CONFIG_AHBC05_BASE+0x80, 0x000001FE);

	/* Enable PLL3 */
	data = inw(CONFIG_PMU_BASE+0x34);
	if (GET_PLAT_ID() == GPLAT_8181_ID) {
		if (!((inw(CONFIG_PMU_BASE+0x30)>>24) & BIT7)) {
			/* only change PLL3 freq in DDR SYNC mode */
#if 1
			// adjust PLL3 freq out to 648MHz, default is 486MHz
			data &= ~0x0000FFFF;
			data |= (vgs[vga_res].ms<<12)|(vgs[vga_res].ns<<4)|(3<<2);
#else
			// adjust PLL3 freq out to 594MHz, default is 486MHz
			data &= ~0x0000FFFF;
			data |= (2<<12)|(99<<4)|(3<<2); // ms/ns/frang
#endif
		}
	} else { /* 8181T/8186 */
		// adjust PLL3 freq out to 648MHz, default is 486MHz
		data &= ~0x0000FFFF;
		data |= (vgs[vga_res].ms<<12)|(vgs[vga_res].ns<<4)|(1<<2); // ms/ns/frang
	}
	outw(CONFIG_PMU_BASE+0x34, data|BIT0);
	/* Wait for 500us */
	udelay(5000);

	/* Re-calculate CLOCK PVALUE of IPs */
	calculate_codec_clock();
	/* ultra config H.264 enc to SYNC mode */
	if (GET_PLAT_ID() == GPLAT_8181_ID) {
		outw(CONFIG_PMU_BASE+0x28, inw(CONFIG_PMU_BASE+0x28)|BIT11); // H264ENC(MCP210) CLK = HCLK
	} else {
		outw(CONFIG_PMU_BASE+0x28, inw(CONFIG_PMU_BASE+0x28)|BIT11|BIT10);
	}
}

#ifdef CONFIG_USE_IRQ

#define IRQ_PMU	    8

// only handle PMU irq
void do_irq (struct pt_regs *pt_regs)
{
	uint val;

	*(volatile ulong *)(CONFIG_PMU_BASE + 0x20) = (1<<17);
	val = *(volatile ulong *)(CONFIG_PMU_BASE + 0x0C);
    val &= ~0x4;
    *(volatile ulong *)(CONFIG_PMU_BASE + 0x0C) = val;

	*(volatile ulong *)(CONFIG_INTC_BASE + 0x08) = (1<<IRQ_PMU);
	*(volatile ulong *)(CONFIG_INTC_BASE + 0x04) &= ~(1<<IRQ_PMU);
}

void PMU_enter_fcs_mode(uint cpu3x, uint mul, uint div)
{
	uint setting, pllout;

	pllout = SYS_CLK * (mul & 0xFF) / (div & 0xff);
	pllout = pllout/1000000;

	/* pllns & pllms */
	setting = (cpu3x << 24) | (div << 12) | (mul << 4);

	/* pll frang */
	if (GET_PLAT_ID() == GPLAT_8181_ID) { /* 8181 series */
		if(pllout > 500)
			setting |= ((1<<20) | (1<<21));
		else if(pllout > 250)
			setting |= (1<<21);
		else if(pllout > 125)
			setting |= (1<<20);
	} else { /* 8186/8181T series */
		if(pllout > 500)
			setting |= (1<<20);
		if ((cpu3x >> 8) & 0x1)
			setting |= (1<<23);
		if ((cpu3x >> 9) & 0x1)
			setting |= (1<<22);
	}

	if(setting == (*(volatile ulong *)(CONFIG_PMU_BASE + 0x30) & 0xfffffff0))
		return;		// the same

	*(volatile ulong *)(CONFIG_PMU_BASE + 0x30) = setting;

	*(volatile ulong *)(CONFIG_INTC_BASE + 0x0C) &= ~(1<<IRQ_PMU);
	*(volatile ulong *)(CONFIG_INTC_BASE + 0x10) &= ~(1<<IRQ_PMU);
	*(volatile ulong *)(CONFIG_INTC_BASE + 0x04) |= (1<<IRQ_PMU);

	printf("go...");

	setting = *(volatile ulong *)(CONFIG_PMU_BASE + 0x0C);
	*(volatile ulong *)(CONFIG_PMU_BASE + 0x0C) = setting | (1<<2);

	setting = 0;
	__asm__ __volatile__ (
                " mcr p15, 0, %0, c7, c0, 4 " :
                "=r"(setting)::
                "memory"
            );
	__asm__ __volatile__ (" nop ":::"memory"); //return here from IDLE mode interrupt
}

void FCS_go(unsigned int cpu3x, unsigned int mul, unsigned int div)
{
	unsigned int pll1_out, pll3_out, fclk, hclk, ddrclk;
	unsigned int tmp;

	printf("Will set the following freq...\n");

	pll1_out = SYS_CLK * (mul & 0xFF) / div;
	pll3_out = u32PMU_ReadPLL3CLK();

	tmp = (cpu3x >> 0) & 0x3;
	if(tmp == 0)
		ddrclk = pll1_out / 1;
	else if(tmp == 1)
		ddrclk = pll1_out / 2;
	else if(tmp == 2)
		ddrclk = pll1_out / 3;
	else
		ddrclk = pll3_out;

	tmp = (cpu3x >> 2) & 0x3;
	if(tmp == 0)
		hclk = pll1_out / 1;
	else if(tmp == 1)
		hclk = pll1_out / 2;
	else if(tmp == 2)
		hclk = pll1_out / 3;
	else
		hclk = pll1_out / 6;

	tmp = (cpu3x >> 4) & 0x3;
	if(tmp == 0)
		fclk = pll1_out / 1;
	else if(tmp == 1)
		fclk = pll1_out / 2;
	else if(tmp == 2)
		fclk = pll1_out / 3;
	else
		fclk = pll1_out / 6;

	printf("PLL1: %d MHz, CPU freq: %d MHz, AHB freq: %d MHz, DDR freq: %d MHz\n",
		pll1_out/1000000, fclk/1000000, hclk/1000000, ddrclk/1000000);

	*(volatile ulong *)(CONFIG_INTC_BASE + 0x08) = (1<<IRQ_PMU);

	PMU_enter_fcs_mode(cpu3x, mul, div);
}

void FCS_go_T(unsigned int cpu3x, unsigned int mul, unsigned int div)
{
	unsigned int pll1_out, fclk, hclk, ddrclk;
	unsigned int tmp;

	printf("Will set the following freq...\n");

	pll1_out = SYS_CLK * (mul & 0xFF) / div;

	tmp = (cpu3x >> 0) & 0x3;
	if(tmp == 0)
		ddrclk = pll1_out / 1;
	else if(tmp == 1)
		ddrclk = pll1_out / 2;
	else if(tmp == 2)
		ddrclk = pll1_out / 3;
	else {
		if (GET_PLAT_ID() == GPLAT_8181T_ID) {
			printf("Invalid setting for DDRCLK\n");
			return;
		}
	}

	tmp = (cpu3x >> 2) & 0x3;
	if(tmp == 0)
		hclk = pll1_out / 1;
	else if(tmp == 1)
		hclk = pll1_out / 2;
	else if(tmp == 2)
		hclk = pll1_out / 3;
	else
		hclk = pll1_out / 4;

	tmp = (cpu3x >> 4) & 0x3;
	if(tmp == 0)
		fclk = pll1_out / 1;
	else if(tmp == 1)
		fclk = pll1_out / 2;
	else if(tmp == 2)
		fclk = pll1_out / 3;
	else
		fclk = pll1_out / 3 * 2;

	printf("PLL1: %d MHz, CPU freq: %d MHz, AHB freq: %d MHz, DDR freq: %d MHz\n",
		pll1_out/1000000, fclk/1000000, hclk/1000000, ddrclk/1000000);

	*(volatile ulong *)(CONFIG_INTC_BASE + 0x08) = (1<<IRQ_PMU);

	PMU_enter_fcs_mode(cpu3x, mul, div);
}
#endif
#endif
