/*
 * Board specific setup info
 *
 * (C) Copyright 2009, Faraday Tech Corp.
 * KJ, Lin, <kjlin@faraday-tech.com>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <config.h>
#include <version.h>

.global reset_cpu
reset_cpu:
	ldr r0, WDT_BASE
	mov r1, #0
	str r1, [r0]

	mov r1, #1
	str r1, [r0,#4]

	ldr r1, WDT_RESET
	str r1, [r0,#8]

	mov r1, #3
	str r1, [r0,#0xc]

reset_failed:
	b reset_failed

WDT_BASE:
	.word 0x99200000
WDT_RESET:
	.word 0x5ab9

#ifndef CONFIG_SKIP_LOWLEVEL_INIT

#ifdef CONFIG_PLATFORM_GM8126
/*
 * Setup DDR controller registers
 *
 *      r0 - DDR controller base address
 *      r1 - DDR configure table
 */
set_ddrconf:
	ldr r4, [r1], #4

0:
	ldr r2, [r1], #4
	ldr r3, [r1], #4
	str r3, [r0, r2]
	subs r4, r4, #1
	bne 0b

	ldr r3, =0x1
	str r3, [r0, #0x04]
1:
	ldr r3, [r0, #0x04]         // wait for stable
	and r3, r3, #0x100
	cmp r3, #0x100
	bne 1b

	mov pc, lr


init_memory:
	mov  r10, lr

	ldr  r0, =CONFIG_PMU_BASE
	ldr  r1, [r0, #0x00]
	and  r1, r1, #0x0000F000
	cmp  r1, #0x00001000
	beq  ddr_8181

	ldr  r1, [r0, #0x30]
	and  r1, r1, #0xFF000000
	cmp  r1, #0x14000000
	beq  ddr_90nm_408
	cmp  r1, #0x44000000
	beq  ddr_90nm_540
	b    ddr_90nm_810

	.type ddr0_config, #object
ddr0_config:
	.word 14
	.word 0x00, 0x00005C01
	.word 0x08, 0x00420642
	.word 0x0C, 0x00000000
	.word 0x10, 0x10003333        // 0x10000000/128MB will be modified after remap
	.word 0x18, 0x19492B4A
	.word 0x1C, 0x014C7230
	.word 0x20, 0x08000012
	.word 0x24, 0x00000004
	.word 0x28, 0x00000108
	.word 0x30, 0x1F000006
	.word 0x34, 0x148888C4
	.word 0x40, 0x00000000
	.word 0x48, 0x005555FF
	.word 0x4C, 0x14888884
	.size ddr0_config, . - ddr0_config

	.type ddr1_config, #object
ddr1_config:
	.word 14
	.word 0x00, 0x00005C01
	.word 0x08, 0x00420642
	.word 0x0C, 0x00000000
	.word 0x10, 0x08003333        // 0x08000000/128MB
	.word 0x18, 0x19492B4A
	.word 0x1C, 0x014C7230
	.word 0x20, 0x08000012
	.word 0x24, 0x00000004
	.word 0x28, 0x00000108
	.word 0x30, 0x1F000036
	.word 0x34, 0x18888884
	.word 0x40, 0x00000000
	.word 0x48, 0x005555FF
	.word 0x4C, 0x18884884
	.size ddr1_config, . - ddr1_config

ddr_8181:
	/* Configure DDR0 */
	ldr r0, =0x99300000
	adr r1, ddr0_config
	bl  set_ddrconf

	/* Configure DDR1 */
	ldr r0, =0x99700000
	adr r1, ddr1_config
	bl  set_ddrconf
	b   ddr_exit

	.type ddr0_config_90nm_408, #object
ddr0_config_90nm_408:
	.word 22
	.word 0x00, 0x00075D01
	.word 0x08, 0x00420642
	.word 0x0C, 0x00000000
	.word 0x10, 0x10004343
	.word 0x14, 0x1E0B0E0A
	.word 0x18, 0x21311323
	.word 0x1C, 0x01001930
	.word 0x20, 0x00000F52
	.word 0x24, 0x00000003
	.word 0x28, 0x00000924
	.word 0x2C, 0x00000000
	.word 0x30, 0x00000000
	.word 0x34, 0x06060606
	.word 0x38, 0x06060606
	.word 0x40, 0x00000000
	.word 0x48, 0x000000FF
	.word 0x74, 0x00000001
	.word 0x7C, 0xFFFFFFFF
	.word 0xA0, 0x87878787
	.word 0xA4, 0x87878787
	.word 0xA8, 0x0001A0AB
	.word 0xAC, 0x00061A80
	.size ddr0_config_90nm_408, . - ddr0_config_90nm_408

	.type ddr1_config_90nm_408, #object
ddr1_config_90nm_408:
	.word 22
	.word 0x00, 0x00075D01
	.word 0x08, 0x00420642
	.word 0x0C, 0x00000000
	.word 0x10, 0x20004343
	.word 0x14, 0x1E0B0E0A
	.word 0x18, 0x21311323
	.word 0x1C, 0x01001930
	.word 0x20, 0x00000F52
	.word 0x24, 0x00000003
	.word 0x28, 0x00000924
	.word 0x2C, 0x00000000
	.word 0x30, 0x00000000
	.word 0x34, 0x06060606
	.word 0x38, 0x06060606
    .word 0x40, 0x00000000
    .word 0x48, 0x000000FF
    .word 0x74, 0x00000001
    .word 0x7C, 0xFFFFFFFF
    .word 0xA0, 0x87878787
    .word 0xA4, 0x87878787
    .word 0xA8, 0x0001A0AB
    .word 0xAC, 0x00061A80
	.size ddr1_config_90nm_408, . - ddr1_config_90nm_408

ddr_90nm_408:
	/* Configure DDR0 */
	ldr r0, =0x99300000
	adr r1, ddr0_config_90nm_408
	bl  set_ddrconf

	/* Configure DDR1 */
	ldr r0, =0x99700000
	adr r1, ddr1_config_90nm_408
	bl  set_ddrconf
	b   ddr_exit

	.type ddr0_config_90nm_540, #object
ddr0_config_90nm_540:
	.word 22
	.word 0x00, 0x00075D01
	.word 0x08, 0x00420852
	.word 0x0C, 0x00000000
	.word 0x10, 0x10004343
	.word 0x14, 0x260E100D
	.word 0x18, 0x22411424
	.word 0x1C, 0x01001940
	.word 0x20, 0x00000F52
	.word 0x24, 0x00000003
	.word 0x28, 0x00000924
	.word 0x2C, 0x00000000
	.word 0x30, 0x00000000
	.word 0x34, 0x06060606
	.word 0x38, 0x06060606
	.word 0x40, 0x00000000
	.word 0x48, 0x000000FF
	.word 0x74, 0x00000001
	.word 0x7C, 0xFFFFFFFF
	.word 0xA0, 0x87878787
	.word 0xA4, 0x87878787
	.word 0xA8, 0x0001A0AB
	.word 0xAC, 0x00061A80
	.size ddr0_config_90nm_540, . - ddr0_config_90nm_540

	.type ddr1_config_90nm_540, #object
ddr1_config_90nm_540:
	.word 22
	.word 0x00, 0x00075D01
	.word 0x08, 0x00420852
	.word 0x0C, 0x00000000
	.word 0x10, 0x20004343
	.word 0x14, 0x260E100D
	.word 0x18, 0x22411424
	.word 0x1C, 0x01001940
	.word 0x20, 0x00000F52
	.word 0x24, 0x00000003
	.word 0x28, 0x00000924
	.word 0x2C, 0x00000000
	.word 0x30, 0x00000000
	.word 0x34, 0x06060606
	.word 0x38, 0x06060606
    .word 0x40, 0x00000000
    .word 0x48, 0x000000FF
    .word 0x74, 0x00000001
    .word 0x7C, 0xFFFFFFFF
    .word 0xA0, 0x87878787
    .word 0xA4, 0x87878787
    .word 0xA8, 0x0001A0AB
    .word 0xAC, 0x00061A80
	.size ddr1_config_90nm_540, . - ddr1_config_90nm_540

ddr_90nm_540:
	/* Configure DDR0 */
	ldr r0, =0x99300000
	adr r1, ddr0_config_90nm_540
	bl  set_ddrconf

	/* Configure DDR1 */
	ldr r0, =0x99700000
	adr r1, ddr1_config_90nm_540
	bl  set_ddrconf
	b   ddr_exit

	.type ddr0_config_90nm_810, #object
ddr0_config_90nm_810:
	.word 22
	.word 0x00, 0x00075D01
	.word 0x08, 0x00400C62
	.word 0x0C, 0x00000000
	.word 0x10, 0x10004343
	.word 0x14, 0x33141812
	.word 0x18, 0x43611646
	.word 0x1C, 0x01001961
	.word 0x20, 0x00000F52
	.word 0x24, 0x00000003
	.word 0x28, 0x00000924
	.word 0x2C, 0x00000000
	.word 0x30, 0x00000000
	.word 0x34, 0x06060606
	.word 0x38, 0x06060606
	.word 0x40, 0x00000000
	.word 0x48, 0x000000FF
	.word 0x74, 0x00000001
	.word 0x7C, 0xFFFFFFFF
	.word 0xA0, 0x87878787
	.word 0xA4, 0x87878787
	.word 0xA8, 0x0001A0AB
	.word 0xAC, 0x00061A80
	.size ddr0_config_90nm_810, . - ddr0_config_90nm_810

	.type ddr1_config_90nm_810, #object
ddr1_config_90nm_810:
	.word 22
	.word 0x00, 0x00075D01
	.word 0x08, 0x00400C62
	.word 0x0C, 0x00000000
	.word 0x10, 0x20004343
	.word 0x14, 0x33141812
	.word 0x18, 0x43611646
	.word 0x1C, 0x01001961
	.word 0x20, 0x00000F52
	.word 0x24, 0x00000003
	.word 0x28, 0x00000924
	.word 0x2C, 0x00000000
	.word 0x30, 0x00000000
	.word 0x34, 0x06060606
	.word 0x38, 0x06060606
    .word 0x40, 0x00000000
    .word 0x48, 0x000000FF
    .word 0x74, 0x00000001
    .word 0x7C, 0xFFFFFFFF
    .word 0xA0, 0x87878787
    .word 0xA4, 0x87878787
    .word 0xA8, 0x0001A0AB
    .word 0xAC, 0x00061A80
	.size ddr1_config_90nm_810, . - ddr1_config_90nm_810

ddr_90nm_810:
	/* Configure DDR0 */
	ldr r0, =0x99300000
	adr r1, ddr0_config_90nm_810
	bl  set_ddrconf

	/* Configure DDR1 */
	ldr r0, =0x99700000
	adr r1, ddr1_config_90nm_810
	bl  set_ddrconf
	b   ddr_exit

ddr_exit:
	mov lr, r10
	mov pc, lr


/* Initial AHB bus to default */
init_ahbbus:
	/* Initial DDR0 base on AHBC0 bus */
	ldr r0, =0x90000000
	ldr r1, =0x00080000
	ldr r2, =0x10080000
	str r1, [r0, #0x10]		// SMC
	str r2, [r0, #0x18]		// DDR0

	/* Configure DDR0/DDR1 base on AHBC1 ~ AHBC6 bus for 0.13um */
	/* Configure DDR0/DDR1 base on AHBC1 ~ AHBC7 bus for 90nm */
	ldr	r4, =CONFIG_PMU_BASE
	ldr r3, [r4, #0x00]
	and r3, r3, #0x0000F000
	cmp r3, #0x00002000
	bne skip_ahb7_conf
	mov r3, #7
	b   set_conf
skip_ahb7_conf:
	mov r3, #6
set_conf:
0:
	add r0, r0, #0x100000
	ldr r1, =0x00070000                 // DDR0 128MB
	ldr r2, =0x08070000                 // DDR1 128MB
	str r1, [r0, #0x00]
	str r2, [r0, #0x04]
	subs r3, r3, #1
	bne 0b

	mov pc, lr
#endif /* end of #ifdef CONFIG_PLATFORM_GM8126 */

/* Set up the platform, once the cpu has been initialized */
.globl lowlevel_init
lowlevel_init:
	/* If U-Boot has been run after the ARM boot monitor
	 * then all the necessary actions have been done
	 * otherwise we are running from user flash mapped to 0x00000000
	 * --- DO NOT REMAP BEFORE THE CODE HAS BEEN RELOCATED --
	 * Changes to the (possibly soft) reset defaults of the processor
	 * itself should be performed in cpu/arm<>/start.S
	 * This function affects only the core module or board settings
	 */
	mov r13, lr

#ifdef CONFIG_PLATFORM_GM8126
	/* set clock */
	ldr	r0, =CONFIG_PMU_BASE
	ldr	r1, [r0, #0x38]		/* AHB clock */
	ldr	r2, =0xFFFFF7B3		/* MEMC/DDR2/JPEG/DMA */
	and	r1, r1, r2
	str	r1, [r0, #0x38]

	ldr	r1, [r0, #0x3C]		/* APB clock */
	ldr	r2, =0xFFDDFFFE		/* UART0/TIMER/INTC */
	and	r1, r1, r2
	str	r1, [r0, #0x3C]

	/* CONFIG_PLL2_750MHZ */
	ldr     r1, [r0, #0x34]
	ldr     r2, =0x0000FFFF
	and     r1, r1, r2
    ldr     r3, [r0, #0x00]
    and     r3, r3, #0x0000F000
    cmp     r3, #0x00001000
    bne     pll2_90nm
	ldr     r2, =0x27DC0000			/* 0.13um setting */
	b       pll2_conf
pll2_90nm:
    ldr     r2, =0x27D40000			/* 90nm setting */
pll2_conf:
	orr     r1, r1, r2				/* PLL2 freq = 750MHz */
	orr     r1, r1, #0x00010000		/* Enable PLL2 */
	str     r1, [r0, #0x34]

	/* delay to wait clock stable */
	ldr     r2, =0x5265C0			/* 10ms in CPU 540MHz */
	mov     r1, #0
pll2_wait:
	add     r1, r1, #1
	cmp     r1, r2
	bne     pll2_wait

	/* set UART clock */
	ldr     r0, =CONFIG_PMU_BASE
	ldr     r1, [r0, #0x28]			/* change UART clock source to divider output */
	ldr     r2, =0x00000080
	orr     r1, r1, r2
	str     r1, [r0, #0x28]
	ldr     r1, [r0, #0x70]			/* set MAC PVALUE */
	ldr     r2, =0xC1FFFFFF
	and     r1, r1, r2
	ldr     r2, =0x0A000000
	orr     r1, r1, r2
	str     r1, [r0, #0x70]
	ldr     r1, [r0, #0x78]			/* set UART PVALUE */
	ldr     r2, =0xFFE07FFF
	and     r1, r1, r2
	ldr     r2, =0x00020000
	orr     r1, r1, r2
	str     r1, [r0, #0x78]
	ldr     r1, [r0, #0x6C]			/* enable MAC pin output mode */
	ldr     r2, =0x00010000
	orr     r1, r1, r2
	str     r1, [r0, #0x6C]
	ldr     r1, [r0, #0x38]			/* enable MAC clock */
	ldr     r2, =0xFFFFFEFF
	and     r1, r1, r2
	str     r1, [r0, #0x38]

#ifdef BOOT_DEBUG
	/* enable UART for early debug trace */
	ldr	r1, =0x98300008
	ldr	r2, =0x35
	str	r2, [r1]

	ldr	r1, =0x9830000C
	ldr	r2, =0x083
	str	r2, [r1]

	ldr	r1, =0x98300000
	ldr	r2, =0x13;
	str	r2, [r1]

	ldr	r1, =0x9830000C
	ldr	r2, =0x003
	str	r2, [r1]

	ldr	r1, =0x98300000
	ldr	r2, =0x30		/* write '0' */
	str	r2, [r1]
#endif

#ifndef CONFIG_NAND
	bl  init_ahbbus

	bl	init_memory

	/* Flash parameter */
	ldr r0, =0x92100000
	ldr r1, =0x10000040		/* 8 bit, BNK size 16 MB, disable write protect */
	str r1, [r0]

	ldr r0, =0x92100004
	ldr r1, =0x010FF0F1
	str r1, [r0]

	/* relocate uboot to RAM for remap */
	ldr	r0, =0x00000000		/* r0 <- current position of code */
	ldr	r2, __stext
	ldr	r3, __sbss
	sub	r2, r3, r2		/* r2 <- size of armboot */
	ldr	r1, =0x10000000		/* r1 <- destination address */
	add	r2, r0, r2		/* r2 <- source end address */

	/*
	 * r0 = source address
	 * r1 = target address
	 * r2 = source end address
	 */
copy_remap:
	ldmia r0!, {r3-r10}
	stmia r1!, {r3-r10}
	cmp	r0, r2
	ble	copy_remap

	/* Fix DDR0 register for remap */
	ldr r0, =0x99300000
	ldr	r1, [r0, #0x10]
	and r1, r1, #0x00FFFFFF
	str	r1, [r0, #0x10]
base_wait:
    ldr r2, [r0, #0x10]
    cmp r1, r2
    bne base_wait

	/* Fix DDR1 register for remap */
	ldr r0, =0x99700000
	ldr	r1, [r0, #0x10]
	and r1, r1, #0x00FFFFFF
    orr r1, r1, #0x08000000
	str	r1, [r0, #0x10]
base_wait1:
    ldr r2, [r0, #0x10]
    cmp r1, r2
    bne base_wait1

	/* Remap slave4 & slave6 on AHBC0 bus */
	ldr	r0, =0x90000000
	ldr	r1, [r0, #0x88]
	orr	r1, r1, #0x1
	str	r1, [r0, #0x88]
	nop
	nop

	/* Fix DDR0/DDR1 base on AHBC0 bus after remap */
	ldr	r0, =0x90000000
	ldr	r1, =0x00070000
	ldr	r2, =0x08070000
	str	r1, [r0, #0x18]
	str	r2, [r0, #0x14]
#endif

	/* mask all IRQs by clearing all bits in the INTMRs */
	mov r1, #0x00
	ldr r0, =(CONFIG_INTC_BASE+0x04)
	str r1, [r0]
	ldr r0, =(CONFIG_INTC_BASE+0x24)
	str r1, [r0]
#endif /* end of #ifdef CONFIG_PLATFORM_GM8126 */

	mov lr, r13
	mov	pc, lr

__stext:
	.word TEXT_BASE

__sbss:
	.word __bss_start

#endif
