/*
 * (C) Copyright 2006
 * Faraday Technology Corp, <www.faraday-tech.com>
 * Fred Chien <fred@faraday-tech.com>
 *
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include "define.h"
#include "../../drivers/net/ftmac110.h"
extern u16 ftmac110_read_phy_register(unsigned char phyaddr, unsigned char phyreg);

static void flash__init (void);
//static void ether__init (void);
void peripheral_power_enable (void);

#if defined(CONFIG_SHOW_BOOT_PROGRESS)
void show_boot_progress(int progress)
{
	printf("Boot reached stage %d\n", progress);
}
#endif

#define COMP_MODE_ENABLE ((unsigned int)0x0000EAEF)

/*
 * Miscellaneous platform dependent initialisations
 */

int board_init (void)
{
	DECLARE_GLOBAL_DATA_PTR;

	/* arch number of Integrator Board */
	gd->bd->bi_arch_number = MACH_TYPE_FARADAY;

	/* adress of boot parameters */
	gd->bd->bi_boot_params = 0x00000100;

	gd->flags = 0;
	gd->baudrate=CONFIG_BAUDRATE;

#ifdef CONFIG_CM_REMAP
extern void cm_remap(void);
	cm_remap();	/* remaps writeable memory to 0x00000000 */
#endif
	icache_enable ();
//	nandc_init ();
//	ether__init ();
	return 0;
}

/* cwz */
//int nand_init(void)
//{
/*
	nandc_init ();
*/
//        nand_probe(NANDC_FLASH_BASE);
/*        if (nand_dev_desc[0].ChipID != NAND_ChipID_UNKNOWN) {
                print_size(nand_dev_desc[0].totlen, "\n");
        }
*/

//}
void board_pmu_eth_init(int internal)
{
	u32 reg_v, reg_pll1;
    u32 mul, div, clk;

	if(internal) {
		/* turn on Power */
		*(volatile ulong *)(CONFIG_PMU_BASE + 0x6c) |= ((BIT10) | (BIT18)); //bit10(mac_clk_en)) and bit18(reg_enable)
		/* turn on CLK */
		*(volatile ulong *)(CONFIG_PMU_BASE + 0x38) &= ~0x00000500; // (bit10 and bit8)

		mdelay(60);
		//*(volatile ulong *)(CONFIG_PMU_BASE + 0x84) = 0x0012c170; // The mac phy hardware reset should be longer than 500 ns
		//*(volatile ulong *)(CONFIG_PMU_BASE + 0x84) = 0x0012c140; // The mac phy hardware reset should be longer than 500 ns
		*(volatile ulong *)(CONFIG_PMU_BASE + 0x84) = 0x0012c100; // The mac phy hardware reset should be longer than 500 ns
		
		/* check MAC CLK */ 
		reg_v = *(volatile ulong *)(CONFIG_PMU_BASE + 0x74) & 0x03ffffff;
		reg_pll1 = *(volatile ulong *)(CONFIG_PMU_BASE + 0x30);
	    mul = (reg_pll1 >>  3) & 0x1FF;    /* N */
	    div = (reg_pll1 >> 12) & 0x1F;     /* M */
		clk = 30 * mul / div ;
		//MII 25MHz
		reg_v |= (((clk / 25) - 1) << 26); 
		*(volatile ulong *)(CONFIG_PMU_BASE + 0x74) = reg_v;

		reg_v = *(volatile ulong *)(CONFIG_PMU_BASE + 0x5c) & 0x0fffffff;
		reg_v |= 0x50000000; //  X_EDP_LINKLED pin is mux-ed out,  X_EDP_SPDLED pin is mux-ed out
		*(volatile ulong *)(CONFIG_PMU_BASE + 0x5c) = reg_v;
		mdelay(10);
		
		//*(volatile ulong *)(CONFIG_PMU_BASE + 0x84) = 0x0012c171; // reset Faraday PHY, for 10M/half
		//*(volatile ulong *)(CONFIG_PMU_BASE + 0x84) = 0x0012c141; // reset Faraday PHY, for 100M/half
		*(volatile ulong *)(CONFIG_PMU_BASE + 0x84) = 0x0012c101; // reset Faraday PHY, for N-Way
	} else {
		/* bit10(mac_clk_en), bit19(RMII), bit11(mac_phy_bypas) */
		*(volatile ulong *)(CONFIG_PMU_BASE + 0x6c) |= ((BIT10)|(BIT11)|(BIT19)); 
		/* bit18(reg_enable=0) */
		*(volatile ulong *)(CONFIG_PMU_BASE + 0x6c) &= ~(BIT18); 			
		/* turn on CLK */
		*(volatile ulong *)(CONFIG_PMU_BASE + 0x38) &= ~0x00000500; // (bit10 and bit8)
		mdelay(60);
		/* check MAC CLK */ 
		reg_v = *(volatile ulong *)(CONFIG_PMU_BASE + 0x74) & 0x03ffffff;
		reg_pll1 = *(volatile ulong *)(CONFIG_PMU_BASE + 0x30);
	    mul = (reg_pll1 >>  3) & 0x1FF;    /* N */
	    div = (reg_pll1 >> 12) & 0x1F;     /* M */
		clk = 30 * mul / div ;
		reg_v |= (((clk / 25) - 1) << 26);
		*(volatile ulong *)(CONFIG_PMU_BASE + 0x74) = reg_v;
		*(volatile ulong *)(CONFIG_PMU_BASE + 0x28) &= ~0x0000003f;	// debug mode turnoff
		/* for pin muxed out */
		*(volatile ulong *)(CONFIG_PMU_BASE + 0x64) = 0x15555555;
	}
}


int board_eth_init(bd_t *bis)
{
	int ret;
	u16 value;
	int internalPhy=1; /* 0:external PHY, 1:internal PHY */

	board_pmu_eth_init(internalPhy); /*internalPhy ==> 0:external PHY, 1:internal PHY */

#ifdef CONFIG_FTGMAC100
	ret= ftgmac100_initialize(bis);
#else
	ret= ftmac110_initialize(bis);
	//	return ftmac110_initialize(bis);

#ifdef FTMAC_DEBUG
	value=0;
	if(internalPhy) {
		value=ftmac110_read_phy_register(1, 1);	// PHY_ADD 1
	} else {
		value=ftmac110_read_phy_register(0, 1); // PHY_ADD 0
	}
	printf("PHY reg(0x01)=%x\n",value);
	if(value &0x0020)
		printf("Auto-negotiation process completed\n");
	else
		printf("Auto-negotiation process NOT completed\n");
#endif
#endif
	return ret;
}

int misc_init_r (void)
{
	setenv("verify", "n");
	return (0);
}

/******************************
 Routine:
 Description: The nc6012 uses  CFI flash.
 In order for the CFI commands to work we must ensure that
 the flash is accessible.
 Also sets up the number of banks for a later check against
 include/configs/nc6012.h
******************************/
int nbanks	= 0xDEADBABE;
int sizeIndex	= 0xCAFEBABE;
static void flash__init (void)
{
}
/******************************
 Routine:
 Description: Check Integrator/CP control
							register settings against
				configs header.
******************************/
/*
void flash_check(void) {
	unsigned int sizes[] =	{0x01000000, 0x02000000};
	if(nbanks != CFG_MAX_FLASH_BANKS){
		printf(	"The board control register indicates %d flash banks, "
			"<U-Boot root>/include/configs/integratorcp.h::"
			"CFG_MAX_FLASH_BANKS is set to %d\n" \
			,nbanks, CFG_MAX_FLASH_BANKS);
	}

	if(PHYS_FLASH_SIZE != sizes[sizeIndex]){
		printf(	"The board control register indicates 0x%08x bytes of "
			"flash, <U-Boot root>/include/configs/integratorcp.h"
			"::PHYS_FLASH_SIZE is set to 0x%08x\n" \
			,sizes[sizeIndex], PHYS_FLASH_SIZE);
	}
}
*/
/*************************************************************
 Routine:ether__init
 Description: take the Ethernet controller out of reset and wait
				for the EEPROM load to complete.
*************************************************************/
static void ether__init (void)
{
}

/******************************
 Routine:
 Description:
******************************/
void SetDramTo256Mb(void)
{
	unsigned int addr, data;

	addr=0x90000018;
	data = 0x00080000;
	*(volatile unsigned int *)(addr) = data;

	addr=0x90100000;
	data = 0x00080000;
	*(volatile unsigned int *)(addr) = data;

	addr=0x90400000;
	data = 0x00080000;
	*(volatile unsigned int *)(addr) = data;

	addr=0x90500000;
	data = 0x00080000;
	*(volatile unsigned int *)(addr) = data;

	addr=0x90600000;
	data = 0x00080000;
	*(volatile unsigned int *)(addr) = data;

	addr=0x99300010;
	data = 0x10005454;
	*(volatile unsigned int *)(addr) = data;

// Set average periodic refresh interval
	addr=0x9930001c;
	data = *(volatile unsigned int *)(addr);
	data &= 0xffffff00;
	data += 0x3b;
	*(volatile unsigned int *)(addr) = data;


	
}
int dram_init (void)
{
	DECLARE_GLOBAL_DATA_PTR;

	gd->bd->bi_dram[0].start = PHYS_SDRAM;
	gd->bd->bi_dram[0].size	 = PHYS_SDRAM_SIZE;

#ifdef CONFIG_CM_SPD_DETECT
		{
extern void dram_query(void);
	unsigned long cm_reg_sdram;
	unsigned long sdram_shift;

	dram_query();	/* Assembler accesses to CM registers */
			/* Queries the SPD values */

	/* Obtain the SDRAM size from the CM SDRAM register */

	cm_reg_sdram = *(volatile ulong *)(CM_BASE + OS_SDRAM);
	/*	 Register				SDRAM size
	 *
	 *	 0xXXXXXXbbb000bb	 16 MB
	 *	 0xXXXXXXbbb001bb	 32 MB
	 *	 0xXXXXXXbbb010bb	 64 MB
	 *	 0xXXXXXXbbb011bb	128 MB
	 *	 0xXXXXXXbbb100bb	256 MB
	 *
	 */
	sdram_shift		 = ((cm_reg_sdram & 0x0000001C)/4)%4;
	gd->bd->bi_dram[0].size	 = 0x01000000 << sdram_shift;

		}
#endif /* CM_SPD_DETECT */
	SetDramTo256Mb();	//By Gary Hsieh

	return 0;
}

/* The Integrator/CP timer1 is clocked at 1MHz
 * can be divided by 16 or 256
 * and can be set up as a 32-bit timer
 */
/* U-Boot expects a 32 bit timer, running at CFG_HZ */
/* Keep total timer count to avoid losing decrements < div_timer */
static unsigned long long total_count = 0;
static unsigned long long lastdec;	 /* Timer reading at last call */
static unsigned long long div_clock = 1; /* Divisor applied to timer clock */
static unsigned long long div_timer = 1; /* Divisor to convert timer reading
					  * change to U-Boot ticks
					  */
/* CFG_HZ = CFG_HZ_CLOCK/(div_clock * div_timer) */
static ulong timestamp;		/* U-Boot ticks since startup */

#define TIMER_LOAD_VAL (CFG_HZ_CLOCK)
#define READ_TIMER (*(volatile ulong *)(CFG_TIMERBASE))

/* all function return values in U-Boot ticks i.e. (1/CFG_HZ) sec
 *	- unless otherwise stated
 */

/* starts up a counter
 * - the Integrator/CP timer can be set up to issue an interrupt */
int interrupt_init (void)
{
	/* Load timer with initial value */
	*(volatile ulong *)(CFG_TIMERBASE + 0) = CFG_HZ_CLOCK;
	/* Set timer to be
	 *	enabled			1
	 *	periodic		1
	 *	no interrupts		0
	 *	X			0
	 *	divider 1	 00 == less rounding error
	 *	32 bit			1
	 *	wrapping		0
	 */
//	*(volatile ulong *)(CFG_TIMERBASE + 8) = 0x000000C2;
	*(volatile ulong *)(CFG_TIMERBASE + 4) = CFG_HZ_CLOCK;//0xffffffff;
	*(volatile ulong *)(CFG_TIMERBASE + 8) = 0;
	*(volatile ulong *)(CFG_TIMERBASE + 0x30) = 0x00000001;
	/* init the timestamp */
	total_count = 0ULL;
	reset_timer_masked();

	div_timer	= (unsigned long long)(CFG_HZ_CLOCK / CFG_HZ); /* each u-boot tick need how much timer tick */
	div_timer /= div_clock;

	return (0);
}

/*
 * timer without interrupts
 */
void reset_timer (void)
{
	reset_timer_masked ();
}

ulong get_timer (ulong base_ticks)
{
	return get_timer_masked () - base_ticks;
}

void set_timer (ulong ticks)
{
	timestamp = ticks;
	total_count = (unsigned long long)ticks * div_timer;
}

/* delay usec useconds */
void udelay (unsigned long usec)
{
	ulong tmo, tmp;

	/* Convert to U-Boot ticks */
//	tmo	= usec * CFG_HZ;
//	tmo /= (1000000L);
	tmo	= usec * (CFG_HZ_CLOCK /1000000L);  /* need how much timer ticks */
        tmo/=div_timer; /* need how much u-boot ticks */

	tmp = get_timer_masked();	/* get current timestamp */
	tmo += tmp;			/* form target timestamp */

	while (get_timer_masked () < tmo) {/* loop till event */
		/*NOP*/;
	}
}

void reset_timer_masked (void)
{
	/* capure current decrementer value */
	lastdec		= (unsigned long long)READ_TIMER;
	/* start "advancing" time stamp from 0 */
	timestamp = 0L;
}

/* converts the timer reading to U-Boot ticks */
/* the timestamp is the number of ticks since reset */
ulong get_timer_masked (void)
{
	/* get current count */
	unsigned long long now = (unsigned long long)READ_TIMER;

	if(now > lastdec) {
		/* Must have wrapped */
		total_count += lastdec + TIMER_LOAD_VAL + 1 - now;
	} else {
		total_count += lastdec - now;
	}
	lastdec = now;
	timestamp = (ulong)(total_count/div_timer); /* convert to u-boot ticks */
//printf("<%x>",timestamp);
	return timestamp;
}

/* waits specified delay value and resets timestamp */
void udelay_masked (unsigned long usec)
{
	udelay(usec);
}

/*
 * This function is derived from PowerPC code (read timebase as long long).
 * On ARM it just returns the timer value.
 */
unsigned long long get_ticks(void)
{
	return (unsigned long long)get_timer(0);
}

/*
 * Return the timebase clock frequency
 * i.e. how often the timer decrements
 */
ulong get_tbclk (void)
{
//	return (ulong)(((unsigned long long)CFG_HZ_CLOCK)/div_clock);
//	return (ulong)((unsigned long long)div_timer);
	return (ulong)((unsigned long long)CFG_HZ);
}

#ifdef CONFIG_SKIP_LOWLEVEL_INIT

//#define SYS_CLK		12000000
#define VGA_CONFIG	0	// default vga setting = 1024x768
#define SYS_CLK		30000000
#define GET_PLAT_FULL_ID()		(inw(CONFIG_PMU_BASE))
#define GPLAT_8126_1080P_ID_B 	0x81262100
#define GPLAT_8126_1080P_ID_C	0x81262200
#define PMU_PMODE_OFFSET      0x0C
#define PMU_PLL1CR_OFFSET     0x30
#define PMU_PLL23CR_OFFSET    0x34

struct vga_setting {
	uint ns;
	uint ms;
	char resolution[10];
};

struct vga_setting vgs[] =
{
	{54,  1, "1024x768"},
	{63,  1, "1280x800"},
	{135, 2, "1280x960"},
	{54,  1, "1280x1024"},
	{72,  1, "1360x768"},
	{99,  2, "720P"},
	{99,  2, "1080I"},
	{63,  1, "800x600"},
	{0,   0, ""}
};

uint vga_res = VGA_CONFIG;

uint u32PMU_ReadPLL1CLK(void)
{
    uint mul, div;

   mul = ((inw(CONFIG_PMU_BASE+PMU_PLL1CR_OFFSET)) >>  4) & 0x1FF;    /* N */
   div = ((inw(CONFIG_PMU_BASE+PMU_PLL1CR_OFFSET)) >> 13) & 0x1F;     /* M */
  

    return (SYS_CLK * mul / div);
}

uint u32PMU_ReadPLL2CLK(void)
{
	uint mul, div;

	 mul = ((inw(CONFIG_PMU_BASE+PMU_PLL23CR_OFFSET)) >> 3) & 0x1FF;    /* N */
    div = ((inw(CONFIG_PMU_BASE+PMU_PLL23CR_OFFSET)) >> 12) & 0x1F;    /* M */

	return (SYS_CLK * mul / div);
}

uint u32PMU_ReadPLL3CLK(void)
{
	uint mul, div;

	mul = (inw(CONFIG_PMU_BASE+0x34) >>  4) & 0xff;
	div = (inw(CONFIG_PMU_BASE+0x34) >> 12) & 0x0f;

	return (SYS_CLK * mul / div);
}

uint u32PMU_ReadDDRCLK(void)
{
    uint pll1_out, pll2_out;
    uint cpu3x;

    cpu3x = ((inw(CONFIG_PMU_BASE+PMU_PLL1CR_OFFSET)) >> 23) & 0x3;
    pll1_out = u32PMU_ReadPLL1CLK();
    pll2_out = u32PMU_ReadPLL2CLK();
    
    if(cpu3x == 0)
    	return pll1_out;
    else if(cpu3x == 1)
        return pll1_out / 2;
    else if(cpu3x == 2)
    	return pll2_out;
    else
        return pll2_out / 2;
}

uint u32PMU_ReadCPUCLK(void)
{
    uint pll1_out,pll2_out;
    uint cpu3x;

    cpu3x = ((inw(CONFIG_PMU_BASE+PMU_PLL1CR_OFFSET)) >> 27) & 0x3;
    pll1_out = u32PMU_ReadPLL1CLK();
    pll2_out = u32PMU_ReadPLL2CLK();

    if(cpu3x == 0)
    	return pll1_out;
    else if(cpu3x == 1)
        return pll1_out / 2;
    else if(cpu3x == 2)
    	return pll1_out / 1.5;
    else
        return pll2_out;	
}

uint u32PMU_ReadHCLK(void)
{
     uint pll1_out,pll2_out;
    uint cpu3x;

    cpu3x = ((inw(CONFIG_PMU_BASE+PMU_PLL1CR_OFFSET)) >> 25) & 0x3;
    pll1_out = u32PMU_ReadPLL1CLK();
    pll2_out = u32PMU_ReadPLL2CLK();
    if(cpu3x == 0)
    	return pll1_out;
    else if(cpu3x == 1)
    	return pll1_out / 2;
    else if(cpu3x == 2)
    	return pll1_out / 3;
    else
        return pll2_out / 2;	
}

uint u32PMU_ReadPCLK(void)
{
    return (u32PMU_ReadHCLK() >> 1);
}

uint u32PMU_ReadJpegCLK(void)
{
    uint div,clk;
    clk = inw(CONFIG_PMU_BASE+0x28);
    if(clk & BIT9)
		return u32PMU_ReadHCLK();

    div = (inw(CONFIG_PMU_BASE+0x74) >> 8) & 0xf;
    return (u32PMU_ReadPLL3CLK() / (div + 1));
}

uint u32PMU_ReadH264encCLK(void)
{
    uint div,clk,ret_clk;

    clk = inw(CONFIG_PMU_BASE+0x28) >> 18;
    switch (clk & 0x3) {
        case 0: 
            div = ((*(unsigned int *)(CONFIG_PMU_BASE+0x7c)) >> 16) & 0x1f;
            ret_clk = (u32PMU_ReadPLL1CLK() / (div + 1));
            break;
        case 1: 
        ret_clk = u32PMU_ReadHCLK();
            break;
        case 2: 
            ret_clk = (u32PMU_ReadPLL1CLK() * 2 / 5);
            break;
        case 3: 
        default: 
            ret_clk = 0;
            printf("Read H264 Clock error!\n");     
            break;
    }
    return (ret_clk);    
}

uint u32PMU_ReadH264decCLK(void)
{
    uint div,clk;
    clk = inw(CONFIG_PMU_BASE+0x28);
    if(clk & BIT10)
		return u32PMU_ReadHCLK();

    div = (inw(CONFIG_PMU_BASE+0x74) >> 4) & 0xf;
    return (u32PMU_ReadPLL3CLK() / (div + 1));
}

void display_sys_freq(void)
{
	printf("\n  ----------------------------------------------------------------------------\n");
	printf("   PLL1:%4d MHz       PLL2:%4d MHz       PLL3:%4d MHz       DDR:%4d MHz\n",
		u32PMU_ReadPLL1CLK()/1000000, u32PMU_ReadPLL2CLK()/1000000,
		u32PMU_ReadPLL3CLK()/1000000, u32PMU_ReadDDRCLK()/1000000);
	printf("   CPU :%4d MHz       HCLK:%4d MHz       PCLK:%4d MHz\n",
		u32PMU_ReadCPUCLK()/1000000, u32PMU_ReadHCLK()/1000000, u32PMU_ReadPCLK()/1000000);
	printf("   JPEG:%4d MHz  H.264 enc:%4d MHz  H.264 dec:%4d MHz\n",
		u32PMU_ReadJpegCLK()/1000000, u32PMU_ReadH264encCLK()/1000000, u32PMU_ReadH264decCLK()/1000000);
	printf("   VGA : %s\n",
		vgs[vga_res].resolution);
	printf("  ----------------------------------------------------------------------------\n");
}

void mcp_clk_mode(uint mpeg4_setting, uint h264_e_setting,  uint h264_pvalue)
{
	uint setting = 0, value;

	value = inw(CONFIG_PMU_BASE + 0x28);

	setting = mpeg4_setting << 7;
	setting |= h264_e_setting << 18;
      outw(CONFIG_PMU_BASE + 0x28, (value & 0xFFF3FF7F) | setting);

	if(h264_pvalue == 1){
		value = inw(CONFIG_PMU_BASE + 0x7C);
	 	outw(CONFIG_PMU_BASE + 0x7C, (value & 0xFFE0FFFF) | (1 << 16));
	}
  
}

uint cal_pvalue(uint wclk)
{
	uint ret = 0, pll3clk;

	pll3clk = u32PMU_ReadPLL3CLK();

	ret = pll3clk/wclk;
	if ((pll3clk/ret) > wclk)
		ret++;
	ret -= 1;

	return ret;
}

void calculate_codec_clock(void)
{
	uint data;

	if (GET_PLAT_ID() == GPLAT_8181_ID) {
		/* Re-calculate CLOCK PVALUE of IPs */
		data = cal_pvalue(84000000); // IDE CLK PVALUE
		outw(CONFIG_PMU_BASE+0x70, (inw(CONFIG_PMU_BASE+0x70)&~0x1F)|data);
		data = cal_pvalue(33000000); // PCI CLK PVALUE
		outw(CONFIG_PMU_BASE+0x70, (inw(CONFIG_PMU_BASE+0x70)&~(0x1F<<15))|(data<<15));
		data = cal_pvalue(162000000); // JPEG(MCP100) CLK PVALUE
		outw(CONFIG_PMU_BASE+0x74, (inw(CONFIG_PMU_BASE+0x74)&~(0xF<<8))|(data<<8));
		data = cal_pvalue(162000000); // H264DEC(MCP220) CLK PVALUE
		outw(CONFIG_PMU_BASE+0x74, (inw(CONFIG_PMU_BASE+0x74)&~(0xF<<4))|(data<<4));
		data = cal_pvalue(216000000); // H264ENC(MCP210) CLK PVALUE
		outw(CONFIG_PMU_BASE+0x74, (inw(CONFIG_PMU_BASE+0x74)&~0xF)|data);
	} else {
		data = cal_pvalue(84000000); // IDE CLK PVALUE
		outw(CONFIG_PMU_BASE+0x70, (inw(CONFIG_PMU_BASE+0x70)&~0x1F)|data);
		data = cal_pvalue(33000000); // PCI CLK PVALUE
		outw(CONFIG_PMU_BASE+0x70, (inw(CONFIG_PMU_BASE+0x70)&~(0x1F<<15))|(data<<15));
		data = cal_pvalue(202500000); // JPEG(MCP100) CLK PVALUE
		outw(CONFIG_PMU_BASE+0x74, (inw(CONFIG_PMU_BASE+0x74)&~(0xF<<8))|(data<<8));
		data = cal_pvalue(250000000); // H264DEC(MCP220) CLK PVALUE
		outw(CONFIG_PMU_BASE+0x74, (inw(CONFIG_PMU_BASE+0x74)&~(0xF<<4))|(data<<4));
		data = cal_pvalue(290000000); // H264ENC(MCP210) CLK PVALUE
		outw(CONFIG_PMU_BASE+0x74, (inw(CONFIG_PMU_BASE+0x74)&~0xF)|data);
	}
}

void set_PLL2(uint pll2_mul, uint pll2_div)
{
	uint pll2_out, tmp;
	
	tmp = inw(CONFIG_PMU_BASE+PMU_PLL23CR_OFFSET);
	tmp &= 0xFFFE0000;
	pll2_out = SYS_CLK / pll2_div * pll2_mul / 1000000;
 	if(pll2_out > 500) 
  		tmp |= (BIT1 | BIT2);
  	else if(pll2_out > 250)
   		tmp |= BIT2;
 	else if(pll2_out > 125)
  		tmp |= BIT1;
  
  tmp |= ((pll2_div << 12) | (pll2_mul << 3)); 
  outw(CONFIG_PMU_BASE + PMU_PLL23CR_OFFSET, tmp | BIT0);
}

void ChangeCacheWAMode(int mode)
{
    uint val; 

    //Enable ALO
    __asm__ __volatile__("mrc p15, 0, %0, c1, c0, 1" : "=r" (val) : : "memory");
    val |= 0x8;
    __asm__ __volatile__("mcr p15, 0, %0, c1, c0, 1" : "=r" (val) : : "memory");
    __asm__ __volatile__("mrc p15, 0, %0, c1, c0, 0" : "=r" (val) : : "memory");

    val &= ~0x14000;

    switch(mode){

        case 1: //RAO=0, STMWA=1
            val |= 0x10000;
            break;
        case 2: //RAO=0, STMWA=0
            break;
        case 0: //RAO=1, STMWA=X
        default:
            val |= 0x4000;
             break;
    } 

    __asm__ __volatile__("mcr p15, 0, %0, c1, c0, 0" : "=r" (val) : : "memory");
    //Disable ALO
    __asm__ __volatile__("mrc p15, 0, %0, c1, c0, 1" : "=r" (val) : : "memory");
    val &= ~0x8;
    __asm__ __volatile__("mcr p15, 0, %0, c1, c0, 1" : "=r" (val) : : "memory");
}

void init_sys_freq(void)
{
	uint reg_v;
	char *s,*s1,*s2;

	/* Configure AHBC01 for LCD priority high */
	outw(CONFIG_AHBC01_BASE + 0x80, 0x00000002);

	/* Configure AHBC04/AHBC05 for Capture0-1 priority high */
	outw(CONFIG_AHBC04_BASE + 0x80, 0x00000006);
	outw(CONFIG_AHBC05_BASE + 0x80, 0x00000006);

	outw(CONFIG_PMU_BASE + 0x08, inw(CONFIG_PMU_BASE + 0x08) & 0x000fffff);	// PLL0 CP1 CP2 set to 00
	outw(CONFIG_PMU_BASE + 0xc, inw(CONFIG_PMU_BASE + 0xc) | BIT12);	// isp_Power_off,
	outw(CONFIG_PMU_BASE + 0x38, 0xf87ff2e3); 
	outw(CONFIG_PMU_BASE + 0x3c, 0xfbffaffe);	// cmos clock on
	outw(CONFIG_PMU_BASE + 0x6c, inw(CONFIG_PMU_BASE + 0x6c) | 0x00020000);	// cmos_clk_en = 1
	outw(CONFIG_PMU_BASE + 0x7c, inw(CONFIG_PMU_BASE + 0x7c) | 0xf);	// tve_Power_off,
	outw(CONFIG_PMU_BASE + 0x90, inw(CONFIG_PMU_BASE + 0x90) | 0x00780000);	// ADC_Power_off, 
	outw(CONFIG_PMU_BASE + 0x9c, inw(CONFIG_PMU_BASE + 0x9c) | 0x03007000);	// Audio_Power_off,
		
	/* mcp100clk_sel, Select the PLL1 output. */
	outw(CONFIG_PMU_BASE + 0x28, inw(CONFIG_PMU_BASE + 0x28) & (~BIT7));
	
	outw(CONFIG_PMU_BASE + 0x44, 0x200200);	// tune clock
	ChangeCacheWAMode(0);    
	    
	/* Sync LCD and EXT_CLK#3 Clock for use EXT_CLK#3 as CT656_CLK source */
	/* Set Ext_CLK#3 to 27MHz */
	reg_v = inw(CONFIG_PMU_BASE + 0x70);
	reg_v &= ~(0x3f<<18);
	reg_v |= (0x09<<18);
	outw(CONFIG_PMU_BASE + 0x70, reg_v);
	
	/* Set LCD_CLK to 27MHz */
	reg_v = inw(CONFIG_PMU_BASE + 0x74);
	reg_v &= ~(0x3f<<20);
	reg_v |= (0x13<<20);
	outw(CONFIG_PMU_BASE + 0x74, reg_v);    
	        
	if ((GET_PLAT_FULL_ID() == GPLAT_8126_1080P_ID_B) || (GET_PLAT_FULL_ID() == GPLAT_8126_1080P_ID_C)){
		//printf("Gary: GET_PLAT_FULL_ID = GPLAT_8126_1080P_ID\n\n");
		
		s = getenv ("DDR2_900MHz");
		s1 = getenv ("CPU_594MHz");
		s2 = getenv ("H264ENC_400MHz");

		//mcp_clk_mode(0, 2);  // mpeg4=HCLK, h264=Div_2.5 
		//mcp_clk_mode(0, 0);  // mpeg4=HCLK, h264=Div_2.5 
		if(strcmp(s2,"1")==0){
			mcp_clk_mode(0, 0, 1);  // mpeg4=HCLK, h264=Div_2.5 
		}
		else{		
			mcp_clk_mode(0, 2, 0);  // mpeg4=HCLK, h264=Div_2.5 
		}		
		if(strcmp(s1,"1")==0){
			set_PLL2(99, 5);	
			//FCS_go(444, 90, 3);	// fclk/hclk=360MHz, pll1/ddr=900MHz
		}
		else{
			set_PLL2(90, 5);
		       //FCS_go(444, 80, 3);	 // fclk/hclk=270MHz, pll1/ddr=800MHz
		}
		if(strcmp(s,"1")==0){
			//set_PLL2(99, 5);	
			FCS_go(444, 90, 3);	// fclk/hclk=360MHz, pll1/ddr=900MHz
		}
		else{		
			//set_PLL2(90, 5);
			FCS_go(444, 80, 3);	 // fclk/hclk=270MHz, pll1/ddr=800MHz
		}
	}
	else{
		//printf("Gary: GET_PLAT_FULL_ID != GPLAT_8126_1080P_ID\n\n");
		mcp_clk_mode(0, 1, 0);
		FCS_go(444, 80, 3);	 // fclk/hclk=270MHz, pll1/ddr=800MHz
	}
}

typedef unsigned int    UINT32;
void Do_Delay(UINT32 num)
{
 UINT32 i;
 	for(i=num;i>0;i--); 
}
void GM8126_Init_MAC_PHY(void)
{
	int reg_v, reg_pll1;
	int mul, div, clk;
	 int macclk_pval;

	/* MAC,PHY Clock */
	outw((UINT32 *) (CONFIG_PMU_BASE + 0x38),
	     inw(CONFIG_PMU_BASE + 0x38) & ~(BIT8 | BIT10));
	/* MAC,PHY Power */
	outw((UINT32 *) (CONFIG_PMU_BASE + 0x6c),
	     (inw(CONFIG_PMU_BASE + 0x6c) | BIT18 | BIT10));

	/* PHY enable reset */
	Do_Delay(50000);
	outw((UINT32 *) (CONFIG_PMU_BASE + 0x84), 0x0012c100);	// N-WAY
   
    	reg_v = inw(CONFIG_PMU_BASE + 0x74) & 0x03ffffff;
    	reg_pll1 = u32PMU_ReadPLL1CLK()/1000000;	
    
    	 macclk_pval = reg_pll1/25;
        macclk_pval = (macclk_pval-1) << 26;
        reg_v |= macclk_pval;	
   
	outw((UINT32 *) (CONFIG_PMU_BASE + 0x74), reg_v);

	/* MAC LED */
	reg_v = inw(CONFIG_PMU_BASE + 0x64) & 0x0fffffff;
	reg_v |= 0x50000000;	// MACCLK_PVALE = 3;
	outw((UINT32 *) (CONFIG_PMU_BASE + 0x64), reg_v);

	/* MAC LED */
	reg_v = inw(CONFIG_PMU_BASE + 0x5c) & 0x0fffffff;
	reg_v |= 0x50000000;	// MACCLK_PVALE = 3;
	outw((UINT32 *) (CONFIG_PMU_BASE + 0x5c), reg_v);

	/* PHY disable reset */
	outw((UINT32 *) (CONFIG_PMU_BASE + 0x84), 0x0012c101);	// N-Way
}

#ifdef CONFIG_USE_IRQ

#define IRQ_PMU	    8

// only handle PMU irq
void do_irq (struct pt_regs *pt_regs)
{
	uint val;

	*(volatile ulong *)(CONFIG_PMU_BASE + 0x20) = (1<<17);
	val = *(volatile ulong *)(CONFIG_PMU_BASE + 0x0C);
    val &= ~0x4;
    *(volatile ulong *)(CONFIG_PMU_BASE + 0x0C) = val;

	*(volatile ulong *)(CONFIG_INTC_BASE + 0x08) = (1<<IRQ_PMU);
	*(volatile ulong *)(CONFIG_INTC_BASE + 0x04) &= ~(1<<IRQ_PMU);
}

void PMU_enter_fcs_mode(uint cpu3x, uint mul, uint div)
{
	uint setting, pllout;

	pllout = SYS_CLK * (mul & 0xFF) / (div & 0xff);
	pllout = pllout/1000000;

	/* pllns & pllms */
	setting = (cpu3x << 24) | (div << 12) | (mul << 4);

	/* pll frang */
	if (GET_PLAT_ID() == GPLAT_8181_ID) { /* 8181 series */
		if(pllout > 500)
			setting |= ((1<<20) | (1<<21));
		else if(pllout > 250)
			setting |= (1<<21);
		else if(pllout > 125)
			setting |= (1<<20);
	} else { /* 8186/8181T series */
		if(pllout > 500)
			setting |= (1<<20);
		if ((cpu3x >> 8) & 0x1)
			setting |= (1<<23);
		if ((cpu3x >> 9) & 0x1)
			setting |= (1<<22);
	}

	if(setting == (*(volatile ulong *)(CONFIG_PMU_BASE + 0x30) & 0xfffffff0))
		return;		// the same

	*(volatile ulong *)(CONFIG_PMU_BASE + 0x30) = setting;

	*(volatile ulong *)(CONFIG_INTC_BASE + 0x0C) &= ~(1<<IRQ_PMU);
	*(volatile ulong *)(CONFIG_INTC_BASE + 0x10) &= ~(1<<IRQ_PMU);
	*(volatile ulong *)(CONFIG_INTC_BASE + 0x04) |= (1<<IRQ_PMU);

	printf("go...");

	setting = *(volatile ulong *)(CONFIG_PMU_BASE + 0x0C);
	*(volatile ulong *)(CONFIG_PMU_BASE + 0x0C) = setting | (1<<2);

	setting = 0;
	__asm__ __volatile__ (
                " mcr p15, 0, %0, c7, c0, 4 " :
                "=r"(setting)::
                "memory"
            );
	__asm__ __volatile__ (" nop ":::"memory"); //return here from IDLE mode interrupt
}

void FCS_go(unsigned int cpu3x, unsigned int mul, unsigned int div)
{
	uint setting, pllout;

  pllout = SYS_CLK / (div & 0x1f) * (mul & 0x1FF);
  pllout = pllout/1000000;


  /* pllns & pllms */
  setting = (cpu3x << 22) | (div << 12) | (mul << 3);

  /* pll frang */
  if (u32PMU_ReadDDRCLK() < 600)
      setting |= BIT31;
  
  if (pllout >= 50 && pllout < 125)
      setting |= (0x0 << 20);
  else if (pllout >= 125 && pllout < 250)
      setting |= (0x01 << 20);
  else if (pllout >= 250 && pllout < 500)
      setting |= (0x02 << 20);
  else
      setting |= (0x03 << 20);

  if(setting == (inw(CONFIG_PMU_BASE + PMU_PLL1CR_OFFSET) & 0xfffffff8))
  	return;		// the same
  //printf("\n\nGary: setting (0x99000000 + 0x30)= 0x%x \n\n",setting);
  outw(CONFIG_PMU_BASE + PMU_PLL1CR_OFFSET, setting);

    
	*(volatile ulong *)(CONFIG_INTC_BASE + 0x0C) &= ~(1<<IRQ_PMU);
	*(volatile ulong *)(CONFIG_INTC_BASE + 0x10) &= ~(1<<IRQ_PMU);
	*(volatile ulong *)(CONFIG_INTC_BASE + 0x04) |= (1<<IRQ_PMU);

	printf("go...");

	setting = inw(CONFIG_PMU_BASE + PMU_PMODE_OFFSET);
	outw(CONFIG_PMU_BASE + PMU_PMODE_OFFSET, setting | (1<<2));

	setting = 0;

  __asm__ __volatile__("mcr p15, 0, %0, c7, c0, 4" : "=r" (setting) : : "memory");
	__asm__ __volatile__ (" nop ":::"memory"); //return here from IDLE mode interrupt  
	__asm__ __volatile__ (" nop ":::"memory"); //return here from IDLE mode interrupt  
}

void FCS_go_T(unsigned int cpu3x, unsigned int mul, unsigned int div)
{
	unsigned int pll1_out, fclk, hclk, ddrclk;
	unsigned int tmp;

	printf("Will set the following freq...\n");

	pll1_out = SYS_CLK * (mul & 0xFF) / div;

	tmp = (cpu3x >> 0) & 0x3;
	if(tmp == 0)
		ddrclk = pll1_out / 1;
	else if(tmp == 1)
		ddrclk = pll1_out / 2;
	else if(tmp == 2)
		ddrclk = pll1_out / 3;
	else {
		if (GET_PLAT_ID() == GPLAT_8181T_ID) {
			printf("Invalid setting for DDRCLK\n");
			return;
		}
	}

	tmp = (cpu3x >> 2) & 0x3;
	if(tmp == 0)
		hclk = pll1_out / 1;
	else if(tmp == 1)
		hclk = pll1_out / 2;
	else if(tmp == 2)
		hclk = pll1_out / 3;
	else
		hclk = pll1_out / 4;

	tmp = (cpu3x >> 4) & 0x3;
	if(tmp == 0)
		fclk = pll1_out / 1;
	else if(tmp == 1)
		fclk = pll1_out / 2;
	else if(tmp == 2)
		fclk = pll1_out / 3;
	else
		fclk = pll1_out / 3 * 2;

	printf("PLL1: %d MHz, CPU freq: %d MHz, AHB freq: %d MHz, DDR freq: %d MHz\n",
		pll1_out/1000000, fclk/1000000, hclk/1000000, ddrclk/1000000);

	*(volatile ulong *)(CONFIG_INTC_BASE + 0x08) = (1<<IRQ_PMU);

	PMU_enter_fcs_mode(cpu3x, mul, div);
}
#endif
#endif
