/*
 * (C) Copyright 2001-2003
 * Stefan Roese, DENX Software Engineering, sr@denx.de.
 *
 * (C) Copyright 2005
 * Matthias Fuchs, esd gmbh germany, matthias.fuchs@esd-electronics.com
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <asm/processor.h>
#include <command.h>
#include <malloc.h>

DECLARE_GLOBAL_DATA_PTR;

extern void lxt971_no_sleep(void);

/* fpga configuration data - not compressed, generated by bin2c */
const unsigned char fpgadata[] =
{
#include "fpgadata.c"
};
int filesize = sizeof(fpgadata);


int board_early_init_f (void)
{
	/*
	 * IRQ 0-15  405GP internally generated; active high; level sensitive
	 * IRQ 16    405GP internally generated; active low; level sensitive
	 * IRQ 17-24 RESERVED
	 * IRQ 25 (EXT IRQ 0) CAN0; active low; level sensitive
	 * IRQ 26 (EXT IRQ 1) SER0 ; active low; level sensitive
	 * IRQ 27 (EXT IRQ 2) SER1; active low; level sensitive
	 * IRQ 28 (EXT IRQ 3) FPGA 0; active low; level sensitive
	 * IRQ 29 (EXT IRQ 4) FPGA 1; active low; level sensitive
	 * IRQ 30 (EXT IRQ 5) PCI INTA; active low; level sensitive
	 * IRQ 31 (EXT IRQ 6) COMPACT FLASH; active high; level sensitive
	 */
	mtdcr(uicsr, 0xFFFFFFFF);       /* clear all ints */
	mtdcr(uicer, 0x00000000);       /* disable all ints */
	mtdcr(uiccr, 0x00000000);       /* set all to be non-critical*/
	mtdcr(uicpr, 0xFFFFFF81);       /* set int polarities */
	mtdcr(uictr, 0x10000000);       /* set int trigger levels */
	mtdcr(uicvcr, 0x00000001);      /* set vect base=0,INT0 highest priority*/
	mtdcr(uicsr, 0xFFFFFFFF);       /* clear all ints */

	/*
	 * EBC Configuration Register: set ready timeout to 512 ebc-clks -> ca. 15 us
	 */
	mtebc (epcr, 0xa8400000);

	/*
	 * Setup GPIO pins
	 */

	mtdcr(cntrl0, mfdcr(cntrl0) | ((CFG_FPGA_INIT | \
					CFG_FPGA_DONE | \
					CFG_XEREADY | \
					CFG_NONMONARCH | \
					CFG_REV1_2) << 5));

	if (!(in32(GPIO0_IR) & CFG_REV1_2)) {
		/* rev 1.2 boards */
		mtdcr(cntrl0, mfdcr(cntrl0) | ((CFG_INTA_FAKE | \
						CFG_SELF_RST) << 5));
	}

	out32(GPIO0_OR, 0);
	out32(GPIO0_TCR, CFG_FPGA_PRG | CFG_FPGA_CLK | CFG_FPGA_DATA | CFG_XEREADY); /* setup for output */

	/* - check if rev1_2 is low, then:
	 * - set/reset CFG_INTA_FAKE/CFG_SELF_RST in TCR to assert INTA# or SELFRST#
	 */

	return 0;
}


/* ------------------------------------------------------------------------- */


int misc_init_r (void)
{
	/* adjust flash start and offset */
	gd->bd->bi_flashstart = 0 - gd->bd->bi_flashsize;
	gd->bd->bi_flashoffset = 0;

	out32(GPIO0_OR, in32(GPIO0_OR) | CFG_XEREADY); /* deassert EREADY# */
	return (0);
}

ushort pmc405_pci_subsys_deviceid(void)
{
	ulong val;
	val = in32(GPIO0_IR);
	if (!(val & CFG_REV1_2)) { /* low=rev1.2 */
		if (val & CFG_NONMONARCH) { /* monarch# signal */
			return CFG_PCI_SUBSYS_DEVICEID_NONMONARCH;
		}
		return CFG_PCI_SUBSYS_DEVICEID_MONARCH;
	}
	return CFG_PCI_SUBSYS_DEVICEID_NONMONARCH;
}

/*
 * Check Board Identity:
 */
int checkboard (void)
{
	ulong val;

	char str[64];
	int i = getenv_r ("serial#", str, sizeof(str));

	puts ("Board: ");

	if (i == -1) {
		puts ("### No HW ID - assuming PMC405");
	} else {
		puts(str);
	}

	val = in32(GPIO0_IR);
	if (!(val & CFG_REV1_2)) { /* low=rev1.2 */
		puts(" rev1.2 (");
		if (val & CFG_NONMONARCH) { /* monarch# signal */
			puts("non-");
		}
		puts("monarch)");
	} else {
		puts(" <=rev1.1");
	}

	putc ('\n');

	return 0;
}

/* ------------------------------------------------------------------------- */
void reset_phy(void)
{
#ifdef CONFIG_LXT971_NO_SLEEP

	/*
	 * Disable sleep mode in LXT971
	 */
	lxt971_no_sleep();
#endif
}


int do_cantest(cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
	ulong addr;
	volatile uchar *ptr;
	volatile uchar val;
	int i;

	addr = simple_strtol (argv[1], NULL, 16) + 0x16;

	i = 0;
	for (;;) {
		ptr = (uchar *)addr;
		for (i=0; i<8; i++) {
			*ptr = i;
			val = *ptr;

			if (val != i) {
				printf("ERROR: addr=%p write=0x%02X, read=0x%02X\n", ptr, i, val);
				return 0;
			}

			/* Abort if ctrl-c was pressed */
			if (ctrlc()) {
				puts("\nAbort\n");
				return 0;
			}

			ptr++;
		}
	}

	return 0;
}
U_BOOT_CMD(
	cantest,	3,	1,	do_cantest,
	"cantest - Test CAN controller",
	NULL
	);
