/****************************************************************************
#	 	spcav4l: v4l library.				            #
#This package work with the spca5xx based webcam with the raw jpeg feature. #
#All the decoding is in user space with the help of libjpeg.                #
#.                                                                          #
# 		Copyright (C) 2003 2004 2005 Michel Xhaard                  #
#                                                                           #
# This program is free software; you can redistribute it and/or modify      #
# it under the terms of the GNU General Public License as published by      #
# the Free Software Foundation; either version 2 of the License, or         #
# (at your option) any later version.                                       #
#                                                                           #
# This program is distributed in the hope that it will be useful,           #
# but WITHOUT ANY WARRANTY; without even the implied warranty of            #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
# GNU General Public License for more details.                              #
#                                                                           #
# You should have received a copy of the GNU General Public License         #
# along with this program; if not, write to the Free Software               #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                           #
****************************************************************************/

#include "spcaframe.h"
#include "spcav4l.h"
//#include "utils.h"
#include "jdatatype.h"
//#include "encoder.h"
#include <time.h>
static int init_v4l (struct vdIn *vd);
double ms_time (void);
void exit_fatal(char *messages);
/****************************************************************************
*			Public
****************************************************************************/
int
init_videoIn (struct vdIn *vd, char *device, int width, int height,
	      int format, int grabmethod)
{
  int err = -1;
  int i;
  if (vd == NULL || device == NULL)
    return -1;
  if (width == 0 || height == 0)
    return -1;
  if(grabmethod < 0 || grabmethod > 1)
  	grabmethod = 1; //read by default;
	// check format 
  vd->videodevice = NULL;
  vd->cameraname = NULL;
  vd->videodevice = NULL;
  vd->videodevice = (char *) realloc (vd->videodevice, 16);
  vd->cameraname = (char *) realloc (vd->cameraname, 32);
  snprintf (vd->videodevice, 12, "%s", device);
 // printf("video %s \n",vd->videodevice);
  memset (vd->cameraname, 0, sizeof (vd->cameraname));
  memset(vd->bridge, 0, sizeof(vd->bridge));
   vd->signalquit = 1;
  vd->hdrwidth = width;
  vd->hdrheight = height;
  /*          compute the max frame size   */
  vd->formatIn = format; 
vd->NeedSeq=0;

//vd->ingrab=19;//FGRABTYPE_SENSOR_OV9710


  //GetDepth ??????????HOW TO DO =>case VIDEO_PALETTE_YUV422: case VIDEO_PALETTE_YUV422P:
  vd->bppIn = GetDepth (vd->formatIn);
  vd->grabMethod = grabmethod;		//mmap or read 
  vd->pFramebuffer = NULL;
  /* init and check all setting */
  err = init_v4l (vd);
  /* allocate the 4 frames output buffer */
  for (i = 0; i < OUTFRMNUMB; i++)
    {
      vd->ptframe[i] = NULL;
      vd->ptframe[i] =
	(unsigned char *) realloc (vd->ptframe[i], sizeof(struct frame_t) + (size_t) vd->framesizeIn );
      vd->framelock[i] = 0;
    }
  vd->frame_cour = 0;
  
  
   pthread_mutex_init (&vd->grabmutex, NULL);
  return err;
}

int
close_v4l (struct vdIn *vd)
{
  int i;
  if (vd->grabMethod)
    {
     // printf ("unmapping frame buffer\n");
      munmap (vd->pFramebuffer, vd->mmapsize);
    } else {
    	free(vd->pFramebuffer);
	vd->pFramebuffer = NULL;
    }
//  printf ("close video_device\n");  
  close (vd->fd);
  /* dealloc the whole buffers */
  if (vd->videodevice)
    {
      free (vd->videodevice);
      vd->videodevice = NULL;
    }
  if (vd->cameraname)
    {
      free (vd->cameraname);
      vd->cameraname = NULL;
    }
 for (i = 0; i < OUTFRMNUMB; i++)
    {
      if (vd->ptframe[i])
	{
	  free (vd->ptframe[i]);
	  vd->ptframe[i] = NULL;
	  vd->framelock[i] = 0;
	//  printf ("freeing output buffer %d\n",i);
	}
    }
     pthread_mutex_destroy (&vd->grabmutex);
   return 0;
}

int jpegenc_close(HANDLE_JPEG_ENC handle)
{	
	//printf("\nClosing JPEG encoder [%p]\n", handle);
	
	jpegenc_reset_dev(handle);
	jpegenc_dealloc_dev(&handle);
	return 0;
}

int 
v4lGrab (struct vdIn *vd)
{
	static	int frame = 0;

  int len;
  int size;
  int erreur = 0;
  int jpegsize = 0;
  int qualite = 1024;
  struct frame_t *headerframe;
  double timecourant =0;
  double temps = 0;
  timecourant = ms_time();
SYUVFrame yuvFrame;

  if (vd->grabMethod)
    {

      vd->vmmap.height = vd->hdrheight;
      vd->vmmap.width = vd->hdrwidth;
      vd->vmmap.format = vd->formatIn;
	  
      if (ioctl (vd->fd, VIDIOCSYNC,&vd->vmmap.frame) < 0)
	{
	  perror ("cvsync err\n");
	  erreur = -1;
	}

	/* Is there someone using the frame */  
    while((vd->framelock[vd->frame_cour] != 0) && vd->signalquit)
   		usleep(1000);
	
//kenny add
	pthread_mutex_lock (&vd->grabmutex);
	
	/*
	memcpy (vd->ptframe[vd->frame_cour]+ sizeof(struct frame_t), vd->pFramebuffer +
	      vd->videombuf.offsets[vd->vmmap.frame] , vd->framesizeIn); 
	 jpegsize =jpeg_compress(vd->ptframe[vd->frame_cour]+ sizeof(struct frame_t),vd->framesizeIn,
	 vd->pFramebuffer + vd->videombuf.offsets[vd->vmmap.frame] ,vd->hdrwidth, vd->hdrheight, qualite);  
	 */


	 temps = ms_time();
unsigned char *dst=vd->ptframe[vd->frame_cour]+ sizeof(struct frame_t);
unsigned char *src =vd->pFramebuffer + vd->videombuf.offsets[vd->vmmap.frame];

	//convertframe(unsigned char *dst,unsigned char *src, int width,int height, int formatIn, int qualite)
#if 0
	jpegsize= convertframe(vd->ptframe[vd->frame_cour]+ sizeof(struct frame_t),
	 		vd->pFramebuffer + vd->videombuf.offsets[vd->vmmap.frame],
			vd->hdrwidth,vd->hdrheight,vd->formatIn,qualite);
#endif
//videoIn->ptframe[iframe]+sizeof(struct frame_t);
//===============================================================
	unsigned char *ptr = vd->pFramebuffer  + vd->videombuf.offsets[vd->vmmap.frame];
	yuvFrame.yAddr=ptr;	
	switch(vd->formatIn) {
	case VIDEO_PALETTE_YUV420P:
	    	yuvFrame.uAddr = (unsigned char *) (ptr + (vd->hdrwidth *  vd->hdrheight));
	    	yuvFrame.vAddr = (unsigned char *) (ptr + (vd->hdrwidth *vd->hdrheight * 5 / 4));
		break;
	case VIDEO_PALETTE_YUV422:
	case VIDEO_PALETTE_YUV422P:
		yuvFrame.uAddr = (unsigned char *) (ptr + (vd->hdrwidth * vd->hdrheight));
		yuvFrame.vAddr = (ptr + (vd->hdrwidth * vd->hdrheight* 6 / 4));
		break;
	default:
		fprintf(stderr, "Unknown palette: %d!\n", vd->formatIn);
		erreur = -1;
	}
	if(erreur>=0)
	{
		 jpegsize=jpegenc_encode_frame(vd->hJPEGEnc, &yuvFrame,dst);
		 vd->jpegsize=jpegsize;
	}
//====================================================================

	 headerframe=(struct frame_t*)vd->ptframe[vd->frame_cour];
	 snprintf(headerframe->header,5,"%s","SPCA"); 
	 headerframe->seqtimes = ms_time();
	 headerframe->deltatimes=(int)(headerframe->seqtimes-timecourant); 
	 headerframe->w = vd->hdrwidth;
	 headerframe->h = vd->hdrheight;
	 
	 headerframe->size = (( jpegsize < 0)?0:jpegsize);
	 headerframe->format = vd->formatIn;
	 headerframe->nbframe = frame++; 
	// printf("vd->frame_cour=[%d]\n",vd->frame_cour);
	// printf("compress frame %d times %f\n",frame, headerframe->seqtimes-temps);
	pthread_mutex_unlock (&vd->grabmutex); 
	

	/************************************/
	
      if ((ioctl (vd->fd, VIDIOCMCAPTURE, &(vd->vmmap))) < 0)
	{
	  perror ("cmcapture");
	  erreur = -1;
	}



      vd->vmmap.frame = (vd->vmmap.frame + 1) % vd->videombuf.frames;
      vd->frame_cour = (vd->frame_cour +1) % OUTFRMNUMB;
    	//printf("frame nb %d\n",vd->vmmap.frame);

    }
  else
    {
      /* read method */
      size = vd->framesizeIn;
      len = read (vd->fd, vd->pFramebuffer, size);
      if (len <= 0 )
	{
	  printf ("v4l read error\n");
	  printf ("len %d asked %d \n", len, size);
	  return 0;
	}
      /* Is there someone using the frame */
       while((vd->framelock[vd->frame_cour] != 0)&& vd->signalquit)
   			usleep(1000);
	pthread_mutex_lock (&vd->grabmutex);
	/*
	 memcpy (vd->ptframe[vd->frame_cour]+ sizeof(struct frame_t), vd->pFramebuffer, vd->framesizeIn);
	 jpegsize =jpeg_compress(vd->ptframe[vd->frame_cour]+ sizeof(struct frame_t),len,
	 vd->pFramebuffer, vd->hdrwidth, vd->hdrheight, qualite); 
	 */
	  temps = ms_time();
	 jpegsize= convertframe(vd->ptframe[vd->frame_cour]+ sizeof(struct frame_t),
	 		vd->pFramebuffer ,
			vd->hdrwidth,vd->hdrheight,vd->formatIn,qualite); 
	 headerframe=(struct frame_t*)vd->ptframe[vd->frame_cour];
	 snprintf(headerframe->header,5,"%s","SPCA"); 
	 headerframe->seqtimes = ms_time();
	 headerframe->deltatimes=(int)(headerframe->seqtimes-timecourant); 
	 headerframe->w = vd->hdrwidth;
	 headerframe->h = vd->hdrheight;
	 headerframe->size = (( jpegsize < 0)?0:jpegsize);; 
	 headerframe->format = vd->formatIn; 
	 headerframe->nbframe = frame++; 
	 //  printf("compress frame %d times %f\n",frame, headerframe->seqtimes-temps);
	vd->frame_cour = (vd->frame_cour +1) % OUTFRMNUMB;  
	pthread_mutex_unlock (&vd->grabmutex); 
      /************************************/
     
    }

  
  return erreur;
}

/*****************************************************************************
* 				Private
******************************************************************************/
#define timeOut 20
static int
init_v4l (struct vdIn *vd)
{
  int f;
  int erreur = 0;
  int err;
int i=0;
#if 0
printf("Open V4L1 device %s\n"
		"  width: %d, height: %d, palette: %d, ingrab: %d, NeedSeq: %d\n",
		vd->videodevice, vd->hdrwidth, vd->hdrheight,
		vd->formatIn, vd->ingrab, vd->NeedSeq);
#endif
#if 1
	while(i<timeOut)
	{
		if ((vd->fd = open (vd->videodevice, O_RDWR)) == -1){
		    	printf ("ERROR opening V4L interface");
			sleep(1);
			i++;
		  }
		else
			{
				i=timeOut;
			}
	}


#else


  if ((vd->fd = open (vd->videodevice, O_RDWR)) == -1){
    	exit_fatal ("ERROR opening V4L interface");
  }
#endif
    memset(&vd->videocap, 0, sizeof(struct video_capability));
  if (ioctl (vd->fd, VIDIOCGCAP, &(vd->videocap)) == -1)
    exit_fatal ("Couldn't get videodevice capability");

	if (!(vd->videocap.type  & VID_TYPE_CAPTURE)) {
       	 exit_fatal( "Fatal: not a capture device\n");
	}

  //printf ("Camera found: %s \n", vd->videocap.name);
 // snprintf (vd->cameraname, 32, "%s", vd->videocap.name);

  
  	////// Set Faraday's own parameters.
	if(vd->ingrab) {
            	if (ioctl(vd->fd, 0x5679, &vd->ingrab) == -1) {	//grab type
            		perror("FTMCP_VIDIOSGRABTYPE");
			//goto ERROR;
            	}
	}
	if (ioctl(vd->fd, 0x5678, &vd->NeedSeq) == -1) {
       	perror("FCAP_IOC_SNEEDSEQ");
		//goto ERROR;
	}

		////// Capture Windows

	vd->videowin.x = 0;
	vd->videowin.y = 0;
	vd->videowin.width = 	vd->hdrwidth;
	vd->videowin.height = vd->hdrheight;
	vd->videowin.chromakey = -1;
	vd->videowin.flags = 0;

	// TODO: Why here ???
	if (ioctl(vd->fd, VIDIOCSWIN, &vd->videowin) < 0) {
		perror("ioctl - VIDIOCSWIN");
		//goto ERROR;
	}
	
  vd->videopict.palette = vd->formatIn;
  vd->videopict.depth = GetDepth (vd->formatIn);
  vd->bppIn = GetDepth (vd->formatIn);


   vd->framesizeIn = (vd->hdrwidth * vd->hdrheight * vd->bppIn) >> 3;


  if (vd->grabMethod)
    {
     // printf (" grabbing method default MMAP asked \n");
      // MMAP VIDEO acquisition
      memset (&(vd->videombuf), 0, sizeof (vd->videombuf));
      if (ioctl (vd->fd, VIDIOCGMBUF, &(vd->videombuf)) < 0)
	{
	  perror (" init VIDIOCGMBUF FAILED\n");
	}
#if 0
	  printf ("VIDIOCGMBUF size %d  frames %d  offets[0]=%d offsets[1]=%d\n",
	      vd->videombuf.size, vd->videombuf.frames,
	      vd->videombuf.offsets[0], vd->videombuf.offsets[1]);
#endif
      vd->pFramebuffer =
	(unsigned char *) mmap (0, vd->videombuf.size, PROT_READ | PROT_WRITE,
				MAP_SHARED, vd->fd, 0);
      vd->mmapsize = vd->videombuf.size;
      vd->vmmap.height = vd->hdrheight;
      vd->vmmap.width = vd->hdrwidth;
      vd->vmmap.format = vd->formatIn;

      for (f = 0; f < vd->videombuf.frames; f++)
	{
	  vd->vmmap.frame = f;
	  if (ioctl (vd->fd, VIDIOCMCAPTURE, &(vd->vmmap)))
	    {
	      perror ("cmcapture");
	    }
	}
      vd->vmmap.frame = 0;
    }
  else
    {
      /* read method */
      /* allocate the read buffer */
      vd->pFramebuffer =
	(unsigned char *) realloc (vd->pFramebuffer, (size_t) vd->framesizeIn);
      printf (" grabbing method READ asked \n");
      if (ioctl (vd->fd, VIDIOCGWIN, &(vd->videowin)) < 0)
	perror ("VIDIOCGWIN failed \n");
      vd->videowin.height = vd->hdrheight;
      vd->videowin.width = vd->hdrwidth;
      if (ioctl (vd->fd, VIDIOCSWIN, &(vd->videowin)) < 0)
	perror ("VIDIOCSWIN failed \n");
      printf ("VIDIOCSWIN height %d  width %d \n",
	      vd->videowin.height, vd->videowin.width);
    }
  vd->frame_cour = 0;
  return erreur;
}

int
GetDepth (int format)
{
  int depth;
  switch (format)
    {
   
   case VIDEO_PALETTE_JPEG:
      {
	depth = 8;		
      }
      break;
    case VIDEO_PALETTE_RAW:
      {
	depth = 8;		
      }
      break;
    case VIDEO_PALETTE_YUV420P:
    case VIDEO_PALETTE_YUV420:
      {
	depth = (8 * 3) >> 1;
      }
      break;

	case VIDEO_PALETTE_YUV422:
	case VIDEO_PALETTE_YUV422P:
		depth =  (8 * 3) >> 1;
	break;
	
    case VIDEO_PALETTE_RGB565:
      depth = 16;
      break;
    case VIDEO_PALETTE_RGB24:
      depth = 24;
      break;
    case VIDEO_PALETTE_RGB32:
      {
	depth = 32;
      }
      break;
    default:
      depth = -1;
      break;
    }
  return depth;
}

double
ms_time (void)
{
  static struct timeval tod;
  gettimeofday (&tod, NULL);
  return ((double) tod.tv_sec * 1000.0 + (double) tod.tv_usec / 1000.0);

}

void exit_fatal(char *messages)
{
	printf("%s \n",messages);
	exit(1);
}

