#ifndef _FRAME_RATE_CONTROL_H
#define _FRAME_RATE_CONTROL_H


#ifdef __cplusplus
extern "C" {
#endif

#include <sys/time.h>
#include <time.h>
#ifndef MILLION_US
#define MILLION_US	1000000
#endif

typedef struct _FrameRateControl {

	// Note that we use integer to represent fps, fps can't be < 1. 
	// so frame gap is between 0 < x < 1,000,000 us, but in the future fps may be < 1.
	int target_frame_gap_sec;		// Usually reserved.	
	int target_frame_gap_usec;
	struct timeval last_frame_time;
#ifdef DEBUG
	struct timeval last_time;
#endif
} SFrameRateControl;



extern int 
FrameRateControlInit(SFrameRateControl *pFrameRateControl, int fps);

extern inline int 
FrameRateControl_wait_before_next_frame(SFrameRateControl *pFrameRateControl);

#ifdef __cplusplus
}
#endif


#endif /* _FRAME_RATE_CONTROL_H */
