/* FrameRateControl.c 
  * 	Moudle which control the frame per second 
  */
#include <stdio.h>
#include "FrameRateControl.h"


int mono_gettimeofday(struct timeval *tv, struct timezone *tz)
{
	struct timespec tp;
	
	if (tv && clock_gettime(CLOCK_MONOTONIC, &tp)==0) {
		tv->tv_sec=tp.tv_sec;
		tv->tv_usec=tp.tv_nsec/1000;
		return 0;
	}
	return -1;
}


int FrameRateControlInit(SFrameRateControl *pFrameRateControl, int fps)
{	
	memset(pFrameRateControl, 0x0, sizeof(SFrameRateControl));

	if (fps > 1 ) {
		pFrameRateControl->target_frame_gap_sec = 0;
		pFrameRateControl->target_frame_gap_usec = MILLION_US / fps;
	} else if (fps == 1) {
		pFrameRateControl->target_frame_gap_sec = 1;
		pFrameRateControl->target_frame_gap_usec = 0;
	} else {
		// NOTICE: used to take care if 0 < fps < 1
		float fFrameGap = 1 / (float) fps;
		pFrameRateControl->target_frame_gap_sec= fFrameGap;
		pFrameRateControl->target_frame_gap_usec = 
				(fFrameGap -pFrameRateControl->target_frame_gap_sec) * MILLION_US;
		
	}
	#if 0
	printf("FPS: %d.  Frame gap: %d sec %d usec\n", fps,
			pFrameRateControl->target_frame_gap_sec,
			pFrameRateControl->target_frame_gap_usec);
	#endif
	return 0;
}


int FrameRateControl_start(SFrameRateControl *pFrameRateControl)
{	
	mono_gettimeofday(&pFrameRateControl->last_frame_time, NULL);
	return 0;
}


int FrameRateControl_wait_before_next_frame(SFrameRateControl *pFrameRateControl)
{
	struct timeval now;
	int elapsed_time_sec, elapsed_time_usec;	/* time elapsed since last frame to current frame */
	mono_gettimeofday(&now, NULL);
	
	elapsed_time_sec = now.tv_sec - pFrameRateControl->last_frame_time.tv_sec;
	elapsed_time_usec = now.tv_usec - pFrameRateControl->last_frame_time.tv_usec;

	while (elapsed_time_usec < 0) {
		elapsed_time_usec+= MILLION_US;
		elapsed_time_sec--;
	}
	
	// TODO: Please watch out if elapsedSecond becomes negative...	
#ifdef DEBUG
	printf("now - last time: %d ms\n",  (now.tv_sec - pFrameRateControl->last_time.tv_sec) * 1000 +
					(now.tv_usec - pFrameRateControl->last_time.tv_usec) /1000 );
	// printf("Frame gap: %d ms\n",  elapsed_time_sec * 1000 + elapsed_time_usec / 1000);
	pFrameRateControl->last_time = now;
#endif

	// Compute wait time..
	struct timeval waitTime;

	waitTime.tv_usec = pFrameRateControl->target_frame_gap_usec - elapsed_time_usec;
	waitTime.tv_sec = pFrameRateControl->target_frame_gap_sec - elapsed_time_sec;

	while(waitTime.tv_usec < 0) {
		waitTime.tv_usec+=MILLION_US;
		waitTime.tv_sec--;
	}

	if ( (waitTime.tv_sec > 0) || (waitTime.tv_sec == 0 && waitTime.tv_usec > 0)) {
		// Frame arrives early, wait till later to grab next frame..

		pFrameRateControl->last_frame_time.tv_usec += pFrameRateControl->target_frame_gap_usec;
		pFrameRateControl->last_frame_time.tv_sec += pFrameRateControl->target_frame_gap_sec;

		while(pFrameRateControl->last_frame_time.tv_usec >= MILLION_US) {
			pFrameRateControl->last_frame_time.tv_usec-= MILLION_US;
			pFrameRateControl->last_frame_time.tv_sec++;
		}

		select(0, NULL, NULL, NULL, &waitTime);		
	} else {
		// Frame arrive late or on-time...
		pFrameRateControl->last_frame_time = now;
	}
}


int FrameRateControl_stop(SFrameRateControl *pFrameRateControl)
{	
	return 0;
}

