#ifndef _PRE_ALARM_H
#define _PRE_ALARM_H

#include <sys/time.h>
#include <sys/queue.h>
#include "rbuf.h"

#ifdef __cplusplus
extern "C" {
#endif

//#define MULTI_SLICE

///////////////////////////////////////////////////////////////////
// Declare a singly-linked tail queue of 
//		type 'struct _frame_queue' that stores type 'struct _frame" entry, i.e.	
//
//    frame_queue_t
//		frame_t -> frame_t -> frame_t ->....
///////////////////////////////////////////////////////////////////

struct _frame;	//// forward declaration.
STAILQ_HEAD(_frame_queue, _frame);
typedef struct _frame_queue frame_queue_t;

typedef struct _frame {
    STAILQ_ENTRY(_frame) entry;
// These two fields are hack.
    /* Called in prealarm_get to allow _cb a chance to modify the frame structure.
     *  It's done so to avoid extra data copy between two buffer pointers
     */
    void (*prepare_get_frame_cb) (void *context, struct _frame *frame);
    void *context;
    struct timeval pts;
    int size;				/* size of buf */	
    int len;				/* data len in buf */
    unsigned char *buf;		/* Reserved while being referenced in queue */ 
    unsigned slice_count;
    unsigned slice_size[256];
} frame_t;	


typedef struct _prealarm_buf {
	int disabled;					// flag indicate prealarm is used or not..
	rbuf_t rbuf;					
	rbuf_t *pRbuf;				/* pointer to rbuf */		
	void *mem;					/* pointer to memory for all allocation in these queue */	
	frame_queue_t	activeQ;		/* FIFO that stores active frame info indexes. */
	frame_queue_t	*pActiveQ;	/* pointer to activeQ. */
	frame_queue_t	freeQ;		/* FIFO that keeps free frame indexes. */
	frame_queue_t	*pFreeQ;	/* pointer to freeQ. */
} prealarm_buf_t;



/// Error
#define PREALARM_ERR_OK							0
#define PREALARM_ERR_GENERIC						-1
#define PREALARM_ERR_GET_NO_STORED_FRAME		-2
#define PREALARM_ERR_STORE_NO_FREE_FRAME		-3


/* prealarm_init
  *	
  * @Parameters
  *	[IN]	bufsize		Maximum size of buffer in bytes.
  *	
  */
extern int prealarm_init(prealarm_buf_t *preAlarm, int bufsize, int fcount);
extern int prealarm_init1(prealarm_buf_t *preAlarm, int bitrateKbps, int duration);

extern int prealarm_store(prealarm_buf_t *preAlarm, frame_t *frame);
extern int prealarm_get(prealarm_buf_t *preAlarm, frame_t *frame);

extern void prealarm_dump(prealarm_buf_t *preAlarm);
extern void prealarm_release(prealarm_buf_t *preAlarm);

#ifdef __cplusplus
}
#endif


#endif /* _PRE_ALARM_H */

