/*
 *  linux/arch/arm/mach-faraday/platform-axi/spec.c
 *
 *  Faraday Platform Specification  (Automatically generated by "autospec", do not edit)
 *
 *  Copyright (C) 2009 Faraday Corp. (http://www.faraday-tech.com)
 *
 *  Platform Hierarchy :
 *
 *    AXI
 *     +- CPU_FA626TE  (0)
 *     +- INTC_FTINTC010  (0)
 *     +- UART_FTUART010  (0)
 *     +- UART_FTUART010  (1)
 *     +- TIMER_FTTMR010  (0)
 *     +- DMAC_FTDMAC030  (0)
 */


//#include <linux/config.h>
#include <linux/init.h>
#include <linux/module.h>

#include <asm/mach/map.h>
#include <asm/sizes.h>

#include <mach/platform/spec.h>

/*
 * Interrrupt numbers
 */


/* UART */
const unsigned char UART_FTUART010_irq[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_IRQ,
     UART_FTUART010_1_IRQ
};

/* TIMER */
const unsigned char TIMER_FTTMR010_irq[TIMER_FTTMR010_COUNT][TIMER_FTTMR010_IRQ_COUNT] = {
    { TIMER_FTTMR010_0_IRQ0, TIMER_FTTMR010_0_IRQ1, TIMER_FTTMR010_0_IRQ2 }
};

/* DMAC */
const unsigned char DMAC_FTDMAC030_irq[DMAC_FTDMAC030_COUNT][DMAC_FTDMAC030_IRQ_COUNT] = {
    { DMAC_FTDMAC030_0_IRQ0, DMAC_FTDMAC030_0_IRQ1, DMAC_FTDMAC030_0_IRQ2 }
};

/*
 * Base addresses
 */


/* CPU */
const unsigned CPU_MEM_pa_base[CPU_MEM_PA_COUNT] = {
     CPU_MEM_0_PA_BASE
};
const unsigned CPU_MEM_pa_limit[CPU_MEM_PA_COUNT] = {
     CPU_MEM_0_PA_LIMIT
};
const unsigned CPU_MEM_pa_size[CPU_MEM_PA_COUNT] = {
     CPU_MEM_0_PA_SIZE
};

/* INTC */
const unsigned INTC_FTINTC010_pa_base[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_PA_BASE
};
const unsigned INTC_FTINTC010_pa_limit[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_PA_LIMIT
};
const unsigned INTC_FTINTC010_pa_size[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_PA_SIZE
};
const unsigned INTC_FTINTC010_va_base[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_VA_BASE
};
const unsigned INTC_FTINTC010_va_limit[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_VA_LIMIT
};
const unsigned INTC_FTINTC010_va_size[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_VA_SIZE
};

/* UART */
const unsigned UART_FTUART010_pa_base[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_PA_BASE,
     UART_FTUART010_1_PA_BASE
};
const unsigned UART_FTUART010_pa_limit[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_PA_LIMIT,
     UART_FTUART010_1_PA_LIMIT
};
const unsigned UART_FTUART010_pa_size[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_PA_SIZE,
     UART_FTUART010_1_PA_SIZE
};
const unsigned UART_FTUART010_va_base[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_VA_BASE,
     UART_FTUART010_1_VA_BASE
};
const unsigned UART_FTUART010_va_limit[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_VA_LIMIT,
     UART_FTUART010_1_VA_LIMIT
};
const unsigned UART_FTUART010_va_size[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_VA_SIZE,
     UART_FTUART010_1_VA_SIZE
};

/* TIMER */
const unsigned TIMER_FTTMR010_pa_base[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_PA_BASE
};
const unsigned TIMER_FTTMR010_pa_limit[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_PA_LIMIT
};
const unsigned TIMER_FTTMR010_pa_size[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_PA_SIZE
};
const unsigned TIMER_FTTMR010_va_base[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_VA_BASE
};
const unsigned TIMER_FTTMR010_va_limit[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_VA_LIMIT
};
const unsigned TIMER_FTTMR010_va_size[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_VA_SIZE
};

/* DMAC */
const unsigned DMAC_FTDMAC030_pa_base[DMAC_FTDMAC030_COUNT] = {
     DMAC_FTDMAC030_0_PA_BASE
};
const unsigned DMAC_FTDMAC030_pa_limit[DMAC_FTDMAC030_COUNT] = {
     DMAC_FTDMAC030_0_PA_LIMIT
};
const unsigned DMAC_FTDMAC030_pa_size[DMAC_FTDMAC030_COUNT] = {
     DMAC_FTDMAC030_0_PA_SIZE
};
const unsigned DMAC_FTDMAC030_va_base[DMAC_FTDMAC030_COUNT] = {
     DMAC_FTDMAC030_0_VA_BASE
};
const unsigned DMAC_FTDMAC030_va_limit[DMAC_FTDMAC030_COUNT] = {
     DMAC_FTDMAC030_0_VA_LIMIT
};
const unsigned DMAC_FTDMAC030_va_size[DMAC_FTDMAC030_COUNT] = {
     DMAC_FTDMAC030_0_VA_SIZE
};

/*
 * Platform Initialization Information
 */

const struct map_desc platform_io_desc[PLATFORM_IO_DESC_NR] __initdata = {
    { INTC_FTINTC010_0_VA_BASE,	__phys_to_pfn(INTC_FTINTC010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { UART_FTUART010_0_VA_BASE,	__phys_to_pfn(UART_FTUART010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { UART_FTUART010_1_VA_BASE,	__phys_to_pfn(UART_FTUART010_1_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { TIMER_FTTMR010_0_VA_BASE,	__phys_to_pfn(TIMER_FTTMR010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { DMAC_FTDMAC030_0_VA_BASE,	__phys_to_pfn(DMAC_FTDMAC030_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB }
};

/*
 * Interrupt Dispatch Tables, for both FIQ and IRQ
 */

/* const interrupt_dispatch_function *fiq_dispatch_table[32]; */

/* const interrupt_dispatch_function *irq_dispatch_table[32]; */


/*
 * Export All Symbols
 */

/*
 * Interrrupt numbers
 */

/* UART */
EXPORT_SYMBOL( UART_FTUART010_irq );
/* TIMER */
EXPORT_SYMBOL( TIMER_FTTMR010_irq );
/* DMAC */
EXPORT_SYMBOL( DMAC_FTDMAC030_irq );

/*
 * Base addresses
 */

/* CPU */
EXPORT_SYMBOL( CPU_MEM_pa_base );
EXPORT_SYMBOL( CPU_MEM_pa_limit );
EXPORT_SYMBOL( CPU_MEM_pa_size );
/* INTC */
EXPORT_SYMBOL( INTC_FTINTC010_pa_base );
EXPORT_SYMBOL( INTC_FTINTC010_pa_limit );
EXPORT_SYMBOL( INTC_FTINTC010_pa_size );
EXPORT_SYMBOL( INTC_FTINTC010_va_base );
EXPORT_SYMBOL( INTC_FTINTC010_va_limit );
EXPORT_SYMBOL( INTC_FTINTC010_va_size );
/* UART */
EXPORT_SYMBOL( UART_FTUART010_pa_base );
EXPORT_SYMBOL( UART_FTUART010_pa_limit );
EXPORT_SYMBOL( UART_FTUART010_pa_size );
EXPORT_SYMBOL( UART_FTUART010_va_base );
EXPORT_SYMBOL( UART_FTUART010_va_limit );
EXPORT_SYMBOL( UART_FTUART010_va_size );
/* TIMER */
EXPORT_SYMBOL( TIMER_FTTMR010_pa_base );
EXPORT_SYMBOL( TIMER_FTTMR010_pa_limit );
EXPORT_SYMBOL( TIMER_FTTMR010_pa_size );
EXPORT_SYMBOL( TIMER_FTTMR010_va_base );
EXPORT_SYMBOL( TIMER_FTTMR010_va_limit );
EXPORT_SYMBOL( TIMER_FTTMR010_va_size );
/* DMAC */
EXPORT_SYMBOL( DMAC_FTDMAC030_pa_base );
EXPORT_SYMBOL( DMAC_FTDMAC030_pa_limit );
EXPORT_SYMBOL( DMAC_FTDMAC030_pa_size );
EXPORT_SYMBOL( DMAC_FTDMAC030_va_base );
EXPORT_SYMBOL( DMAC_FTDMAC030_va_limit );
EXPORT_SYMBOL( DMAC_FTDMAC030_va_size );

/*
 * Interrupt Dispatch Tables, for both FIQ and IRQ
 */

