/*
 *  linux/arch/arm/mach-faraday/platform-a369/spec.c
 *
 *  Faraday Platform Specification  (Automatically generated by "autospec", do not edit)
 *
 *  Copyright (C) 2009 Faraday Corp. (http://www.faraday-tech.com)
 *
 *  Platform Hierarchy :
 *
 *    A369
 *     +- CPUS_FA606TE  (0)
 *     +- CPU_FA626TE  (0)
 *     +- ADC_FTTSC010  (0)
 *     +- AES_FTAES020  (0)
 *     +- AHBB_FTAHBB020  (0)
 *     +- AHBB_FTAHBB020  (1)
 *     +- AHBB_FTAHBB020  (2)
 *     +- AHBC_FTAHBC020  (0)
 *     +- AHBC_FTAHBC020  (1)
 *     +- AHBC_FTAHBC020  (2)
 *     +- DDRC_FTDDRII030  (0)
 *     +- DEVICE_FA606TE  (0)
 *     +- DEVICE_FA606TE  (1)
 *     +- DEVICE_FA626TE  (2)
 *     +- DEVICE_FTAHBB020  (3)
 *     +- DEVICE_FTAHBB020  (4)
 *     +- DEVICE_FTAHBB020  (5)
 *     +- DEVICE_FTAHBB020  (6)
 *     +- DEVICE_FTAPBBRG020  (7)
 *     +- DEVICE_FTDDRII030  (8)
 *     +- DEVICE_FTDDRII030  (9)
 *     +- DEVICE_FTDDRII030  (10)
 *     +- DEVICE_FTEMC020  (11)
 *     +- DEVICE_FTEMC020  (12)
 *     +- DEVICE_FTSMC020  (13)
 *     +- EBIEBI_FTEBI020  (0)
 *     +- EBIEBI_FTEBI020  (1)
 *     +- GPIO_FTGPIO010  (0)
 *     +- GPIO_FTGPIO010  (1)
 *     +- IDE_FTIDE020  (0)
 *     +- IIC_FTIIC010  (0)
 *     +- IIC_FTIIC010  (1)
 *     +- INTC_FTINTC020  (0)
 *     +- INTC_FTINTC020  (1)
 *     +- KBC_FTKBC010  (0)
 *     +- LCDC_FTLCDC200  (0)
 *     +- MAC_FTGMAC100  (0)
 *     +- MCP_FTMCP100  (0)
 *     +- MCP_FTMCP220  (1)
 *     +- NANDC_FTNANDC021  (0)
 *     +- PCI0
 *     |   +- PCI_FTPCIE3914  (0)
 *     +- PCIIO_FTPCIE3914  (0)
 *     +- PCIMEM_FTPCIE3914  (0)
 *     +- RTC_FTRTC011  (0)
 *     +- SATA_FTSATA100  (0)
 *     +- SATA_FTSATA110  (1)
 *     +- SCU_FTSCU010  (0)
 *     +- SDC_FTSDC010  (0)
 *     +- SDC_FTSDC010  (1)
 *     +- SMC_FTSMC020  (0)
 *     +- SSP_FTSSP010  (0)
 *     +- SSP_FTSSP010  (1)
 *     +- TIMER_FTPWMTMR010  (0)
 *     +- UART_FTUART010  (0)
 *     +- UART_FTUART010  (1)
 *     +- UART_FTUART010  (2)
 *     +- UART_FTUART010  (3)
 *     +- USB_FOTG2XX  (0)
 *     +- USB_FUSBH200  (1)
 *     +- WDT_FTWDT010  (0)
 *     +- APBDMA
 *     |   +- APBBRG_FTAPBBRG020  (0)
 *     +- AHBDMA
 *     |   +- DMAC_FTDMAC020  (0)
 *     +- AHBDMA_1
 *         +- DMAC_FTDMAC020  (1)
 */


#include <linux/init.h>
#include <linux/module.h>

#include <asm/mach/map.h>
#include <asm/sizes.h>

#include <mach/platform/spec.h>
/*
 * Interrrupt numbers
 */


/* ADC */
const unsigned char ADC_FTTSC010_irq[ADC_FTTSC010_COUNT][ADC_FTTSC010_IRQ_COUNT] = {
    { ADC_FTTSC010_0_IRQ0, ADC_FTTSC010_0_IRQ1 }
};

/* AES */
const unsigned char AES_FTAES020_irq[AES_FTAES020_COUNT] = {
     AES_FTAES020_0_IRQ
};

/* DDRC */
const unsigned char DDRC_FTDDRII030_irq[DDRC_FTDDRII030_COUNT] = {
     DDRC_FTDDRII030_0_IRQ
};

/* GPIO */
const unsigned char GPIO_FTGPIO010_irq[GPIO_FTGPIO010_COUNT] = {
     GPIO_FTGPIO010_0_IRQ,
     GPIO_FTGPIO010_1_IRQ
};

/* IDE */
const unsigned char IDE_FTIDE020_irq[IDE_FTIDE020_COUNT] = {
     IDE_FTIDE020_0_IRQ
};

/* IIC */
const unsigned char IIC_FTIIC010_irq[IIC_FTIIC010_COUNT] = {
     IIC_FTIIC010_0_IRQ,
     IIC_FTIIC010_1_IRQ
};

/* KBC */
const unsigned char KBC_FTKBC010_irq[KBC_FTKBC010_COUNT] = {
     KBC_FTKBC010_0_IRQ
};

/* LCDC */
const unsigned char LCDC_FTLCDC200_irq[LCDC_FTLCDC200_COUNT][LCDC_FTLCDC200_IRQ_COUNT] = {
    { LCDC_FTLCDC200_0_IRQ0, LCDC_FTLCDC200_0_IRQ1, LCDC_FTLCDC200_0_IRQ2, LCDC_FTLCDC200_0_IRQ3 }
};

/* MAC */
const unsigned char MAC_FTGMAC100_irq[MAC_FTGMAC100_COUNT] = {
     MAC_FTGMAC100_0_IRQ
};

/* MCP */
const unsigned char MCP_FTMCP100_irq[MCP_FTMCP100_COUNT] = {
     MCP_FTMCP100_0_IRQ
};
const unsigned char MCP_FTMCP220_irq[MCP_FTMCP220_COUNT] = {
     MCP_FTMCP220_0_IRQ
};

/* NANDC */
const unsigned char NANDC_FTNANDC021_irq[NANDC_FTNANDC021_COUNT] = {
     NANDC_FTNANDC021_0_IRQ
};

/* RTC */
const unsigned char RTC_FTRTC011_irq[RTC_FTRTC011_COUNT][RTC_FTRTC011_IRQ_COUNT] = {
    { RTC_FTRTC011_0_IRQ0, RTC_FTRTC011_0_IRQ1, RTC_FTRTC011_0_IRQ2, RTC_FTRTC011_0_IRQ3 }
};

/* SATA */
const unsigned char SATA_FTSATA100_irq[SATA_FTSATA100_COUNT] = {
     SATA_FTSATA100_0_IRQ
};
const unsigned char SATA_FTSATA110_irq[SATA_FTSATA110_COUNT] = {
     SATA_FTSATA110_0_IRQ
};

/* SCU */
const unsigned char SCU_FTSCU010_irq[SCU_FTSCU010_COUNT] = {
     SCU_FTSCU010_0_IRQ
};

/* SDC */
const unsigned char SDC_FTSDC010_irq[SDC_FTSDC010_COUNT] = {
     SDC_FTSDC010_0_IRQ,
     SDC_FTSDC010_1_IRQ
};

/* SSP */
const unsigned char SSP_FTSSP010_irq[SSP_FTSSP010_COUNT] = {
     SSP_FTSSP010_0_IRQ,
     SSP_FTSSP010_1_IRQ
};

/* TIMER */
const unsigned char TIMER_FTPWMTMR010_irq[TIMER_FTPWMTMR010_COUNT][TIMER_FTPWMTMR010_IRQ_COUNT] = {
    { TIMER_FTPWMTMR010_0_IRQ0, TIMER_FTPWMTMR010_0_IRQ1, TIMER_FTPWMTMR010_0_IRQ2, TIMER_FTPWMTMR010_0_IRQ3 }
};

/* UART */
const unsigned char UART_FTUART010_irq[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_IRQ,
     UART_FTUART010_1_IRQ,
     UART_FTUART010_2_IRQ,
     UART_FTUART010_3_IRQ
};

/* USB */
const unsigned char USB_FOTG2XX_irq[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_IRQ
};
const unsigned char USB_FUSBH200_irq[USB_FUSBH200_COUNT] = {
     USB_FUSBH200_0_IRQ
};

/* WDT */
const unsigned char WDT_FTWDT010_irq[WDT_FTWDT010_COUNT] = {
     WDT_FTWDT010_0_IRQ
};

/* PCI */
const unsigned char PCI_FTPCIE3914_irq[PCI_FTPCIE3914_COUNT][PCI_FTPCIE3914_IRQ_COUNT] = {
    { PCI_FTPCIE3914_0_IRQ0, PCI_FTPCIE3914_0_IRQ1, PCI_FTPCIE3914_0_IRQ2, PCI_FTPCIE3914_0_IRQ3 }
};

/* APBBRG */
const unsigned char APBBRG_FTAPBBRG020_irq[APBBRG_FTAPBBRG020_COUNT][APBBRG_FTAPBBRG020_IRQ_COUNT] = {
    { APBBRG_FTAPBBRG020_0_IRQ0, APBBRG_FTAPBBRG020_0_IRQ1, APBBRG_FTAPBBRG020_0_IRQ2, APBBRG_FTAPBBRG020_0_IRQ3 }
};

/* DMAC */
const unsigned char DMAC_FTDMAC020_irq[DMAC_FTDMAC020_COUNT][DMAC_FTDMAC020_IRQ_COUNT] = {
    { DMAC_FTDMAC020_0_IRQ0, DMAC_FTDMAC020_0_IRQ1, DMAC_FTDMAC020_0_IRQ2, DMAC_FTDMAC020_0_IRQ3, DMAC_FTDMAC020_0_IRQ4, DMAC_FTDMAC020_0_IRQ5, DMAC_FTDMAC020_0_IRQ6, DMAC_FTDMAC020_0_IRQ7 },
    { DMAC_FTDMAC020_1_IRQ0, DMAC_FTDMAC020_1_IRQ1, DMAC_FTDMAC020_1_IRQ2, DMAC_FTDMAC020_1_IRQ3, DMAC_FTDMAC020_1_IRQ4, DMAC_FTDMAC020_1_IRQ5, DMAC_FTDMAC020_1_IRQ6, DMAC_FTDMAC020_1_IRQ7 }
};

/*
 * Base addresses
 */


/* CPUS */
const unsigned CPUS_FA606TE_pa_base[CPUS_FA606TE_COUNT] = {
     CPUS_FA606TE_0_PA_BASE
};
const unsigned CPUS_FA606TE_pa_limit[CPUS_FA606TE_COUNT] = {
     CPUS_FA606TE_0_PA_LIMIT
};
const unsigned CPUS_FA606TE_pa_size[CPUS_FA606TE_COUNT] = {
     CPUS_FA606TE_0_PA_SIZE
};

/* CPU */
const unsigned CPU_MEM_pa_base[CPU_MEM_PA_COUNT] = {
     CPU_MEM_0_PA_BASE
};
const unsigned CPU_MEM_pa_limit[CPU_MEM_PA_COUNT] = {
     CPU_MEM_0_PA_LIMIT
};
const unsigned CPU_MEM_pa_size[CPU_MEM_PA_COUNT] = {
     CPU_MEM_0_PA_SIZE
};

/* ADC */
const unsigned ADC_FTTSC010_pa_base[ADC_FTTSC010_COUNT] = {
     ADC_FTTSC010_0_PA_BASE
};
const unsigned ADC_FTTSC010_pa_limit[ADC_FTTSC010_COUNT] = {
     ADC_FTTSC010_0_PA_LIMIT
};
const unsigned ADC_FTTSC010_pa_size[ADC_FTTSC010_COUNT] = {
     ADC_FTTSC010_0_PA_SIZE
};
const unsigned ADC_FTTSC010_va_base[ADC_FTTSC010_COUNT] = {
     ADC_FTTSC010_0_VA_BASE
};
const unsigned ADC_FTTSC010_va_limit[ADC_FTTSC010_COUNT] = {
     ADC_FTTSC010_0_VA_LIMIT
};
const unsigned ADC_FTTSC010_va_size[ADC_FTTSC010_COUNT] = {
     ADC_FTTSC010_0_VA_SIZE
};

/* AES */
const unsigned AES_FTAES020_pa_base[AES_FTAES020_COUNT] = {
     AES_FTAES020_0_PA_BASE
};
const unsigned AES_FTAES020_pa_limit[AES_FTAES020_COUNT] = {
     AES_FTAES020_0_PA_LIMIT
};
const unsigned AES_FTAES020_pa_size[AES_FTAES020_COUNT] = {
     AES_FTAES020_0_PA_SIZE
};
const unsigned AES_FTAES020_va_base[AES_FTAES020_COUNT] = {
     AES_FTAES020_0_VA_BASE
};
const unsigned AES_FTAES020_va_limit[AES_FTAES020_COUNT] = {
     AES_FTAES020_0_VA_LIMIT
};
const unsigned AES_FTAES020_va_size[AES_FTAES020_COUNT] = {
     AES_FTAES020_0_VA_SIZE
};

/* AHBB */
const unsigned AHBB_FTAHBB020_pa_base[AHBB_FTAHBB020_COUNT] = {
     AHBB_FTAHBB020_0_PA_BASE,
     AHBB_FTAHBB020_1_PA_BASE,
     AHBB_FTAHBB020_2_PA_BASE
};
const unsigned AHBB_FTAHBB020_pa_limit[AHBB_FTAHBB020_COUNT] = {
     AHBB_FTAHBB020_0_PA_LIMIT,
     AHBB_FTAHBB020_1_PA_LIMIT,
     AHBB_FTAHBB020_2_PA_LIMIT
};
const unsigned AHBB_FTAHBB020_pa_size[AHBB_FTAHBB020_COUNT] = {
     AHBB_FTAHBB020_0_PA_SIZE,
     AHBB_FTAHBB020_1_PA_SIZE,
     AHBB_FTAHBB020_2_PA_SIZE
};
const unsigned AHBB_FTAHBB020_va_base[AHBB_FTAHBB020_COUNT] = {
     AHBB_FTAHBB020_0_VA_BASE,
     AHBB_FTAHBB020_1_VA_BASE,
     AHBB_FTAHBB020_2_VA_BASE
};
const unsigned AHBB_FTAHBB020_va_limit[AHBB_FTAHBB020_COUNT] = {
     AHBB_FTAHBB020_0_VA_LIMIT,
     AHBB_FTAHBB020_1_VA_LIMIT,
     AHBB_FTAHBB020_2_VA_LIMIT
};
const unsigned AHBB_FTAHBB020_va_size[AHBB_FTAHBB020_COUNT] = {
     AHBB_FTAHBB020_0_VA_SIZE,
     AHBB_FTAHBB020_1_VA_SIZE,
     AHBB_FTAHBB020_2_VA_SIZE
};

/* AHBC */
const unsigned AHBC_FTAHBC020_pa_base[AHBC_FTAHBC020_COUNT] = {
     AHBC_FTAHBC020_0_PA_BASE,
     AHBC_FTAHBC020_1_PA_BASE,
     AHBC_FTAHBC020_2_PA_BASE
};
const unsigned AHBC_FTAHBC020_pa_limit[AHBC_FTAHBC020_COUNT] = {
     AHBC_FTAHBC020_0_PA_LIMIT,
     AHBC_FTAHBC020_1_PA_LIMIT,
     AHBC_FTAHBC020_2_PA_LIMIT
};
const unsigned AHBC_FTAHBC020_pa_size[AHBC_FTAHBC020_COUNT] = {
     AHBC_FTAHBC020_0_PA_SIZE,
     AHBC_FTAHBC020_1_PA_SIZE,
     AHBC_FTAHBC020_2_PA_SIZE
};
const unsigned AHBC_FTAHBC020_va_base[AHBC_FTAHBC020_COUNT] = {
     AHBC_FTAHBC020_0_VA_BASE,
     AHBC_FTAHBC020_1_VA_BASE,
     AHBC_FTAHBC020_2_VA_BASE
};
const unsigned AHBC_FTAHBC020_va_limit[AHBC_FTAHBC020_COUNT] = {
     AHBC_FTAHBC020_0_VA_LIMIT,
     AHBC_FTAHBC020_1_VA_LIMIT,
     AHBC_FTAHBC020_2_VA_LIMIT
};
const unsigned AHBC_FTAHBC020_va_size[AHBC_FTAHBC020_COUNT] = {
     AHBC_FTAHBC020_0_VA_SIZE,
     AHBC_FTAHBC020_1_VA_SIZE,
     AHBC_FTAHBC020_2_VA_SIZE
};

/* DDRC */
const unsigned DDRC_FTDDRII030_pa_base[DDRC_FTDDRII030_COUNT] = {
     DDRC_FTDDRII030_0_PA_BASE
};
const unsigned DDRC_FTDDRII030_pa_limit[DDRC_FTDDRII030_COUNT] = {
     DDRC_FTDDRII030_0_PA_LIMIT
};
const unsigned DDRC_FTDDRII030_pa_size[DDRC_FTDDRII030_COUNT] = {
     DDRC_FTDDRII030_0_PA_SIZE
};
const unsigned DDRC_FTDDRII030_va_base[DDRC_FTDDRII030_COUNT] = {
     DDRC_FTDDRII030_0_VA_BASE
};
const unsigned DDRC_FTDDRII030_va_limit[DDRC_FTDDRII030_COUNT] = {
     DDRC_FTDDRII030_0_VA_LIMIT
};
const unsigned DDRC_FTDDRII030_va_size[DDRC_FTDDRII030_COUNT] = {
     DDRC_FTDDRII030_0_VA_SIZE
};

/* DEVICE */
const unsigned DEVICE_FA606TE_pa_base[DEVICE_FA606TE_COUNT] = {
     DEVICE_FA606TE_0_PA_BASE,
     DEVICE_FA606TE_1_PA_BASE
};
const unsigned DEVICE_FA606TE_pa_limit[DEVICE_FA606TE_COUNT] = {
     DEVICE_FA606TE_0_PA_LIMIT,
     DEVICE_FA606TE_1_PA_LIMIT
};
const unsigned DEVICE_FA606TE_pa_size[DEVICE_FA606TE_COUNT] = {
     DEVICE_FA606TE_0_PA_SIZE,
     DEVICE_FA606TE_1_PA_SIZE
};
const unsigned DEVICE_FA626TE_pa_base[DEVICE_FA626TE_COUNT] = {
     DEVICE_FA626TE_0_PA_BASE
};
const unsigned DEVICE_FA626TE_pa_limit[DEVICE_FA626TE_COUNT] = {
     DEVICE_FA626TE_0_PA_LIMIT
};
const unsigned DEVICE_FA626TE_pa_size[DEVICE_FA626TE_COUNT] = {
     DEVICE_FA626TE_0_PA_SIZE
};
const unsigned DEVICE_FTAHBB020_pa_base[DEVICE_FTAHBB020_COUNT] = {
     DEVICE_FTAHBB020_0_PA_BASE,
     DEVICE_FTAHBB020_1_PA_BASE,
     DEVICE_FTAHBB020_2_PA_BASE,
     DEVICE_FTAHBB020_3_PA_BASE
};
const unsigned DEVICE_FTAHBB020_pa_limit[DEVICE_FTAHBB020_COUNT] = {
     DEVICE_FTAHBB020_0_PA_LIMIT,
     DEVICE_FTAHBB020_1_PA_LIMIT,
     DEVICE_FTAHBB020_2_PA_LIMIT,
     DEVICE_FTAHBB020_3_PA_LIMIT
};
const unsigned DEVICE_FTAHBB020_pa_size[DEVICE_FTAHBB020_COUNT] = {
     DEVICE_FTAHBB020_0_PA_SIZE,
     DEVICE_FTAHBB020_1_PA_SIZE,
     DEVICE_FTAHBB020_2_PA_SIZE,
     DEVICE_FTAHBB020_3_PA_SIZE
};
const unsigned DEVICE_FTAPBBRG020_pa_base[DEVICE_FTAPBBRG020_COUNT] = {
     DEVICE_FTAPBBRG020_0_PA_BASE
};
const unsigned DEVICE_FTAPBBRG020_pa_limit[DEVICE_FTAPBBRG020_COUNT] = {
     DEVICE_FTAPBBRG020_0_PA_LIMIT
};
const unsigned DEVICE_FTAPBBRG020_pa_size[DEVICE_FTAPBBRG020_COUNT] = {
     DEVICE_FTAPBBRG020_0_PA_SIZE
};
const unsigned DEVICE_FTDDRII030_pa_base[DEVICE_FTDDRII030_COUNT] = {
     DEVICE_FTDDRII030_0_PA_BASE,
     DEVICE_FTDDRII030_1_PA_BASE,
     DEVICE_FTDDRII030_2_PA_BASE
};
const unsigned DEVICE_FTDDRII030_pa_limit[DEVICE_FTDDRII030_COUNT] = {
     DEVICE_FTDDRII030_0_PA_LIMIT,
     DEVICE_FTDDRII030_1_PA_LIMIT,
     DEVICE_FTDDRII030_2_PA_LIMIT
};
const unsigned DEVICE_FTDDRII030_pa_size[DEVICE_FTDDRII030_COUNT] = {
     DEVICE_FTDDRII030_0_PA_SIZE,
     DEVICE_FTDDRII030_1_PA_SIZE,
     DEVICE_FTDDRII030_2_PA_SIZE
};
const unsigned DEVICE_FTEMC020_pa_base[DEVICE_FTEMC020_COUNT] = {
     DEVICE_FTEMC020_0_PA_BASE,
     DEVICE_FTEMC020_1_PA_BASE
};
const unsigned DEVICE_FTEMC020_pa_limit[DEVICE_FTEMC020_COUNT] = {
     DEVICE_FTEMC020_0_PA_LIMIT,
     DEVICE_FTEMC020_1_PA_LIMIT
};
const unsigned DEVICE_FTEMC020_pa_size[DEVICE_FTEMC020_COUNT] = {
     DEVICE_FTEMC020_0_PA_SIZE,
     DEVICE_FTEMC020_1_PA_SIZE
};
const unsigned DEVICE_FTSMC020_pa_base[DEVICE_FTSMC020_COUNT] = {
     DEVICE_FTSMC020_0_PA_BASE
};
const unsigned DEVICE_FTSMC020_pa_limit[DEVICE_FTSMC020_COUNT] = {
     DEVICE_FTSMC020_0_PA_LIMIT
};
const unsigned DEVICE_FTSMC020_pa_size[DEVICE_FTSMC020_COUNT] = {
     DEVICE_FTSMC020_0_PA_SIZE
};

/* EBIEBI */
const unsigned EBIEBI_FTEBI020_pa_base[EBIEBI_FTEBI020_COUNT] = {
     EBIEBI_FTEBI020_0_PA_BASE,
     EBIEBI_FTEBI020_1_PA_BASE
};
const unsigned EBIEBI_FTEBI020_pa_limit[EBIEBI_FTEBI020_COUNT] = {
     EBIEBI_FTEBI020_0_PA_LIMIT,
     EBIEBI_FTEBI020_1_PA_LIMIT
};
const unsigned EBIEBI_FTEBI020_pa_size[EBIEBI_FTEBI020_COUNT] = {
     EBIEBI_FTEBI020_0_PA_SIZE,
     EBIEBI_FTEBI020_1_PA_SIZE
};
const unsigned EBIEBI_FTEBI020_va_base[EBIEBI_FTEBI020_COUNT] = {
     EBIEBI_FTEBI020_0_VA_BASE,
     EBIEBI_FTEBI020_1_VA_BASE
};
const unsigned EBIEBI_FTEBI020_va_limit[EBIEBI_FTEBI020_COUNT] = {
     EBIEBI_FTEBI020_0_VA_LIMIT,
     EBIEBI_FTEBI020_1_VA_LIMIT
};
const unsigned EBIEBI_FTEBI020_va_size[EBIEBI_FTEBI020_COUNT] = {
     EBIEBI_FTEBI020_0_VA_SIZE,
     EBIEBI_FTEBI020_1_VA_SIZE
};

/* GPIO */
const unsigned GPIO_FTGPIO010_pa_base[GPIO_FTGPIO010_COUNT] = {
     GPIO_FTGPIO010_0_PA_BASE,
     GPIO_FTGPIO010_1_PA_BASE
};
const unsigned GPIO_FTGPIO010_pa_limit[GPIO_FTGPIO010_COUNT] = {
     GPIO_FTGPIO010_0_PA_LIMIT,
     GPIO_FTGPIO010_1_PA_LIMIT
};
const unsigned GPIO_FTGPIO010_pa_size[GPIO_FTGPIO010_COUNT] = {
     GPIO_FTGPIO010_0_PA_SIZE,
     GPIO_FTGPIO010_1_PA_SIZE
};
const unsigned GPIO_FTGPIO010_va_base[GPIO_FTGPIO010_COUNT] = {
     GPIO_FTGPIO010_0_VA_BASE,
     GPIO_FTGPIO010_1_VA_BASE
};
const unsigned GPIO_FTGPIO010_va_limit[GPIO_FTGPIO010_COUNT] = {
     GPIO_FTGPIO010_0_VA_LIMIT,
     GPIO_FTGPIO010_1_VA_LIMIT
};
const unsigned GPIO_FTGPIO010_va_size[GPIO_FTGPIO010_COUNT] = {
     GPIO_FTGPIO010_0_VA_SIZE,
     GPIO_FTGPIO010_1_VA_SIZE
};

/* IDE */
const unsigned IDE_FTIDE020_pa_base[IDE_FTIDE020_COUNT] = {
     IDE_FTIDE020_0_PA_BASE
};
const unsigned IDE_FTIDE020_pa_limit[IDE_FTIDE020_COUNT] = {
     IDE_FTIDE020_0_PA_LIMIT
};
const unsigned IDE_FTIDE020_pa_size[IDE_FTIDE020_COUNT] = {
     IDE_FTIDE020_0_PA_SIZE
};
const unsigned IDE_FTIDE020_va_base[IDE_FTIDE020_COUNT] = {
     IDE_FTIDE020_0_VA_BASE
};
const unsigned IDE_FTIDE020_va_limit[IDE_FTIDE020_COUNT] = {
     IDE_FTIDE020_0_VA_LIMIT
};
const unsigned IDE_FTIDE020_va_size[IDE_FTIDE020_COUNT] = {
     IDE_FTIDE020_0_VA_SIZE
};

/* IIC */
const unsigned IIC_FTIIC010_pa_base[IIC_FTIIC010_COUNT] = {
     IIC_FTIIC010_0_PA_BASE,
     IIC_FTIIC010_1_PA_BASE
};
const unsigned IIC_FTIIC010_pa_limit[IIC_FTIIC010_COUNT] = {
     IIC_FTIIC010_0_PA_LIMIT,
     IIC_FTIIC010_1_PA_LIMIT
};
const unsigned IIC_FTIIC010_pa_size[IIC_FTIIC010_COUNT] = {
     IIC_FTIIC010_0_PA_SIZE,
     IIC_FTIIC010_1_PA_SIZE
};
const unsigned IIC_FTIIC010_va_base[IIC_FTIIC010_COUNT] = {
     IIC_FTIIC010_0_VA_BASE,
     IIC_FTIIC010_1_VA_BASE
};
const unsigned IIC_FTIIC010_va_limit[IIC_FTIIC010_COUNT] = {
     IIC_FTIIC010_0_VA_LIMIT,
     IIC_FTIIC010_1_VA_LIMIT
};
const unsigned IIC_FTIIC010_va_size[IIC_FTIIC010_COUNT] = {
     IIC_FTIIC010_0_VA_SIZE,
     IIC_FTIIC010_1_VA_SIZE
};

/* INTC */
const unsigned INTC_FTINTC020_pa_base[INTC_FTINTC020_COUNT] = {
     INTC_FTINTC020_0_PA_BASE,
     INTC_FTINTC020_1_PA_BASE
};
const unsigned INTC_FTINTC020_pa_limit[INTC_FTINTC020_COUNT] = {
     INTC_FTINTC020_0_PA_LIMIT,
     INTC_FTINTC020_1_PA_LIMIT
};
const unsigned INTC_FTINTC020_pa_size[INTC_FTINTC020_COUNT] = {
     INTC_FTINTC020_0_PA_SIZE,
     INTC_FTINTC020_1_PA_SIZE
};
const unsigned INTC_FTINTC020_va_base[INTC_FTINTC020_COUNT] = {
     INTC_FTINTC020_0_VA_BASE,
     INTC_FTINTC020_1_VA_BASE
};
const unsigned INTC_FTINTC020_va_limit[INTC_FTINTC020_COUNT] = {
     INTC_FTINTC020_0_VA_LIMIT,
     INTC_FTINTC020_1_VA_LIMIT
};
const unsigned INTC_FTINTC020_va_size[INTC_FTINTC020_COUNT] = {
     INTC_FTINTC020_0_VA_SIZE,
     INTC_FTINTC020_1_VA_SIZE
};

/* KBC */
const unsigned KBC_FTKBC010_pa_base[KBC_FTKBC010_COUNT] = {
     KBC_FTKBC010_0_PA_BASE
};
const unsigned KBC_FTKBC010_pa_limit[KBC_FTKBC010_COUNT] = {
     KBC_FTKBC010_0_PA_LIMIT
};
const unsigned KBC_FTKBC010_pa_size[KBC_FTKBC010_COUNT] = {
     KBC_FTKBC010_0_PA_SIZE
};
const unsigned KBC_FTKBC010_va_base[KBC_FTKBC010_COUNT] = {
     KBC_FTKBC010_0_VA_BASE
};
const unsigned KBC_FTKBC010_va_limit[KBC_FTKBC010_COUNT] = {
     KBC_FTKBC010_0_VA_LIMIT
};
const unsigned KBC_FTKBC010_va_size[KBC_FTKBC010_COUNT] = {
     KBC_FTKBC010_0_VA_SIZE
};

/* LCDC */
const unsigned LCDC_FTLCDC200_pa_base[LCDC_FTLCDC200_COUNT] = {
     LCDC_FTLCDC200_0_PA_BASE
};
const unsigned LCDC_FTLCDC200_pa_limit[LCDC_FTLCDC200_COUNT] = {
     LCDC_FTLCDC200_0_PA_LIMIT
};
const unsigned LCDC_FTLCDC200_pa_size[LCDC_FTLCDC200_COUNT] = {
     LCDC_FTLCDC200_0_PA_SIZE
};
const unsigned LCDC_FTLCDC200_va_base[LCDC_FTLCDC200_COUNT] = {
     LCDC_FTLCDC200_0_VA_BASE
};
const unsigned LCDC_FTLCDC200_va_limit[LCDC_FTLCDC200_COUNT] = {
     LCDC_FTLCDC200_0_VA_LIMIT
};
const unsigned LCDC_FTLCDC200_va_size[LCDC_FTLCDC200_COUNT] = {
     LCDC_FTLCDC200_0_VA_SIZE
};

/* MAC */
const unsigned MAC_FTGMAC100_pa_base[MAC_FTGMAC100_COUNT] = {
     MAC_FTGMAC100_0_PA_BASE
};
const unsigned MAC_FTGMAC100_pa_limit[MAC_FTGMAC100_COUNT] = {
     MAC_FTGMAC100_0_PA_LIMIT
};
const unsigned MAC_FTGMAC100_pa_size[MAC_FTGMAC100_COUNT] = {
     MAC_FTGMAC100_0_PA_SIZE
};
const unsigned MAC_FTGMAC100_va_base[MAC_FTGMAC100_COUNT] = {
     MAC_FTGMAC100_0_VA_BASE
};
const unsigned MAC_FTGMAC100_va_limit[MAC_FTGMAC100_COUNT] = {
     MAC_FTGMAC100_0_VA_LIMIT
};
const unsigned MAC_FTGMAC100_va_size[MAC_FTGMAC100_COUNT] = {
     MAC_FTGMAC100_0_VA_SIZE
};

/* MCP */
const unsigned MCP_FTMCP100_pa_base[MCP_FTMCP100_COUNT] = {
     MCP_FTMCP100_0_PA_BASE
};
const unsigned MCP_FTMCP100_pa_limit[MCP_FTMCP100_COUNT] = {
     MCP_FTMCP100_0_PA_LIMIT
};
const unsigned MCP_FTMCP100_pa_size[MCP_FTMCP100_COUNT] = {
     MCP_FTMCP100_0_PA_SIZE
};
const unsigned MCP_FTMCP100_va_base[MCP_FTMCP100_COUNT] = {
     MCP_FTMCP100_0_VA_BASE
};
const unsigned MCP_FTMCP100_va_limit[MCP_FTMCP100_COUNT] = {
     MCP_FTMCP100_0_VA_LIMIT
};
const unsigned MCP_FTMCP100_va_size[MCP_FTMCP100_COUNT] = {
     MCP_FTMCP100_0_VA_SIZE
};
const unsigned MCP_FTMCP220_pa_base[MCP_FTMCP220_COUNT] = {
     MCP_FTMCP220_0_PA_BASE
};
const unsigned MCP_FTMCP220_pa_limit[MCP_FTMCP220_COUNT] = {
     MCP_FTMCP220_0_PA_LIMIT
};
const unsigned MCP_FTMCP220_pa_size[MCP_FTMCP220_COUNT] = {
     MCP_FTMCP220_0_PA_SIZE
};
const unsigned MCP_FTMCP220_va_base[MCP_FTMCP220_COUNT] = {
     MCP_FTMCP220_0_VA_BASE
};
const unsigned MCP_FTMCP220_va_limit[MCP_FTMCP220_COUNT] = {
     MCP_FTMCP220_0_VA_LIMIT
};
const unsigned MCP_FTMCP220_va_size[MCP_FTMCP220_COUNT] = {
     MCP_FTMCP220_0_VA_SIZE
};

/* NANDC */
const unsigned NANDC_FTNANDC021_pa_base[NANDC_FTNANDC021_COUNT] = {
     NANDC_FTNANDC021_0_PA_BASE
};
const unsigned NANDC_FTNANDC021_pa_limit[NANDC_FTNANDC021_COUNT] = {
     NANDC_FTNANDC021_0_PA_LIMIT
};
const unsigned NANDC_FTNANDC021_pa_size[NANDC_FTNANDC021_COUNT] = {
     NANDC_FTNANDC021_0_PA_SIZE
};
const unsigned NANDC_FTNANDC021_va_base[NANDC_FTNANDC021_COUNT] = {
     NANDC_FTNANDC021_0_VA_BASE
};
const unsigned NANDC_FTNANDC021_va_limit[NANDC_FTNANDC021_COUNT] = {
     NANDC_FTNANDC021_0_VA_LIMIT
};
const unsigned NANDC_FTNANDC021_va_size[NANDC_FTNANDC021_COUNT] = {
     NANDC_FTNANDC021_0_VA_SIZE
};

/* PCIIO */
const unsigned PCIIO_FTPCIE3914_pa_base[PCIIO_FTPCIE3914_COUNT] = {
     PCIIO_FTPCIE3914_0_PA_BASE
};
const unsigned PCIIO_FTPCIE3914_pa_limit[PCIIO_FTPCIE3914_COUNT] = {
     PCIIO_FTPCIE3914_0_PA_LIMIT
};
const unsigned PCIIO_FTPCIE3914_pa_size[PCIIO_FTPCIE3914_COUNT] = {
     PCIIO_FTPCIE3914_0_PA_SIZE
};
const unsigned PCIIO_FTPCIE3914_va_base[PCIIO_FTPCIE3914_COUNT] = {
     PCIIO_FTPCIE3914_0_VA_BASE
};
const unsigned PCIIO_FTPCIE3914_va_limit[PCIIO_FTPCIE3914_COUNT] = {
     PCIIO_FTPCIE3914_0_VA_LIMIT
};
const unsigned PCIIO_FTPCIE3914_va_size[PCIIO_FTPCIE3914_COUNT] = {
     PCIIO_FTPCIE3914_0_VA_SIZE
};

/* PCIMEM */
const unsigned PCIMEM_FTPCIE3914_pa_base[PCIMEM_FTPCIE3914_COUNT] = {
     PCIMEM_FTPCIE3914_0_PA_BASE
};
const unsigned PCIMEM_FTPCIE3914_pa_limit[PCIMEM_FTPCIE3914_COUNT] = {
     PCIMEM_FTPCIE3914_0_PA_LIMIT
};
const unsigned PCIMEM_FTPCIE3914_pa_size[PCIMEM_FTPCIE3914_COUNT] = {
     PCIMEM_FTPCIE3914_0_PA_SIZE
};
const unsigned PCIMEM_FTPCIE3914_va_base[PCIMEM_FTPCIE3914_COUNT] = {
     PCIMEM_FTPCIE3914_0_VA_BASE
};
const unsigned PCIMEM_FTPCIE3914_va_limit[PCIMEM_FTPCIE3914_COUNT] = {
     PCIMEM_FTPCIE3914_0_VA_LIMIT
};
const unsigned PCIMEM_FTPCIE3914_va_size[PCIMEM_FTPCIE3914_COUNT] = {
     PCIMEM_FTPCIE3914_0_VA_SIZE
};

/* RTC */
const unsigned RTC_FTRTC011_pa_base[RTC_FTRTC011_COUNT] = {
     RTC_FTRTC011_0_PA_BASE
};
const unsigned RTC_FTRTC011_pa_limit[RTC_FTRTC011_COUNT] = {
     RTC_FTRTC011_0_PA_LIMIT
};
const unsigned RTC_FTRTC011_pa_size[RTC_FTRTC011_COUNT] = {
     RTC_FTRTC011_0_PA_SIZE
};
const unsigned RTC_FTRTC011_va_base[RTC_FTRTC011_COUNT] = {
     RTC_FTRTC011_0_VA_BASE
};
const unsigned RTC_FTRTC011_va_limit[RTC_FTRTC011_COUNT] = {
     RTC_FTRTC011_0_VA_LIMIT
};
const unsigned RTC_FTRTC011_va_size[RTC_FTRTC011_COUNT] = {
     RTC_FTRTC011_0_VA_SIZE
};

/* SATA */
const unsigned SATA_FTSATA100_pa_base[SATA_FTSATA100_COUNT] = {
     SATA_FTSATA100_0_PA_BASE
};
const unsigned SATA_FTSATA100_pa_limit[SATA_FTSATA100_COUNT] = {
     SATA_FTSATA100_0_PA_LIMIT
};
const unsigned SATA_FTSATA100_pa_size[SATA_FTSATA100_COUNT] = {
     SATA_FTSATA100_0_PA_SIZE
};
const unsigned SATA_FTSATA100_va_base[SATA_FTSATA100_COUNT] = {
     SATA_FTSATA100_0_VA_BASE
};
const unsigned SATA_FTSATA100_va_limit[SATA_FTSATA100_COUNT] = {
     SATA_FTSATA100_0_VA_LIMIT
};
const unsigned SATA_FTSATA100_va_size[SATA_FTSATA100_COUNT] = {
     SATA_FTSATA100_0_VA_SIZE
};
const unsigned SATA_FTSATA110_pa_base[SATA_FTSATA110_COUNT] = {
     SATA_FTSATA110_0_PA_BASE
};
const unsigned SATA_FTSATA110_pa_limit[SATA_FTSATA110_COUNT] = {
     SATA_FTSATA110_0_PA_LIMIT
};
const unsigned SATA_FTSATA110_pa_size[SATA_FTSATA110_COUNT] = {
     SATA_FTSATA110_0_PA_SIZE
};
const unsigned SATA_FTSATA110_va_base[SATA_FTSATA110_COUNT] = {
     SATA_FTSATA110_0_VA_BASE
};
const unsigned SATA_FTSATA110_va_limit[SATA_FTSATA110_COUNT] = {
     SATA_FTSATA110_0_VA_LIMIT
};
const unsigned SATA_FTSATA110_va_size[SATA_FTSATA110_COUNT] = {
     SATA_FTSATA110_0_VA_SIZE
};

/* SCU */
const unsigned SCU_FTSCU010_pa_base[SCU_FTSCU010_COUNT] = {
     SCU_FTSCU010_0_PA_BASE
};
const unsigned SCU_FTSCU010_pa_limit[SCU_FTSCU010_COUNT] = {
     SCU_FTSCU010_0_PA_LIMIT
};
const unsigned SCU_FTSCU010_pa_size[SCU_FTSCU010_COUNT] = {
     SCU_FTSCU010_0_PA_SIZE
};
const unsigned SCU_FTSCU010_va_base[SCU_FTSCU010_COUNT] = {
     SCU_FTSCU010_0_VA_BASE
};
const unsigned SCU_FTSCU010_va_limit[SCU_FTSCU010_COUNT] = {
     SCU_FTSCU010_0_VA_LIMIT
};
const unsigned SCU_FTSCU010_va_size[SCU_FTSCU010_COUNT] = {
     SCU_FTSCU010_0_VA_SIZE
};

/* SDC */
const unsigned SDC_FTSDC010_pa_base[SDC_FTSDC010_COUNT] = {
     SDC_FTSDC010_0_PA_BASE,
     SDC_FTSDC010_1_PA_BASE
};
const unsigned SDC_FTSDC010_pa_limit[SDC_FTSDC010_COUNT] = {
     SDC_FTSDC010_0_PA_LIMIT,
     SDC_FTSDC010_1_PA_LIMIT
};
const unsigned SDC_FTSDC010_pa_size[SDC_FTSDC010_COUNT] = {
     SDC_FTSDC010_0_PA_SIZE,
     SDC_FTSDC010_1_PA_SIZE
};
const unsigned SDC_FTSDC010_va_base[SDC_FTSDC010_COUNT] = {
     SDC_FTSDC010_0_VA_BASE,
     SDC_FTSDC010_1_VA_BASE
};
const unsigned SDC_FTSDC010_va_limit[SDC_FTSDC010_COUNT] = {
     SDC_FTSDC010_0_VA_LIMIT,
     SDC_FTSDC010_1_VA_LIMIT
};
const unsigned SDC_FTSDC010_va_size[SDC_FTSDC010_COUNT] = {
     SDC_FTSDC010_0_VA_SIZE,
     SDC_FTSDC010_1_VA_SIZE
};

/* SMC */
const unsigned SMC_FTSMC020_pa_base[SMC_FTSMC020_COUNT] = {
     SMC_FTSMC020_0_PA_BASE
};
const unsigned SMC_FTSMC020_pa_limit[SMC_FTSMC020_COUNT] = {
     SMC_FTSMC020_0_PA_LIMIT
};
const unsigned SMC_FTSMC020_pa_size[SMC_FTSMC020_COUNT] = {
     SMC_FTSMC020_0_PA_SIZE
};
const unsigned SMC_FTSMC020_va_base[SMC_FTSMC020_COUNT] = {
     SMC_FTSMC020_0_VA_BASE
};
const unsigned SMC_FTSMC020_va_limit[SMC_FTSMC020_COUNT] = {
     SMC_FTSMC020_0_VA_LIMIT
};
const unsigned SMC_FTSMC020_va_size[SMC_FTSMC020_COUNT] = {
     SMC_FTSMC020_0_VA_SIZE
};

/* SSP */
const unsigned SSP_FTSSP010_pa_base[SSP_FTSSP010_COUNT] = {
     SSP_FTSSP010_0_PA_BASE,
     SSP_FTSSP010_1_PA_BASE
};
const unsigned SSP_FTSSP010_pa_limit[SSP_FTSSP010_COUNT] = {
     SSP_FTSSP010_0_PA_LIMIT,
     SSP_FTSSP010_1_PA_LIMIT
};
const unsigned SSP_FTSSP010_pa_size[SSP_FTSSP010_COUNT] = {
     SSP_FTSSP010_0_PA_SIZE,
     SSP_FTSSP010_1_PA_SIZE
};
const unsigned SSP_FTSSP010_va_base[SSP_FTSSP010_COUNT] = {
     SSP_FTSSP010_0_VA_BASE,
     SSP_FTSSP010_1_VA_BASE
};
const unsigned SSP_FTSSP010_va_limit[SSP_FTSSP010_COUNT] = {
     SSP_FTSSP010_0_VA_LIMIT,
     SSP_FTSSP010_1_VA_LIMIT
};
const unsigned SSP_FTSSP010_va_size[SSP_FTSSP010_COUNT] = {
     SSP_FTSSP010_0_VA_SIZE,
     SSP_FTSSP010_1_VA_SIZE
};

/* TIMER */
const unsigned TIMER_FTPWMTMR010_pa_base[TIMER_FTPWMTMR010_COUNT] = {
     TIMER_FTPWMTMR010_0_PA_BASE
};
const unsigned TIMER_FTPWMTMR010_pa_limit[TIMER_FTPWMTMR010_COUNT] = {
     TIMER_FTPWMTMR010_0_PA_LIMIT
};
const unsigned TIMER_FTPWMTMR010_pa_size[TIMER_FTPWMTMR010_COUNT] = {
     TIMER_FTPWMTMR010_0_PA_SIZE
};
const unsigned TIMER_FTPWMTMR010_va_base[TIMER_FTPWMTMR010_COUNT] = {
     TIMER_FTPWMTMR010_0_VA_BASE
};
const unsigned TIMER_FTPWMTMR010_va_limit[TIMER_FTPWMTMR010_COUNT] = {
     TIMER_FTPWMTMR010_0_VA_LIMIT
};
const unsigned TIMER_FTPWMTMR010_va_size[TIMER_FTPWMTMR010_COUNT] = {
     TIMER_FTPWMTMR010_0_VA_SIZE
};

/* UART */
const unsigned UART_FTUART010_pa_base[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_PA_BASE,
     UART_FTUART010_1_PA_BASE,
     UART_FTUART010_2_PA_BASE,
     UART_FTUART010_3_PA_BASE
};
const unsigned UART_FTUART010_pa_limit[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_PA_LIMIT,
     UART_FTUART010_1_PA_LIMIT,
     UART_FTUART010_2_PA_LIMIT,
     UART_FTUART010_3_PA_LIMIT
};
const unsigned UART_FTUART010_pa_size[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_PA_SIZE,
     UART_FTUART010_1_PA_SIZE,
     UART_FTUART010_2_PA_SIZE,
     UART_FTUART010_3_PA_SIZE
};
const unsigned UART_FTUART010_va_base[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_VA_BASE,
     UART_FTUART010_1_VA_BASE,
     UART_FTUART010_2_VA_BASE,
     UART_FTUART010_3_VA_BASE
};
const unsigned UART_FTUART010_va_limit[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_VA_LIMIT,
     UART_FTUART010_1_VA_LIMIT,
     UART_FTUART010_2_VA_LIMIT,
     UART_FTUART010_3_VA_LIMIT
};
const unsigned UART_FTUART010_va_size[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_VA_SIZE,
     UART_FTUART010_1_VA_SIZE,
     UART_FTUART010_2_VA_SIZE,
     UART_FTUART010_3_VA_SIZE
};

/* USB */
const unsigned USB_FOTG2XX_pa_base[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_PA_BASE
};
const unsigned USB_FOTG2XX_pa_limit[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_PA_LIMIT
};
const unsigned USB_FOTG2XX_pa_size[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_PA_SIZE
};
const unsigned USB_FOTG2XX_va_base[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_VA_BASE
};
const unsigned USB_FOTG2XX_va_limit[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_VA_LIMIT
};
const unsigned USB_FOTG2XX_va_size[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_VA_SIZE
};
const unsigned USB_FUSBH200_pa_base[USB_FUSBH200_COUNT] = {
     USB_FUSBH200_0_PA_BASE
};
const unsigned USB_FUSBH200_pa_limit[USB_FUSBH200_COUNT] = {
     USB_FUSBH200_0_PA_LIMIT
};
const unsigned USB_FUSBH200_pa_size[USB_FUSBH200_COUNT] = {
     USB_FUSBH200_0_PA_SIZE
};
const unsigned USB_FUSBH200_va_base[USB_FUSBH200_COUNT] = {
     USB_FUSBH200_0_VA_BASE
};
const unsigned USB_FUSBH200_va_limit[USB_FUSBH200_COUNT] = {
     USB_FUSBH200_0_VA_LIMIT
};
const unsigned USB_FUSBH200_va_size[USB_FUSBH200_COUNT] = {
     USB_FUSBH200_0_VA_SIZE
};

/* WDT */
const unsigned WDT_FTWDT010_pa_base[WDT_FTWDT010_COUNT] = {
     WDT_FTWDT010_0_PA_BASE
};
const unsigned WDT_FTWDT010_pa_limit[WDT_FTWDT010_COUNT] = {
     WDT_FTWDT010_0_PA_LIMIT
};
const unsigned WDT_FTWDT010_pa_size[WDT_FTWDT010_COUNT] = {
     WDT_FTWDT010_0_PA_SIZE
};
const unsigned WDT_FTWDT010_va_base[WDT_FTWDT010_COUNT] = {
     WDT_FTWDT010_0_VA_BASE
};
const unsigned WDT_FTWDT010_va_limit[WDT_FTWDT010_COUNT] = {
     WDT_FTWDT010_0_VA_LIMIT
};
const unsigned WDT_FTWDT010_va_size[WDT_FTWDT010_COUNT] = {
     WDT_FTWDT010_0_VA_SIZE
};

/* PCI */
const unsigned PCI_FTPCIE3914_pa_base[PCI_FTPCIE3914_COUNT] = {
     PCI_FTPCIE3914_0_PA_BASE
};
const unsigned PCI_FTPCIE3914_pa_limit[PCI_FTPCIE3914_COUNT] = {
     PCI_FTPCIE3914_0_PA_LIMIT
};
const unsigned PCI_FTPCIE3914_pa_size[PCI_FTPCIE3914_COUNT] = {
     PCI_FTPCIE3914_0_PA_SIZE
};
const unsigned PCI_FTPCIE3914_va_base[PCI_FTPCIE3914_COUNT] = {
     PCI_FTPCIE3914_0_VA_BASE
};
const unsigned PCI_FTPCIE3914_va_limit[PCI_FTPCIE3914_COUNT] = {
     PCI_FTPCIE3914_0_VA_LIMIT
};
const unsigned PCI_FTPCIE3914_va_size[PCI_FTPCIE3914_COUNT] = {
     PCI_FTPCIE3914_0_VA_SIZE
};

/* APBBRG */
const unsigned APBBRG_FTAPBBRG020_pa_base[APBBRG_FTAPBBRG020_COUNT] = {
     APBBRG_FTAPBBRG020_0_PA_BASE
};
const unsigned APBBRG_FTAPBBRG020_pa_limit[APBBRG_FTAPBBRG020_COUNT] = {
     APBBRG_FTAPBBRG020_0_PA_LIMIT
};
const unsigned APBBRG_FTAPBBRG020_pa_size[APBBRG_FTAPBBRG020_COUNT] = {
     APBBRG_FTAPBBRG020_0_PA_SIZE
};
const unsigned APBBRG_FTAPBBRG020_va_base[APBBRG_FTAPBBRG020_COUNT] = {
     APBBRG_FTAPBBRG020_0_VA_BASE
};
const unsigned APBBRG_FTAPBBRG020_va_limit[APBBRG_FTAPBBRG020_COUNT] = {
     APBBRG_FTAPBBRG020_0_VA_LIMIT
};
const unsigned APBBRG_FTAPBBRG020_va_size[APBBRG_FTAPBBRG020_COUNT] = {
     APBBRG_FTAPBBRG020_0_VA_SIZE
};

/* DMAC */
const unsigned DMAC_FTDMAC020_pa_base[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_PA_BASE,
     DMAC_FTDMAC020_1_PA_BASE
};
const unsigned DMAC_FTDMAC020_pa_limit[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_PA_LIMIT,
     DMAC_FTDMAC020_1_PA_LIMIT
};
const unsigned DMAC_FTDMAC020_pa_size[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_PA_SIZE,
     DMAC_FTDMAC020_1_PA_SIZE
};
const unsigned DMAC_FTDMAC020_va_base[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_VA_BASE,
     DMAC_FTDMAC020_1_VA_BASE
};
const unsigned DMAC_FTDMAC020_va_limit[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_VA_LIMIT,
     DMAC_FTDMAC020_1_VA_LIMIT
};
const unsigned DMAC_FTDMAC020_va_size[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_VA_SIZE,
     DMAC_FTDMAC020_1_VA_SIZE
};

/*
 * Platform Initialization Information
 */

const struct map_desc platform_io_desc[PLATFORM_IO_DESC_NR] __initdata = {
    { ADC_FTTSC010_0_VA_BASE,	__phys_to_pfn(ADC_FTTSC010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AES_FTAES020_0_VA_BASE,	__phys_to_pfn(AES_FTAES020_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBB_FTAHBB020_0_VA_BASE,	__phys_to_pfn(AHBB_FTAHBB020_0_PA_BASE), 0x00001000,	MT_DEVICE_NCNB },
    { AHBB_FTAHBB020_1_VA_BASE,	__phys_to_pfn(AHBB_FTAHBB020_1_PA_BASE), 0x00001000,	MT_DEVICE_NCNB },
    { AHBB_FTAHBB020_2_VA_BASE,	__phys_to_pfn(AHBB_FTAHBB020_2_PA_BASE), 0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC020_0_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC020_0_PA_BASE), 0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC020_1_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC020_1_PA_BASE), 0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC020_2_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC020_2_PA_BASE), 0x00001000,	MT_DEVICE_NCNB },
    { DDRC_FTDDRII030_0_VA_BASE, __phys_to_pfn(DDRC_FTDDRII030_0_PA_BASE), 0x00001000,	MT_DEVICE_NCNB },
    { EBIEBI_FTEBI020_0_VA_BASE, __phys_to_pfn(EBIEBI_FTEBI020_0_PA_BASE), 0x00001000,	MT_DEVICE_NCNB },
    { EBIEBI_FTEBI020_1_VA_BASE, __phys_to_pfn(EBIEBI_FTEBI020_1_PA_BASE), 0x00001000,	MT_DEVICE_NCNB },
    { GPIO_FTGPIO010_0_VA_BASE,	__phys_to_pfn(GPIO_FTGPIO010_0_PA_BASE), 0x00001000,	MT_DEVICE_NCNB },
    { GPIO_FTGPIO010_1_VA_BASE,	__phys_to_pfn(GPIO_FTGPIO010_1_PA_BASE), 0x00001000,	MT_DEVICE_NCNB },
    { IDE_FTIDE020_0_VA_BASE, __phys_to_pfn(IDE_FTIDE020_0_PA_BASE), 0x00001000,	MT_DEVICE_NCNB },
    { IIC_FTIIC010_0_VA_BASE, __phys_to_pfn(IIC_FTIIC010_0_PA_BASE), 0x00001000,	MT_DEVICE_NCNB },
    { IIC_FTIIC010_1_VA_BASE, __phys_to_pfn(IIC_FTIIC010_1_PA_BASE), 0x00001000,	MT_DEVICE_NCNB },
    { INTC_FTINTC020_0_VA_BASE,	__phys_to_pfn(INTC_FTINTC020_0_PA_BASE), 0x00001000,	MT_DEVICE_NCNB },
    { INTC_FTINTC020_1_VA_BASE,	__phys_to_pfn(INTC_FTINTC020_1_PA_BASE), 0x00001000,	MT_DEVICE_NCNB },
    { KBC_FTKBC010_0_VA_BASE,	__phys_to_pfn(KBC_FTKBC010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { LCDC_FTLCDC200_0_VA_BASE,	__phys_to_pfn(LCDC_FTLCDC200_0_PA_BASE),	0x00010000,	MT_DEVICE_NCNB },
    { MAC_FTGMAC100_0_VA_BASE,	__phys_to_pfn(MAC_FTGMAC100_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { MCP_FTMCP100_0_VA_BASE,	__phys_to_pfn(MCP_FTMCP100_0_PA_BASE),	0x00100000,	MT_DEVICE_NCNB },
    { MCP_FTMCP220_0_VA_BASE,	__phys_to_pfn(MCP_FTMCP220_0_PA_BASE),	0x000F1000,	MT_DEVICE_NCNB },
    { NANDC_FTNANDC021_0_VA_BASE,	__phys_to_pfn(NANDC_FTNANDC021_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { PCIIO_FTPCIE3914_0_VA_BASE,	__phys_to_pfn(PCIIO_FTPCIE3914_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { PCIMEM_FTPCIE3914_0_VA_BASE,	__phys_to_pfn(PCIMEM_FTPCIE3914_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { RTC_FTRTC011_0_VA_BASE,	__phys_to_pfn(RTC_FTRTC011_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { SATA_FTSATA100_0_VA_BASE,	__phys_to_pfn(SATA_FTSATA100_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { SATA_FTSATA110_0_VA_BASE,	__phys_to_pfn(SATA_FTSATA110_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { SCU_FTSCU010_0_VA_BASE,	__phys_to_pfn(SCU_FTSCU010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { SDC_FTSDC010_0_VA_BASE,	__phys_to_pfn(SDC_FTSDC010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { SDC_FTSDC010_1_VA_BASE,	__phys_to_pfn(SDC_FTSDC010_1_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { SMC_FTSMC020_0_VA_BASE,	__phys_to_pfn(SMC_FTSMC020_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { SSP_FTSSP010_0_VA_BASE,	__phys_to_pfn(SSP_FTSSP010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { SSP_FTSSP010_1_VA_BASE,	__phys_to_pfn(SSP_FTSSP010_1_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { TIMER_FTPWMTMR010_0_VA_BASE,	__phys_to_pfn(TIMER_FTPWMTMR010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { UART_FTUART010_0_VA_BASE,	__phys_to_pfn(UART_FTUART010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { UART_FTUART010_1_VA_BASE,	__phys_to_pfn(UART_FTUART010_1_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { UART_FTUART010_2_VA_BASE,	__phys_to_pfn(UART_FTUART010_2_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { UART_FTUART010_3_VA_BASE,	__phys_to_pfn(UART_FTUART010_3_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { USB_FOTG2XX_0_VA_BASE,	__phys_to_pfn(USB_FOTG2XX_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { USB_FUSBH200_0_VA_BASE,	__phys_to_pfn(USB_FUSBH200_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { WDT_FTWDT010_0_VA_BASE,	__phys_to_pfn(WDT_FTWDT010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { PCI_FTPCIE3914_0_VA_BASE,	__phys_to_pfn(PCI_FTPCIE3914_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { APBBRG_FTAPBBRG020_0_VA_BASE,	__phys_to_pfn(APBBRG_FTAPBBRG020_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { DMAC_FTDMAC020_0_VA_BASE,	__phys_to_pfn(DMAC_FTDMAC020_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { DMAC_FTDMAC020_1_VA_BASE,	__phys_to_pfn(DMAC_FTDMAC020_1_PA_BASE),	0x00001000,	MT_DEVICE_NCNB }
};

/*
 * Interrupt Dispatch Tables, for both FIQ and IRQ
 */

/* const interrupt_dispatch_function *fiq_dispatch_table[32]; */

/*
 * Export All Symbols
 */

/*
 * Interrrupt numbers
 */

/* ADC */
EXPORT_SYMBOL( ADC_FTTSC010_irq );
/* AES */
EXPORT_SYMBOL( AES_FTAES020_irq );
/* DDRC */
EXPORT_SYMBOL( DDRC_FTDDRII030_irq );
/* GPIO */
EXPORT_SYMBOL( GPIO_FTGPIO010_irq );
/* IDE */
EXPORT_SYMBOL( IDE_FTIDE020_irq );
/* IIC */
EXPORT_SYMBOL( IIC_FTIIC010_irq );
/* KBC */
EXPORT_SYMBOL( KBC_FTKBC010_irq );
/* LCDC */
EXPORT_SYMBOL( LCDC_FTLCDC200_irq );
/* MAC */
EXPORT_SYMBOL( MAC_FTGMAC100_irq );
/* MCP */
EXPORT_SYMBOL( MCP_FTMCP100_irq );
EXPORT_SYMBOL( MCP_FTMCP220_irq );
/* NANDC */
EXPORT_SYMBOL( NANDC_FTNANDC021_irq );
/* RTC */
EXPORT_SYMBOL( RTC_FTRTC011_irq );
/* SATA */
EXPORT_SYMBOL( SATA_FTSATA100_irq );
EXPORT_SYMBOL( SATA_FTSATA110_irq );
/* SCU */
EXPORT_SYMBOL( SCU_FTSCU010_irq );
/* SDC */
EXPORT_SYMBOL( SDC_FTSDC010_irq );
/* SSP */
EXPORT_SYMBOL( SSP_FTSSP010_irq );
/* TIMER */
EXPORT_SYMBOL( TIMER_FTPWMTMR010_irq );
/* UART */
EXPORT_SYMBOL( UART_FTUART010_irq );
/* USB */
EXPORT_SYMBOL( USB_FOTG2XX_irq );
EXPORT_SYMBOL( USB_FUSBH200_irq );
/* WDT */
EXPORT_SYMBOL( WDT_FTWDT010_irq );
/* PCI */
EXPORT_SYMBOL( PCI_FTPCIE3914_irq );
/* APBBRG */
EXPORT_SYMBOL( APBBRG_FTAPBBRG020_irq );
/* DMAC */
EXPORT_SYMBOL( DMAC_FTDMAC020_irq );

/*
 * Base addresses
 */

/* CPUS */
EXPORT_SYMBOL( CPUS_FA606TE_pa_base );
EXPORT_SYMBOL( CPUS_FA606TE_pa_limit );
EXPORT_SYMBOL( CPUS_FA606TE_pa_size );
/* CPU */
EXPORT_SYMBOL( CPU_MEM_pa_base );
EXPORT_SYMBOL( CPU_MEM_pa_limit );
EXPORT_SYMBOL( CPU_MEM_pa_size );
/* ADC */
EXPORT_SYMBOL( ADC_FTTSC010_pa_base );
EXPORT_SYMBOL( ADC_FTTSC010_pa_limit );
EXPORT_SYMBOL( ADC_FTTSC010_pa_size );
EXPORT_SYMBOL( ADC_FTTSC010_va_base );
EXPORT_SYMBOL( ADC_FTTSC010_va_limit );
EXPORT_SYMBOL( ADC_FTTSC010_va_size );
/* AES */
EXPORT_SYMBOL( AES_FTAES020_pa_base );
EXPORT_SYMBOL( AES_FTAES020_pa_limit );
EXPORT_SYMBOL( AES_FTAES020_pa_size );
EXPORT_SYMBOL( AES_FTAES020_va_base );
EXPORT_SYMBOL( AES_FTAES020_va_limit );
EXPORT_SYMBOL( AES_FTAES020_va_size );
/* AHBB */
EXPORT_SYMBOL( AHBB_FTAHBB020_pa_base );
EXPORT_SYMBOL( AHBB_FTAHBB020_pa_limit );
EXPORT_SYMBOL( AHBB_FTAHBB020_pa_size );
EXPORT_SYMBOL( AHBB_FTAHBB020_va_base );
EXPORT_SYMBOL( AHBB_FTAHBB020_va_limit );
EXPORT_SYMBOL( AHBB_FTAHBB020_va_size );
/* AHBC */
EXPORT_SYMBOL( AHBC_FTAHBC020_pa_base );
EXPORT_SYMBOL( AHBC_FTAHBC020_pa_limit );
EXPORT_SYMBOL( AHBC_FTAHBC020_pa_size );
EXPORT_SYMBOL( AHBC_FTAHBC020_va_base );
EXPORT_SYMBOL( AHBC_FTAHBC020_va_limit );
EXPORT_SYMBOL( AHBC_FTAHBC020_va_size );
/* DDRC */
EXPORT_SYMBOL( DDRC_FTDDRII030_pa_base );
EXPORT_SYMBOL( DDRC_FTDDRII030_pa_limit );
EXPORT_SYMBOL( DDRC_FTDDRII030_pa_size );
EXPORT_SYMBOL( DDRC_FTDDRII030_va_base );
EXPORT_SYMBOL( DDRC_FTDDRII030_va_limit );
EXPORT_SYMBOL( DDRC_FTDDRII030_va_size );
/* DEVICE */
EXPORT_SYMBOL( DEVICE_FA606TE_pa_base );
EXPORT_SYMBOL( DEVICE_FA606TE_pa_limit );
EXPORT_SYMBOL( DEVICE_FA606TE_pa_size );
EXPORT_SYMBOL( DEVICE_FA626TE_pa_base );
EXPORT_SYMBOL( DEVICE_FA626TE_pa_limit );
EXPORT_SYMBOL( DEVICE_FA626TE_pa_size );
EXPORT_SYMBOL( DEVICE_FTAHBB020_pa_base );
EXPORT_SYMBOL( DEVICE_FTAHBB020_pa_limit );
EXPORT_SYMBOL( DEVICE_FTAHBB020_pa_size );
EXPORT_SYMBOL( DEVICE_FTAPBBRG020_pa_base );
EXPORT_SYMBOL( DEVICE_FTAPBBRG020_pa_limit );
EXPORT_SYMBOL( DEVICE_FTAPBBRG020_pa_size );
EXPORT_SYMBOL( DEVICE_FTDDRII030_pa_base );
EXPORT_SYMBOL( DEVICE_FTDDRII030_pa_limit );
EXPORT_SYMBOL( DEVICE_FTDDRII030_pa_size );
EXPORT_SYMBOL( DEVICE_FTEMC020_pa_base );
EXPORT_SYMBOL( DEVICE_FTEMC020_pa_limit );
EXPORT_SYMBOL( DEVICE_FTEMC020_pa_size );
EXPORT_SYMBOL( DEVICE_FTSMC020_pa_base );
EXPORT_SYMBOL( DEVICE_FTSMC020_pa_limit );
EXPORT_SYMBOL( DEVICE_FTSMC020_pa_size );
/* EBIEBI */
EXPORT_SYMBOL( EBIEBI_FTEBI020_pa_base );
EXPORT_SYMBOL( EBIEBI_FTEBI020_pa_limit );
EXPORT_SYMBOL( EBIEBI_FTEBI020_pa_size );
EXPORT_SYMBOL( EBIEBI_FTEBI020_va_base );
EXPORT_SYMBOL( EBIEBI_FTEBI020_va_limit );
EXPORT_SYMBOL( EBIEBI_FTEBI020_va_size );
/* GPIO */
EXPORT_SYMBOL( GPIO_FTGPIO010_pa_base );
EXPORT_SYMBOL( GPIO_FTGPIO010_pa_limit );
EXPORT_SYMBOL( GPIO_FTGPIO010_pa_size );
EXPORT_SYMBOL( GPIO_FTGPIO010_va_base );
EXPORT_SYMBOL( GPIO_FTGPIO010_va_limit );
EXPORT_SYMBOL( GPIO_FTGPIO010_va_size );
/* IDE */
EXPORT_SYMBOL( IDE_FTIDE020_pa_base );
EXPORT_SYMBOL( IDE_FTIDE020_pa_limit );
EXPORT_SYMBOL( IDE_FTIDE020_pa_size );
EXPORT_SYMBOL( IDE_FTIDE020_va_base );
EXPORT_SYMBOL( IDE_FTIDE020_va_limit );
EXPORT_SYMBOL( IDE_FTIDE020_va_size );
/* IIC */
EXPORT_SYMBOL( IIC_FTIIC010_pa_base );
EXPORT_SYMBOL( IIC_FTIIC010_pa_limit );
EXPORT_SYMBOL( IIC_FTIIC010_pa_size );
EXPORT_SYMBOL( IIC_FTIIC010_va_base );
EXPORT_SYMBOL( IIC_FTIIC010_va_limit );
EXPORT_SYMBOL( IIC_FTIIC010_va_size );
/* INTC */
EXPORT_SYMBOL( INTC_FTINTC020_pa_base );
EXPORT_SYMBOL( INTC_FTINTC020_pa_limit );
EXPORT_SYMBOL( INTC_FTINTC020_pa_size );
EXPORT_SYMBOL( INTC_FTINTC020_va_base );
EXPORT_SYMBOL( INTC_FTINTC020_va_limit );
EXPORT_SYMBOL( INTC_FTINTC020_va_size );
/* KBC */
EXPORT_SYMBOL( KBC_FTKBC010_pa_base );
EXPORT_SYMBOL( KBC_FTKBC010_pa_limit );
EXPORT_SYMBOL( KBC_FTKBC010_pa_size );
EXPORT_SYMBOL( KBC_FTKBC010_va_base );
EXPORT_SYMBOL( KBC_FTKBC010_va_limit );
EXPORT_SYMBOL( KBC_FTKBC010_va_size );
/* LCDC */
EXPORT_SYMBOL( LCDC_FTLCDC200_pa_base );
EXPORT_SYMBOL( LCDC_FTLCDC200_pa_limit );
EXPORT_SYMBOL( LCDC_FTLCDC200_pa_size );
EXPORT_SYMBOL( LCDC_FTLCDC200_va_base );
EXPORT_SYMBOL( LCDC_FTLCDC200_va_limit );
EXPORT_SYMBOL( LCDC_FTLCDC200_va_size );
/* MAC */
EXPORT_SYMBOL( MAC_FTGMAC100_pa_base );
EXPORT_SYMBOL( MAC_FTGMAC100_pa_limit );
EXPORT_SYMBOL( MAC_FTGMAC100_pa_size );
EXPORT_SYMBOL( MAC_FTGMAC100_va_base );
EXPORT_SYMBOL( MAC_FTGMAC100_va_limit );
EXPORT_SYMBOL( MAC_FTGMAC100_va_size );
/* MCP */
EXPORT_SYMBOL( MCP_FTMCP100_pa_base );
EXPORT_SYMBOL( MCP_FTMCP100_pa_limit );
EXPORT_SYMBOL( MCP_FTMCP100_pa_size );
EXPORT_SYMBOL( MCP_FTMCP100_va_base );
EXPORT_SYMBOL( MCP_FTMCP100_va_limit );
EXPORT_SYMBOL( MCP_FTMCP100_va_size );
EXPORT_SYMBOL( MCP_FTMCP220_pa_base );
EXPORT_SYMBOL( MCP_FTMCP220_pa_limit );
EXPORT_SYMBOL( MCP_FTMCP220_pa_size );
EXPORT_SYMBOL( MCP_FTMCP220_va_base );
EXPORT_SYMBOL( MCP_FTMCP220_va_limit );
EXPORT_SYMBOL( MCP_FTMCP220_va_size );
/* NANDC */
EXPORT_SYMBOL( NANDC_FTNANDC021_pa_base );
EXPORT_SYMBOL( NANDC_FTNANDC021_pa_limit );
EXPORT_SYMBOL( NANDC_FTNANDC021_pa_size );
EXPORT_SYMBOL( NANDC_FTNANDC021_va_base );
EXPORT_SYMBOL( NANDC_FTNANDC021_va_limit );
EXPORT_SYMBOL( NANDC_FTNANDC021_va_size );
/* PCIIO */
EXPORT_SYMBOL( PCIIO_FTPCIE3914_pa_base );
EXPORT_SYMBOL( PCIIO_FTPCIE3914_pa_limit );
EXPORT_SYMBOL( PCIIO_FTPCIE3914_pa_size );
EXPORT_SYMBOL( PCIIO_FTPCIE3914_va_base );
EXPORT_SYMBOL( PCIIO_FTPCIE3914_va_limit );
EXPORT_SYMBOL( PCIIO_FTPCIE3914_va_size );
/* PCIMEM */
EXPORT_SYMBOL( PCIMEM_FTPCIE3914_pa_base );
EXPORT_SYMBOL( PCIMEM_FTPCIE3914_pa_limit );
EXPORT_SYMBOL( PCIMEM_FTPCIE3914_pa_size );
EXPORT_SYMBOL( PCIMEM_FTPCIE3914_va_base );
EXPORT_SYMBOL( PCIMEM_FTPCIE3914_va_limit );
EXPORT_SYMBOL( PCIMEM_FTPCIE3914_va_size );
/* RTC */
EXPORT_SYMBOL( RTC_FTRTC011_pa_base );
EXPORT_SYMBOL( RTC_FTRTC011_pa_limit );
EXPORT_SYMBOL( RTC_FTRTC011_pa_size );
EXPORT_SYMBOL( RTC_FTRTC011_va_base );
EXPORT_SYMBOL( RTC_FTRTC011_va_limit );
EXPORT_SYMBOL( RTC_FTRTC011_va_size );
/* SATA */
EXPORT_SYMBOL( SATA_FTSATA100_pa_base );
EXPORT_SYMBOL( SATA_FTSATA100_pa_limit );
EXPORT_SYMBOL( SATA_FTSATA100_pa_size );
EXPORT_SYMBOL( SATA_FTSATA100_va_base );
EXPORT_SYMBOL( SATA_FTSATA100_va_limit );
EXPORT_SYMBOL( SATA_FTSATA100_va_size );
EXPORT_SYMBOL( SATA_FTSATA110_pa_base );
EXPORT_SYMBOL( SATA_FTSATA110_pa_limit );
EXPORT_SYMBOL( SATA_FTSATA110_pa_size );
EXPORT_SYMBOL( SATA_FTSATA110_va_base );
EXPORT_SYMBOL( SATA_FTSATA110_va_limit );
EXPORT_SYMBOL( SATA_FTSATA110_va_size );
/* SCU */
EXPORT_SYMBOL( SCU_FTSCU010_pa_base );
EXPORT_SYMBOL( SCU_FTSCU010_pa_limit );
EXPORT_SYMBOL( SCU_FTSCU010_pa_size );
EXPORT_SYMBOL( SCU_FTSCU010_va_base );
EXPORT_SYMBOL( SCU_FTSCU010_va_limit );
EXPORT_SYMBOL( SCU_FTSCU010_va_size );
/* SDC */
EXPORT_SYMBOL( SDC_FTSDC010_pa_base );
EXPORT_SYMBOL( SDC_FTSDC010_pa_limit );
EXPORT_SYMBOL( SDC_FTSDC010_pa_size );
EXPORT_SYMBOL( SDC_FTSDC010_va_base );
EXPORT_SYMBOL( SDC_FTSDC010_va_limit );
EXPORT_SYMBOL( SDC_FTSDC010_va_size );
/* SMC */
EXPORT_SYMBOL( SMC_FTSMC020_pa_base );
EXPORT_SYMBOL( SMC_FTSMC020_pa_limit );
EXPORT_SYMBOL( SMC_FTSMC020_pa_size );
EXPORT_SYMBOL( SMC_FTSMC020_va_base );
EXPORT_SYMBOL( SMC_FTSMC020_va_limit );
EXPORT_SYMBOL( SMC_FTSMC020_va_size );
/* SSP */
EXPORT_SYMBOL( SSP_FTSSP010_pa_base );
EXPORT_SYMBOL( SSP_FTSSP010_pa_limit );
EXPORT_SYMBOL( SSP_FTSSP010_pa_size );
EXPORT_SYMBOL( SSP_FTSSP010_va_base );
EXPORT_SYMBOL( SSP_FTSSP010_va_limit );
EXPORT_SYMBOL( SSP_FTSSP010_va_size );
/* TIMER */
EXPORT_SYMBOL( TIMER_FTPWMTMR010_pa_base );
EXPORT_SYMBOL( TIMER_FTPWMTMR010_pa_limit );
EXPORT_SYMBOL( TIMER_FTPWMTMR010_pa_size );
EXPORT_SYMBOL( TIMER_FTPWMTMR010_va_base );
EXPORT_SYMBOL( TIMER_FTPWMTMR010_va_limit );
EXPORT_SYMBOL( TIMER_FTPWMTMR010_va_size );
/* UART */
EXPORT_SYMBOL( UART_FTUART010_pa_base );
EXPORT_SYMBOL( UART_FTUART010_pa_limit );
EXPORT_SYMBOL( UART_FTUART010_pa_size );
EXPORT_SYMBOL( UART_FTUART010_va_base );
EXPORT_SYMBOL( UART_FTUART010_va_limit );
EXPORT_SYMBOL( UART_FTUART010_va_size );
/* USB */
EXPORT_SYMBOL( USB_FOTG2XX_pa_base );
EXPORT_SYMBOL( USB_FOTG2XX_pa_limit );
EXPORT_SYMBOL( USB_FOTG2XX_pa_size );
EXPORT_SYMBOL( USB_FOTG2XX_va_base );
EXPORT_SYMBOL( USB_FOTG2XX_va_limit );
EXPORT_SYMBOL( USB_FOTG2XX_va_size );
EXPORT_SYMBOL( USB_FUSBH200_pa_base );
EXPORT_SYMBOL( USB_FUSBH200_pa_limit );
EXPORT_SYMBOL( USB_FUSBH200_pa_size );
EXPORT_SYMBOL( USB_FUSBH200_va_base );
EXPORT_SYMBOL( USB_FUSBH200_va_limit );
EXPORT_SYMBOL( USB_FUSBH200_va_size );
/* WDT */
EXPORT_SYMBOL( WDT_FTWDT010_pa_base );
EXPORT_SYMBOL( WDT_FTWDT010_pa_limit );
EXPORT_SYMBOL( WDT_FTWDT010_pa_size );
EXPORT_SYMBOL( WDT_FTWDT010_va_base );
EXPORT_SYMBOL( WDT_FTWDT010_va_limit );
EXPORT_SYMBOL( WDT_FTWDT010_va_size );
/* PCI */
EXPORT_SYMBOL( PCI_FTPCIE3914_pa_base );
EXPORT_SYMBOL( PCI_FTPCIE3914_pa_limit );
EXPORT_SYMBOL( PCI_FTPCIE3914_pa_size );
EXPORT_SYMBOL( PCI_FTPCIE3914_va_base );
EXPORT_SYMBOL( PCI_FTPCIE3914_va_limit );
EXPORT_SYMBOL( PCI_FTPCIE3914_va_size );
/* APBBRG */
EXPORT_SYMBOL( APBBRG_FTAPBBRG020_pa_base );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020_pa_limit );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020_pa_size );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020_va_base );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020_va_limit );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020_va_size );
/* DMAC */
EXPORT_SYMBOL( DMAC_FTDMAC020_pa_base );
EXPORT_SYMBOL( DMAC_FTDMAC020_pa_limit );
EXPORT_SYMBOL( DMAC_FTDMAC020_pa_size );
EXPORT_SYMBOL( DMAC_FTDMAC020_va_base );
EXPORT_SYMBOL( DMAC_FTDMAC020_va_limit );
EXPORT_SYMBOL( DMAC_FTDMAC020_va_size );

/*
 * Interrupt Dispatch Tables, for both FIQ and IRQ
 */

