/*
 *  linux/arch/arm/mach-faraday/include/mach/platform-axi/spec.h
 *
 *  Faraday Platform Specification  (Automatically generated by "autospec", do not edit)
 *
 *  Copyright (C) 2009 Faraday Corp. (http://www.faraday-tech.com)
 *
 *  Platform Hierarchy :
 *
 *    AXI
 *     +- CPU_FA626TE  (0)
 *     +- INTC_FTINTC010  (0)
 *     +- UART_FTUART010  (0)
 *     +- UART_FTUART010  (1)
 *     +- TIMER_FTTMR010  (0)
 *     +- DMAC_FTDMAC030  (0)
 */

#ifndef __AXI_PLATFORM_SPECIFICATION__
#define __AXI_PLATFORM_SPECIFICATION__

#define PLATFORM_NAME	"Faraday AXI"

/*
 * Component counts
 */

/* CPU */
#define CPU_COUNT	1
#define CPU_FA626TE_COUNT	1
/* INTC */
#define INTC_COUNT	1
#define INTC_FTINTC010_COUNT	1
/* UART */
#define UART_COUNT	2
#define UART_FTUART010_COUNT	2
/* TIMER */
#define TIMER_COUNT	1
#define TIMER_FTTMR010_COUNT	1
/* DMAC */
#define DMAC_COUNT	1
#define DMAC_FTDMAC030_COUNT	1

/*
 * Hierarchial Component IDs
 */


/*
 * Number of interrupts, including IRQ and FIQ
 */

#define PLATFORM_IRQ_TOTALCOUNT	13
#define PLATFORM_FIQ_TOTALCOUNT	11

#define PLATFORM_IRQ_BASE	0
#define PLATFORM_FIQ_BASE	13
#define PLATFORM_INTERRUPTS	24

/*
 * IRQ/FIQ trigger level and trigger mode
 */

#define PLATFORM_IRQ_TRIGGER_MODE	0x0000000E
#define PLATFORM_IRQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_FIQ_TRIGGER_LEVEL	0xFFFFFFFF

/*
 * Interrupt numbers of Hierarchical Architecture
 */


/*
 * Interrrupt numbers
 */

/* UART */
#define UART_FTUART010_IRQ_COUNT	1
#define UART_FTUART010_IRQ	4
#define UART_FTUART010_0_IRQ	4
#define UART_FTUART010_1_IRQ	5

/* TIMER */
#define TIMER_FTTMR010_IRQ_COUNT	3
#define TIMER_FTTMR010_IRQ0	1
#define TIMER_FTTMR010_0_IRQ0	1
#define TIMER_FTTMR010_IRQ1	2
#define TIMER_FTTMR010_0_IRQ1	2
#define TIMER_FTTMR010_IRQ2	3
#define TIMER_FTTMR010_0_IRQ2	3

/* DMAC */
#define DMAC_FTDMAC030_IRQ_COUNT	3
#define DMAC_FTDMAC030_IRQ0	11
#define DMAC_FTDMAC030_0_IRQ0	11
#define DMAC_FTDMAC030_IRQ1	12
#define DMAC_FTDMAC030_0_IRQ1	12
#define DMAC_FTDMAC030_IRQ2	13
#define DMAC_FTDMAC030_0_IRQ2	13

/*
 * Base addresses
 */

/* CPU */
#define CPU_MEM_PA_COUNT	1
#define CPU_MEM_PA_BASE	0x00000000
#define CPU_MEM_PA_LIMIT	0x10000000
#define CPU_MEM_PA_SIZE	0x10000001
#define CPU_MEM_0_PA_BASE	0x00000000
#define CPU_MEM_0_PA_LIMIT	0x10000000
#define CPU_MEM_0_PA_SIZE	0x10000001

/* INTC */
#define INTC_FTINTC010_PA_COUNT	1
#define INTC_FTINTC010_PA_BASE	0xA8300000
#define INTC_FTINTC010_PA_LIMIT	0xA83FFFFF
#define INTC_FTINTC010_PA_SIZE	0x00100000
#define INTC_FTINTC010_0_PA_BASE	0xA8300000
#define INTC_FTINTC010_0_PA_LIMIT	0xA83FFFFF
#define INTC_FTINTC010_0_PA_SIZE	0x00100000
#define INTC_FTINTC010_VA_COUNT	1
#define INTC_FTINTC010_VA_BASE	0xFA830000
#define INTC_FTINTC010_VA_LIMIT	0xFA830FFF
#define INTC_FTINTC010_VA_SIZE	0x00001000
#define INTC_FTINTC010_0_VA_BASE	0xFA830000
#define INTC_FTINTC010_0_VA_LIMIT	0xFA830FFF
#define INTC_FTINTC010_0_VA_SIZE	0x00001000

/* UART */
#define UART_FTUART010_PA_COUNT	1
#define UART_FTUART010_PA_BASE	0xA8000000
#define UART_FTUART010_PA_LIMIT	0xA80FFFFF
#define UART_FTUART010_PA_SIZE	0x00100000
#define UART_FTUART010_0_PA_BASE	0xA8000000
#define UART_FTUART010_0_PA_LIMIT	0xA80FFFFF
#define UART_FTUART010_0_PA_SIZE	0x00100000
#define UART_FTUART010_1_PA_BASE	0xA8100000
#define UART_FTUART010_1_PA_LIMIT	0xA81FFFFF
#define UART_FTUART010_1_PA_SIZE	0x00100000
#define UART_FTUART010_VA_COUNT	1
#define UART_FTUART010_VA_BASE	0xFA800000
#define UART_FTUART010_VA_LIMIT	0xFA800FFF
#define UART_FTUART010_VA_SIZE	0x00001000
#define UART_FTUART010_0_VA_BASE	0xFA800000
#define UART_FTUART010_0_VA_LIMIT	0xFA800FFF
#define UART_FTUART010_0_VA_SIZE	0x00001000
#define UART_FTUART010_1_VA_BASE	0xFA810000
#define UART_FTUART010_1_VA_LIMIT	0xFA810FFF
#define UART_FTUART010_1_VA_SIZE	0x00001000

/* TIMER */
#define TIMER_FTTMR010_PA_COUNT	1
#define TIMER_FTTMR010_PA_BASE	0xA8200000
#define TIMER_FTTMR010_PA_LIMIT	0xA820000F
#define TIMER_FTTMR010_PA_SIZE	0x00000010
#define TIMER_FTTMR010_0_PA_BASE	0xA8200000
#define TIMER_FTTMR010_0_PA_LIMIT	0xA820000F
#define TIMER_FTTMR010_0_PA_SIZE	0x00000010
#define TIMER_FTTMR010_VA_COUNT	1
#define TIMER_FTTMR010_VA_BASE	0xFA820000
#define TIMER_FTTMR010_VA_LIMIT	0xFA820FFF
#define TIMER_FTTMR010_VA_SIZE	0x00001000
#define TIMER_FTTMR010_0_VA_BASE	0xFA820000
#define TIMER_FTTMR010_0_VA_LIMIT	0xFA820FFF
#define TIMER_FTTMR010_0_VA_SIZE	0x00001000

/* DMAC */
#define DMAC_FTDMAC030_PA_COUNT	1
#define DMAC_FTDMAC030_PA_BASE	0xA8500000
#define DMAC_FTDMAC030_PA_LIMIT	0xA85FFFFF
#define DMAC_FTDMAC030_PA_SIZE	0x00100000
#define DMAC_FTDMAC030_0_PA_BASE	0xA8500000
#define DMAC_FTDMAC030_0_PA_LIMIT	0xA85FFFFF
#define DMAC_FTDMAC030_0_PA_SIZE	0x00100000
#define DMAC_FTDMAC030_VA_COUNT	1
#define DMAC_FTDMAC030_VA_BASE	0xFA850000
#define DMAC_FTDMAC030_VA_LIMIT	0xFA850FFF
#define DMAC_FTDMAC030_VA_SIZE	0x00001000
#define DMAC_FTDMAC030_0_VA_BASE	0xFA850000
#define DMAC_FTDMAC030_0_VA_LIMIT	0xFA850FFF
#define DMAC_FTDMAC030_0_VA_SIZE	0x00001000

/*
 * C definitions
 */
#ifndef __ASSEMBLER__

#include <linux/linkage.h>

typedef asmlinkage unsigned interrupt_dispatch_function(unsigned);

/*
 * Interrrupt numbers
 */

/* UART */
extern const unsigned char UART_FTUART010_irq[UART_FTUART010_COUNT];
/* TIMER */
extern const unsigned char TIMER_FTTMR010_irq[TIMER_FTTMR010_COUNT][TIMER_FTTMR010_IRQ_COUNT];
/* DMAC */
extern const unsigned char DMAC_FTDMAC030_irq[DMAC_FTDMAC030_COUNT][DMAC_FTDMAC030_IRQ_COUNT];

/*
 * Base addresses
 */

/* CPU */
extern const unsigned CPU_MEM_pa_base[CPU_MEM_PA_COUNT];
extern const unsigned CPU_MEM_pa_limit[CPU_MEM_PA_COUNT];
extern const unsigned CPU_MEM_pa_size[CPU_MEM_PA_COUNT];
/* INTC */
extern const unsigned INTC_FTINTC010_pa_base[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_pa_limit[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_pa_size[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_va_base[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_va_limit[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_va_size[INTC_FTINTC010_COUNT];
/* UART */
extern const unsigned UART_FTUART010_pa_base[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_pa_limit[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_pa_size[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_va_base[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_va_limit[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_va_size[UART_FTUART010_COUNT];
/* TIMER */
extern const unsigned TIMER_FTTMR010_pa_base[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_pa_limit[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_pa_size[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_va_base[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_va_limit[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_va_size[TIMER_FTTMR010_COUNT];
/* DMAC */
extern const unsigned DMAC_FTDMAC030_pa_base[DMAC_FTDMAC030_COUNT];
extern const unsigned DMAC_FTDMAC030_pa_limit[DMAC_FTDMAC030_COUNT];
extern const unsigned DMAC_FTDMAC030_pa_size[DMAC_FTDMAC030_COUNT];
extern const unsigned DMAC_FTDMAC030_va_base[DMAC_FTDMAC030_COUNT];
extern const unsigned DMAC_FTDMAC030_va_limit[DMAC_FTDMAC030_COUNT];
extern const unsigned DMAC_FTDMAC030_va_size[DMAC_FTDMAC030_COUNT];

/* IO mapping */
#define PLATFORM_IO_DESC_NR 5
struct map_desc;

#endif /* ifndef __ASSEMBLER__ */

#endif /* __AXI_PLATFORM_SPECIFICATION__ */

