/*
 *  arch/arm/mach-faraday/include/mach/platform-a320/spec.h
 *
 *  Faraday Platform Specification  (Automatically generated by "autospec", do not edit)
 *
 *  Copyright (C) 2008 Faraday Corp. (http://www.faraday-tech.com)
 *
 *  Platform Hierarchy :
 *
 *    FIA320D
 *     +- CPU_FA526  (0)
 *     +- INTC_FTINTC010  (0)
 *     +- UART_FTUART010  (0)
 *     +- UART_FTUART010  (1)
 *     +- UART_FTUART010  (2)
 *     +- TIMER_FTTMR010  (0)
 *     +- SSP_FTSSP010  (0)
 *     +- FLH_FTFLH010  (0)
 *     +- PMU_FTPMU010  (0)
 *     +- MAC_FTMAC100  (0)
 *     +- SDC_FTSDC010  (0)
 *     +- SDC_FTSDC020  (1)
 *     +- AHBDMA
 *     |   +- DMAC_FTDMAC020  (0)
 *     +- APBDMA
 *     |   +- APBBRG_FTAPBBRG020S  (0)
 *     +- NANDC_FTNANDC020  (0)
 *     +- RTC_FTRTC010  (0)
 *     +- WDT_FTWDT010  (0)
 *     +- GPIO_FTGPIO010  (0)
 *     +- CFC_FTCFC010  (0)
 *     +- LCD_FTLCDC100  (0)
 *     +- I2C_FTI2C010  (0)
 *     +- USB_FOTG2XX  (0)
 *     +- USB_FUSBH200  (1)
 *     +- USB_FUSB220  (2)
 *     +- FIA321
 *     |   +- INTC_FTINTC010  (1)
 *     |   +- KMI_FTKBC010  (0)
 *     |   +- KMI_FTKBC010  (1)
 *     |   +- APBDMA
 *     |   |   +- APBBRG_FTAPBBRG020S  (1)
 *     |   +- MAC_FTMAC100  (1)
 *     |   +- PCI
 *     |   |   +- PCIC_FTPCI100  (0)
 *     |   +- PCIMEM
 *     |   +- PCIIO
 *     +- FIQ_RELAY
 *         +- FIQ_RELAYER
 */

#ifndef __A320_PLATFORM_SPECIFICATION__
#define __A320_PLATFORM_SPECIFICATION__

#define PLATFORM_NAME	"Faraday A320"

/*
 * Component counts
 */

/* CPU */
#define CPU_COUNT	1
#define CPU_FA526_COUNT	1
/* INTC */
#define INTC_COUNT	2
#define INTC_FTINTC010_COUNT	2
/* UART */
#define UART_COUNT	3
#define UART_FTUART010_COUNT	3
/* TIMER */
#define TIMER_COUNT	1
#define TIMER_FTTMR010_COUNT	1
/* SSP */
#define SSP_COUNT	1
#define SSP_FTSSP010_COUNT	1
/* FLH */
#define FLH_COUNT	1
#define FLH_FTFLH010_COUNT	1
/* PMU */
#define PMU_COUNT	1
#define PMU_FTPMU010_COUNT	1
/* MAC */
#define MAC_COUNT	2
#define MAC_FTMAC100_COUNT	2
/* SDC */
#define SDC_COUNT	2
#define SDC_FTSDC010_COUNT	1
#define SDC_FTSDC020_COUNT	1
/* AHBDMA */
#define AHBDMA_COUNT	1
/* APBDMA */
#define APBDMA_COUNT	2
/* NANDC */
#define NANDC_COUNT	1
#define NANDC_FTNANDC020_COUNT	1
/* RTC */
#define RTC_COUNT	1
#define RTC_FTRTC010_COUNT	1
/* WDT */
#define WDT_COUNT	1
#define WDT_FTWDT010_COUNT	1
/* GPIO */
#define GPIO_COUNT	1
#define GPIO_FTGPIO010_COUNT	1
/* CFC */
#define CFC_COUNT	1
#define CFC_FTCFC010_COUNT	1
/* LCD */
#define LCD_COUNT	1
#define LCD_FTLCDC100_COUNT	1
/* I2C */
#define I2C_COUNT	1
#define I2C_FTI2C010_COUNT	1
/* USB */
#define USB_COUNT	3
#define USB_FOTG2XX_COUNT	1
#define USB_FUSBH200_COUNT	1
#define USB_FUSB220_COUNT	1
/* FIA321 */
#define FIA321_COUNT	1
/* FIQ_RELAY */
#define FIQ_RELAY_COUNT	1
/* DMAC */
#define DMAC_COUNT	1
#define DMAC_FTDMAC020_COUNT	1
/* APBBRG */
#define APBBRG_COUNT	2
#define APBBRG_FTAPBBRG020S_COUNT	2
/* KMI */
#define KMI_COUNT	2
#define KMI_FTKBC010_COUNT	2
/* PCI */
#define PCI_COUNT	1
/* PCIMEM */
#define PCIMEM_COUNT	1
/* PCIIO */
#define PCIIO_COUNT	1
/* FIQ_RELAYER */
#define FIQ_RELAYER_COUNT	1
/* PCIC */
#define PCIC_COUNT	1
#define PCIC_FTPCI100_COUNT	1

/*
 * Hierarchial Component IDs
 */

#define PLATFORM_AHBDMA_DMAC_FTDMAC020_ID	0
#define PLATFORM_APBDMA_APBBRG_FTAPBBRG020S_ID	0
#define PLATFORM_FIQ_RELAY_FIQ_RELAYER_ID	0
#define PLATFORM_FIA321_INTC_FTINTC010_ID	1
#define PLATFORM_FIA321_KMI_FTKBC010_ID	0
#define PLATFORM_FIA321_APBDMA_ID	1
#define PLATFORM_FIA321_MAC_FTMAC100_ID	1
#define PLATFORM_FIA321_PCI_ID	0
#define PLATFORM_FIA321_PCIMEM_ID	0
#define PLATFORM_FIA321_PCIIO_ID	0
#define PLATFORM_FIA321_APBDMA_APBBRG_FTAPBBRG020S_ID	1
#define PLATFORM_FIA321_PCI_PCIC_FTPCI100_ID	0

/*
 * Number of interrupts, including IRQ and FIQ
 */

#define PLATFORM_IRQ_TOTALCOUNT	32
#define PLATFORM_FIQ_TOTALCOUNT	32
#define PLATFORM_AHBDMA_IRQ_TOTALCOUNT	8
#define PLATFORM_AHBDMA_FIQ_TOTALCOUNT	0
#define PLATFORM_APBDMA_IRQ_TOTALCOUNT	4
#define PLATFORM_APBDMA_FIQ_TOTALCOUNT	0
#define PLATFORM_FIQ_RELAY_IRQ_TOTALCOUNT	32
#define PLATFORM_FIQ_RELAY_FIQ_TOTALCOUNT	0
#define PLATFORM_FIA321_IRQ_TOTALCOUNT	32
#define PLATFORM_FIA321_FIQ_TOTALCOUNT	32
#define PLATFORM_FIA321_APBDMA_IRQ_TOTALCOUNT	4
#define PLATFORM_FIA321_APBDMA_FIQ_TOTALCOUNT	0
#define PLATFORM_FIA321_PCI_IRQ_TOTALCOUNT	4
#define PLATFORM_FIA321_PCI_FIQ_TOTALCOUNT	0

#define PLATFORM_IRQ_BASE	0
#define PLATFORM_FIQ_BASE	32
#define PLATFORM_AHBDMA_IRQ_BASE	64
#define PLATFORM_APBDMA_IRQ_BASE	72
#define PLATFORM_FIQ_RELAY_IRQ_BASE	76
#define PLATFORM_FIA321_IRQ_BASE	108
#define PLATFORM_FIA321_FIQ_BASE	140
#define PLATFORM_FIA321_APBDMA_IRQ_BASE	172
#define PLATFORM_FIA321_PCI_IRQ_BASE	176
#define PLATFORM_INTERRUPTS	180

/*
 * IRQ/FIQ trigger level and trigger mode
 */

#define PLATFORM_IRQ_TRIGGER_MODE	0x000EE000
#define PLATFORM_IRQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_FIQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_AHBDMA_IRQ_TRIGGER_MODE	0x00000000
#define PLATFORM_AHBDMA_IRQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_AHBDMA_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_AHBDMA_FIQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_APBDMA_IRQ_TRIGGER_MODE	0x00000000
#define PLATFORM_APBDMA_IRQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_APBDMA_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_APBDMA_FIQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_FIQ_RELAY_IRQ_TRIGGER_MODE	0x00000000
#define PLATFORM_FIQ_RELAY_IRQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_FIQ_RELAY_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_FIQ_RELAY_FIQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_FIA321_IRQ_TRIGGER_MODE	0x00000210
#define PLATFORM_FIA321_IRQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_FIA321_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_FIA321_FIQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_FIA321_APBDMA_IRQ_TRIGGER_MODE	0x00000000
#define PLATFORM_FIA321_APBDMA_IRQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_FIA321_APBDMA_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_FIA321_APBDMA_FIQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_FIA321_PCI_IRQ_TRIGGER_MODE	0x00000000
#define PLATFORM_FIA321_PCI_IRQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_FIA321_PCI_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_FIA321_PCI_FIQ_TRIGGER_LEVEL	0xFFFFFFFF

/*
 * Interrupt numbers of Hierarchical Architecture
 */

/* AHBDMA */
#define PLATFORM_AHBDMA_IRQ	21

/* APBDMA */
#define PLATFORM_APBDMA_IRQ	24

/* FIQ_RELAY */
#define PLATFORM_FIQ_RELAY_IRQ	15

/* FIA321 */
#define PLATFORM_FIA321_IRQ	30
#define PLATFORM_FIA321_FIQ	0

/* APBDMA */
#define PLATFORM_FIA321_APBDMA_IRQ	24

/* PCI */
#define PLATFORM_FIA321_PCI_IRQ	28


/*
 * Interrrupt numbers
 */

/* UART */
#define UART_FTUART010_IRQ_COUNT	1
#define UART_FTUART010_IRQ	10
#define UART_FTUART010_0_IRQ	10
#define UART_FTUART010_1_IRQ	11
#define UART_FTUART010_2_IRQ	7

/* TIMER */
#define TIMER_FTTMR010_IRQ_COUNT	3
#define TIMER_FTTMR010_IRQ0	19
#define TIMER_FTTMR010_0_IRQ0	19
#define TIMER_FTTMR010_IRQ1	14
#define TIMER_FTTMR010_0_IRQ1	14
#define TIMER_FTTMR010_IRQ2	15
#define TIMER_FTTMR010_0_IRQ2	15

/* SSP */
#define SSP_FTSSP010_IRQ_COUNT	1
#define SSP_FTSSP010_IRQ	6
#define SSP_FTSSP010_0_IRQ	6

/* MAC */
#define MAC_FTMAC100_IRQ_COUNT	1
#define MAC_FTMAC100_IRQ	25
#define MAC_FTMAC100_0_IRQ	25
#define MAC_FTMAC100_1_IRQ	133

/* SDC */
#define SDC_FTSDC010_IRQ_COUNT	1
#define SDC_FTSDC010_IRQ	5
#define SDC_FTSDC010_0_IRQ	5
#define SDC_FTSDC020_IRQ_COUNT	1
#define SDC_FTSDC020_IRQ	29
#define SDC_FTSDC020_0_IRQ	29

/* NANDC */
#define NANDC_FTNANDC020_IRQ_COUNT	1
#define NANDC_FTNANDC020_IRQ	29
#define NANDC_FTNANDC020_0_IRQ	29

/* RTC */
#define RTC_FTRTC010_IRQ_COUNT	2
#define RTC_FTRTC010_IRQ0	17
#define RTC_FTRTC010_0_IRQ0	17
#define RTC_FTRTC010_IRQ1	18
#define RTC_FTRTC010_0_IRQ1	18

/* WDT */
#define WDT_FTWDT010_IRQ_COUNT	1
#define WDT_FTWDT010_IRQ	16
#define WDT_FTWDT010_0_IRQ	16

/* GPIO */
#define GPIO_FTGPIO010_IRQ_COUNT	1
#define GPIO_FTGPIO010_IRQ	13
#define GPIO_FTGPIO010_0_IRQ	13

/* CFC */
#define CFC_FTCFC010_IRQ_COUNT	2
#define CFC_FTCFC010_IRQ0	0
#define CFC_FTCFC010_0_IRQ0	0
#define CFC_FTCFC010_IRQ1	1
#define CFC_FTCFC010_0_IRQ1	1

/* LCD */
#define LCD_FTLCDC100_IRQ_COUNT	1
#define LCD_FTLCDC100_IRQ	20
#define LCD_FTLCDC100_0_IRQ	20

/* I2C */
#define I2C_FTI2C010_IRQ_COUNT	1
#define I2C_FTI2C010_IRQ	3
#define I2C_FTI2C010_0_IRQ	3

/* USB */
#define USB_FOTG2XX_IRQ_COUNT	1
#define USB_FOTG2XX_IRQ	29
#define USB_FOTG2XX_0_IRQ	29
#define USB_FUSBH200_IRQ_COUNT	1
#define USB_FUSBH200_IRQ	29
#define USB_FUSBH200_0_IRQ	29
#define USB_FUSB220_IRQ_COUNT	1
#define USB_FUSB220_IRQ	26
#define USB_FUSB220_0_IRQ	26

/* DMAC */
#define DMAC_FTDMAC020_IRQ_COUNT	8
#define DMAC_FTDMAC020_IRQ0	64
#define DMAC_FTDMAC020_0_IRQ0	64
#define DMAC_FTDMAC020_IRQ1	65
#define DMAC_FTDMAC020_0_IRQ1	65
#define DMAC_FTDMAC020_IRQ2	66
#define DMAC_FTDMAC020_0_IRQ2	66
#define DMAC_FTDMAC020_IRQ3	67
#define DMAC_FTDMAC020_0_IRQ3	67
#define DMAC_FTDMAC020_IRQ4	68
#define DMAC_FTDMAC020_0_IRQ4	68
#define DMAC_FTDMAC020_IRQ5	69
#define DMAC_FTDMAC020_0_IRQ5	69
#define DMAC_FTDMAC020_IRQ6	70
#define DMAC_FTDMAC020_0_IRQ6	70
#define DMAC_FTDMAC020_IRQ7	71
#define DMAC_FTDMAC020_0_IRQ7	71

/* APBBRG */
#define APBBRG_FTAPBBRG020S_IRQ_COUNT	4
#define APBBRG_FTAPBBRG020S_IRQ0	72
#define APBBRG_FTAPBBRG020S_0_IRQ0	72
#define APBBRG_FTAPBBRG020S_IRQ1	73
#define APBBRG_FTAPBBRG020S_0_IRQ1	73
#define APBBRG_FTAPBBRG020S_IRQ2	74
#define APBBRG_FTAPBBRG020S_0_IRQ2	74
#define APBBRG_FTAPBBRG020S_IRQ3	75
#define APBBRG_FTAPBBRG020S_0_IRQ3	75
#define APBBRG_FTAPBBRG020S_1_IRQ0	172
#define APBBRG_FTAPBBRG020S_1_IRQ1	173
#define APBBRG_FTAPBBRG020S_1_IRQ2	174
#define APBBRG_FTAPBBRG020S_1_IRQ3	175

/* KMI */
#define KMI_FTKBC010_IRQ_COUNT	1
#define KMI_FTKBC010_IRQ	112
#define KMI_FTKBC010_0_IRQ	112
#define KMI_FTKBC010_1_IRQ	117

/* PCIC */
#define PCIC_FTPCI100_IRQ_COUNT	4
#define PCIC_FTPCI100_IRQ0	176
#define PCIC_FTPCI100_0_IRQ0	176
#define PCIC_FTPCI100_IRQ1	177
#define PCIC_FTPCI100_0_IRQ1	177
#define PCIC_FTPCI100_IRQ2	178
#define PCIC_FTPCI100_0_IRQ2	178
#define PCIC_FTPCI100_IRQ3	179
#define PCIC_FTPCI100_0_IRQ3	179

/*
 * Base addresses
 */

/* CPU */
#define CPU_MEM_PA_COUNT	1
#define CPU_MEM_PA_BASE	0x00000000
#define CPU_MEM_PA_LIMIT	0x03FFFFFF
#define CPU_MEM_PA_SIZE	0x04000000
#define CPU_MEM_0_PA_BASE	0x00000000
#define CPU_MEM_0_PA_LIMIT	0x03FFFFFF
#define CPU_MEM_0_PA_SIZE	0x04000000

/* INTC */
#define INTC_FTINTC010_PA_COUNT	1
#define INTC_FTINTC010_PA_BASE	0x98800000
#define INTC_FTINTC010_PA_LIMIT	0x988FFFFF
#define INTC_FTINTC010_PA_SIZE	0x00100000
#define INTC_FTINTC010_0_PA_BASE	0x98800000
#define INTC_FTINTC010_0_PA_LIMIT	0x988FFFFF
#define INTC_FTINTC010_0_PA_SIZE	0x00100000
#define INTC_FTINTC010_1_PA_BASE	0xB0800000
#define INTC_FTINTC010_1_PA_LIMIT	0xB08FFFFF
#define INTC_FTINTC010_1_PA_SIZE	0x00100000
#define INTC_FTINTC010_VA_COUNT	1
#define INTC_FTINTC010_VA_BASE	0xF9880000
#define INTC_FTINTC010_VA_LIMIT	0xF9880FFF
#define INTC_FTINTC010_VA_SIZE	0x00001000
#define INTC_FTINTC010_0_VA_BASE	0xF9880000
#define INTC_FTINTC010_0_VA_LIMIT	0xF9880FFF
#define INTC_FTINTC010_0_VA_SIZE	0x00001000
#define INTC_FTINTC010_1_VA_BASE	0xFB080000
#define INTC_FTINTC010_1_VA_LIMIT	0xFB080FFF
#define INTC_FTINTC010_1_VA_SIZE	0x00001000

/* UART */
#define UART_FTUART010_PA_COUNT	1
#define UART_FTUART010_PA_BASE	0x98200000
#define UART_FTUART010_PA_LIMIT	0x982FFFFF
#define UART_FTUART010_PA_SIZE	0x00100000
#define UART_FTUART010_0_PA_BASE	0x98200000
#define UART_FTUART010_0_PA_LIMIT	0x982FFFFF
#define UART_FTUART010_0_PA_SIZE	0x00100000
#define UART_FTUART010_1_PA_BASE	0x98300000
#define UART_FTUART010_1_PA_LIMIT	0x983FFFFF
#define UART_FTUART010_1_PA_SIZE	0x00100000
#define UART_FTUART010_2_PA_BASE	0x99600000
#define UART_FTUART010_2_PA_LIMIT	0x996FFFFF
#define UART_FTUART010_2_PA_SIZE	0x00100000
#define UART_FTUART010_VA_COUNT	1
#define UART_FTUART010_VA_BASE	0xF9820000
#define UART_FTUART010_VA_LIMIT	0xF9820FFF
#define UART_FTUART010_VA_SIZE	0x00001000
#define UART_FTUART010_0_VA_BASE	0xF9820000
#define UART_FTUART010_0_VA_LIMIT	0xF9820FFF
#define UART_FTUART010_0_VA_SIZE	0x00001000
#define UART_FTUART010_1_VA_BASE	0xF9830000
#define UART_FTUART010_1_VA_LIMIT	0xF9830FFF
#define UART_FTUART010_1_VA_SIZE	0x00001000
#define UART_FTUART010_2_VA_BASE	0xF9960000
#define UART_FTUART010_2_VA_LIMIT	0xF9960FFF
#define UART_FTUART010_2_VA_SIZE	0x00001000

/* TIMER */
#define TIMER_FTTMR010_PA_COUNT	1
#define TIMER_FTTMR010_PA_BASE	0x98400000
#define TIMER_FTTMR010_PA_LIMIT	0x9840000F
#define TIMER_FTTMR010_PA_SIZE	0x00000010
#define TIMER_FTTMR010_0_PA_BASE	0x98400000
#define TIMER_FTTMR010_0_PA_LIMIT	0x9840000F
#define TIMER_FTTMR010_0_PA_SIZE	0x00000010
#define TIMER_FTTMR010_VA_COUNT	1
#define TIMER_FTTMR010_VA_BASE	0xF9840000
#define TIMER_FTTMR010_VA_LIMIT	0xF9840FFF
#define TIMER_FTTMR010_VA_SIZE	0x00001000
#define TIMER_FTTMR010_0_VA_BASE	0xF9840000
#define TIMER_FTTMR010_0_VA_LIMIT	0xF9840FFF
#define TIMER_FTTMR010_0_VA_SIZE	0x00001000

/* SSP */
#define SSP_FTSSP010_PA_COUNT	1
#define SSP_FTSSP010_PA_BASE	0x99400000
#define SSP_FTSSP010_PA_LIMIT	0x994FFFFF
#define SSP_FTSSP010_PA_SIZE	0x00100000
#define SSP_FTSSP010_0_PA_BASE	0x99400000
#define SSP_FTSSP010_0_PA_LIMIT	0x994FFFFF
#define SSP_FTSSP010_0_PA_SIZE	0x00100000
#define SSP_FTSSP010_VA_COUNT	1
#define SSP_FTSSP010_VA_BASE	0xF9940000
#define SSP_FTSSP010_VA_LIMIT	0xF9940FFF
#define SSP_FTSSP010_VA_SIZE	0x00001000
#define SSP_FTSSP010_0_VA_BASE	0xF9940000
#define SSP_FTSSP010_0_VA_LIMIT	0xF9940FFF
#define SSP_FTSSP010_0_VA_SIZE	0x00001000

/* FLH */
#define FLH_FTFLH010_PA_COUNT	1
#define FLH_FTFLH010_PA_BASE	0x80440000
#define FLH_FTFLH010_PA_LIMIT	0x8053FFFF
#define FLH_FTFLH010_PA_SIZE	0x00100000
#define FLH_FTFLH010_0_PA_BASE	0x80440000
#define FLH_FTFLH010_0_PA_LIMIT	0x8053FFFF
#define FLH_FTFLH010_0_PA_SIZE	0x00100000
#define FLH_FTFLH010_VA_COUNT	1
#define FLH_FTFLH010_VA_BASE	0xF8400000
#define FLH_FTFLH010_VA_LIMIT	0xF84FFFFF
#define FLH_FTFLH010_VA_SIZE	0x00100000
#define FLH_FTFLH010_0_VA_BASE	0xF8400000
#define FLH_FTFLH010_0_VA_LIMIT	0xF84FFFFF
#define FLH_FTFLH010_0_VA_SIZE	0x00100000

/* PMU */
#define PMU_FTPMU010_PA_COUNT	1
#define PMU_FTPMU010_PA_BASE	0x98100000
#define PMU_FTPMU010_PA_LIMIT	0x981FFFFF
#define PMU_FTPMU010_PA_SIZE	0x00100000
#define PMU_FTPMU010_0_PA_BASE	0x98100000
#define PMU_FTPMU010_0_PA_LIMIT	0x981FFFFF
#define PMU_FTPMU010_0_PA_SIZE	0x00100000
#define PMU_FTPMU010_VA_COUNT	1
#define PMU_FTPMU010_VA_BASE	0xF9810000
#define PMU_FTPMU010_VA_LIMIT	0xF9810FFF
#define PMU_FTPMU010_VA_SIZE	0x00001000
#define PMU_FTPMU010_0_VA_BASE	0xF9810000
#define PMU_FTPMU010_0_VA_LIMIT	0xF9810FFF
#define PMU_FTPMU010_0_VA_SIZE	0x00001000

/* MAC */
#define MAC_FTMAC100_PA_COUNT	1
#define MAC_FTMAC100_PA_BASE	0x90900000
#define MAC_FTMAC100_PA_LIMIT	0x909FFFFF
#define MAC_FTMAC100_PA_SIZE	0x00100000
#define MAC_FTMAC100_0_PA_BASE	0x90900000
#define MAC_FTMAC100_0_PA_LIMIT	0x909FFFFF
#define MAC_FTMAC100_0_PA_SIZE	0x00100000
#define MAC_FTMAC100_1_PA_BASE	0x92000000
#define MAC_FTMAC100_1_PA_LIMIT	0x920FFFFF
#define MAC_FTMAC100_1_PA_SIZE	0x00100000
#define MAC_FTMAC100_VA_COUNT	1
#define MAC_FTMAC100_VA_BASE	0xF9090000
#define MAC_FTMAC100_VA_LIMIT	0xF9090FFF
#define MAC_FTMAC100_VA_SIZE	0x00001000
#define MAC_FTMAC100_0_VA_BASE	0xF9090000
#define MAC_FTMAC100_0_VA_LIMIT	0xF9090FFF
#define MAC_FTMAC100_0_VA_SIZE	0x00001000
#define MAC_FTMAC100_1_VA_BASE	0xF9200000
#define MAC_FTMAC100_1_VA_LIMIT	0xF9200FFF
#define MAC_FTMAC100_1_VA_SIZE	0x00001000

/* SDC */
#define SDC_FTSDC010_PA_COUNT	1
#define SDC_FTSDC010_PA_BASE	0x98E00000
#define SDC_FTSDC010_PA_LIMIT	0x98EFFFFF
#define SDC_FTSDC010_PA_SIZE	0x00100000
#define SDC_FTSDC010_0_PA_BASE	0x98E00000
#define SDC_FTSDC010_0_PA_LIMIT	0x98EFFFFF
#define SDC_FTSDC010_0_PA_SIZE	0x00100000
#define SDC_FTSDC010_VA_COUNT	1
#define SDC_FTSDC010_VA_BASE	0xF98E0000
#define SDC_FTSDC010_VA_LIMIT	0xF98E0FFF
#define SDC_FTSDC010_VA_SIZE	0x00001000
#define SDC_FTSDC010_0_VA_BASE	0xF98E0000
#define SDC_FTSDC010_0_VA_LIMIT	0xF98E0FFF
#define SDC_FTSDC010_0_VA_SIZE	0x00001000
#define SDC_FTSDC020_PA_COUNT	1
#define SDC_FTSDC020_PA_BASE	0x92000000
#define SDC_FTSDC020_PA_LIMIT	0x9200FFFF
#define SDC_FTSDC020_PA_SIZE	0x00010000
#define SDC_FTSDC020_0_PA_BASE	0x92000000
#define SDC_FTSDC020_0_PA_LIMIT	0x9200FFFF
#define SDC_FTSDC020_0_PA_SIZE	0x00010000
#define SDC_FTSDC020_VA_COUNT	1
#define SDC_FTSDC020_VA_BASE	0xF9200000
#define SDC_FTSDC020_VA_LIMIT	0xF9200FFF
#define SDC_FTSDC020_VA_SIZE	0x00001000
#define SDC_FTSDC020_0_VA_BASE	0xF9200000
#define SDC_FTSDC020_0_VA_LIMIT	0xF9200FFF
#define SDC_FTSDC020_0_VA_SIZE	0x00001000

/* NANDC */
#define NANDC_FTNANDC020_PA_COUNT	1
#define NANDC_FTNANDC020_PA_BASE	0x90C00000
#define NANDC_FTNANDC020_PA_LIMIT	0x90C0FFFF
#define NANDC_FTNANDC020_PA_SIZE	0x00010000
#define NANDC_FTNANDC020_0_PA_BASE	0x90C00000
#define NANDC_FTNANDC020_0_PA_LIMIT	0x90C0FFFF
#define NANDC_FTNANDC020_0_PA_SIZE	0x00010000
#define NANDC_FTNANDC020_VA_COUNT	1
#define NANDC_FTNANDC020_VA_BASE	0xF90C0000
#define NANDC_FTNANDC020_VA_LIMIT	0xF90C0FFF
#define NANDC_FTNANDC020_VA_SIZE	0x00001000
#define NANDC_FTNANDC020_0_VA_BASE	0xF90C0000
#define NANDC_FTNANDC020_0_VA_LIMIT	0xF90C0FFF
#define NANDC_FTNANDC020_0_VA_SIZE	0x00001000

/* RTC */
#define RTC_FTRTC010_PA_COUNT	1
#define RTC_FTRTC010_PA_BASE	0x98600000
#define RTC_FTRTC010_PA_LIMIT	0x9860FFFF
#define RTC_FTRTC010_PA_SIZE	0x00010000
#define RTC_FTRTC010_0_PA_BASE	0x98600000
#define RTC_FTRTC010_0_PA_LIMIT	0x9860FFFF
#define RTC_FTRTC010_0_PA_SIZE	0x00010000
#define RTC_FTRTC010_VA_COUNT	1
#define RTC_FTRTC010_VA_BASE	0xF9860000
#define RTC_FTRTC010_VA_LIMIT	0xF9860FFF
#define RTC_FTRTC010_VA_SIZE	0x00001000
#define RTC_FTRTC010_0_VA_BASE	0xF9860000
#define RTC_FTRTC010_0_VA_LIMIT	0xF9860FFF
#define RTC_FTRTC010_0_VA_SIZE	0x00001000

/* WDT */
#define WDT_FTWDT010_PA_COUNT	1
#define WDT_FTWDT010_PA_BASE	0x98500000
#define WDT_FTWDT010_PA_LIMIT	0x9850FFFF
#define WDT_FTWDT010_PA_SIZE	0x00010000
#define WDT_FTWDT010_0_PA_BASE	0x98500000
#define WDT_FTWDT010_0_PA_LIMIT	0x9850FFFF
#define WDT_FTWDT010_0_PA_SIZE	0x00010000
#define WDT_FTWDT010_VA_COUNT	1
#define WDT_FTWDT010_VA_BASE	0xF9850000
#define WDT_FTWDT010_VA_LIMIT	0xF9850FFF
#define WDT_FTWDT010_VA_SIZE	0x00001000
#define WDT_FTWDT010_0_VA_BASE	0xF9850000
#define WDT_FTWDT010_0_VA_LIMIT	0xF9850FFF
#define WDT_FTWDT010_0_VA_SIZE	0x00001000

/* GPIO */
#define GPIO_FTGPIO010_PA_COUNT	1
#define GPIO_FTGPIO010_PA_BASE	0x98700000
#define GPIO_FTGPIO010_PA_LIMIT	0x9870FFFF
#define GPIO_FTGPIO010_PA_SIZE	0x00010000
#define GPIO_FTGPIO010_0_PA_BASE	0x98700000
#define GPIO_FTGPIO010_0_PA_LIMIT	0x9870FFFF
#define GPIO_FTGPIO010_0_PA_SIZE	0x00010000
#define GPIO_FTGPIO010_VA_COUNT	1
#define GPIO_FTGPIO010_VA_BASE	0xF9870000
#define GPIO_FTGPIO010_VA_LIMIT	0xF9870FFF
#define GPIO_FTGPIO010_VA_SIZE	0x00001000
#define GPIO_FTGPIO010_0_VA_BASE	0xF9870000
#define GPIO_FTGPIO010_0_VA_LIMIT	0xF9870FFF
#define GPIO_FTGPIO010_0_VA_SIZE	0x00001000

/* CFC */
#define CFC_FTCFC010_PA_COUNT	1
#define CFC_FTCFC010_PA_BASE	0x98D00000
#define CFC_FTCFC010_PA_LIMIT	0x98D0FFFF
#define CFC_FTCFC010_PA_SIZE	0x00010000
#define CFC_FTCFC010_0_PA_BASE	0x98D00000
#define CFC_FTCFC010_0_PA_LIMIT	0x98D0FFFF
#define CFC_FTCFC010_0_PA_SIZE	0x00010000
#define CFC_FTCFC010_VA_COUNT	1
#define CFC_FTCFC010_VA_BASE	0xF98D0000
#define CFC_FTCFC010_VA_LIMIT	0xF98D0FFF
#define CFC_FTCFC010_VA_SIZE	0x00001000
#define CFC_FTCFC010_0_VA_BASE	0xF98D0000
#define CFC_FTCFC010_0_VA_LIMIT	0xF98D0FFF
#define CFC_FTCFC010_0_VA_SIZE	0x00001000

/* LCD */
#define LCD_FTLCDC100_PA_COUNT	1
#define LCD_FTLCDC100_PA_BASE	0x90600000
#define LCD_FTLCDC100_PA_LIMIT	0x9060FFFF
#define LCD_FTLCDC100_PA_SIZE	0x00010000
#define LCD_FTLCDC100_0_PA_BASE	0x90600000
#define LCD_FTLCDC100_0_PA_LIMIT	0x9060FFFF
#define LCD_FTLCDC100_0_PA_SIZE	0x00010000
#define LCD_FTLCDC100_VA_COUNT	1
#define LCD_FTLCDC100_VA_BASE	0xF9060000
#define LCD_FTLCDC100_VA_LIMIT	0xF9060FFF
#define LCD_FTLCDC100_VA_SIZE	0x00001000
#define LCD_FTLCDC100_0_VA_BASE	0xF9060000
#define LCD_FTLCDC100_0_VA_LIMIT	0xF9060FFF
#define LCD_FTLCDC100_0_VA_SIZE	0x00001000

/* I2C */
#define I2C_FTI2C010_PA_COUNT	1
#define I2C_FTI2C010_PA_BASE	0x98A00000
#define I2C_FTI2C010_PA_LIMIT	0x98A0FFFF
#define I2C_FTI2C010_PA_SIZE	0x00010000
#define I2C_FTI2C010_0_PA_BASE	0x98A00000
#define I2C_FTI2C010_0_PA_LIMIT	0x98A0FFFF
#define I2C_FTI2C010_0_PA_SIZE	0x00010000
#define I2C_FTI2C010_VA_COUNT	1
#define I2C_FTI2C010_VA_BASE	0xF98A0000
#define I2C_FTI2C010_VA_LIMIT	0xF98A0FFF
#define I2C_FTI2C010_VA_SIZE	0x00001000
#define I2C_FTI2C010_0_VA_BASE	0xF98A0000
#define I2C_FTI2C010_0_VA_LIMIT	0xF98A0FFF
#define I2C_FTI2C010_0_VA_SIZE	0x00001000

/* USB */
#define USB_FOTG2XX_PA_COUNT	1
#define USB_FOTG2XX_PA_BASE	0x92000000
#define USB_FOTG2XX_PA_LIMIT	0x9200FFFF
#define USB_FOTG2XX_PA_SIZE	0x00010000
#define USB_FOTG2XX_0_PA_BASE	0x92000000
#define USB_FOTG2XX_0_PA_LIMIT	0x9200FFFF
#define USB_FOTG2XX_0_PA_SIZE	0x00010000
#define USB_FOTG2XX_VA_COUNT	1
#define USB_FOTG2XX_VA_BASE	0xF9200000
#define USB_FOTG2XX_VA_LIMIT	0xF9200FFF
#define USB_FOTG2XX_VA_SIZE	0x00001000
#define USB_FOTG2XX_0_VA_BASE	0xF9200000
#define USB_FOTG2XX_0_VA_LIMIT	0xF9200FFF
#define USB_FOTG2XX_0_VA_SIZE	0x00001000
#define USB_FUSBH200_PA_COUNT	1
#define USB_FUSBH200_PA_BASE	0x92000000
#define USB_FUSBH200_PA_LIMIT	0x9200FFFF
#define USB_FUSBH200_PA_SIZE	0x00010000
#define USB_FUSBH200_0_PA_BASE	0x92000000
#define USB_FUSBH200_0_PA_LIMIT	0x9200FFFF
#define USB_FUSBH200_0_PA_SIZE	0x00010000
#define USB_FUSBH200_VA_COUNT	1
#define USB_FUSBH200_VA_BASE	0xF9200000
#define USB_FUSBH200_VA_LIMIT	0xF9200FFF
#define USB_FUSBH200_VA_SIZE	0x00001000
#define USB_FUSBH200_0_VA_BASE	0xF9200000
#define USB_FUSBH200_0_VA_LIMIT	0xF9200FFF
#define USB_FUSBH200_0_VA_SIZE	0x00001000
#define USB_FUSB220_PA_COUNT	1
#define USB_FUSB220_PA_BASE	0x90B00000
#define USB_FUSB220_PA_LIMIT	0x90B0FFFF
#define USB_FUSB220_PA_SIZE	0x00010000
#define USB_FUSB220_0_PA_BASE	0x90B00000
#define USB_FUSB220_0_PA_LIMIT	0x90B0FFFF
#define USB_FUSB220_0_PA_SIZE	0x00010000
#define USB_FUSB220_VA_COUNT	1
#define USB_FUSB220_VA_BASE	0xF90B0000
#define USB_FUSB220_VA_LIMIT	0xF90B0FFF
#define USB_FUSB220_VA_SIZE	0x00001000
#define USB_FUSB220_0_VA_BASE	0xF90B0000
#define USB_FUSB220_0_VA_LIMIT	0xF90B0FFF
#define USB_FUSB220_0_VA_SIZE	0x00001000

/* DMAC */
#define DMAC_FTDMAC020_PA_COUNT	1
#define DMAC_FTDMAC020_PA_BASE	0x90400000
#define DMAC_FTDMAC020_PA_LIMIT	0x904FFFFF
#define DMAC_FTDMAC020_PA_SIZE	0x00100000
#define DMAC_FTDMAC020_0_PA_BASE	0x90400000
#define DMAC_FTDMAC020_0_PA_LIMIT	0x904FFFFF
#define DMAC_FTDMAC020_0_PA_SIZE	0x00100000
#define DMAC_FTDMAC020_VA_COUNT	1
#define DMAC_FTDMAC020_VA_BASE	0xF9040000
#define DMAC_FTDMAC020_VA_LIMIT	0xF9040FFF
#define DMAC_FTDMAC020_VA_SIZE	0x00001000
#define DMAC_FTDMAC020_0_VA_BASE	0xF9040000
#define DMAC_FTDMAC020_0_VA_LIMIT	0xF9040FFF
#define DMAC_FTDMAC020_0_VA_SIZE	0x00001000

/* APBBRG */
#define APBBRG_FTAPBBRG020S_PA_COUNT	1
#define APBBRG_FTAPBBRG020S_PA_BASE	0x90500000
#define APBBRG_FTAPBBRG020S_PA_LIMIT	0x905FFFFF
#define APBBRG_FTAPBBRG020S_PA_SIZE	0x00100000
#define APBBRG_FTAPBBRG020S_0_PA_BASE	0x90500000
#define APBBRG_FTAPBBRG020S_0_PA_LIMIT	0x905FFFFF
#define APBBRG_FTAPBBRG020S_0_PA_SIZE	0x00100000
#define APBBRG_FTAPBBRG020S_1_PA_BASE	0x90E00000
#define APBBRG_FTAPBBRG020S_1_PA_LIMIT	0x90EFFFFF
#define APBBRG_FTAPBBRG020S_1_PA_SIZE	0x00100000
#define APBBRG_FTAPBBRG020S_VA_COUNT	1
#define APBBRG_FTAPBBRG020S_VA_BASE	0xF9050000
#define APBBRG_FTAPBBRG020S_VA_LIMIT	0xF9050FFF
#define APBBRG_FTAPBBRG020S_VA_SIZE	0x00001000
#define APBBRG_FTAPBBRG020S_0_VA_BASE	0xF9050000
#define APBBRG_FTAPBBRG020S_0_VA_LIMIT	0xF9050FFF
#define APBBRG_FTAPBBRG020S_0_VA_SIZE	0x00001000
#define APBBRG_FTAPBBRG020S_1_VA_BASE	0xF90E0000
#define APBBRG_FTAPBBRG020S_1_VA_LIMIT	0xF90E0FFF
#define APBBRG_FTAPBBRG020S_1_VA_SIZE	0x00001000

/* KMI */
#define KMI_FTKBC010_PA_COUNT	1
#define KMI_FTKBC010_PA_BASE	0xB1300000
#define KMI_FTKBC010_PA_LIMIT	0xB13FFFFF
#define KMI_FTKBC010_PA_SIZE	0x00100000
#define KMI_FTKBC010_0_PA_BASE	0xB1300000
#define KMI_FTKBC010_0_PA_LIMIT	0xB13FFFFF
#define KMI_FTKBC010_0_PA_SIZE	0x00100000
#define KMI_FTKBC010_1_PA_BASE	0xB1700000
#define KMI_FTKBC010_1_PA_LIMIT	0xB17FFFFF
#define KMI_FTKBC010_1_PA_SIZE	0x00100000
#define KMI_FTKBC010_VA_COUNT	1
#define KMI_FTKBC010_VA_BASE	0xFB130000
#define KMI_FTKBC010_VA_LIMIT	0xFB130FFF
#define KMI_FTKBC010_VA_SIZE	0x00001000
#define KMI_FTKBC010_0_VA_BASE	0xFB130000
#define KMI_FTKBC010_0_VA_LIMIT	0xFB130FFF
#define KMI_FTKBC010_0_VA_SIZE	0x00001000
#define KMI_FTKBC010_1_VA_BASE	0xFB170000
#define KMI_FTKBC010_1_VA_LIMIT	0xFB170FFF
#define KMI_FTKBC010_1_VA_SIZE	0x00001000

/* PCIMEM */
#define PCIMEM_PA_COUNT	1
#define PCIMEM_PA_BASE	0xA0000000
#define PCIMEM_PA_LIMIT	0xAFFFFFFF
#define PCIMEM_PA_SIZE	0x10000000
#define PCIMEM_0_PA_BASE	0xA0000000
#define PCIMEM_0_PA_LIMIT	0xAFFFFFFF
#define PCIMEM_0_PA_SIZE	0x10000000
#define PCIMEM_VA_COUNT	1
#define PCIMEM_VA_BASE	0xE0000000
#define PCIMEM_VA_LIMIT	0xEFFFFFFF
#define PCIMEM_VA_SIZE	0x10000000
#define PCIMEM_0_VA_BASE	0xE0000000
#define PCIMEM_0_VA_LIMIT	0xEFFFFFFF
#define PCIMEM_0_VA_SIZE	0x10000000

/* PCIIO */
#define PCIIO_PA_COUNT	1
#define PCIIO_PA_BASE	0x90C01000
#define PCIIO_PA_LIMIT	0x90CFFFFF
#define PCIIO_PA_SIZE	0x000FF000
#define PCIIO_0_PA_BASE	0x90C01000
#define PCIIO_0_PA_LIMIT	0x90CFFFFF
#define PCIIO_0_PA_SIZE	0x000FF000
#define PCIIO_VA_COUNT	1
#define PCIIO_VA_BASE	0xF9D01000
#define PCIIO_VA_LIMIT	0xF9DFFFFF
#define PCIIO_VA_SIZE	0x000FF000
#define PCIIO_0_VA_BASE	0xF9D01000
#define PCIIO_0_VA_LIMIT	0xF9DFFFFF
#define PCIIO_0_VA_SIZE	0x000FF000

/* PCIC */
#define PCIC_FTPCI100_PA_COUNT	1
#define PCIC_FTPCI100_PA_BASE	0x90C00000
#define PCIC_FTPCI100_PA_LIMIT	0x90C00FFF
#define PCIC_FTPCI100_PA_SIZE	0x00001000
#define PCIC_FTPCI100_0_PA_BASE	0x90C00000
#define PCIC_FTPCI100_0_PA_LIMIT	0x90C00FFF
#define PCIC_FTPCI100_0_PA_SIZE	0x00001000
#define PCIC_FTPCI100_VA_COUNT	1
#define PCIC_FTPCI100_VA_BASE	0xF90C0000
#define PCIC_FTPCI100_VA_LIMIT	0xF90C0FFF
#define PCIC_FTPCI100_VA_SIZE	0x00001000
#define PCIC_FTPCI100_0_VA_BASE	0xF90C0000
#define PCIC_FTPCI100_0_VA_LIMIT	0xF90C0FFF
#define PCIC_FTPCI100_0_VA_SIZE	0x00001000

#ifdef CONFIG_PLATFORM_AHBDMA_MODULE
#define CONFIG_PLATFORM_AHBDMA
#endif

#ifdef CONFIG_PLATFORM_AHBDMA
/* #undef FIQ_DISPATCH_TABLE */
#define IRQ_DISPATCH_TABLE 1
#endif

#ifdef CONFIG_PLATFORM_APBDMA_MODULE
#define CONFIG_PLATFORM_APBDMA
#endif

#ifdef CONFIG_PLATFORM_APBDMA
/* #undef FIQ_DISPATCH_TABLE */
#define IRQ_DISPATCH_TABLE 1
#endif

#ifdef CONFIG_PLATFORM_FIA321_MODULE
#define CONFIG_PLATFORM_FIA321
#endif

#ifdef CONFIG_PLATFORM_FIA321
/* #undef FIQ_DISPATCH_TABLE */
#define IRQ_DISPATCH_TABLE 1
#endif

#ifdef CONFIG_PLATFORM_FIQ_RELAY_MODULE
#define CONFIG_PLATFORM_FIQ_RELAY
#endif

#ifdef CONFIG_PLATFORM_FIQ_RELAY
/* #undef FIQ_DISPATCH_TABLE */
#define IRQ_DISPATCH_TABLE 1
#endif

/*
 * C definitions
 */
#ifndef __ASSEMBLER__

#include <linux/linkage.h>

typedef asmlinkage unsigned interrupt_dispatch_function(unsigned);

#ifdef CONFIG_PLATFORM_FIQ_RELAY
extern interrupt_dispatch_function fiq_relay_irq15_dispatch;
#else
#define fiq_relay_irq15_dispatch 0
#endif

#ifdef CONFIG_PLATFORM_FIA321
extern interrupt_dispatch_function fia321_irq30_dispatch;
#else
#define fia321_irq30_dispatch 0
#endif

#ifdef CONFIG_PLATFORM_APBDMA
extern interrupt_dispatch_function apbdma_irq24_dispatch;
#else
#define apbdma_irq24_dispatch 0
#endif

#ifdef CONFIG_PLATFORM_AHBDMA
extern interrupt_dispatch_function ahbdma_irq21_dispatch;
#else
#define ahbdma_irq21_dispatch 0
#endif

/*
 * Interrrupt numbers
 */

/* UART */
extern const unsigned char UART_FTUART010_irq[UART_FTUART010_COUNT];
/* TIMER */
extern const unsigned char TIMER_FTTMR010_irq[TIMER_FTTMR010_COUNT][TIMER_FTTMR010_IRQ_COUNT];
/* SSP */
extern const unsigned char SSP_FTSSP010_irq[SSP_FTSSP010_COUNT];
/* MAC */
extern const unsigned char MAC_FTMAC100_irq[MAC_FTMAC100_COUNT];
/* SDC */
extern const unsigned char SDC_FTSDC010_irq[SDC_FTSDC010_COUNT];
extern const unsigned char SDC_FTSDC020_irq[SDC_FTSDC020_COUNT];
/* NANDC */
extern const unsigned char NANDC_FTNANDC020_irq[NANDC_FTNANDC020_COUNT];
/* RTC */
extern const unsigned char RTC_FTRTC010_irq[RTC_FTRTC010_COUNT][RTC_FTRTC010_IRQ_COUNT];
/* WDT */
extern const unsigned char WDT_FTWDT010_irq[WDT_FTWDT010_COUNT];
/* GPIO */
extern const unsigned char GPIO_FTGPIO010_irq[GPIO_FTGPIO010_COUNT];
/* CFC */
extern const unsigned char CFC_FTCFC010_irq[CFC_FTCFC010_COUNT][CFC_FTCFC010_IRQ_COUNT];
/* LCD */
extern const unsigned char LCD_FTLCDC100_irq[LCD_FTLCDC100_COUNT];
/* I2C */
extern const unsigned char I2C_FTI2C010_irq[I2C_FTI2C010_COUNT];
/* USB */
extern const unsigned char USB_FOTG2XX_irq[USB_FOTG2XX_COUNT];
extern const unsigned char USB_FUSBH200_irq[USB_FUSBH200_COUNT];
extern const unsigned char USB_FUSB220_irq[USB_FUSB220_COUNT];
/* DMAC */
extern const unsigned char DMAC_FTDMAC020_irq[DMAC_FTDMAC020_COUNT][DMAC_FTDMAC020_IRQ_COUNT];
/* APBBRG */
extern const unsigned char APBBRG_FTAPBBRG020S_irq[APBBRG_FTAPBBRG020S_COUNT][APBBRG_FTAPBBRG020S_IRQ_COUNT];
/* KMI */
extern const unsigned char KMI_FTKBC010_irq[KMI_FTKBC010_COUNT];
/* PCIC */
extern const unsigned char PCIC_FTPCI100_irq[PCIC_FTPCI100_COUNT][PCIC_FTPCI100_IRQ_COUNT];

/*
 * Base addresses
 */

/* CPU */
extern const unsigned CPU_MEM_pa_base[CPU_MEM_PA_COUNT];
extern const unsigned CPU_MEM_pa_limit[CPU_MEM_PA_COUNT];
extern const unsigned CPU_MEM_pa_size[CPU_MEM_PA_COUNT];
/* INTC */
extern const unsigned INTC_FTINTC010_pa_base[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_pa_limit[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_pa_size[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_va_base[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_va_limit[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_va_size[INTC_FTINTC010_COUNT];
/* UART */
extern const unsigned UART_FTUART010_pa_base[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_pa_limit[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_pa_size[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_va_base[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_va_limit[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_va_size[UART_FTUART010_COUNT];
/* TIMER */
extern const unsigned TIMER_FTTMR010_pa_base[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_pa_limit[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_pa_size[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_va_base[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_va_limit[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_va_size[TIMER_FTTMR010_COUNT];
/* SSP */
extern const unsigned SSP_FTSSP010_pa_base[SSP_FTSSP010_COUNT];
extern const unsigned SSP_FTSSP010_pa_limit[SSP_FTSSP010_COUNT];
extern const unsigned SSP_FTSSP010_pa_size[SSP_FTSSP010_COUNT];
extern const unsigned SSP_FTSSP010_va_base[SSP_FTSSP010_COUNT];
extern const unsigned SSP_FTSSP010_va_limit[SSP_FTSSP010_COUNT];
extern const unsigned SSP_FTSSP010_va_size[SSP_FTSSP010_COUNT];
/* FLH */
extern const unsigned FLH_FTFLH010_pa_base[FLH_FTFLH010_COUNT];
extern const unsigned FLH_FTFLH010_pa_limit[FLH_FTFLH010_COUNT];
extern const unsigned FLH_FTFLH010_pa_size[FLH_FTFLH010_COUNT];
extern const unsigned FLH_FTFLH010_va_base[FLH_FTFLH010_COUNT];
extern const unsigned FLH_FTFLH010_va_limit[FLH_FTFLH010_COUNT];
extern const unsigned FLH_FTFLH010_va_size[FLH_FTFLH010_COUNT];
/* PMU */
extern const unsigned PMU_FTPMU010_pa_base[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_pa_limit[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_pa_size[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_va_base[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_va_limit[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_va_size[PMU_FTPMU010_COUNT];
/* MAC */
extern const unsigned MAC_FTMAC100_pa_base[MAC_FTMAC100_COUNT];
extern const unsigned MAC_FTMAC100_pa_limit[MAC_FTMAC100_COUNT];
extern const unsigned MAC_FTMAC100_pa_size[MAC_FTMAC100_COUNT];
extern const unsigned MAC_FTMAC100_va_base[MAC_FTMAC100_COUNT];
extern const unsigned MAC_FTMAC100_va_limit[MAC_FTMAC100_COUNT];
extern const unsigned MAC_FTMAC100_va_size[MAC_FTMAC100_COUNT];
/* SDC */
extern const unsigned SDC_FTSDC010_pa_base[SDC_FTSDC010_COUNT];
extern const unsigned SDC_FTSDC010_pa_limit[SDC_FTSDC010_COUNT];
extern const unsigned SDC_FTSDC010_pa_size[SDC_FTSDC010_COUNT];
extern const unsigned SDC_FTSDC010_va_base[SDC_FTSDC010_COUNT];
extern const unsigned SDC_FTSDC010_va_limit[SDC_FTSDC010_COUNT];
extern const unsigned SDC_FTSDC010_va_size[SDC_FTSDC010_COUNT];
extern const unsigned SDC_FTSDC020_pa_base[SDC_FTSDC020_COUNT];
extern const unsigned SDC_FTSDC020_pa_limit[SDC_FTSDC020_COUNT];
extern const unsigned SDC_FTSDC020_pa_size[SDC_FTSDC020_COUNT];
extern const unsigned SDC_FTSDC020_va_base[SDC_FTSDC020_COUNT];
extern const unsigned SDC_FTSDC020_va_limit[SDC_FTSDC020_COUNT];
extern const unsigned SDC_FTSDC020_va_size[SDC_FTSDC020_COUNT];
/* NANDC */
extern const unsigned NANDC_FTNANDC020_pa_base[NANDC_FTNANDC020_COUNT];
extern const unsigned NANDC_FTNANDC020_pa_limit[NANDC_FTNANDC020_COUNT];
extern const unsigned NANDC_FTNANDC020_pa_size[NANDC_FTNANDC020_COUNT];
extern const unsigned NANDC_FTNANDC020_va_base[NANDC_FTNANDC020_COUNT];
extern const unsigned NANDC_FTNANDC020_va_limit[NANDC_FTNANDC020_COUNT];
extern const unsigned NANDC_FTNANDC020_va_size[NANDC_FTNANDC020_COUNT];
/* RTC */
extern const unsigned RTC_FTRTC010_pa_base[RTC_FTRTC010_COUNT];
extern const unsigned RTC_FTRTC010_pa_limit[RTC_FTRTC010_COUNT];
extern const unsigned RTC_FTRTC010_pa_size[RTC_FTRTC010_COUNT];
extern const unsigned RTC_FTRTC010_va_base[RTC_FTRTC010_COUNT];
extern const unsigned RTC_FTRTC010_va_limit[RTC_FTRTC010_COUNT];
extern const unsigned RTC_FTRTC010_va_size[RTC_FTRTC010_COUNT];
/* WDT */
extern const unsigned WDT_FTWDT010_pa_base[WDT_FTWDT010_COUNT];
extern const unsigned WDT_FTWDT010_pa_limit[WDT_FTWDT010_COUNT];
extern const unsigned WDT_FTWDT010_pa_size[WDT_FTWDT010_COUNT];
extern const unsigned WDT_FTWDT010_va_base[WDT_FTWDT010_COUNT];
extern const unsigned WDT_FTWDT010_va_limit[WDT_FTWDT010_COUNT];
extern const unsigned WDT_FTWDT010_va_size[WDT_FTWDT010_COUNT];
/* GPIO */
extern const unsigned GPIO_FTGPIO010_pa_base[GPIO_FTGPIO010_COUNT];
extern const unsigned GPIO_FTGPIO010_pa_limit[GPIO_FTGPIO010_COUNT];
extern const unsigned GPIO_FTGPIO010_pa_size[GPIO_FTGPIO010_COUNT];
extern const unsigned GPIO_FTGPIO010_va_base[GPIO_FTGPIO010_COUNT];
extern const unsigned GPIO_FTGPIO010_va_limit[GPIO_FTGPIO010_COUNT];
extern const unsigned GPIO_FTGPIO010_va_size[GPIO_FTGPIO010_COUNT];
/* CFC */
extern const unsigned CFC_FTCFC010_pa_base[CFC_FTCFC010_COUNT];
extern const unsigned CFC_FTCFC010_pa_limit[CFC_FTCFC010_COUNT];
extern const unsigned CFC_FTCFC010_pa_size[CFC_FTCFC010_COUNT];
extern const unsigned CFC_FTCFC010_va_base[CFC_FTCFC010_COUNT];
extern const unsigned CFC_FTCFC010_va_limit[CFC_FTCFC010_COUNT];
extern const unsigned CFC_FTCFC010_va_size[CFC_FTCFC010_COUNT];
/* LCD */
extern const unsigned LCD_FTLCDC100_pa_base[LCD_FTLCDC100_COUNT];
extern const unsigned LCD_FTLCDC100_pa_limit[LCD_FTLCDC100_COUNT];
extern const unsigned LCD_FTLCDC100_pa_size[LCD_FTLCDC100_COUNT];
extern const unsigned LCD_FTLCDC100_va_base[LCD_FTLCDC100_COUNT];
extern const unsigned LCD_FTLCDC100_va_limit[LCD_FTLCDC100_COUNT];
extern const unsigned LCD_FTLCDC100_va_size[LCD_FTLCDC100_COUNT];
/* I2C */
extern const unsigned I2C_FTI2C010_pa_base[I2C_FTI2C010_COUNT];
extern const unsigned I2C_FTI2C010_pa_limit[I2C_FTI2C010_COUNT];
extern const unsigned I2C_FTI2C010_pa_size[I2C_FTI2C010_COUNT];
extern const unsigned I2C_FTI2C010_va_base[I2C_FTI2C010_COUNT];
extern const unsigned I2C_FTI2C010_va_limit[I2C_FTI2C010_COUNT];
extern const unsigned I2C_FTI2C010_va_size[I2C_FTI2C010_COUNT];
/* USB */
extern const unsigned USB_FOTG2XX_pa_base[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_pa_limit[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_pa_size[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_va_base[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_va_limit[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_va_size[USB_FOTG2XX_COUNT];
extern const unsigned USB_FUSBH200_pa_base[USB_FUSBH200_COUNT];
extern const unsigned USB_FUSBH200_pa_limit[USB_FUSBH200_COUNT];
extern const unsigned USB_FUSBH200_pa_size[USB_FUSBH200_COUNT];
extern const unsigned USB_FUSBH200_va_base[USB_FUSBH200_COUNT];
extern const unsigned USB_FUSBH200_va_limit[USB_FUSBH200_COUNT];
extern const unsigned USB_FUSBH200_va_size[USB_FUSBH200_COUNT];
extern const unsigned USB_FUSB220_pa_base[USB_FUSB220_COUNT];
extern const unsigned USB_FUSB220_pa_limit[USB_FUSB220_COUNT];
extern const unsigned USB_FUSB220_pa_size[USB_FUSB220_COUNT];
extern const unsigned USB_FUSB220_va_base[USB_FUSB220_COUNT];
extern const unsigned USB_FUSB220_va_limit[USB_FUSB220_COUNT];
extern const unsigned USB_FUSB220_va_size[USB_FUSB220_COUNT];
/* DMAC */
extern const unsigned DMAC_FTDMAC020_pa_base[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_pa_limit[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_pa_size[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_va_base[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_va_limit[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_va_size[DMAC_FTDMAC020_COUNT];
/* APBBRG */
extern const unsigned APBBRG_FTAPBBRG020S_pa_base[APBBRG_FTAPBBRG020S_COUNT];
extern const unsigned APBBRG_FTAPBBRG020S_pa_limit[APBBRG_FTAPBBRG020S_COUNT];
extern const unsigned APBBRG_FTAPBBRG020S_pa_size[APBBRG_FTAPBBRG020S_COUNT];
extern const unsigned APBBRG_FTAPBBRG020S_va_base[APBBRG_FTAPBBRG020S_COUNT];
extern const unsigned APBBRG_FTAPBBRG020S_va_limit[APBBRG_FTAPBBRG020S_COUNT];
extern const unsigned APBBRG_FTAPBBRG020S_va_size[APBBRG_FTAPBBRG020S_COUNT];
/* KMI */
extern const unsigned KMI_FTKBC010_pa_base[KMI_FTKBC010_COUNT];
extern const unsigned KMI_FTKBC010_pa_limit[KMI_FTKBC010_COUNT];
extern const unsigned KMI_FTKBC010_pa_size[KMI_FTKBC010_COUNT];
extern const unsigned KMI_FTKBC010_va_base[KMI_FTKBC010_COUNT];
extern const unsigned KMI_FTKBC010_va_limit[KMI_FTKBC010_COUNT];
extern const unsigned KMI_FTKBC010_va_size[KMI_FTKBC010_COUNT];
/* PCIMEM */
extern const unsigned PCIMEM_pa_base[PCIMEM_COUNT];
extern const unsigned PCIMEM_pa_limit[PCIMEM_COUNT];
extern const unsigned PCIMEM_pa_size[PCIMEM_COUNT];
extern const unsigned PCIMEM_va_base[PCIMEM_COUNT];
extern const unsigned PCIMEM_va_limit[PCIMEM_COUNT];
extern const unsigned PCIMEM_va_size[PCIMEM_COUNT];
/* PCIIO */
extern const unsigned PCIIO_pa_base[PCIIO_COUNT];
extern const unsigned PCIIO_pa_limit[PCIIO_COUNT];
extern const unsigned PCIIO_pa_size[PCIIO_COUNT];
extern const unsigned PCIIO_va_base[PCIIO_COUNT];
extern const unsigned PCIIO_va_limit[PCIIO_COUNT];
extern const unsigned PCIIO_va_size[PCIIO_COUNT];
/* PCIC */
extern const unsigned PCIC_FTPCI100_pa_base[PCIC_FTPCI100_COUNT];
extern const unsigned PCIC_FTPCI100_pa_limit[PCIC_FTPCI100_COUNT];
extern const unsigned PCIC_FTPCI100_pa_size[PCIC_FTPCI100_COUNT];
extern const unsigned PCIC_FTPCI100_va_base[PCIC_FTPCI100_COUNT];
extern const unsigned PCIC_FTPCI100_va_limit[PCIC_FTPCI100_COUNT];
extern const unsigned PCIC_FTPCI100_va_size[PCIC_FTPCI100_COUNT];

/* IO mapping */
#define PLATFORM_IO_DESC_NR 31
struct map_desc;
//extern const struct map_desc platform_io_desc[PLATFORM_IO_DESC_NR];

#endif /* ifndef __ASSEMBLER__ */

#endif /* __A320_PLATFORM_SPECIFICATION__ */

