/*
 *  linux/arch/arm/mach-faraday/platform-gm8126/spec.c
 *
 *  Faraday Platform Specification  (Automatically generated by "autospec", do not edit)
 *
 *  Copyright (C) 2010 Faraday Corp. (http://www.faraday-tech.com)
 *
 *  Platform Hierarchy :
 *
 *    GM8126
 *     +- CPU_FA626  (0)
 *     +- PMU_FTPMU010  (0)
 *     +- DDRC_FTDDRC010  (0)
 *     +- AHBC_FTAHBC010  (0)
 *     +- AHBC_FTAHBC010  (1)
 *     +- AHBC_FTAHBC010  (2)
 *     +- AHBC_FTAHBC010  (3)
 *     +- AHBC_FTAHBC010  (4)
 *     +- AHBC_FTAHBC010  (5)
 *     +- AHBC_FTAHBC010  (6)
 *     +- AHBC_FTAHBC010  (7)
 *     +- AHBC_FTAHBC010  (8)
 *     +- AHBC_FTAHBC010  (9)
 *     +- AHBC_FTAHBC010  (10)
 *     +- UART_FTUART010  (0)
 *     +- UART_FTUART010  (1)
 *     +- UART_FTUART010  (2)
 *     +- UART_FTUART010  (3)
 *     +- UART_FTUART010  (4)
 *     +- TIMER_FTTMR010  (0)
 *     +- INTC_FTINTC010  (0)
 *     +- SRAM_FTSMC010  (0)
 *     +- NAND_FTNAND023  (0)
 *     +- NANDDP_FTNAND023  (0)
 *     +- USB_FOTG2XX  (0)
 *     +- AHBDMA
 *     |   +- DMAC_FTDMAC020  (0)
 *     +- APBDMA
 *     |   +- APBBRG_FTAPBBRG020S  (0)
 *     +- FIQ_RELAY
 *         +- FIQ_RELAYER
 */


#include <linux/init.h>
#include <linux/module.h>

#include <asm/mach/map.h>
#include <asm/sizes.h>

#include <mach/platform/spec.h>

/*
 * Interrrupt numbers
 */


/* UART */
const unsigned char UART_FTUART010_irq[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_IRQ,
     UART_FTUART010_1_IRQ,
     UART_FTUART010_2_IRQ,
     UART_FTUART010_3_IRQ,
     UART_FTUART010_4_IRQ
};

/* TIMER */
const unsigned char TIMER_FTTMR010_irq[TIMER_FTTMR010_COUNT][TIMER_FTTMR010_IRQ_COUNT] = {
    { TIMER_FTTMR010_0_IRQ0, TIMER_FTTMR010_0_IRQ1, TIMER_FTTMR010_0_IRQ2 }
};

/* NAND */
const unsigned char NAND_FTNAND023_irq[NAND_FTNAND023_COUNT] = {
     NAND_FTNAND023_0_IRQ
};

/* USB */
const unsigned char USB_FOTG2XX_irq[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_IRQ
};

/* DMAC */
const unsigned char DMAC_FTDMAC020_irq[DMAC_FTDMAC020_COUNT][DMAC_FTDMAC020_IRQ_COUNT] = {
    { DMAC_FTDMAC020_0_IRQ0, DMAC_FTDMAC020_0_IRQ1, DMAC_FTDMAC020_0_IRQ2, DMAC_FTDMAC020_0_IRQ3, DMAC_FTDMAC020_0_IRQ4, DMAC_FTDMAC020_0_IRQ5, DMAC_FTDMAC020_0_IRQ6, DMAC_FTDMAC020_0_IRQ7 }
};

/* APBBRG */
const unsigned char APBBRG_FTAPBBRG020S_irq[APBBRG_FTAPBBRG020S_COUNT][APBBRG_FTAPBBRG020S_IRQ_COUNT] = {
    { APBBRG_FTAPBBRG020S_0_IRQ0, APBBRG_FTAPBBRG020S_0_IRQ1, APBBRG_FTAPBBRG020S_0_IRQ2, APBBRG_FTAPBBRG020S_0_IRQ3 }
};

/*
 * Base addresses
 */


/* CPU */
const unsigned CPU_MEM_pa_base[CPU_MEM_PA_COUNT] = {
     CPU_MEM_0_PA_BASE
};
const unsigned CPU_MEM_pa_limit[CPU_MEM_PA_COUNT] = {
     CPU_MEM_0_PA_LIMIT
};
const unsigned CPU_MEM_pa_size[CPU_MEM_PA_COUNT] = {
     CPU_MEM_0_PA_SIZE
};

/* PMU */
const unsigned PMU_FTPMU010_pa_base[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_PA_BASE
};
const unsigned PMU_FTPMU010_pa_limit[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_PA_LIMIT
};
const unsigned PMU_FTPMU010_pa_size[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_PA_SIZE
};
const unsigned PMU_FTPMU010_va_base[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_VA_BASE
};
const unsigned PMU_FTPMU010_va_limit[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_VA_LIMIT
};
const unsigned PMU_FTPMU010_va_size[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_VA_SIZE
};

/* DDRC */
const unsigned DDRC_FTDDRC010_pa_base[DDRC_FTDDRC010_COUNT] = {
     DDRC_FTDDRC010_0_PA_BASE
};
const unsigned DDRC_FTDDRC010_pa_limit[DDRC_FTDDRC010_COUNT] = {
     DDRC_FTDDRC010_0_PA_LIMIT
};
const unsigned DDRC_FTDDRC010_pa_size[DDRC_FTDDRC010_COUNT] = {
     DDRC_FTDDRC010_0_PA_SIZE
};
const unsigned DDRC_FTDDRC010_va_base[DDRC_FTDDRC010_COUNT] = {
     DDRC_FTDDRC010_0_VA_BASE
};
const unsigned DDRC_FTDDRC010_va_limit[DDRC_FTDDRC010_COUNT] = {
     DDRC_FTDDRC010_0_VA_LIMIT
};
const unsigned DDRC_FTDDRC010_va_size[DDRC_FTDDRC010_COUNT] = {
     DDRC_FTDDRC010_0_VA_SIZE
};

/* AHBC */
const unsigned AHBC_FTAHBC010_pa_base[AHBC_FTAHBC010_COUNT] = {
     AHBC_FTAHBC010_0_PA_BASE,
     AHBC_FTAHBC010_1_PA_BASE,
     AHBC_FTAHBC010_2_PA_BASE,
     AHBC_FTAHBC010_3_PA_BASE,
     AHBC_FTAHBC010_4_PA_BASE,
     AHBC_FTAHBC010_5_PA_BASE,
     AHBC_FTAHBC010_6_PA_BASE,
     AHBC_FTAHBC010_7_PA_BASE,
     AHBC_FTAHBC010_8_PA_BASE,
     AHBC_FTAHBC010_9_PA_BASE,
     AHBC_FTAHBC010_10_PA_BASE
};
const unsigned AHBC_FTAHBC010_pa_limit[AHBC_FTAHBC010_COUNT] = {
     AHBC_FTAHBC010_0_PA_LIMIT,
     AHBC_FTAHBC010_1_PA_LIMIT,
     AHBC_FTAHBC010_2_PA_LIMIT,
     AHBC_FTAHBC010_3_PA_LIMIT,
     AHBC_FTAHBC010_4_PA_LIMIT,
     AHBC_FTAHBC010_5_PA_LIMIT,
     AHBC_FTAHBC010_6_PA_LIMIT,
     AHBC_FTAHBC010_7_PA_LIMIT,
     AHBC_FTAHBC010_8_PA_LIMIT,
     AHBC_FTAHBC010_9_PA_LIMIT,
     AHBC_FTAHBC010_10_PA_LIMIT
};
const unsigned AHBC_FTAHBC010_pa_size[AHBC_FTAHBC010_COUNT] = {
     AHBC_FTAHBC010_0_PA_SIZE,
     AHBC_FTAHBC010_1_PA_SIZE,
     AHBC_FTAHBC010_2_PA_SIZE,
     AHBC_FTAHBC010_3_PA_SIZE,
     AHBC_FTAHBC010_4_PA_SIZE,
     AHBC_FTAHBC010_5_PA_SIZE,
     AHBC_FTAHBC010_6_PA_SIZE,
     AHBC_FTAHBC010_7_PA_SIZE,
     AHBC_FTAHBC010_8_PA_SIZE,
     AHBC_FTAHBC010_9_PA_SIZE,
     AHBC_FTAHBC010_10_PA_SIZE
};
const unsigned AHBC_FTAHBC010_va_base[AHBC_FTAHBC010_COUNT] = {
     AHBC_FTAHBC010_0_VA_BASE,
     AHBC_FTAHBC010_1_VA_BASE,
     AHBC_FTAHBC010_2_VA_BASE,
     AHBC_FTAHBC010_3_VA_BASE,
     AHBC_FTAHBC010_4_VA_BASE,
     AHBC_FTAHBC010_5_VA_BASE,
     AHBC_FTAHBC010_6_VA_BASE,
     AHBC_FTAHBC010_7_VA_BASE,
     AHBC_FTAHBC010_8_VA_BASE,
     AHBC_FTAHBC010_9_VA_BASE,
     AHBC_FTAHBC010_10_VA_BASE
};
const unsigned AHBC_FTAHBC010_va_limit[AHBC_FTAHBC010_COUNT] = {
     AHBC_FTAHBC010_0_VA_LIMIT,
     AHBC_FTAHBC010_1_VA_LIMIT,
     AHBC_FTAHBC010_2_VA_LIMIT,
     AHBC_FTAHBC010_3_VA_LIMIT,
     AHBC_FTAHBC010_4_VA_LIMIT,
     AHBC_FTAHBC010_5_VA_LIMIT,
     AHBC_FTAHBC010_6_VA_LIMIT,
     AHBC_FTAHBC010_7_VA_LIMIT,
     AHBC_FTAHBC010_8_VA_LIMIT,
     AHBC_FTAHBC010_9_VA_LIMIT,
     AHBC_FTAHBC010_10_VA_LIMIT
};
const unsigned AHBC_FTAHBC010_va_size[AHBC_FTAHBC010_COUNT] = {
     AHBC_FTAHBC010_0_VA_SIZE,
     AHBC_FTAHBC010_1_VA_SIZE,
     AHBC_FTAHBC010_2_VA_SIZE,
     AHBC_FTAHBC010_3_VA_SIZE,
     AHBC_FTAHBC010_4_VA_SIZE,
     AHBC_FTAHBC010_5_VA_SIZE,
     AHBC_FTAHBC010_6_VA_SIZE,
     AHBC_FTAHBC010_7_VA_SIZE,
     AHBC_FTAHBC010_8_VA_SIZE,
     AHBC_FTAHBC010_9_VA_SIZE,
     AHBC_FTAHBC010_10_VA_SIZE
};

/* UART */
const unsigned UART_FTUART010_pa_base[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_PA_BASE,
     UART_FTUART010_1_PA_BASE,
     UART_FTUART010_2_PA_BASE,
     UART_FTUART010_3_PA_BASE,
     UART_FTUART010_4_PA_BASE
};
const unsigned UART_FTUART010_pa_limit[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_PA_LIMIT,
     UART_FTUART010_1_PA_LIMIT,
     UART_FTUART010_2_PA_LIMIT,
     UART_FTUART010_3_PA_LIMIT,
     UART_FTUART010_4_PA_LIMIT
};
const unsigned UART_FTUART010_pa_size[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_PA_SIZE,
     UART_FTUART010_1_PA_SIZE,
     UART_FTUART010_2_PA_SIZE,
     UART_FTUART010_3_PA_SIZE,
     UART_FTUART010_4_PA_SIZE
};
const unsigned UART_FTUART010_va_base[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_VA_BASE,
     UART_FTUART010_1_VA_BASE,
     UART_FTUART010_2_VA_BASE,
     UART_FTUART010_3_VA_BASE,
     UART_FTUART010_4_VA_BASE
};
const unsigned UART_FTUART010_va_limit[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_VA_LIMIT,
     UART_FTUART010_1_VA_LIMIT,
     UART_FTUART010_2_VA_LIMIT,
     UART_FTUART010_3_VA_LIMIT,
     UART_FTUART010_4_VA_LIMIT
};
const unsigned UART_FTUART010_va_size[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_VA_SIZE,
     UART_FTUART010_1_VA_SIZE,
     UART_FTUART010_2_VA_SIZE,
     UART_FTUART010_3_VA_SIZE,
     UART_FTUART010_4_VA_SIZE
};

/* TIMER */
const unsigned TIMER_FTTMR010_pa_base[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_PA_BASE
};
const unsigned TIMER_FTTMR010_pa_limit[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_PA_LIMIT
};
const unsigned TIMER_FTTMR010_pa_size[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_PA_SIZE
};
const unsigned TIMER_FTTMR010_va_base[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_VA_BASE
};
const unsigned TIMER_FTTMR010_va_limit[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_VA_LIMIT
};
const unsigned TIMER_FTTMR010_va_size[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_VA_SIZE
};

/* INTC */
const unsigned INTC_FTINTC010_pa_base[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_PA_BASE
};
const unsigned INTC_FTINTC010_pa_limit[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_PA_LIMIT
};
const unsigned INTC_FTINTC010_pa_size[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_PA_SIZE
};
const unsigned INTC_FTINTC010_va_base[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_VA_BASE
};
const unsigned INTC_FTINTC010_va_limit[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_VA_LIMIT
};
const unsigned INTC_FTINTC010_va_size[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_VA_SIZE
};

/* SRAM */
const unsigned SRAM_FTSMC010_pa_base[SRAM_FTSMC010_COUNT] = {
     SRAM_FTSMC010_0_PA_BASE
};
const unsigned SRAM_FTSMC010_pa_limit[SRAM_FTSMC010_COUNT] = {
     SRAM_FTSMC010_0_PA_LIMIT
};
const unsigned SRAM_FTSMC010_pa_size[SRAM_FTSMC010_COUNT] = {
     SRAM_FTSMC010_0_PA_SIZE
};
const unsigned SRAM_FTSMC010_va_base[SRAM_FTSMC010_COUNT] = {
     SRAM_FTSMC010_0_VA_BASE
};
const unsigned SRAM_FTSMC010_va_limit[SRAM_FTSMC010_COUNT] = {
     SRAM_FTSMC010_0_VA_LIMIT
};
const unsigned SRAM_FTSMC010_va_size[SRAM_FTSMC010_COUNT] = {
     SRAM_FTSMC010_0_VA_SIZE
};

/* NAND */
const unsigned NAND_FTNAND023_pa_base[NAND_FTNAND023_COUNT] = {
     NAND_FTNAND023_0_PA_BASE
};
const unsigned NAND_FTNAND023_pa_limit[NAND_FTNAND023_COUNT] = {
     NAND_FTNAND023_0_PA_LIMIT
};
const unsigned NAND_FTNAND023_pa_size[NAND_FTNAND023_COUNT] = {
     NAND_FTNAND023_0_PA_SIZE
};
const unsigned NAND_FTNAND023_va_base[NAND_FTNAND023_COUNT] = {
     NAND_FTNAND023_0_VA_BASE
};
const unsigned NAND_FTNAND023_va_limit[NAND_FTNAND023_COUNT] = {
     NAND_FTNAND023_0_VA_LIMIT
};
const unsigned NAND_FTNAND023_va_size[NAND_FTNAND023_COUNT] = {
     NAND_FTNAND023_0_VA_SIZE
};

/* NANDDP */
const unsigned NANDDP_FTNAND023_pa_base[NANDDP_FTNAND023_COUNT] = {
     NANDDP_FTNAND023_0_PA_BASE
};
const unsigned NANDDP_FTNAND023_pa_limit[NANDDP_FTNAND023_COUNT] = {
     NANDDP_FTNAND023_0_PA_LIMIT
};
const unsigned NANDDP_FTNAND023_pa_size[NANDDP_FTNAND023_COUNT] = {
     NANDDP_FTNAND023_0_PA_SIZE
};
const unsigned NANDDP_FTNAND023_va_base[NANDDP_FTNAND023_COUNT] = {
     NANDDP_FTNAND023_0_VA_BASE
};
const unsigned NANDDP_FTNAND023_va_limit[NANDDP_FTNAND023_COUNT] = {
     NANDDP_FTNAND023_0_VA_LIMIT
};
const unsigned NANDDP_FTNAND023_va_size[NANDDP_FTNAND023_COUNT] = {
     NANDDP_FTNAND023_0_VA_SIZE
};

/* USB */
const unsigned USB_FOTG2XX_pa_base[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_PA_BASE
};
const unsigned USB_FOTG2XX_pa_limit[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_PA_LIMIT
};
const unsigned USB_FOTG2XX_pa_size[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_PA_SIZE
};
const unsigned USB_FOTG2XX_va_base[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_VA_BASE
};
const unsigned USB_FOTG2XX_va_limit[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_VA_LIMIT
};
const unsigned USB_FOTG2XX_va_size[USB_FOTG2XX_COUNT] = {
     USB_FOTG2XX_0_VA_SIZE
};

/* DMAC */
const unsigned DMAC_FTDMAC020_pa_base[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_PA_BASE
};
const unsigned DMAC_FTDMAC020_pa_limit[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_PA_LIMIT
};
const unsigned DMAC_FTDMAC020_pa_size[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_PA_SIZE
};
const unsigned DMAC_FTDMAC020_va_base[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_VA_BASE
};
const unsigned DMAC_FTDMAC020_va_limit[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_VA_LIMIT
};
const unsigned DMAC_FTDMAC020_va_size[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_VA_SIZE
};

/* APBBRG */
const unsigned APBBRG_FTAPBBRG020S_pa_base[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_PA_BASE
};
const unsigned APBBRG_FTAPBBRG020S_pa_limit[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_PA_LIMIT
};
const unsigned APBBRG_FTAPBBRG020S_pa_size[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_PA_SIZE
};
const unsigned APBBRG_FTAPBBRG020S_va_base[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_VA_BASE
};
const unsigned APBBRG_FTAPBBRG020S_va_limit[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_VA_LIMIT
};
const unsigned APBBRG_FTAPBBRG020S_va_size[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_VA_SIZE
};

/*
 * Platform Initialization Information
 */

const struct map_desc platform_io_desc[PLATFORM_IO_DESC_NR] __initdata = {
    { PMU_FTPMU010_0_VA_BASE,	__phys_to_pfn(PMU_FTPMU010_0_PA_BASE),	0x00010000,	MT_DEVICE_NCNB },
    { DDRC_FTDDRC010_0_VA_BASE,	__phys_to_pfn(DDRC_FTDDRC010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC010_0_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC010_1_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC010_1_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC010_2_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC010_2_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC010_3_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC010_3_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC010_4_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC010_4_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC010_5_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC010_5_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC010_6_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC010_6_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC010_7_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC010_7_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC010_8_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC010_8_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC010_9_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC010_9_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { AHBC_FTAHBC010_10_VA_BASE,	__phys_to_pfn(AHBC_FTAHBC010_10_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { UART_FTUART010_0_VA_BASE,	__phys_to_pfn(UART_FTUART010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { UART_FTUART010_1_VA_BASE,	__phys_to_pfn(UART_FTUART010_1_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { UART_FTUART010_2_VA_BASE,	__phys_to_pfn(UART_FTUART010_2_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { UART_FTUART010_3_VA_BASE,	__phys_to_pfn(UART_FTUART010_3_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { UART_FTUART010_4_VA_BASE,	__phys_to_pfn(UART_FTUART010_4_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { TIMER_FTTMR010_0_VA_BASE,	__phys_to_pfn(TIMER_FTTMR010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { INTC_FTINTC010_0_VA_BASE,	__phys_to_pfn(INTC_FTINTC010_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { SRAM_FTSMC010_0_VA_BASE,	__phys_to_pfn(SRAM_FTSMC010_0_PA_BASE),	0x00010000,	MT_DEVICE_NCNB },
    { NAND_FTNAND023_0_VA_BASE,	__phys_to_pfn(NAND_FTNAND023_0_PA_BASE),	0x00010000,	MT_DEVICE_NCNB },
    { NANDDP_FTNAND023_0_VA_BASE,	__phys_to_pfn(NANDDP_FTNAND023_0_PA_BASE),	0x00010000,	MT_DEVICE_NCNB },
    { USB_FOTG2XX_0_VA_BASE,	__phys_to_pfn(USB_FOTG2XX_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { DMAC_FTDMAC020_0_VA_BASE,	__phys_to_pfn(DMAC_FTDMAC020_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB },
    { APBBRG_FTAPBBRG020S_0_VA_BASE,	__phys_to_pfn(APBBRG_FTAPBBRG020S_0_PA_BASE),	0x00001000,	MT_DEVICE_NCNB }
};

/*
 * Interrupt Dispatch Tables, for both FIQ and IRQ
 */

/* const interrupt_dispatch_function *fiq_dispatch_table[32]; */

#ifdef IRQ_DISPATCH_TABLE
const interrupt_dispatch_function *irq_dispatch_table[32]
= {
    /* 00 */  0,
    /* 01 */  ahbdma_irq1_dispatch,
    /* 02 */  apbdma_irq2_dispatch,
    /* 03 */  0,
    /* 04 */  0,
    /* 05 */  0,
    /* 06 */  0,
    /* 07 */  0,
    /* 08 */  0,
    /* 09 */  0,
    /* 10 */  0,
    /* 11 */  0,
    /* 12 */  0,
    /* 13 */  0,
    /* 14 */  fiq_relay_irq14_dispatch,
    /* 15 */  0,
    /* 16 */  0,
    /* 17 */  0,
    /* 18 */  0,
    /* 19 */  0,
    /* 20 */  0,
    /* 21 */  0,
    /* 22 */  0,
    /* 23 */  0,
    /* 24 */  0,
    /* 25 */  0,
    /* 26 */  0,
    /* 27 */  0,
    /* 28 */  0,
    /* 29 */  0,
    /* 30 */  0,
    /* 31 */  0
};
#endif


/*
 * Export All Symbols
 */

/*
 * Interrrupt numbers
 */

/* UART */
EXPORT_SYMBOL( UART_FTUART010_irq );
/* TIMER */
EXPORT_SYMBOL( TIMER_FTTMR010_irq );
/* NAND */
EXPORT_SYMBOL( NAND_FTNAND023_irq );
/* USB */
EXPORT_SYMBOL( USB_FOTG2XX_irq );
/* DMAC */
EXPORT_SYMBOL( DMAC_FTDMAC020_irq );
/* APBBRG */
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_irq );

/*
 * Base addresses
 */

/* CPU */
EXPORT_SYMBOL( CPU_MEM_pa_base );
EXPORT_SYMBOL( CPU_MEM_pa_limit );
EXPORT_SYMBOL( CPU_MEM_pa_size );
/* PMU */
EXPORT_SYMBOL( PMU_FTPMU010_pa_base );
EXPORT_SYMBOL( PMU_FTPMU010_pa_limit );
EXPORT_SYMBOL( PMU_FTPMU010_pa_size );
EXPORT_SYMBOL( PMU_FTPMU010_va_base );
EXPORT_SYMBOL( PMU_FTPMU010_va_limit );
EXPORT_SYMBOL( PMU_FTPMU010_va_size );
/* DDRC */
EXPORT_SYMBOL( DDRC_FTDDRC010_pa_base );
EXPORT_SYMBOL( DDRC_FTDDRC010_pa_limit );
EXPORT_SYMBOL( DDRC_FTDDRC010_pa_size );
EXPORT_SYMBOL( DDRC_FTDDRC010_va_base );
EXPORT_SYMBOL( DDRC_FTDDRC010_va_limit );
EXPORT_SYMBOL( DDRC_FTDDRC010_va_size );
/* AHBC */
EXPORT_SYMBOL( AHBC_FTAHBC010_pa_base );
EXPORT_SYMBOL( AHBC_FTAHBC010_pa_limit );
EXPORT_SYMBOL( AHBC_FTAHBC010_pa_size );
EXPORT_SYMBOL( AHBC_FTAHBC010_va_base );
EXPORT_SYMBOL( AHBC_FTAHBC010_va_limit );
EXPORT_SYMBOL( AHBC_FTAHBC010_va_size );
/* UART */
EXPORT_SYMBOL( UART_FTUART010_pa_base );
EXPORT_SYMBOL( UART_FTUART010_pa_limit );
EXPORT_SYMBOL( UART_FTUART010_pa_size );
EXPORT_SYMBOL( UART_FTUART010_va_base );
EXPORT_SYMBOL( UART_FTUART010_va_limit );
EXPORT_SYMBOL( UART_FTUART010_va_size );
/* TIMER */
EXPORT_SYMBOL( TIMER_FTTMR010_pa_base );
EXPORT_SYMBOL( TIMER_FTTMR010_pa_limit );
EXPORT_SYMBOL( TIMER_FTTMR010_pa_size );
EXPORT_SYMBOL( TIMER_FTTMR010_va_base );
EXPORT_SYMBOL( TIMER_FTTMR010_va_limit );
EXPORT_SYMBOL( TIMER_FTTMR010_va_size );
/* INTC */
EXPORT_SYMBOL( INTC_FTINTC010_pa_base );
EXPORT_SYMBOL( INTC_FTINTC010_pa_limit );
EXPORT_SYMBOL( INTC_FTINTC010_pa_size );
EXPORT_SYMBOL( INTC_FTINTC010_va_base );
EXPORT_SYMBOL( INTC_FTINTC010_va_limit );
EXPORT_SYMBOL( INTC_FTINTC010_va_size );
/* SRAM */
EXPORT_SYMBOL( SRAM_FTSMC010_pa_base );
EXPORT_SYMBOL( SRAM_FTSMC010_pa_limit );
EXPORT_SYMBOL( SRAM_FTSMC010_pa_size );
EXPORT_SYMBOL( SRAM_FTSMC010_va_base );
EXPORT_SYMBOL( SRAM_FTSMC010_va_limit );
EXPORT_SYMBOL( SRAM_FTSMC010_va_size );
/* NAND */
EXPORT_SYMBOL( NAND_FTNAND023_pa_base );
EXPORT_SYMBOL( NAND_FTNAND023_pa_limit );
EXPORT_SYMBOL( NAND_FTNAND023_pa_size );
EXPORT_SYMBOL( NAND_FTNAND023_va_base );
EXPORT_SYMBOL( NAND_FTNAND023_va_limit );
EXPORT_SYMBOL( NAND_FTNAND023_va_size );
/* NANDDP */
EXPORT_SYMBOL( NANDDP_FTNAND023_pa_base );
EXPORT_SYMBOL( NANDDP_FTNAND023_pa_limit );
EXPORT_SYMBOL( NANDDP_FTNAND023_pa_size );
EXPORT_SYMBOL( NANDDP_FTNAND023_va_base );
EXPORT_SYMBOL( NANDDP_FTNAND023_va_limit );
EXPORT_SYMBOL( NANDDP_FTNAND023_va_size );
/* USB */
EXPORT_SYMBOL( USB_FOTG2XX_pa_base );
EXPORT_SYMBOL( USB_FOTG2XX_pa_limit );
EXPORT_SYMBOL( USB_FOTG2XX_pa_size );
EXPORT_SYMBOL( USB_FOTG2XX_va_base );
EXPORT_SYMBOL( USB_FOTG2XX_va_limit );
EXPORT_SYMBOL( USB_FOTG2XX_va_size );
/* DMAC */
EXPORT_SYMBOL( DMAC_FTDMAC020_pa_base );
EXPORT_SYMBOL( DMAC_FTDMAC020_pa_limit );
EXPORT_SYMBOL( DMAC_FTDMAC020_pa_size );
EXPORT_SYMBOL( DMAC_FTDMAC020_va_base );
EXPORT_SYMBOL( DMAC_FTDMAC020_va_limit );
EXPORT_SYMBOL( DMAC_FTDMAC020_va_size );
/* APBBRG */
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_pa_base );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_pa_limit );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_pa_size );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_va_base );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_va_limit );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_va_size );

/*
 * Interrupt Dispatch Tables, for both FIQ and IRQ
 */

#ifdef IRQ_DISPATCH_TABLE
EXPORT_SYMBOL( irq_dispatch_table );
#endif

