/*
 *  linux/include/asm-arm/arch-faraday/platform-gm8126/spec.h
 *
 *  Faraday Platform Specification  (Automatically generated by "autospec", do not edit)
 *
 *  Copyright (C) 2010 Faraday Corp. (http://www.faraday-tech.com)
 *
 *  Platform Hierarchy :
 *
 *    GM8126
 *     +- CPU_FA626  (0)
 *     +- PMU_FTPMU010  (0)
 *     +- DDRC_FTDDRC010  (0)
 *     +- AHBC_FTAHBC010  (0)
 *     +- AHBC_FTAHBC010  (1)
 *     +- AHBC_FTAHBC010  (2)
 *     +- AHBC_FTAHBC010  (3)
 *     +- AHBC_FTAHBC010  (4)
 *     +- AHBC_FTAHBC010  (5)
 *     +- AHBC_FTAHBC010  (6)
 *     +- AHBC_FTAHBC010  (7)
 *     +- AHBC_FTAHBC010  (8)
 *     +- AHBC_FTAHBC010  (9)
 *     +- AHBC_FTAHBC010  (10)
 *     +- UART_FTUART010  (0)
 *     +- UART_FTUART010  (1)
 *     +- UART_FTUART010  (2)
 *     +- UART_FTUART010  (3)
 *     +- UART_FTUART010  (4)
 *     +- TIMER_FTTMR010  (0)
 *     +- INTC_FTINTC010  (0)
 *     +- SRAM_FTSMC010  (0)
 *     +- NAND_FTNAND023  (0)
 *     +- NANDDP_FTNAND023  (0)
 *     +- USB_FOTG2XX  (0)
 *     +- AHBDMA
 *     |   +- DMAC_FTDMAC020  (0)
 *     +- APBDMA
 *     |   +- APBBRG_FTAPBBRG020S  (0)
 *     +- FIQ_RELAY
 *         +- FIQ_RELAYER
 */

#ifndef __GM8126_PLATFORM_SPECIFICATION__
#define __GM8126_PLATFORM_SPECIFICATION__

#define PLATFORM_NAME	"Faraday GM8126"

/*
 * Component counts
 */

/* CPU */
#define CPU_COUNT	1
#define CPU_FA626_COUNT	1
/* PMU */
#define PMU_COUNT	1
#define PMU_FTPMU010_COUNT	1
/* DDRC */
#define DDRC_COUNT	1
#define DDRC_FTDDRC010_COUNT	1
/* AHBC */
#define AHBC_COUNT	11
#define AHBC_FTAHBC010_COUNT	11
/* UART */
#define UART_COUNT	5
#define UART_FTUART010_COUNT	5
/* TIMER */
#define TIMER_COUNT	1
#define TIMER_FTTMR010_COUNT	1
/* INTC */
#define INTC_COUNT	1
#define INTC_FTINTC010_COUNT	1
/* SRAM */
#define SRAM_COUNT	1
#define SRAM_FTSMC010_COUNT	1
/* NAND */
#define NAND_COUNT	1
#define NAND_FTNAND023_COUNT	1
/* NANDDP */
#define NANDDP_COUNT	1
#define NANDDP_FTNAND023_COUNT	1
/* USB */
#define USB_COUNT	1
#define USB_FOTG2XX_COUNT	1
/* AHBDMA */
#define AHBDMA_COUNT	1
/* APBDMA */
#define APBDMA_COUNT	1
/* FIQ_RELAY */
#define FIQ_RELAY_COUNT	1
/* DMAC */
#define DMAC_COUNT	1
#define DMAC_FTDMAC020_COUNT	1
/* APBBRG */
#define APBBRG_COUNT	1
#define APBBRG_FTAPBBRG020S_COUNT	1
/* FIQ_RELAYER */
#define FIQ_RELAYER_COUNT	1

/*
 * Hierarchial Component IDs
 */

#define PLATFORM_AHBDMA_DMAC_FTDMAC020_ID	0
#define PLATFORM_APBDMA_APBBRG_FTAPBBRG020S_ID	0
#define PLATFORM_FIQ_RELAY_FIQ_RELAYER_ID	0

/*
 * Number of interrupts, including IRQ and FIQ
 */

#define PLATFORM_IRQ_TOTALCOUNT	64
#define PLATFORM_FIQ_TOTALCOUNT	32
#define PLATFORM_AHBDMA_IRQ_TOTALCOUNT	8
#define PLATFORM_AHBDMA_FIQ_TOTALCOUNT	0
#define PLATFORM_APBDMA_IRQ_TOTALCOUNT	4
#define PLATFORM_APBDMA_FIQ_TOTALCOUNT	0
#define PLATFORM_FIQ_RELAY_IRQ_TOTALCOUNT	32
#define PLATFORM_FIQ_RELAY_FIQ_TOTALCOUNT	0

#define PLATFORM_IRQ_BASE	0
#define PLATFORM_FIQ_BASE	0
#define PLATFORM_AHBDMA_IRQ_BASE	1
#define PLATFORM_APBDMA_IRQ_BASE	2
#define PLATFORM_INTERRUPTS	64

/*
 * IRQ/FIQ trigger level and trigger mode
 */

#define PLATFORM_IRQ_TRIGGER_MODE	0x00000000
#define PLATFORM_IRQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_FIQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_AHBDMA_IRQ_TRIGGER_MODE	0x00000000
#define PLATFORM_AHBDMA_IRQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_AHBDMA_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_AHBDMA_FIQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_APBDMA_IRQ_TRIGGER_MODE	0x00000000
#define PLATFORM_APBDMA_IRQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_APBDMA_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_APBDMA_FIQ_TRIGGER_LEVEL	0xFFFFFFFF

/*
 * Interrupt numbers of Hierarchical Architecture
 */

/* AHBDMA */
#define PLATFORM_AHBDMA_IRQ	1

/* APBDMA */
#define PLATFORM_APBDMA_IRQ	2


/*
 * Interrrupt numbers
 */

/* UART */
#define UART_FTUART010_IRQ_COUNT	1
#define UART_FTUART010_IRQ	9
#define UART_FTUART010_0_IRQ	9
#define UART_FTUART010_1_IRQ	10
#define UART_FTUART010_2_IRQ	20
#define UART_FTUART010_3_IRQ	21
#define UART_FTUART010_4_IRQ	22

/* TIMER */
#define TIMER_FTTMR010_IRQ_COUNT	3
#define TIMER_FTTMR010_IRQ0	14
#define TIMER_FTTMR010_0_IRQ0	14
#define TIMER_FTTMR010_IRQ1	14
#define TIMER_FTTMR010_0_IRQ1	14
#define TIMER_FTTMR010_IRQ2	14
#define TIMER_FTTMR010_0_IRQ2	14

/* NAND */
#define NAND_FTNAND023_IRQ_COUNT	1
#define NAND_FTNAND023_IRQ	23
#define NAND_FTNAND023_0_IRQ	23

/* USB */
#define USB_FOTG2XX_IRQ_COUNT	1
#define USB_FOTG2XX_IRQ	4
#define USB_FOTG2XX_0_IRQ	4

/* DMAC */
#define DMAC_FTDMAC020_IRQ_COUNT	8
#define DMAC_FTDMAC020_IRQ0	1
#define DMAC_FTDMAC020_0_IRQ0	1
#define DMAC_FTDMAC020_IRQ1	1
#define DMAC_FTDMAC020_0_IRQ1	1
#define DMAC_FTDMAC020_IRQ2	1
#define DMAC_FTDMAC020_0_IRQ2	1
#define DMAC_FTDMAC020_IRQ3	1
#define DMAC_FTDMAC020_0_IRQ3	1
#define DMAC_FTDMAC020_IRQ4	1
#define DMAC_FTDMAC020_0_IRQ4	1
#define DMAC_FTDMAC020_IRQ5	1
#define DMAC_FTDMAC020_0_IRQ5	1
#define DMAC_FTDMAC020_IRQ6	1
#define DMAC_FTDMAC020_0_IRQ6	1
#define DMAC_FTDMAC020_IRQ7	1
#define DMAC_FTDMAC020_0_IRQ7	1

/* APBBRG */
#define APBBRG_FTAPBBRG020S_IRQ_COUNT	4
#define APBBRG_FTAPBBRG020S_IRQ0	2
#define APBBRG_FTAPBBRG020S_0_IRQ0	2
#define APBBRG_FTAPBBRG020S_IRQ1	2
#define APBBRG_FTAPBBRG020S_0_IRQ1	2
#define APBBRG_FTAPBBRG020S_IRQ2	2
#define APBBRG_FTAPBBRG020S_0_IRQ2	2
#define APBBRG_FTAPBBRG020S_IRQ3	2
#define APBBRG_FTAPBBRG020S_0_IRQ3	2

/*
 * Base addresses
 */

/* CPU */
#define CPU_MEM_PA_COUNT	1
#define CPU_MEM_PA_BASE	0x00000000
#define CPU_MEM_PA_LIMIT	0x05000000
#define CPU_MEM_PA_SIZE	0x05000001
#define CPU_MEM_0_PA_BASE	0x00000000
#define CPU_MEM_0_PA_LIMIT	0x05000000
#define CPU_MEM_0_PA_SIZE	0x05000001

/* PMU */
#define PMU_FTPMU010_PA_COUNT	1
#define PMU_FTPMU010_PA_BASE	0x99000000
#define PMU_FTPMU010_PA_LIMIT	0x990FFFFF
#define PMU_FTPMU010_PA_SIZE	0x00100000
#define PMU_FTPMU010_0_PA_BASE	0x99000000
#define PMU_FTPMU010_0_PA_LIMIT	0x990FFFFF
#define PMU_FTPMU010_0_PA_SIZE	0x00100000
#define PMU_FTPMU010_VA_COUNT	1
#define PMU_FTPMU010_VA_BASE	0xF9900000
#define PMU_FTPMU010_VA_LIMIT	0xF990FFFF
#define PMU_FTPMU010_VA_SIZE	0x00010000
#define PMU_FTPMU010_0_VA_BASE	0xF9900000
#define PMU_FTPMU010_0_VA_LIMIT	0xF990FFFF
#define PMU_FTPMU010_0_VA_SIZE	0x00010000

/* DDRC */
#define DDRC_FTDDRC010_PA_COUNT	1
#define DDRC_FTDDRC010_PA_BASE	0x99300000
#define DDRC_FTDDRC010_PA_LIMIT	0x99300FFF
#define DDRC_FTDDRC010_PA_SIZE	0x00001000
#define DDRC_FTDDRC010_0_PA_BASE	0x99300000
#define DDRC_FTDDRC010_0_PA_LIMIT	0x99300FFF
#define DDRC_FTDDRC010_0_PA_SIZE	0x00001000
#define DDRC_FTDDRC010_VA_COUNT	1
#define DDRC_FTDDRC010_VA_BASE	0xF9930000
#define DDRC_FTDDRC010_VA_LIMIT	0xF9930FFF
#define DDRC_FTDDRC010_VA_SIZE	0x00001000
#define DDRC_FTDDRC010_0_VA_BASE	0xF9930000
#define DDRC_FTDDRC010_0_VA_LIMIT	0xF9930FFF
#define DDRC_FTDDRC010_0_VA_SIZE	0x00001000

/* AHBC */
#define AHBC_FTAHBC010_PA_COUNT	1
#define AHBC_FTAHBC010_PA_BASE	0x90000000
#define AHBC_FTAHBC010_PA_LIMIT	0x90000FFF
#define AHBC_FTAHBC010_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_0_PA_BASE	0x90000000
#define AHBC_FTAHBC010_0_PA_LIMIT	0x90000FFF
#define AHBC_FTAHBC010_0_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_1_PA_BASE	0x90100000
#define AHBC_FTAHBC010_1_PA_LIMIT	0x90100FFF
#define AHBC_FTAHBC010_1_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_2_PA_BASE	0x90200000
#define AHBC_FTAHBC010_2_PA_LIMIT	0x90200FFF
#define AHBC_FTAHBC010_2_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_3_PA_BASE	0x90300000
#define AHBC_FTAHBC010_3_PA_LIMIT	0x90300FFF
#define AHBC_FTAHBC010_3_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_4_PA_BASE	0x90400000
#define AHBC_FTAHBC010_4_PA_LIMIT	0x90400FFF
#define AHBC_FTAHBC010_4_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_5_PA_BASE	0x90500000
#define AHBC_FTAHBC010_5_PA_LIMIT	0x90500FFF
#define AHBC_FTAHBC010_5_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_6_PA_BASE	0x90600000
#define AHBC_FTAHBC010_6_PA_LIMIT	0x90600FFF
#define AHBC_FTAHBC010_6_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_7_PA_BASE	0x90700000
#define AHBC_FTAHBC010_7_PA_LIMIT	0x90700FFF
#define AHBC_FTAHBC010_7_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_8_PA_BASE	0x90800000
#define AHBC_FTAHBC010_8_PA_LIMIT	0x90800FFF
#define AHBC_FTAHBC010_8_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_9_PA_BASE	0x90900000
#define AHBC_FTAHBC010_9_PA_LIMIT	0x90900FFF
#define AHBC_FTAHBC010_9_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_10_PA_BASE	0x90A00000
#define AHBC_FTAHBC010_10_PA_LIMIT	0x90A00FFF
#define AHBC_FTAHBC010_10_PA_SIZE	0x00001000
#define AHBC_FTAHBC010_VA_COUNT	1
#define AHBC_FTAHBC010_VA_BASE	0xF9000000
#define AHBC_FTAHBC010_VA_LIMIT	0xF9000FFF
#define AHBC_FTAHBC010_VA_SIZE	0x00001000
#define AHBC_FTAHBC010_0_VA_BASE	0xF9000000
#define AHBC_FTAHBC010_0_VA_LIMIT	0xF9000FFF
#define AHBC_FTAHBC010_0_VA_SIZE	0x00001000
#define AHBC_FTAHBC010_1_VA_BASE	0xF9010000
#define AHBC_FTAHBC010_1_VA_LIMIT	0xF9010FFF
#define AHBC_FTAHBC010_1_VA_SIZE	0x00001000
#define AHBC_FTAHBC010_2_VA_BASE	0xF9020000
#define AHBC_FTAHBC010_2_VA_LIMIT	0xF9020FFF
#define AHBC_FTAHBC010_2_VA_SIZE	0x00001000
#define AHBC_FTAHBC010_3_VA_BASE	0xF9030000
#define AHBC_FTAHBC010_3_VA_LIMIT	0xF9030FFF
#define AHBC_FTAHBC010_3_VA_SIZE	0x00001000
#define AHBC_FTAHBC010_4_VA_BASE	0xF9040000
#define AHBC_FTAHBC010_4_VA_LIMIT	0xF9040FFF
#define AHBC_FTAHBC010_4_VA_SIZE	0x00001000
#define AHBC_FTAHBC010_5_VA_BASE	0xF9050000
#define AHBC_FTAHBC010_5_VA_LIMIT	0xF9050FFF
#define AHBC_FTAHBC010_5_VA_SIZE	0x00001000
#define AHBC_FTAHBC010_6_VA_BASE	0xF9060000
#define AHBC_FTAHBC010_6_VA_LIMIT	0xF9060FFF
#define AHBC_FTAHBC010_6_VA_SIZE	0x00001000
#define AHBC_FTAHBC010_7_VA_BASE	0xF9070000
#define AHBC_FTAHBC010_7_VA_LIMIT	0xF9070FFF
#define AHBC_FTAHBC010_7_VA_SIZE	0x00001000
#define AHBC_FTAHBC010_8_VA_BASE	0xF9080000
#define AHBC_FTAHBC010_8_VA_LIMIT	0xF9080FFF
#define AHBC_FTAHBC010_8_VA_SIZE	0x00001000
#define AHBC_FTAHBC010_9_VA_BASE	0xF9090000
#define AHBC_FTAHBC010_9_VA_LIMIT	0xF9090FFF
#define AHBC_FTAHBC010_9_VA_SIZE	0x00001000
#define AHBC_FTAHBC010_10_VA_BASE	0xF90A0000
#define AHBC_FTAHBC010_10_VA_LIMIT	0xF90A0FFF
#define AHBC_FTAHBC010_10_VA_SIZE	0x00001000

/* UART */
#define UART_FTUART010_PA_COUNT	1
#define UART_FTUART010_PA_BASE	0x98300000
#define UART_FTUART010_PA_LIMIT	0x983FFFFF
#define UART_FTUART010_PA_SIZE	0x00100000
#define UART_FTUART010_0_PA_BASE	0x98300000
#define UART_FTUART010_0_PA_LIMIT	0x983FFFFF
#define UART_FTUART010_0_PA_SIZE	0x00100000
#define UART_FTUART010_1_PA_BASE	0x98400000
#define UART_FTUART010_1_PA_LIMIT	0x984FFFFF
#define UART_FTUART010_1_PA_SIZE	0x00100000
#define UART_FTUART010_2_PA_BASE	0x98500000
#define UART_FTUART010_2_PA_LIMIT	0x985FFFFF
#define UART_FTUART010_2_PA_SIZE	0x00100000
#define UART_FTUART010_3_PA_BASE	0x98800000
#define UART_FTUART010_3_PA_LIMIT	0x988FFFFF
#define UART_FTUART010_3_PA_SIZE	0x00100000
#define UART_FTUART010_4_PA_BASE	0x98900000
#define UART_FTUART010_4_PA_LIMIT	0x989FFFFF
#define UART_FTUART010_4_PA_SIZE	0x00100000
#define UART_FTUART010_VA_COUNT	1
#define UART_FTUART010_VA_BASE	0xF9830000
#define UART_FTUART010_VA_LIMIT	0xF9830FFF
#define UART_FTUART010_VA_SIZE	0x00001000
#define UART_FTUART010_0_VA_BASE	0xF9830000
#define UART_FTUART010_0_VA_LIMIT	0xF9830FFF
#define UART_FTUART010_0_VA_SIZE	0x00001000
#define UART_FTUART010_1_VA_BASE	0xF9840000
#define UART_FTUART010_1_VA_LIMIT	0xF9840FFF
#define UART_FTUART010_1_VA_SIZE	0x00001000
#define UART_FTUART010_2_VA_BASE	0xF9850000
#define UART_FTUART010_2_VA_LIMIT	0xF9850FFF
#define UART_FTUART010_2_VA_SIZE	0x00001000
#define UART_FTUART010_3_VA_BASE	0xF9880000
#define UART_FTUART010_3_VA_LIMIT	0xF9880FFF
#define UART_FTUART010_3_VA_SIZE	0x00001000
#define UART_FTUART010_4_VA_BASE	0xF9890000
#define UART_FTUART010_4_VA_LIMIT	0xF9890FFF
#define UART_FTUART010_4_VA_SIZE	0x00001000

/* TIMER */
#define TIMER_FTTMR010_PA_COUNT	1
#define TIMER_FTTMR010_PA_BASE	0x99100000
#define TIMER_FTTMR010_PA_LIMIT	0x9910000F
#define TIMER_FTTMR010_PA_SIZE	0x00000010
#define TIMER_FTTMR010_0_PA_BASE	0x99100000
#define TIMER_FTTMR010_0_PA_LIMIT	0x9910000F
#define TIMER_FTTMR010_0_PA_SIZE	0x00000010
#define TIMER_FTTMR010_VA_COUNT	1
#define TIMER_FTTMR010_VA_BASE	0xF9910000
#define TIMER_FTTMR010_VA_LIMIT	0xF9910FFF
#define TIMER_FTTMR010_VA_SIZE	0x00001000
#define TIMER_FTTMR010_0_VA_BASE	0xF9910000
#define TIMER_FTTMR010_0_VA_LIMIT	0xF9910FFF
#define TIMER_FTTMR010_0_VA_SIZE	0x00001000

/* INTC */
#define INTC_FTINTC010_PA_COUNT	1
#define INTC_FTINTC010_PA_BASE	0x99500000
#define INTC_FTINTC010_PA_LIMIT	0x995FFFFF
#define INTC_FTINTC010_PA_SIZE	0x00100000
#define INTC_FTINTC010_0_PA_BASE	0x99500000
#define INTC_FTINTC010_0_PA_LIMIT	0x995FFFFF
#define INTC_FTINTC010_0_PA_SIZE	0x00100000
#define INTC_FTINTC010_VA_COUNT	1
#define INTC_FTINTC010_VA_BASE	0xF9950000
#define INTC_FTINTC010_VA_LIMIT	0xF9950FFF
#define INTC_FTINTC010_VA_SIZE	0x00001000
#define INTC_FTINTC010_0_VA_BASE	0xF9950000
#define INTC_FTINTC010_0_VA_LIMIT	0xF9950FFF
#define INTC_FTINTC010_0_VA_SIZE	0x00001000

/* SRAM */
#define SRAM_FTSMC010_PA_COUNT	1
#define SRAM_FTSMC010_PA_BASE	0x92100000
#define SRAM_FTSMC010_PA_LIMIT	0x921FFFFF
#define SRAM_FTSMC010_PA_SIZE	0x00100000
#define SRAM_FTSMC010_0_PA_BASE	0x92100000
#define SRAM_FTSMC010_0_PA_LIMIT	0x921FFFFF
#define SRAM_FTSMC010_0_PA_SIZE	0x00100000
#define SRAM_FTSMC010_VA_COUNT	1
#define SRAM_FTSMC010_VA_BASE	0xF9210000
#define SRAM_FTSMC010_VA_LIMIT	0xF921FFFF
#define SRAM_FTSMC010_VA_SIZE	0x00010000
#define SRAM_FTSMC010_0_VA_BASE	0xF9210000
#define SRAM_FTSMC010_0_VA_LIMIT	0xF921FFFF
#define SRAM_FTSMC010_0_VA_SIZE	0x00010000

/* NAND */
#define NAND_FTNAND023_PA_COUNT	1
#define NAND_FTNAND023_PA_BASE	0x92C00000
#define NAND_FTNAND023_PA_LIMIT	0x92CFFFFF
#define NAND_FTNAND023_PA_SIZE	0x00100000
#define NAND_FTNAND023_0_PA_BASE	0x92C00000
#define NAND_FTNAND023_0_PA_LIMIT	0x92CFFFFF
#define NAND_FTNAND023_0_PA_SIZE	0x00100000
#define NAND_FTNAND023_VA_COUNT	1
#define NAND_FTNAND023_VA_BASE	0xF92C0000
#define NAND_FTNAND023_VA_LIMIT	0xF92CFFFF
#define NAND_FTNAND023_VA_SIZE	0x00010000
#define NAND_FTNAND023_0_VA_BASE	0xF92C0000
#define NAND_FTNAND023_0_VA_LIMIT	0xF92CFFFF
#define NAND_FTNAND023_0_VA_SIZE	0x00010000

/* NANDDP */
#define NANDDP_FTNAND023_PA_COUNT	1
#define NANDDP_FTNAND023_PA_BASE	0x96000000
#define NANDDP_FTNAND023_PA_LIMIT	0x960FFFFF
#define NANDDP_FTNAND023_PA_SIZE	0x00100000
#define NANDDP_FTNAND023_0_PA_BASE	0x96000000
#define NANDDP_FTNAND023_0_PA_LIMIT	0x960FFFFF
#define NANDDP_FTNAND023_0_PA_SIZE	0x00100000
#define NANDDP_FTNAND023_VA_COUNT	1
#define NANDDP_FTNAND023_VA_BASE	0xF9600000
#define NANDDP_FTNAND023_VA_LIMIT	0xF960FFFF
#define NANDDP_FTNAND023_VA_SIZE	0x00010000
#define NANDDP_FTNAND023_0_VA_BASE	0xF9600000
#define NANDDP_FTNAND023_0_VA_LIMIT	0xF960FFFF
#define NANDDP_FTNAND023_0_VA_SIZE	0x00010000

/* USB */
#define USB_FOTG2XX_PA_COUNT	1
#define USB_FOTG2XX_PA_BASE	0x92200000
#define USB_FOTG2XX_PA_LIMIT	0x92200FFF
#define USB_FOTG2XX_PA_SIZE	0x00001000
#define USB_FOTG2XX_0_PA_BASE	0x92200000
#define USB_FOTG2XX_0_PA_LIMIT	0x92200FFF
#define USB_FOTG2XX_0_PA_SIZE	0x00001000
#define USB_FOTG2XX_VA_COUNT	1
#define USB_FOTG2XX_VA_BASE	0xF9220000
#define USB_FOTG2XX_VA_LIMIT	0xF9220FFF
#define USB_FOTG2XX_VA_SIZE	0x00001000
#define USB_FOTG2XX_0_VA_BASE	0xF9220000
#define USB_FOTG2XX_0_VA_LIMIT	0xF9220FFF
#define USB_FOTG2XX_0_VA_SIZE	0x00001000

/* DMAC */
#define DMAC_FTDMAC020_PA_COUNT	1
#define DMAC_FTDMAC020_PA_BASE	0x92600000
#define DMAC_FTDMAC020_PA_LIMIT	0x926FFFFF
#define DMAC_FTDMAC020_PA_SIZE	0x00100000
#define DMAC_FTDMAC020_0_PA_BASE	0x92600000
#define DMAC_FTDMAC020_0_PA_LIMIT	0x926FFFFF
#define DMAC_FTDMAC020_0_PA_SIZE	0x00100000
#define DMAC_FTDMAC020_VA_COUNT	1
#define DMAC_FTDMAC020_VA_BASE	0xF9260000
#define DMAC_FTDMAC020_VA_LIMIT	0xF9260FFF
#define DMAC_FTDMAC020_VA_SIZE	0x00001000
#define DMAC_FTDMAC020_0_VA_BASE	0xF9260000
#define DMAC_FTDMAC020_0_VA_LIMIT	0xF9260FFF
#define DMAC_FTDMAC020_0_VA_SIZE	0x00001000

/* APBBRG */
#define APBBRG_FTAPBBRG020S_PA_COUNT	1
#define APBBRG_FTAPBBRG020S_PA_BASE	0x92000000
#define APBBRG_FTAPBBRG020S_PA_LIMIT	0x920FFFFF
#define APBBRG_FTAPBBRG020S_PA_SIZE	0x00100000
#define APBBRG_FTAPBBRG020S_0_PA_BASE	0x92000000
#define APBBRG_FTAPBBRG020S_0_PA_LIMIT	0x920FFFFF
#define APBBRG_FTAPBBRG020S_0_PA_SIZE	0x00100000
#define APBBRG_FTAPBBRG020S_VA_COUNT	1
#define APBBRG_FTAPBBRG020S_VA_BASE	0xF9200000
#define APBBRG_FTAPBBRG020S_VA_LIMIT	0xF9200FFF
#define APBBRG_FTAPBBRG020S_VA_SIZE	0x00001000
#define APBBRG_FTAPBBRG020S_0_VA_BASE	0xF9200000
#define APBBRG_FTAPBBRG020S_0_VA_LIMIT	0xF9200FFF
#define APBBRG_FTAPBBRG020S_0_VA_SIZE	0x00001000

#ifdef CONFIG_PLATFORM_AHBDMA_MODULE
#define CONFIG_PLATFORM_AHBDMA
#endif

#ifdef CONFIG_PLATFORM_AHBDMA
/* #undef FIQ_DISPATCH_TABLE */
#define IRQ_DISPATCH_TABLE 1
#endif

#ifdef CONFIG_PLATFORM_APBDMA_MODULE
#define CONFIG_PLATFORM_APBDMA
#endif

#ifdef CONFIG_PLATFORM_APBDMA
/* #undef FIQ_DISPATCH_TABLE */
#define IRQ_DISPATCH_TABLE 1
#endif

/*
 * C definitions
 */
#ifndef __ASSEMBLER__

#include <linux/linkage.h>

typedef asmlinkage unsigned interrupt_dispatch_function(unsigned);

#ifdef CONFIG_PLATFORM_APBDMA
extern interrupt_dispatch_function apbdma_irq2_dispatch;
#else
#define apbdma_irq2_dispatch 0
#endif

#ifdef CONFIG_PLATFORM_AHBDMA
extern interrupt_dispatch_function ahbdma_irq1_dispatch;
#else
#define ahbdma_irq1_dispatch 0
#endif

/*
 * Interrrupt numbers
 */

/* UART */
extern const unsigned char UART_FTUART010_irq[UART_FTUART010_COUNT];
/* TIMER */
extern const unsigned char TIMER_FTTMR010_irq[TIMER_FTTMR010_COUNT][TIMER_FTTMR010_IRQ_COUNT];
/* NAND */
extern const unsigned char NAND_FTNAND023_irq[NAND_FTNAND023_COUNT];
/* USB */
extern const unsigned char USB_FOTG2XX_irq[USB_FOTG2XX_COUNT];
/* DMAC */
extern const unsigned char DMAC_FTDMAC020_irq[DMAC_FTDMAC020_COUNT][DMAC_FTDMAC020_IRQ_COUNT];
/* APBBRG */
extern const unsigned char APBBRG_FTAPBBRG020S_irq[APBBRG_FTAPBBRG020S_COUNT][APBBRG_FTAPBBRG020S_IRQ_COUNT];

/*
 * Base addresses
 */

/* CPU */
extern const unsigned CPU_MEM_pa_base[CPU_MEM_PA_COUNT];
extern const unsigned CPU_MEM_pa_limit[CPU_MEM_PA_COUNT];
extern const unsigned CPU_MEM_pa_size[CPU_MEM_PA_COUNT];
/* PMU */
extern const unsigned PMU_FTPMU010_pa_base[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_pa_limit[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_pa_size[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_va_base[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_va_limit[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_va_size[PMU_FTPMU010_COUNT];
/* DDRC */
extern const unsigned DDRC_FTDDRC010_pa_base[DDRC_FTDDRC010_COUNT];
extern const unsigned DDRC_FTDDRC010_pa_limit[DDRC_FTDDRC010_COUNT];
extern const unsigned DDRC_FTDDRC010_pa_size[DDRC_FTDDRC010_COUNT];
extern const unsigned DDRC_FTDDRC010_va_base[DDRC_FTDDRC010_COUNT];
extern const unsigned DDRC_FTDDRC010_va_limit[DDRC_FTDDRC010_COUNT];
extern const unsigned DDRC_FTDDRC010_va_size[DDRC_FTDDRC010_COUNT];
/* AHBC */
extern const unsigned AHBC_FTAHBC010_pa_base[AHBC_FTAHBC010_COUNT];
extern const unsigned AHBC_FTAHBC010_pa_limit[AHBC_FTAHBC010_COUNT];
extern const unsigned AHBC_FTAHBC010_pa_size[AHBC_FTAHBC010_COUNT];
extern const unsigned AHBC_FTAHBC010_va_base[AHBC_FTAHBC010_COUNT];
extern const unsigned AHBC_FTAHBC010_va_limit[AHBC_FTAHBC010_COUNT];
extern const unsigned AHBC_FTAHBC010_va_size[AHBC_FTAHBC010_COUNT];
/* UART */
extern const unsigned UART_FTUART010_pa_base[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_pa_limit[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_pa_size[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_va_base[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_va_limit[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_va_size[UART_FTUART010_COUNT];
/* TIMER */
extern const unsigned TIMER_FTTMR010_pa_base[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_pa_limit[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_pa_size[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_va_base[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_va_limit[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_va_size[TIMER_FTTMR010_COUNT];
/* INTC */
extern const unsigned INTC_FTINTC010_pa_base[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_pa_limit[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_pa_size[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_va_base[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_va_limit[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_va_size[INTC_FTINTC010_COUNT];
/* SRAM */
extern const unsigned SRAM_FTSMC010_pa_base[SRAM_FTSMC010_COUNT];
extern const unsigned SRAM_FTSMC010_pa_limit[SRAM_FTSMC010_COUNT];
extern const unsigned SRAM_FTSMC010_pa_size[SRAM_FTSMC010_COUNT];
extern const unsigned SRAM_FTSMC010_va_base[SRAM_FTSMC010_COUNT];
extern const unsigned SRAM_FTSMC010_va_limit[SRAM_FTSMC010_COUNT];
extern const unsigned SRAM_FTSMC010_va_size[SRAM_FTSMC010_COUNT];
/* NAND */
extern const unsigned NAND_FTNAND023_pa_base[NAND_FTNAND023_COUNT];
extern const unsigned NAND_FTNAND023_pa_limit[NAND_FTNAND023_COUNT];
extern const unsigned NAND_FTNAND023_pa_size[NAND_FTNAND023_COUNT];
extern const unsigned NAND_FTNAND023_va_base[NAND_FTNAND023_COUNT];
extern const unsigned NAND_FTNAND023_va_limit[NAND_FTNAND023_COUNT];
extern const unsigned NAND_FTNAND023_va_size[NAND_FTNAND023_COUNT];
/* NANDDP */
extern const unsigned NANDDP_FTNAND023_pa_base[NANDDP_FTNAND023_COUNT];
extern const unsigned NANDDP_FTNAND023_pa_limit[NANDDP_FTNAND023_COUNT];
extern const unsigned NANDDP_FTNAND023_pa_size[NANDDP_FTNAND023_COUNT];
extern const unsigned NANDDP_FTNAND023_va_base[NANDDP_FTNAND023_COUNT];
extern const unsigned NANDDP_FTNAND023_va_limit[NANDDP_FTNAND023_COUNT];
extern const unsigned NANDDP_FTNAND023_va_size[NANDDP_FTNAND023_COUNT];
/* USB */
extern const unsigned USB_FOTG2XX_pa_base[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_pa_limit[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_pa_size[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_va_base[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_va_limit[USB_FOTG2XX_COUNT];
extern const unsigned USB_FOTG2XX_va_size[USB_FOTG2XX_COUNT];
/* DMAC */
extern const unsigned DMAC_FTDMAC020_pa_base[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_pa_limit[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_pa_size[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_va_base[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_va_limit[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_va_size[DMAC_FTDMAC020_COUNT];
/* APBBRG */
extern const unsigned APBBRG_FTAPBBRG020S_pa_base[APBBRG_FTAPBBRG020S_COUNT];
extern const unsigned APBBRG_FTAPBBRG020S_pa_limit[APBBRG_FTAPBBRG020S_COUNT];
extern const unsigned APBBRG_FTAPBBRG020S_pa_size[APBBRG_FTAPBBRG020S_COUNT];
extern const unsigned APBBRG_FTAPBBRG020S_va_base[APBBRG_FTAPBBRG020S_COUNT];
extern const unsigned APBBRG_FTAPBBRG020S_va_limit[APBBRG_FTAPBBRG020S_COUNT];
extern const unsigned APBBRG_FTAPBBRG020S_va_size[APBBRG_FTAPBBRG020S_COUNT];

/* IO mapping */
#define PLATFORM_IO_DESC_NR 26
struct map_desc;
//extern const struct map_desc platform_io_desc[PLATFORM_IO_DESC_NR];

#endif /* ifndef __ASSEMBLER__ */

#endif /* __GM8126_PLATFORM_SPECIFICATION__ */

