
##Setting parameter

###############################################################################
###  Customized Define
###############################################################################
ifeq ($(CONFIG_BRAND_NAME),LEVELONE)
CONFG_CFLAGS+=-DLEVELONE
endif

ifeq ($(CONFIG_BRAND_NAME),BRICKCOM)
CONFG_CFLAGS+=-DBRICKCOM
endif

ifeq ($(CONFIG_BRAND_NAME),WHITELEVEL)
CONFG_CFLAGS+=-DWHITELEVEL
CONFG_CFLAGS+=-DNETWORKCAMERA
endif

ifeq ($(CONFIG_BRAND_NAME),ANY)
CONFG_CFLAGS+=-DANY
endif

###############################################################################
###  Software Version Control
###############################################################################

CONFG_CFLAGS+=-DFW_VERSION=\"$(fw_version)\"
CONFG_CFLAGS+=-DFW_MINOR_VERSION=\"$(fw_minor_version)\"
date_var=`date +%Y-%m-%d_%H:%M:%S`
CONFG_CFLAGS+=-DCONFIG_SETTING_FW_DATE=\"$(date_var)\"

###############################################################################
###  Product Info Define
###############################################################################

CONFG_CFLAGS+=-DCONFIG_DBI_INAME=\"$(CONFIG_PRODUCT_INFO_Manufacturer)\"
CONFG_CFLAGS+=-DCONFIG_DBI_PNAME=\"$(CONFIG_PRODUCT_INFO_ModelName)\"
CONFG_CFLAGS+=-DCONFIG_DBI_COMMENTS=\"$(CONFIG_PRODUCT_INFO_COMMENTS)\"
CONFG_CFLAGS+=-DCONFIG_DBI_SNAME=\"$(CONFIG_PRODUCT_INFO_SeriesName)\"
CONFG_CFLAGS+=-DCONFIG_DBI_MNUMBER=\"$(CONFIG_PRODUCT_INFO_ModelNumber)\"
CONFG_CFLAGS+=-DCONFIG_DBI_URL=\"$(CONFIG_PRODUCT_INFO_Manufacturer_URL)\"
CONFG_CFLAGS+=-DCONFIG_DBI_CNAME=\"$(CONFIG_PRODUCT_INFO_CompanyName)\"
CONFG_CFLAGS+=-DCONFIG_DBI_DPNAME=\"$(CONFIG_PRODUCT_INFO_ProductName)\"
CONFG_CFLAGS+=-DCONFIG_PRODUCT_INFO_DefaultLanguage=\"$(CONFIG_PRODUCT_INFO_DefaultLanguage)\"


###############################################################################
###  ActiveX Version Control
###############################################################################

###White Label

#NetworkCamera
ifeq ($(CONFIG_PRODUCT_INFO_CompanyName),"NetworkCamera")
CONFIG_ACTIVE_VERSION="1,0,0,17"
CONFIG_ACTIVE_NAME="NetworkCamera.cab"
CONFIG_ACTIVE_CLSID="CLSID:DE15541B-2958-49F1-A159-BAB0D0A06CD1"

#Viotech
else ifeq ($(CONFIG_PRODUCT_INFO_CompanyName),"Viotech")
CONFIG_ACTIVE_VERSION="1,0,0,2"
CONFIG_ACTIVE_NAME="Viotech.cab"
CONFIG_ACTIVE_CLSID="CLSID:60684043-9FD0-4470-9221-1D7F9707A507"

#Bikal
else ifeq ($(CONFIG_PRODUCT_INFO_CompanyName),"Bikal")
CONFIG_ACTIVE_VERSION="1,0,0,1"
CONFIG_ACTIVE_NAME="Bikal.cab"
CONFIG_ACTIVE_CLSID="CLSID:FA535FBE-E807-40A1-82DF-0D43ACD5C6BB"

#FINE
else ifeq ($(CONFIG_PRODUCT_INFO_CompanyName),"FINE")
CONFIG_ACTIVE_VERSION="1,0,0,2"
CONFIG_ACTIVE_NAME="FinestSecurity.cab"
CONFIG_ACTIVE_CLSID="CLSID:4A5F57B7-6C9C-4D04-8801-5D473DA5112B"

#Gnomo
else ifeq ($(CONFIG_PRODUCT_INFO_CompanyName),"Gnomo")
CONFIG_ACTIVE_VERSION="1,0,0,1"
CONFIG_ACTIVE_NAME="Gnomo.cab"
CONFIG_ACTIVE_CLSID="CLSID:033FE8ED-6279-480E-96C8-4A162F7784BA"

#BlueEyes
else ifeq ($(CONFIG_PRODUCT_INFO_CompanyName),"BlueEyes")
CONFIG_ACTIVE_VERSION="1,0,0,2"
CONFIG_ACTIVE_NAME="BlueEyes.cab"
CONFIG_ACTIVE_CLSID="CLSID:FF1D4721-FF5C-4d94-A56A-4FB69517367E"

#GM-Innovation
else ifeq ($(CONFIG_PRODUCT_INFO_CompanyName),"GM-Innovation")
CONFIG_ACTIVE_VERSION="1,0,0,8"
CONFIG_ACTIVE_NAME="NetworkCamera.cab"
CONFIG_ACTIVE_CLSID="CLSID:DE15541B-2958-49F1-A159-BAB0D0A06CD1"

#HIC
else ifeq ($(CONFIG_PRODUCT_INFO_CompanyName),"HIC")
CONFIG_ACTIVE_VERSION="1,0,0,11"
CONFIG_ACTIVE_NAME="NetworkCamera.cab"
CONFIG_ACTIVE_CLSID="CLSID:DE15541B-2958-49F1-A159-BAB0D0A06CD1"

#STAR-NET
else ifeq ($(CONFIG_PRODUCT_INFO_CompanyName),"STAR-NET")
CONFIG_ACTIVE_VERSION="1,0,0,2"
CONFIG_ACTIVE_NAME="FujStarNet.cab"
CONFIG_ACTIVE_CLSID="CLSID:BDF129FA-6524-4397-AA8E-21D2E868885A"

#Zhixin
else ifeq ($(CONFIG_PRODUCT_INFO_CompanyName),"Zhixin")
CONFIG_ACTIVE_VERSION="1,0,0,11"
CONFIG_ACTIVE_NAME="NetworkCamera.cab"
CONFIG_ACTIVE_CLSID="CLSID:DE15541B-2958-49F1-A159-BAB0D0A06CD1"

#Octet
else ifeq ($(CONFIG_PRODUCT_INFO_CompanyName),"Octet")
CONFIG_ACTIVE_VERSION="1,0,0,1"
CONFIG_ACTIVE_NAME="Octet.cab"
CONFIG_ACTIVE_CLSID="CLSID:94F849E0-FEEA-41cf-BA3E-A3F8720AAC92"

#Promelit
else ifeq ($(CONFIG_PRODUCT_INFO_CompanyName),"Promelit")
CONFIG_ACTIVE_VERSION="1,0,0,1"
CONFIG_ACTIVE_NAME="Promelit.cab"
CONFIG_ACTIVE_CLSID="CLSID:DFD7D44F-5D0A-4DD4-AADA-6F1FAE15A3E5"

#Linear
else ifeq ($(CONFIG_PRODUCT_INFO_CompanyName),"Linear")
CONFIG_ACTIVE_VERSION="1,0,0,11"
CONFIG_ACTIVE_NAME="NetworkCamera.cab"
CONFIG_ACTIVE_CLSID="CLSID:DE15541B-2958-49F1-A159-BAB0D0A06CD1"

#Huadala
else ifeq ($(CONFIG_PRODUCT_INFO_CompanyName),"Huadala")
CONFIG_ACTIVE_VERSION="1,0,0,11"
CONFIG_ACTIVE_NAME="NetworkCamera.cab"
CONFIG_ACTIVE_CLSID="CLSID:DE15541B-2958-49F1-A159-BAB0D0A06CD1"

#TOPICA
else ifeq ($(CONFIG_PRODUCT_INFO_CompanyName),"TOPICA")
CONFIG_ACTIVE_VERSION="1,0,0,1"
CONFIG_ACTIVE_NAME="Topica.cab"
CONFIG_ACTIVE_CLSID="CLSID:99477088-D541-4C7E-945D-9E8854469CF5"

endif

CONFG_CFLAGS+=-DACTIVE_VERSION=\"$(CONFIG_ACTIVE_VERSION)\"
CONFG_CFLAGS+=-DACTIVE_NAME=\"$(CONFIG_ACTIVE_NAME)\"
CONFG_CFLAGS+=-DACTIVE_CLSID=\"$(CONFIG_ACTIVE_CLSID)\"


###############################################################################
###  Hardware Module Define
###############################################################################
CONFG_CFLAGS+=-DSAMBA_MOUNT_MODULE=0

ifeq ($(CONFIG_HW_MODULE_USB_STORAGE),1)
CONFG_CFLAGS+=-DUSB_STORAGE_MODULE=1
endif
CONFG_CFLAGS+=-DCONFIG_WIFI_DRIVER=\"$(CONFIG_HW_MODULE_WIFI)\"
CONFG_CFLAGS+=-DCONFIG_WHITEIRLED=0
CONFG_CFLAGS+=-DCONFIG_FW_FLASH_SIZE=$(CONFIG_FW_FLASH_SIZE)
CONFG_CFLAGS+=-DCONFIG_FW_MEMORY_SIZE=$(CONFIG_FW_MEMORY_SIZE)

###############################################################################
###  Application Module Define
###############################################################################

ifeq ($(CONFIG_APP_MODULE_EVENT_VER),1)
CONFG_CFLAGS+=-DCONFIG_OLD_EVENT=1
endif

## for PTZ module
CONFIG_IP2986=N
CONFIG_VISCA=N
CONFIG_MLP2=N
CONFIG_AFREEY=Y
export CONFIG_IP2986 CONFIG_VISCA CONFIG_MLP2 CONFIG_AFREEY
ifeq ($(CONFIG_IP2986),Y)
CONFG_CFLAGS+=-DCONFIG_IP2986_MODULE=1
endif
ifeq ($(CONFIG_VISCA),Y)
CONFG_CFLAGS+=-DCONFIG_VISCA_MODULE=1
endif
ifeq ($(CONFIG_MLP2),Y)
CONFG_CFLAGS+=-DCONFIG_MLP2=1
endif
ifeq ($(CONFIG_AFREEY),Y)
CONFG_CFLAGS+=-DCONFIG_AFREEY_MODULE=1
endif

ifeq ($(CONFIG_VIDEO_ENCRYPT),1)
CONFG_CFLAGS+=-DCONFIG_VIDEO_ENCRYPT=$(CONFIG_VIDEO_ENCRYPT)
endif

#ONVIF 0:close ,1: support 1.0 , 2:support  2.0  ,3:support 1.0 2.0
CONFG_CFLAGS+=-DCONFIG_ONVIF=$(CONFIG_ONVIF_SW)

#Brand Link feature  Y: support, N: not support
ifeq ($(CONFIG_BRAND_LINK_SUPPORT),Y)
CONFG_CFLAGS+=-DCONFIG_BRAND_LINK_SUPPORT=1
else
CONFG_CFLAGS+=-DCONFIG_BRAND_LINK_SUPPORT=0
endif

#Add Customized Config
ifeq ($(CONFIG_CUSTOMIZED),Y)
CONFG_CFLAGS+=-DCONFIG_CUSTOMIZED=1
CONFG_CFLAGS+=-DCONFIG_CUSTOMIZED_$(CONFIG_CUSTOMIZED_FILE)=1
else
CONFG_CFLAGS+=-DCONFIG_CUSTOMIZED=0
endif

#RTMP SERVER define
ifneq ($(CONFIG_RTMP_SERVER),0)
CONFG_CFLAGS+=-DCONFIG_RTMP_SERVER
endif

#Nuuolink P2P  Y: support, N: not support
ifeq ($(CONFIG_NUUOLINK_P2P),Y)
CONFG_CFLAGS+=-DCONFIG_NUUOLINK_P2P=1
endif

#GBT28181
ifeq ($(CONFIG_GBT28181),Y)
CONFG_CFLAGS+=-DCONFIG_GBT28181=1
endif

#KiWatch
ifeq ($(CONFIG_KIWATCH),Y)
CONFG_CFLAGS+=-DCONFIG_KIWATCH=1
else
CONFG_CFLAGS+=-DCONFIG_KIWATCH=0
endif

# ROI 
ifeq ($(CONFIG_ROI),Y)
CONFG_CFLAGS+=-DCONFIG_ROI=1
else
CONFG_CFLAGS+=-DCONFIG_ROI=0
endif

###############################################################################
###  Sensor Parameter Define
###############################################################################

CONFG_CFLAGS+=-DCONFIG_SENSOR_MAX_RESOLUTION_W=\"$(CONFIG_SENSOR_MAX_RESOLUTION_W)\"
CONFG_CFLAGS+=-DCONFIG_SENSOR_MAX_RESOLUTION_H=\"$(CONFIG_SENSOR_MAX_RESOLUTION_H)\"


#CGI PATH 
CONFG_CFLAGS+=-DCONFIG_API_PATH=\"$(CONFIG_API_PATH)\"

###############################################################################
###  Video/Audio Parameter Define
###############################################################################

ifeq ($(CONFIG_EZLINK_V2),Y)
CONFG_CFLAGS+=-DCONFIG_EZLINK=1
else
CONFG_CFLAGS+=-DCONFIG_EZLINK=0
endif

ifeq ($(CONFIG_ENABLED_TELNET),Y)
CONFG_CFLAGS+=-DENABLE_TELNETD
endif

ifeq ($(CONFIG_ISCSI),Y)
CONFG_CFLAGS+=-DCONFIG_OPEN_ISCSI
endif

export CONFG_CFLAGS
