/******************************************************************************
*
* Copyright 2013, Silicon Image, Inc.  All rights reserved.
* No part of this work may be reproduced, modified, distributed, transmitted,
* transcribed, or translated into any language or computer format, in any form
* or by any means without written permission of
* Silicon Image, Inc., 1140 East Arques Avenue, Sunnyvale, California 94085
*
*****************************************************************************/
/**
* @file si_lib_log_api.h
*
* @brief 
*
*****************************************************************************/

#ifndef __SI_LIB_LOG_API_H__
#define __SI_LIB_LOG_API_H__

/***** #include statements ***************************************************/

#include "si_datatypes.h"

/***** public macro definitions **********************************************/
#ifdef HDMI_DBG
#ifdef SII_DEBUG
#define SII_LIB_LOG_DEBUG1(obj, str)      { SiiLibLogTimeStamp(sSiiLibObjClassStr, obj); SiiLibLogPrintf str; }
#define SII_LIB_LOG_DEBUG2(str)           { SiiLibLogPrintf str; }
#else /* SII_DEBUG */
#define SII_LIB_LOG_DEBUG1(obj, str)
#define SII_LIB_LOG_DEBUG2(str)
#endif /* SII_DEBUG */

#define SII_LIB_LOG_PRINT1(obj, str)      { SiiLibLogTimeStamp(sSiiLibObjClassStr, obj); SiiLibLogPrintf str; }
#define SII_LIB_LOG_PRINT2(str)           { SiiLibLogPrintf str; }


#else /* HDMI_DBG */
#define SII_LIB_LOG_DEBUG1(...)
#define SII_LIB_LOG_DEBUG2(...)
#define SII_LIB_LOG_PRINT1(...)
#define SII_LIB_LOG_PRINT2(...)


#endif /* HDMI_DBG */




/***** public type definitions ***********************************************/

/***** public functions ******************************************************/

void SiiLibLogTimeStamp(const char* pClassStr, void* pObj);
void SiiLibLogPrintf( char* pFrm, ...);

#endif /* __SI_LIB_LOG_API_H__ */

/***** end of file ***********************************************************/
