/******************************************************************************

  Copyright (C), 2014-2024, Hisilicon Tech. Co., Ltd.

 ******************************************************************************
  File Name     : drv_hdmi_proc.c
  Version       : Initial Draft
  Author        : Hisilicon multimedia software group
  Created       : 2015/02/01
  Description   :
  History       :
  Date          : 2015/02/01
  Author        : t00273561
  Modification  :
*******************************************************************************/

#include "proc_ext.h"
#include "dev_ext.h"
#include "mod_ext.h"

#include "drv_hdmi_proc.h"
#include "drv_hdmi_intf.h"
#include "drv_hdmi_common.h"
#include "drv_hdmi_event.h"
#include "drv_hdmi_edid.h"



#define PROC_PRINT(fmt...)		seq_printf(pFile,fmt)
#ifndef ARRAY_SIZE
#define ARRAY_SIZE(a)		(sizeof(a)/sizeof(a[0]))
#endif
#define STR_YES				"YES"
#define STR_NO					"NO"
#define STR_ERROR				"ERROR"
#define STR_ENABLE				"ENABLE "
#define STR_DISABLE			"DISABLE"

#define 	PROC_FEILD_RATE_DEVIATION	50
#define 	PROC_PIXL_FREQ_DEVIATION	100
#define 	HDMI_VIC_PC_BASE 			((HDMI_VIC_VIRTUAL_BASE)+0x100)




#define CHECK_RET_SUCCESS(ret) \
	do{ 					 \
		if(HI_SUCCESS != ret){\
			printk("Error In %s,Line %d,return not success!\n",__FUNCTION__,__LINE__);	   \
			return ;\
		} \
	}while(0) 


#define CHECK_POINTER(p)		do{	\
	if(p==HI_NULL){					\
		printk("%s %d null pointer!\n",__FUNCTION__,__LINE__);	\
		return ;					\
	}								\
}while(0)

#if 0
typedef struct {
	HI_CHAR *pcOutColorSpace;
	HI_CHAR *pcColorimetry ;
	HI_CHAR *pcPixelRepetition;
	HI_CHAR *pcScanInfo;
	HI_CHAR *pcAspectRatio;
}HDMI_AVIIF_PARSE_S;

#endif	

typedef union
{
    struct
    {
        HI_U8    bzScanInfo            : 2   ; // [0..1] 
        HI_U8    bzBarDataPresent      : 2   ; // [2..3] 
        HI_U8    bzActFmtInfoPresent   : 1   ; // [5] 
        HI_U8    bzColorSpace          : 3   ; // [6..7] 
    } bits;

    HI_U8    u8;

} HDMI_AVIIF_BYTE1_U;

typedef union
{
    struct
    {
        HI_U8    bzActAspRatio         : 4   ; // [0..3] 
        HI_U8    bzPictureAspectRatio  : 2   ; // [4..5] 
        HI_U8    bzColorimetry         : 2   ; // [6..7] 
    } bits;

    HI_U8    u8;

} HDMI_AVIIF_BYTE2_U;



typedef union
{
    struct
    {
        HI_U8    bzPixelRepetition     	: 4   ; // [0..3] 
        HI_U8    bzITContentType   	   	: 2   ; // [4..5] 
        HI_U8    bzYCCQuantizationRange	: 2   ; // [6..7] 
    } bits;

    HI_U8    u8;

} HDMI_AVIIF_BYTE5_U;


typedef union
{
    struct
    {
        HI_U8    bzAudioChanelCnt     	: 3   ; // [0..2] 
        HI_U8    bzF13   	   			: 1   ; // [3] 
        HI_U8    bzAduioCodingType		: 4   ; // [4..7] 
    } bits;

    HI_U8    u8;

} HDMI_AUDIO_IF_BYTE1_U;

typedef union
{
    struct
    {
        HI_U8    bzAudioSampingSize     : 2   ; // [0..1] 
        HI_U8    bzAudioSampingFreq  	: 3   ; // [2..4] 
        HI_U8    bzF25toF27				: 3   ; // [5..7] 
    } bits;

    HI_U8    u8;

} HDMI_AUDIO_IF_BYTE2_U;

typedef union
{
	/* EIA-CEA-861-F P66 */
    struct
    {
        HI_U8    bzLFE_PlayBack     	: 2   ; // [0..1] 
        HI_U8    bzF52 	   				: 1   ; // [3] 
        HI_U8    bzLevelShiftValue 		: 3   ; // [4..6] 
        HI_U8    bzDownMixInhibit		: 1   ; // [7] 
    } bits;

    HI_U8    u8;

} HDMI_AUDIO_IF_BYTE5_U;

typedef struct 
{
	HI_U32				u32Vic; 
	HI_U32				u32PixlFreq;				/* KHz */
	HI_U32				u32HorActive;	
	HI_U32				u32VerActive;
	HI_U32				u32FieldRate;				/* 0.01Hz */
	HI_CHAR				*pcFormat;
}HDMI_FMT_NAME_PARAM_S;


const static HI_CHAR *s_aStr_LFE_PlayBack[] = 
{
	/* EIA-CEA-861-F P66 */
	"Un-known",			//0b00
	"0 dB",				//0b01
	"+10 dB",			//0b10
	"Reserved",			//0b11
	
};




const static HI_CHAR *s_aStrScanInfo[] = 
{
	/* EIA-CEA-861-F P43 */
	"No Data",			//0b00
	"overscanned",		//0b01
	"underscanned",		//0b10
	"Reserved",			//0b11
	
};

const static HI_CHAR *s_aStr_Colorimetry[] = 
{
	/* EIA-CEA-861-F P44 */
	"No Data",			//0b00
	"SMPTE 170M",		//0b01
	"ITU-R BT.709",		//0b10
	"Extended",			//0b11	
};

const static HI_CHAR *s_aStr_PictureAspectRatio[] = 
{
	/* EIA-CEA-861-F P44 */
	"No Data",			//0b00
	"4:3",				//0b01
	"16:9",				//0b10
	"Reserved",			//0b11	
};


const static HI_CHAR *s_aStrPixelRepetition[] = 
{
	"No Repetition",	//0b0000
	"2 times",			//0b0001
	"3 times",			//0b0010
	"4 times",			//0b0011
	"5 times",			//0b0100
	"6 times",			//0b0101
	"7 times",			//0b0110
	"8 times",			//0b0111
	"9 times",			//0b1000
	"10 times",			//0b1001
	"Reserved",			//0x0a
	"Reserved",			//0x0b
	"Reserved",			//0x0c
	"Reserved",			//0x0d
	"Reserved",			//0x0e
	"Reserved",			//0x0f
};


const static HI_CHAR *s_aStrAudioCodingType[] = 
{
	/* EIA-CEA-861-F P62 */
	"Stream head",		//0b0000
	"L-PCM",			//0b0001
	"AC-3",				//0b0010
	"MPEG-1",			//0b0011
	"MP3",				//0b0100
	"MPEG2",			//0b0101
	"AAC LC",			//0b0110
	"DTS",				//0b0111
	"ATRAC",			//0b1000
	"OneBitAudio",		//0b1001
	"EnhancedAC3",		//0b1010
	"DTS-HD",			//0b1011
	"MAT",				//0b1100
	"DST",				//0b1101
	"WMA Pro",			//0b1110
	"Extension",		//0b1111
};


const static HI_CHAR *s_aStrAudioChannelCnt[] = 
{
	/* EIA-CEA-861-F P62 */
	"Stream header",	//0b000
	"2 channels",		//0b001
	"3 channels",		//0b010
	"4 channels",		//0b011
	"5 channels",		//0b100
	"6 channels",		//0b101
	"7 channels",		//0b110
	"8 channels",		//0b111
};


const static HI_CHAR *s_aStrAudioSampingFreq[] = 
{
	/* EIA-CEA-861-F P62 */
	"Stream header",	//0b000
	"32 kHz",			//0b001
	"44.1 kHz",			//0b010
	"48 kHz",			//0b011
	"88.2 kHz",			//0b100
	"96 kHz",			//0b101
	"176.4 kHz",		//0b110
	"192 kHz",			//0b111
};


const static HI_CHAR *s_aStrAudioSampingSize[] = 
{
	/* EIA-CEA-861-F P62 */
	"Stream header",	//0b00
	"16 bit",			//0b01
	"20 bit",			//0b10
	"24 bit",			//0b11	
};



const static HI_CHAR *s_aStrRunState[] = 
{
	"NONE",				//HDMI_RUN_STATE_NONE 	= 0x00,
    "INIT",				//HDMI_RUN_STATE_INIT 	= 0x01,
    "OPEN",				//HDMI_RUN_STATE_OPEN 	= 0x02,
    "START",			//HDMI_RUN_STATE_START 	= 0x04,
    "STOP",				//HDMI_RUN_STATE_STOP 	= 0x08,
    "CLOSE",			//HDMI_RUN_STATE_CLOSE 	= 0x10, 
    "DEINIT",			//HDMI_RUN_STATE_DEINIT 	= 0x20,

};

const static HI_CHAR *s_aSrt_enTransitionState[]=

{
    "NONE",				//HDMI_TRANSITION_NONE = 0x0,
    "BOOT_MCE",			//HDMI_TRANSITION_BOOT_MCE = 0x1,
    "MCE_BOOT",			//HDMI_TRANSITION_MCE_APP = 0x2,
    "BOOT_APP",			//HDMI_TRANSITION_BOOT_APP = 0x4,
};


const static HI_CHAR *s_aStrTmdsMode[] =
{
    "NONE",				//HDMI_TMDS_MODE_NONE = 0,
    "DVI",				//HDMI_TMDS_MODE_DVI = 1,
    "HDMI1.4",			//HDMI_TMDS_MODE_HDMI_1_4 = 2,
    "HDMI2.0",			//HDMI_TMDS_MODE_HDMI_2_0 =3,
    "AUTO",				//HDMI_TMDS_MODE_AUTO = 4,
};

const static HI_CHAR *s_aStr_enHdcpMode[] =
{
	"NONE",				//HDMI_HDCP_MODE_NONE = 0,
    "HDCP1.4",			//HDMI_HDCP_MODE_1_4 = 1,
    "HDCP2.2",			//HDMI_HDCP_MODE_2_2=2,
    "AUTO",				//HDMI_HDCP_MODE_AUTO=3,
};

const static HI_CHAR *s_aStr_u8Network[] =
{
	"TV",				//HDMI_CEC_LOGICALADD_TV               = 0X00, 
    "RECORDDEV_1",		//HDMI_CEC_LOGICALADD_RECORDDEV_1      = 0X01, 
    "RECORDDEV_2",		//HDMI_CEC_LOGICALADD_RECORDDEV_2      = 0X02, 
    "TUNER_1",			//HDMI_CEC_LOGICALADD_TUNER_1          = 0X03, 
    "PLAYDEV_1",		//HDMI_CEC_LOGICALADD_PLAYDEV_1        = 0X04,
    "AUDIOSYSTEM",		//HDMI_CEC_LOGICALADD_AUDIOSYSTEM      = 0X05,
    "TUNER_2",			//HDMI_CEC_LOGICALADD_TUNER_2          = 0X06,
    "TUNER_3",			//HDMI_CEC_LOGICALADD_TUNER_3          = 0X07, 
    "PLAYDEV_2",		//HDMI_CEC_LOGICALADD_PLAYDEV_2        = 0X08, 
    "RECORDDEV_3",		//HDMI_CEC_LOGICALADD_RECORDDEV_3      = 0X09, 
    "TUNER_4",			//HDMI_CEC_LOGICALADD_TUNER_4          = 0X0A, 
    "PLAYDEV_3",		//HDMI_CEC_LOGICALADD_PLAYDEV_3        = 0X0B, 
    "RESERVED_1",		//HDMI_CEC_LOGICALADD_RESERVED_1       = 0X0C, 
    "RESERVED_2",		//HDMI_CEC_LOGICALADD_RESERVED_2       = 0X0D, 
    "SPECIALUSE",		//HDMI_CEC_LOGICALADD_SPECIALUSE       = 0X0E, 
    "BROADCAST",		//HDMI_CEC_LOGICALADD_BROADCAST        = 0X0F, 
						//HDMI_CEC_LOGICALADD_BUTT
};

const static HI_CHAR *s_aStr_ColorSpace[] =
{
	/* EIA-CEA-861-F P43 */
	"RGB",				//HDMI_COLORSPACE_RGB = 0, 		0b000
	"YCbCr422",			//HDMI_COLORSPACE_YCbCr422 =1 ,	0b001
	"YCbCr444",			//HDMI_COLORSPACE_YCbCr444 = 2,	0b010
	"YCbCr420",			//HDMI_COLORSPACE_YCbCr420 = 3,	0b011
	"Reserved",			//0b100
	"Reserved",			//0b101
	"Reserved",			//0b110
	"IDO-Defined",		//0b111

};
	

const static HI_CHAR *s_aStr_enOutBitDepth[] =
{
	"08 bit",			//HDMI_VIDEO_BITDEPTH_8 = 0,         
	"10 bit",			//HDMI_VIDEO_BITDEPTH_10 =1,        
	"12 bit",			//HDMI_VIDEO_BITDEPTH_12 =2,        
	"16 bit",			//HDMI_VIDEO_BITDEPTH_16 = 3,  
};

const static HI_CHAR *s_aStr_SoundIntf[] =
{
    "I2S",				//HDMI_AUDIO_INTERFACE__I2S = 0,
    "SPDIF",			//HDMI_AUDIO_INTERFACE__SPDIF = 1, 
    "HBRA",				//HDMI_AUDIO_INTERFACE__HBRA = 2, 
    "ERROR",			//HDMI_AUDIO_INTERFACE__BUTT
};



const static HI_CHAR *s_aStr_HvSyncPol[] =
{
	"HPVP",				//HDMI_HV_SYNC_POL_HPVP = 0,
	"HPVN",				//HDMI_HV_SYNC_POL_HPVN = 1,
	"HNVP",				//HDMI_HV_SYNC_POL_HNVP = 2,
	"HNVN",				//HDMI_HV_SYNC_POL_HNVN = 3
};

const static HI_CHAR *s_aStr_Speaker[] =
{

	"FL_FR",			//HDMI_EDID_AUDIO_SPEAKER_FL_FR   ,
    "LFE",				//HDMI_EDID_AUDIO_SPEAKER_LFE     , 
    "FC",				//HDMI_EDID_AUDIO_SPEAKER_FC      , 
    "RL_RR",			//HDMI_EDID_AUDIO_SPEAKER_RL_RR   ,
    "RC",				//HDMI_EDID_AUDIO_SPEAKER_RC      ,
    "FLC_FRC",			//HDMI_EDID_AUDIO_SPEAKER_FLC_FRC , 
    "RLC_RRC",			//HDMI_EDID_AUDIO_SPEAKER_RLC_RRC ,
    "FLW_FRW",			//HDMI_EDID_AUDIO_SPEAKER_FLW_FRW ,
    "FLH_FRH",			//HDMI_EDID_AUDIO_SPEAKER_FLH_FRH ,
    "TC",				//HDMI_EDID_AUDIO_SPEAKER_TC      ,
    "FCH",				//HDMI_EDID_AUDIO_SPEAKER_FCH     ,
						//HDMI_EDID_AUDIO_SPEAKER_BUTT    ,
};

const static HI_CHAR *s_aStr_3DType[] =
{
	"FPK",				//HDMI_EDID_3D_FRAME_PACKETING				 = 0x00, /**<3d type:Frame Packing*/
	"FIELD_ALTER",		//HDMI_EDID_3D_FIELD_ALTERNATIVE				 = 0x01, /**<3d type:Field alternative*/
	"LINE_ALTER",		//HDMI_EDID_3D_LINE_ALTERNATIVE				 = 0x02, /**<3d type:Line alternative*/
	"SBS_full",			//HDMI_EDID_3D_SIDE_BY_SIDE_FULL				 = 0x03, /**<3d type:Side by side full*/
	"L_DEPTH",			//HDMI_EDID_3D_L_DEPTH						 = 0x04, /**<3d type:L+depth*/
	"LdGGd",			//HDMI_EDID_3D_L_DEPTH_GRAPHICS_GRAPHICS_DEPTH = 0x05, /**<3d type:L+depth+Graphics+Graphics-depth*/
	"TAB",				//HDMI_EDID_3D_TOP_AND_BOTTOM 				 = 0x06, /**<3d type:Top and Bottom*/
	"SBS_half",			//HDMI_EDID_3D_SIDE_BY_SIDE_HALF
};

const static HI_CHAR *s_aStr_EstabTiming[] =
{
	/*VESA Enhanced EDID Standard Release A, Rev.1 Page 16 */
	"V800X600_60",			//HDMI_EDID_ESTABTIMG_VESA_800X600_60 		,0
	"V800X600_56",			//HDMI_EDID_ESTABTIMG_VESA_800X600_56			,
	"V640X480_75",			//HDMI_EDID_ESTABTIMG_VESA_640X480_75			,
	"V640X480_72",			//HDMI_EDID_ESTABTIMG_VESA_640X480_72			,
	"V640X480_67",			//HDMI_EDID_ESTABTIMG_IBM_VGA_640X480_67		,
	"V640X480_60",			//HDMI_EDID_ESTABTIMG_IBM_XGA_640X480_60		,5
	"V720X400_88",			//HDMI_EDID_ESTABTIMG_IBM_XGA2_720X400_88		,
	"V720X400_70",			//HDMI_EDID_ESTABTIMG_IBM_XGA_720X400_70		,
	
	"V1280X1024_75",			//HDMI_EDID_ESTABTIMG_VESA_1280X1024_75		,
	"V1024X768_75",			//HDMI_EDID_ESTABTIMG_VESA_1024X768_75		,
	"V1024X768_70",			//HDMI_EDID_ESTABTIMG_VESA_1024X768_70		,
	"V1024X768_60",			//HDMI_EDID_ESTABTIMG_VESA_1024X768_60		,11
	"V1024X768_87",			//HDMI_EDID_ESTABTIMG_IBM_1024X768_87			,
	"V832X624_75",			//HDMI_EDID_ESTABTIMG_APPLE_MACII_832X624_75	,
	"V800X600_75",			//HDMI_EDID_ESTABTIMG_VESA_800X600_75			,
	"V800X600_72",			//HDMI_EDID_ESTABTIMG_VESA_800X600_72			,

	"V1152X870_75",			//HDMI_EDID_ESTABTIMG_VESA_1152X870_75		,
	
							//HDMI_EDID_ESTABTIMG_BUTT					,

};

static const HDMI_FMT_NAME_PARAM_S s_stFmtParam[]=
{
	/********************VIC,PixFfeq  , HACT ,VACT,FldRate,    Fmt************************/
	{						 1, 25175 ,  640 ,480 , 6000 ,	"640X480_60"	},		// 1. 640 x 480p @ 60 VGA
	{						 2, 27000 ,  720 ,480 , 6000 ,	"480P_60"		},		// 2,3 720 x 480p
	{						 3, 27000 ,  720 ,480 , 6000 ,	"480P_60"		},		// 2,3 720 x 480p
	{						 4, 74170 ,  1280,720 , 6000 ,	"720P_60"		},		// 4   1280 x 720p
	{						 5, 74170 ,  1920,1080, 6000 ,	"1080i_60" 		},		// 5 1920 x 1080i
	{						 6, 27000 ,  720 ,480 , 6000 ,	"NTSC" 			},		// 6,7 720 x 480i, pix repl
	{						 7, 27000 ,  720 ,480 , 6000 ,	"NTSC" 			},		// 6,7 720 x 480i, pix repl
	
	{						16, 148500,  1920,1080, 6000 ,	"1080P_60" 		},		// 16 1920 x 1080p
	{						17, 27000 ,  720 ,576 , 5000 ,	"576P_50"		},		// 17,18 720 x 576p
	{						18, 27000 ,  720 ,576 , 5000 ,	"576P_50"		},		// 17,18 720 x 576p
	{						19, 74250 ,  1280,720 , 5000 ,	"720P_50"		},		// 19 1280 x 720p
	{						20, 74250 ,  1920,1080, 5000 ,	"1080i_50" 		},		// 20 1920 x 1080i
	{						21, 27000 ,  1440,576 , 5000 ,	"PAL"			},		// 21,22 1440 x 576i
	{						22, 27000 ,  1440,576 , 5000 ,	"PAL"			},		// 21,22 1440 x 576i
	
	/********************VIC,PixFfeq  , HACT ,VACT,FldRate,    Fmt************************/
	{						31, 148500,  1440,576 , 5000 ,	"1080P_50" 		},		// 31(1) 1920 x 1080p
	{						32, 74170 ,  1920,1080, 2400 ,	"1080P_24" 		},		// 32(2) 1920 x 1080p
	{						33, 74250 ,  1920,1080, 2500 ,	"1080P_25" 		},		// 33(3) 1920 x 1080p
	{						34, 74170 ,  1920,1080, 3000 ,	"1080P_30" 		},		// 34(4) 1920 x 1080p
	
#if defined (DVI_SUPPORT)
	/********************VIC,PixFfeq  , HACT ,VACT,FldRate,    Fmt************************/
	
	{ HDMI_VIC_PC_BASE+ 	 9, 40000 , 800 ,600 ,	6000 ,	"800X600_60"	},		// 800x600@60.317
	{ HDMI_VIC_PC_BASE+ 	13, 65000 , 1024,768 ,	6000 ,	"1024X768_60"	},		// 1024x768@60
	{ HDMI_VIC_PC_BASE+ 	18, 162000, 1600,1200,	6000 ,	"1600X1200_60"	},		// 1600x1200@60

	/********************VIC,PixFfeq  , HACT ,VACT,FldRate,    Fmt************************/
	{ HDMI_VIC_PC_BASE+ 	25, 108000, 1280,1024,	6000 ,	"1280X1024_60"	},		// 1280x1024@60
	{ HDMI_VIC_PC_BASE+ 	28, 85500 , 1360,768 ,	6000 ,	"1366X768_60"	},		// 1360x768@60
	{ HDMI_VIC_PC_BASE+ 	41, 154000, 1920,1200,	6000 ,	"1920X1200_60"	},		// 1920x1200@59.95
#endif
	/*for 2k & 4k ,we use VIRTUAL VIC*/
	{ HDMI_EDID_VIRTUAL_VIC_3840X2160_30, 297000,  3840,2160, 3000 ,	"2160P_30" 		}, 		// 1 2160P@30,3840X2160_30
	{ HDMI_EDID_VIRTUAL_VIC_3840X2160_25, 297000,  3840,2160, 2500 ,	"2160P_25" 		}, 		// 2 2160P@25,3840X2160_25
	{ HDMI_EDID_VIRTUAL_VIC_3840X2160_24, 297000,  3840,2160, 2400 ,	"2160P_24" 		}, 		// 3 2160P@24,3840X2160_24
	{ HDMI_EDID_VIRTUAL_VIC_4096X2160_24, 297000,  4096,2160, 2400 ,	"4K*2K_24" 		}, 		// 4 4k*2K SMTP 4096*2160_24

};

#if 0
static HI_CHAR * Proc_Etablish2Format(HI_U32 u32EtablishCode)
{
	HI_U32 i = 0;
	HDMI_ESTAB_FORMAT_S *pstEstabTiming = HI_NULL;

	for (i=0;i<ARRAY_SIZE(s_aStr_EstabTiming);i++)
	{
		pstEstabTiming = (HDMI_ESTAB_FORMAT_S *)&s_aStr_EstabTiming[i];
		if (   pstEstabTiming != HI_NULL
			&& pstEstabTiming->u32EtablishCode == u32EtablishCode)
		{
			return pstEstabTiming->pcFormat;
		}
	}

	return HI_NULL;
	
}

static HI_CHAR * Proc_PreTiming2Format(HDMI_EDID_PRE_TIMING_S *pstPreTiming)
{
	HI_U32 i = 0;
	HDMI_FMT_NAME_PARAM_S *pstFmtParam = HI_NULL;

	if (pstPreTiming == HI_NULL)
	{
		return HI_NULL;
	}

	for (i=0;i<ARRAY_SIZE(s_stFmtParam);i++)
	{
		pstFmtParam = (HDMI_FMT_NAME_PARAM_S *)&s_stFmtParam[i];
		if (   (pstFmtParam != HI_NULL)
			&& (pstFmtParam->u32HorActive == pstPreTiming->u32HACT)
			&& (pstFmtParam->u32VerActive == pstPreTiming->u32VACT)
			&& (pstFmtParam->u32PixlFreq >= pstPreTiming->u32PixelClk)
			&& ((pstFmtParam->u32PixlFreq-PROC_PIXL_FREQ_DEVIATION) <= pstPreTiming->u32PixelClk)  )
		{
			return pstFmtParam->pcFormat;
		}
	}

	return HI_NULL;
	
}

#endif
static HI_CHAR * Proc_Vic2Format(HI_U32 u32Vic)
{
	HI_U32 i = 0;
	HDMI_FMT_NAME_PARAM_S *pstFmtParam = HI_NULL;

	for (i=0;i<ARRAY_SIZE(s_stFmtParam);i++)
	{
		pstFmtParam = (HDMI_FMT_NAME_PARAM_S *)&s_stFmtParam[i];
		if (   (pstFmtParam != HI_NULL)
			&& (pstFmtParam->u32Vic == u32Vic)    )
		{
			return pstFmtParam->pcFormat;
		}
	}

	return HI_NULL;
	
}


static HI_CHAR * Proc_StdTiming2Format(HDMI_EDID_STD_TIMING_S *pstStdTiming)
{
	HI_U32 i = 0;
	HDMI_FMT_NAME_PARAM_S *pstFmtParam = HI_NULL;

	if (pstStdTiming == HI_NULL)
	{
		return HI_NULL;
	}

	for (i=0;i<ARRAY_SIZE(s_stFmtParam);i++)
	{
		pstFmtParam = (HDMI_FMT_NAME_PARAM_S *)&s_stFmtParam[i];
		if (   (pstFmtParam != HI_NULL) 
			&& (pstFmtParam->u32HorActive == pstStdTiming->u32HorActive)
			&& (pstFmtParam->u32VerActive == pstStdTiming->u32VerActive)
			&& (pstFmtParam->u32FieldRate >= pstStdTiming->u32RefreshRate)
			&& ((pstFmtParam->u32FieldRate-PROC_FEILD_RATE_DEVIATION) <= pstStdTiming->u32RefreshRate)  )
		{
			return pstFmtParam->pcFormat;
		}
	}

	return HI_NULL;
	
}




static HI_VOID ProcSrc_GlobleSoftStatusPrint(struct seq_file *pFile,HDMI_DEVICE_ID_E enHdmiID)
{
	HDMI_DEVICE_S *pstHdmiDev = HI_NULL;
	HI_U32 i=0;
	HI_U32 u32Tmp = 0;
	pstHdmiDev = GetHdmiDevice(enHdmiID);

	PROC_PRINT("-------------------------------- [GlobalSoftStatus] -----------------------------\n");

	CHECK_POINTER(pstHdmiDev);
	
	/* line 1 */
	PROC_PRINT("%-20s: %-15s  |","enTmdsMode",s_aStrTmdsMode[pstHdmiDev->enTmdsMode]);
	PROC_PRINT("%-20s:", "enRunState");
	if (pstHdmiDev->enRunState != HDMI_RUN_STATE_NONE)
	{
		for (i=0;i<ARRAY_SIZE(s_aStrRunState);i++)
		{
			if (pstHdmiDev->enRunState & (1<<i))
			{
				PROC_PRINT(" %s", s_aStrRunState[i]);
			}
		}
	}
	else
	{
		PROC_PRINT(" %s", s_aStrRunState[HDMI_RUN_STATE_NONE]);
	}
	PROC_PRINT("\n");

	/* line 2 */
	PROC_PRINT("%-20s: %-15s  |", "kThreadTimerStat",(pstHdmiDev->stThreadInfo.kThreadTimerSate==HDMI_THREAD_STATE_STATR)?"RUN":"STOP");		
	PROC_PRINT("%-20s:", "enTransitionState");
	if (pstHdmiDev->enTransitionState != HDMI_TRANSITION_NONE)
	{
		for (i=0;i<ARRAY_SIZE(s_aSrt_enTransitionState);i++)
		{
			if (pstHdmiDev->enRunState & (1<<i))
			{
				PROC_PRINT(" %s", s_aSrt_enTransitionState[i]);
			}
		}
	}
	else
	{
		PROC_PRINT(" %s", s_aSrt_enTransitionState[HDMI_TRANSITION_NONE]);
	}
	PROC_PRINT("\n");

	/* line 3 */
	PROC_PRINT("%-20s: %-15u  |",  "u32KernelCnt",pstHdmiDev->u32KernelCnt);
	PROC_PRINT("%-20s: %-15u  \n", "u32UserCnt",pstHdmiDev->u32UserCnt);

	/* line 4*/
	PROC_PRINT("%-20s: %-15s  |",  "bHdcpIsOn",pstHdmiDev->stHdcpInfo.bHdcpIsOn ? STR_YES : STR_NO);
	if (pstHdmiDev->stHdcpInfo.enHdcpMode < ARRAY_SIZE(s_aStr_enHdcpMode))
	{
		PROC_PRINT("%-20s: %-15s  \n", "enHdcpMode",s_aStr_enHdcpMode[pstHdmiDev->stHdcpInfo.enHdcpMode]);
	}
	else
	{
		PROC_PRINT("%-20s: %-15s  \n", "enHdcpMode",STR_ERROR);
	}
	/* line 5*/
	PROC_PRINT("%-20s: %-15s  |",  "bHdcp1Prep",pstHdmiDev->stHdcpInfo.bHdcp1Prep ? STR_YES : STR_NO);
	//PROC_PRINT("%-20s: %-15s  \n", "bHdcp2Prep",pstHdmiDev->stHdcpInfo.bHdcp2Prep ? STR_YES : STR_NO);
	PROC_PRINT("\n");
	/* line 6*/
	PROC_PRINT("%-20s: %-15s  |",  "bCecIsOn",pstHdmiDev->stCecInfo.bCecIsOn ? STR_YES : STR_NO);
	PROC_PRINT("%-20s:",  "u8CecNetwork");
	for (i = 0,u32Tmp = HI_FALSE; i < ARRAY_SIZE(s_aStr_u8Network); i++)
	{
		if (pstHdmiDev->stCecInfo.u8Network[i])
		{
			u32Tmp = HI_TRUE;
			PROC_PRINT(" %s", s_aStr_u8Network[i]);
		}
	}
	if (u32Tmp==HI_FALSE)
	{
		PROC_PRINT(" %s", "NONE");
	}
	PROC_PRINT("\n");

	/* line 7*/
	PROC_PRINT("%-20s: %-15x  |",  "u8LogicalAddr",pstHdmiDev->stCecInfo.u8LogicalAddr);
	PROC_PRINT("%-20s: %02x.%02x.%02x.%02x  \n",  "u8PhysicalAddr",
							pstHdmiDev->stCecInfo.u8PhysicalAddr[0],
							pstHdmiDev->stCecInfo.u8PhysicalAddr[1],
							pstHdmiDev->stCecInfo.u8PhysicalAddr[2],
							pstHdmiDev->stCecInfo.u8PhysicalAddr[3]);
	
	
	PROC_PRINT("\n");
	
	
}


static HI_VOID ProcSrc_HardWareStatusPrint(struct seq_file *pFile,HDMI_DEVICE_ID_E enHdmiID)
{
	HI_U32 i=0;
//	HI_U32 u32Tmp = 0;
	HI_CHAR *pTmpFmt = HI_NULL;
	HI_U8 *paData = HI_NULL;
	HDMI_DEVICE_S *pstHdmiDev = GetHdmiDevice(enHdmiID);
	HDMI_HAL_S  *pstHdmiHal	= HI_NULL;
	HDMI_HARDWARE_STATUS_S	stHwStatus;
	HDMI_AVIIF_BYTE1_U	unAviByte1 ;
	HDMI_AVIIF_BYTE2_U	unAviByte2 ;
	HDMI_AVIIF_BYTE5_U	unAviByte5 ;

	HDMI_AUDIO_IF_BYTE1_U unAudioByte1 ;
	HDMI_AUDIO_IF_BYTE2_U unAudioByte2 ;
	HDMI_AUDIO_IF_BYTE5_U unAudioByte5 ;
	
	
	PROC_PRINT("---------------------------------- [HardWare Status] ----------------------------\n");

	CHECK_POINTER(pstHdmiDev);
	pstHdmiHal = pstHdmiDev->pstHdmiHal;
	CHECK_POINTER(pstHdmiHal);

	pstHdmiHal->HAL_HDMI_HardwareStatusGet(pstHdmiHal,&stHwStatus);
	
	/* line 1 */
	if (stHwStatus.stCommonStatus.enTmdsMode < ARRAY_SIZE(s_aStrTmdsMode))
	{
		PROC_PRINT("%-20s: %-15s  |", 	"enTmdsMode",s_aStrTmdsMode[stHwStatus.stCommonStatus.enTmdsMode]);
	}
	else
	{
		PROC_PRINT("%-20s: %-15s  |",	"enTmdsMode",STR_ERROR);
	}
	PROC_PRINT("%-20s: %-15s  \n",	"bHotPlug",stHwStatus.stCommonStatus.bHotPlug ? STR_YES : STR_NO);
	
	/* line 2 */	
	PROC_PRINT("%-20s: %-15s  |",	"bAvMute",stHwStatus.stCommonStatus.bAvMute ? STR_YES : STR_NO);
	PROC_PRINT("%-20s: %-15s  \n", 	"bRsen",stHwStatus.stCommonStatus.bRsen ? STR_YES : STR_NO);

	/* line 3 */
	PROC_PRINT("%-20s: %-15s  |",	"bPhyOe",stHwStatus.stPhyStatus.bPhyOe ? STR_YES : STR_NO);
	PROC_PRINT("%-20s: %-15s  \n", 	"enDeepColor",stHwStatus.stPhyStatus.enDeepColor ? STR_YES : STR_NO);

	/* line 4 */
	PROC_PRINT("%-20s: %-15s  \n",	"bPhyPowerOn",stHwStatus.stPhyStatus.bPhyPowerOn ? STR_YES : STR_NO);

	/* Hardware Video/Audio Path */
	PROC_PRINT("------------HW Video Path--------------|---------------HW Audio Path-------------\n");
	
	/* line 1 */
	PROC_PRINT("%-20s: %-15s  |",	"bDither",stHwStatus.stVideoStatus.bDither ? STR_YES : STR_NO);
	PROC_PRINT("%-20s: %-15s  \n", 	"bAudioEnable",stHwStatus.stAudioStatus.bAudioEnable ? STR_YES : STR_NO);

	/* line 2 */
	PROC_PRINT("%-20s: %-15s  |",	"bIn420Ydemux",stHwStatus.stVideoStatus.bIn420Ydemux ? STR_YES : STR_NO);
	PROC_PRINT("%-20s: %-15s  \n", 	"bAudioMute",stHwStatus.stAudioStatus.bAudioMute ? STR_YES : STR_NO);

	/* line 3 */
	PROC_PRINT("%-20s: %-15s  |",	"bOut420Ydemux",stHwStatus.stVideoStatus.bOut420Ydemux ? STR_YES : STR_NO);
	PROC_PRINT("%-20s: %-15s  \n", 	"bDownSample",stHwStatus.stAudioStatus.bDownSample ? STR_YES : STR_NO);

	/* line 4 */
	if (stHwStatus.stVideoStatus.enInColorSpace < ARRAY_SIZE(s_aStr_ColorSpace))
	{
		PROC_PRINT("%-20s: %-15s  |",	"enInColorSpace",s_aStr_ColorSpace[stHwStatus.stVideoStatus.enInColorSpace]);
	}
	else
	{
		PROC_PRINT("%-20s: %-15s  |",	"enInColorSpace",STR_ERROR);
	}

	if (  (stHwStatus.stAudioStatus.enLayout <= HDMI_AUDIO_FORMAT_8CH)
		&&(stHwStatus.stAudioStatus.enLayout >= HDMI_AUDIO_FORMAT_2CH)  )
	{
		PROC_PRINT("%-20s: %-15d  \n",	"enLayout channel",stHwStatus.stAudioStatus.enLayout);
	}
	else
	{
		PROC_PRINT("%-20s: %-15s  \n",	"enLayout channel", STR_ERROR);
	}

	/* line 5 */
	if (stHwStatus.stVideoStatus.enOutColorSpace < ARRAY_SIZE(s_aStr_ColorSpace))
	{
		PROC_PRINT("%-20s: %-15s  |",	"enOutColorSpace",s_aStr_ColorSpace[stHwStatus.stVideoStatus.enOutColorSpace]);
	}
	else
	{
		PROC_PRINT("%-20s: %-15s  |",	"enOutColorSpace",STR_ERROR);
	}
	PROC_PRINT("%-20s: %-15d  \n", 	"enSampleDepth",stHwStatus.stAudioStatus.enSampleDepth);

	/* line 6 */
	if (stHwStatus.stVideoStatus.enOutBitDepth < ARRAY_SIZE(s_aStr_ColorSpace))
	{
		PROC_PRINT("%-20s: %-15s  |",	"enOutBitDepth",s_aStr_enOutBitDepth[stHwStatus.stVideoStatus.enOutBitDepth] );
	}
	else
	{
		PROC_PRINT("%-20s: %-15s  |",	"enOutBitDepth",STR_ERROR );
	}

	if (stHwStatus.stVideoStatus.enOutBitDepth < ARRAY_SIZE(s_aStr_SoundIntf))
	{
		PROC_PRINT("%-20s: %-15s  \n", 	"enSoundIntf",s_aStr_SoundIntf[stHwStatus.stAudioStatus.enSoundIntf]);
	}
	else
	{
		PROC_PRINT("%-20s: %-15s  \n", 	"enSoundIntf",STR_ERROR);	
	}
	
	/* line 7 */
	if (stHwStatus.stVideoStatus.enOutBitDepth < ARRAY_SIZE(s_aStr_HvSyncPol))
	{
		PROC_PRINT("%-20s: %-15s  |",	"enHvSyncPol",s_aStr_HvSyncPol[stHwStatus.stVideoStatus.enHvSyncPol]);
	}
	else
	{
		PROC_PRINT("%-20s: %-15s  |",	"enHvSyncPol",STR_ERROR);
	}
	PROC_PRINT("%-20s: %-15d  \n",	"enSampleFs",stHwStatus.stAudioStatus.enSampleFs);
	
	/* line 8 */
	PROC_PRINT("%-20s: %-15s  |",	"bRGB2YCbCr",stHwStatus.stVideoStatus.bRGB2YCbCr ? STR_YES : STR_NO);
	PROC_PRINT("%-20s: %-15s  \n",	"N Value","NONE");

	/* line 9 */
	PROC_PRINT("%-20s: %-15s  |",	"bRGB2YCbCr",stHwStatus.stVideoStatus.bYCbCr2RGB? STR_YES : STR_NO);
	PROC_PRINT("%-20s: %-15s  \n",	"bYCbCr420_422",stHwStatus.stVideoStatus.bYCbCr420_422? STR_YES : STR_NO);

	/* line 10 */
	PROC_PRINT("%-20s: %-15s  |",	"bYCbCr422_420",stHwStatus.stVideoStatus.bYCbCr422_420? STR_YES : STR_NO);
	PROC_PRINT("%-20s: %-15s  \n",	"bYCbCr422_444",stHwStatus.stVideoStatus.bYCbCr422_444? STR_YES : STR_NO);

	/* line 11 */
	PROC_PRINT("%-20s: %-15s  |",	"bYCbCr444_422",stHwStatus.stVideoStatus.bYCbCr444_422? STR_YES : STR_NO);
	PROC_PRINT("%-20s: %-15s  \n",	"bYCbCr422_444",stHwStatus.stVideoStatus.bYCbCr422_444? STR_YES : STR_NO);

	/* Info frame parse */
	PROC_PRINT("------------IF Video Parse-------------|--------------IF Audio Parse-------------\n");
	
	unAviByte1.u8 = stHwStatus.stInfoFrameStatus.u8AVI[4];
	unAviByte2.u8 = stHwStatus.stInfoFrameStatus.u8AVI[5];
	unAviByte5.u8 = stHwStatus.stInfoFrameStatus.u8AVI[9];

	unAudioByte1.u8 = stHwStatus.stInfoFrameStatus.u8AUDIO[4];
	unAudioByte2.u8 = stHwStatus.stInfoFrameStatus.u8AUDIO[5];
	unAudioByte5.u8 = stHwStatus.stInfoFrameStatus.u8AUDIO[9];

	/* line 6 */
	PROC_PRINT("%-20s: %-15s  |",	"ColorSpace",s_aStr_ColorSpace[unAviByte1.bits.bzColorSpace]);
	PROC_PRINT("%-20s: %-15s  \n",	"AduioCodingType",s_aStrAudioCodingType[unAudioByte1.bits.bzAduioCodingType]);
	/* line 7 */
	
	pTmpFmt = Proc_Vic2Format(stHwStatus.stInfoFrameStatus.u8AVI[7]);
	PROC_PRINT("%-20s: %-13s(%2d)|",	"Current Format", pTmpFmt==HI_NULL ? "" : pTmpFmt,stHwStatus.stInfoFrameStatus.u8AVI[7]);	
	//PROC_PRINT("%-20s: 0x%02x(%-2u)%-9s|",	"Vedio ID Code",stHwStatus.stInfoFrameStatus.u8AVI[7],stHwStatus.stInfoFrameStatus.u8AVI[7],"");
	PROC_PRINT("%-20s: %-15s  \n",	"AudioChanelCnt",s_aStrAudioChannelCnt[unAudioByte1.bits.bzAudioChanelCnt]);

	/* line 8 */
	PROC_PRINT("%-20s: %-15s  |",	"ScanInfo",s_aStrScanInfo[unAviByte1.bits.bzScanInfo]);
	PROC_PRINT("%-20s: %-15s  \n",	"AudioSampingSize",s_aStrAudioSampingSize[unAudioByte2.bits.bzAudioSampingSize]);

	/* line 9 */
	PROC_PRINT("%-20s: %-15s  |",	"Colorimetry",s_aStr_Colorimetry[unAviByte2.bits.bzColorimetry]);
	PROC_PRINT("%-20s: %-15s  \n",	"AudioSampingFreq",s_aStrAudioSampingFreq[unAudioByte2.bits.bzAudioSampingFreq]);

	/* line 10 */
	PROC_PRINT("%-20s: %-15s  |",	"PictureAspectRatio",s_aStr_PictureAspectRatio[unAviByte2.bits.bzPictureAspectRatio]);
	PROC_PRINT("%-20s: %-15s  \n",	"LFE_PlayBack",s_aStr_LFE_PlayBack[unAudioByte5.bits.bzLFE_PlayBack]);

	/* line 11 */
	PROC_PRINT("%-20s: %-15s  |",	"PixelRepetition",s_aStrPixelRepetition[unAviByte5.bits.bzPixelRepetition]);
	PROC_PRINT("%-20s: %-5d dB\n",	"LevelShiftValue",unAudioByte5.bits.bzLevelShiftValue);

	/* Info Frame Raw Data */
	PROC_PRINT("------------------------------ [Info Frame RawData] ----------------------------\n");

	/* line 1 */
	PROC_PRINT("[HEX]%s%10s:",	"AVI  ",stHwStatus.stInfoFrameStatus.bAVIEnable ? STR_ENABLE : STR_DISABLE);
	paData = stHwStatus.stInfoFrameStatus.u8AVI;
	for (i = 0;i < paData[2]+4 && i < ARRAY_SIZE(stHwStatus.stInfoFrameStatus.u8AVI) ; i++)
	{
		if ( i == 20 )
		{
			PROC_PRINT("\n%21s","");
		}
		if ( (i%4) == 0 )
		{
			if (i==0)
			{
				PROC_PRINT("[");	
			}
			else
			{
				PROC_PRINT("  ");	
			}
		}
		
		PROC_PRINT(" %02x",stHwStatus.stInfoFrameStatus.u8AVI[i]);
		if (i==3)
		{
			PROC_PRINT("]");	
		}
	}
	PROC_PRINT("\n"); 

	/* line 2 */
	PROC_PRINT("[HEX]%s%10s:",	"AUDIO",stHwStatus.stInfoFrameStatus.bAUDIOEnable ? STR_ENABLE : STR_DISABLE);
	paData = stHwStatus.stInfoFrameStatus.u8AUDIO;
	for (i = 0;i < paData[2]+4 && i < ARRAY_SIZE(stHwStatus.stInfoFrameStatus.u8AUDIO) ; i++)
	{
		if ( i == 20 )
		{
			PROC_PRINT("\n%21s","");
		}
		if ( (i%4) == 0 )
		{
			if (i==0)
			{
				PROC_PRINT("[");	
			}
			else
			{
				PROC_PRINT("  ");	
			}
		}
		
		PROC_PRINT(" %02x",stHwStatus.stInfoFrameStatus.u8AUDIO[i]);
		if (i==3)
		{
			PROC_PRINT("]");	
		}
	}
	PROC_PRINT("\n");

	/* line 3 */
	PROC_PRINT("[HEX]%s%10s:",	"VS   ",stHwStatus.stInfoFrameStatus.bVSIFEnable ? STR_ENABLE : STR_DISABLE);
	paData = stHwStatus.stInfoFrameStatus.u8VSIF;
	for (i = 0;i < paData[2]+4 && i < ARRAY_SIZE(stHwStatus.stInfoFrameStatus.u8VSIF) ; i++)
	{
		if ( i == 20 )
		{
			PROC_PRINT("\n%21s","");
		}
		if ( (i%4) == 0 )
		{
			if (i==0)
			{
				PROC_PRINT("[");	
			}
			else
			{
				PROC_PRINT("  ");	
			}
		}
		
		PROC_PRINT(" %02x",stHwStatus.stInfoFrameStatus.u8VSIF[i]);
		if (i==3)
		{
			PROC_PRINT("]");	
		}
	}
	PROC_PRINT("\n");

	/* line 4 */
	PROC_PRINT("[HEX]%s%10s:",	"MPEG ",stHwStatus.stInfoFrameStatus.bMPEGEnable? STR_ENABLE : STR_DISABLE);
	paData = stHwStatus.stInfoFrameStatus.u8MPEG;
	for (i = 0;i < paData[2]+4 &&  i < ARRAY_SIZE(stHwStatus.stInfoFrameStatus.u8MPEG) ; i++)
	{
		if ( i == 20 )
		{
			PROC_PRINT("\n%21s","");
		}
		if ( (i%4) == 0 )
		{
			if (i==0)
			{
				PROC_PRINT("[");	
			}
			else
			{
				PROC_PRINT("  ");	
			}
		}
		
		PROC_PRINT(" %02x",stHwStatus.stInfoFrameStatus.u8MPEG[i]);
		if (i==3)
		{
			PROC_PRINT("]");	
		}
	}
	PROC_PRINT("\n");

	/* line 5 */
	PROC_PRINT("[HEX]%s%10s:",	"SPD  ",stHwStatus.stInfoFrameStatus.bSPDEnable ? STR_ENABLE : STR_DISABLE);
	paData = stHwStatus.stInfoFrameStatus.u8SPD;
	for (i = 0;i < paData[2]+4 && i < ARRAY_SIZE(stHwStatus.stInfoFrameStatus.u8SPD) ; i++)
	{
		if ( i == 20 )
		{
			PROC_PRINT("\n%21s","");
		}
		if ( (i%4) == 0 )
		{
			if (i==0)
			{
				PROC_PRINT("[");	
			}
			else
			{
				PROC_PRINT("  ");	
			}
		}
		PROC_PRINT(" %02x",stHwStatus.stInfoFrameStatus.u8SPD[i]);
		if (i==3)
		{
			PROC_PRINT("]");	
		}
	}
	PROC_PRINT("\n");
		
	PROC_PRINT("\n");

}


static HI_VOID ProcSrc_EventInfoPrint(struct seq_file *pFile,HDMI_DEVICE_ID_E enHdmiID)
{
	HI_U32 					i=0,j=0;
	HI_U32 					u32TotalPool = 0;
 	HI_S32 					s32Ret = HI_SUCCESS;
	HDMI_DEVICE_S 			*pstHdmiDev = GetHdmiDevice(enHdmiID);
	HDMI_EVENT_INFO_S 		*pstEvtInfo = HI_NULL;
	HDMI_EVENT_RUN_CNT_S 	stRunCnt;
	HDMI_EVENT_RUN_CTRL_S 	stCtrl;
	
	CHECK_POINTER(pstHdmiDev);
	pstEvtInfo = &pstHdmiDev->stEventInfo;
	CHECK_POINTER(pstEvtInfo);

	s32Ret = DRV_HDMI_EventPoolTotalGet(pstEvtInfo,&u32TotalPool);
	CHECK_RET_SUCCESS(s32Ret);

	for (i = 0; i < u32TotalPool; i++)
	{
		if(DRV_HDMI_EventPoolStatusGet(pstEvtInfo,i+1,&stCtrl,&stRunCnt)==HI_SUCCESS)
		{
			PROC_PRINT("------------------------ [TaskID=%u Event Pool[%u] Status] ------------------------\n",stCtrl.u32PoolID,i);
			/* line1 */
			PROC_PRINT("CNT|%-8s|%-8s|%-8s|%-8s|%-8s|%-8s|%-8s|%-8s|%-8s\n",
												"ErrTotal",
												"HPD",
												"UnHPD",
												"EdidFail",
												"HdcpFail",
												"HdcpSucc",
												"RsenCon",
												"RsenDis",
												"HdcpUsr");
			/* line2 */
			PROC_PRINT("WR:|%-8u|%-8u|%-8u|%-8u|%-8u|%-8u|%-8u|%-8u|%-8u\n",
												stRunCnt.u32ErrWdCnt,
												stRunCnt.u32HPDWrCnt,	
												stRunCnt.u32UnHPDWrCnt,	
												stRunCnt.u32EdidFailWrCnt,
												stRunCnt.u32HdcpFailWrCnt,
												stRunCnt.u32HdcpSuccWrCnt,
												stRunCnt.u32RsenConWrCnt,
												stRunCnt.u32RsenDisWrCnt,
												stRunCnt.u32HdcpUserWrCnt);
			/* line3 */
			PROC_PRINT("RD:|%-8u|%-8u|%-8u|%-8u|%-8u|%-8u|%-8u|%-8u|%-8u\n",
												stRunCnt.u32ErrRdCnt,
												stRunCnt.u32HPDRdCnt,		
												stRunCnt.u32UnHPDRdCnt,
												stRunCnt.u32EdidFailRdCnt,
												stRunCnt.u32HdcpFailRdCnt,
												stRunCnt.u32HdcpSuccRdCnt,
												stRunCnt.u32RsenConRdCnt,
												stRunCnt.u32RsenDisRdCnt,
												stRunCnt.u32HdcpUserRdCnt);
			/* line4 */
			PROC_PRINT("Data[WkFlg=%1d |RdAble=%2d/%-2d| RdPtr=%-2d| WrPtr=%-2d](H):",
												stCtrl.bWakeUpFlag,
												stCtrl.u32RdAbleCnt,
												ARRAY_SIZE(stCtrl.enEventPool),
												stCtrl.u32ReadPtr,
												stCtrl.u32WritePtr);
			
			for (j = 0; j < ARRAY_SIZE(stCtrl.enEventPool); j++)
			{
				if ( j == 5 )
				{
					PROC_PRINT("  ");
				}
				PROC_PRINT(" %02x",stCtrl.enEventPool[j] );
			}
			
			PROC_PRINT("\n");
		}
	}

	return ;
}

static HI_VOID ProcSrc_EdidInfoPrint(struct seq_file *pFile,HDMI_DEVICE_ID_E enHdmiID)
{
	HI_S32 					i = 0,j=0;
 	HI_U32			 		s32Ret = HI_SUCCESS;
	HDMI_EDID_DATA_E 		eRet = HI_SUCCESS;
	HI_S32					s32RawLen = 0;
	HDMI_EDID_STATUS_S		stStatus;					
	HI_U8					*pu8EdidRaw = HI_NULL;
	HI_CHAR					*pTmpFmt = HI_NULL;
	HI_CHAR					aTmpArray[20];
	HDMI_SINK_CAPABILITY_S	*pstCap = HI_NULL;
	HDMI_EDID_INFO_S		*pstEdidInfo = HI_NULL;
	HDMI_DEVICE_S 			*pstHdmiDev = GetHdmiDevice(enHdmiID);

	CHECK_POINTER(pstHdmiDev);
	pstEdidInfo = &pstHdmiDev->stEdidInfo;
	CHECK_POINTER(pstEdidInfo);

	pu8EdidRaw = (HI_U8 *)HDMI_KMALLOC(HDMI_EDID_TOTAL_SIZE);
	CHECK_POINTER(pu8EdidRaw);

	s32Ret = DRV_HDMI_EdidStatusGet(pstEdidInfo,&stStatus);
	if (s32Ret != HI_SUCCESS)
	{
		HDMI_ERR("Get edid stat!\n");
		HDMI_KFREE(pu8EdidRaw);
		return ;
	}

	memset(aTmpArray,'\0',sizeof(aTmpArray));

	/* line 1 */
	PROC_PRINT("%-20s: %-15s  |",	"bCapSink",stStatus.bCapSink ? STR_YES : STR_NO);
	PROC_PRINT("%-20s: %-15s  \n",	"bCapValid",stStatus.bCapValid ? STR_YES : STR_NO);
	/* line 2 */
	PROC_PRINT("%-20s: %-15s  |",	"bRawValid",stStatus.bRawValid ? STR_YES : STR_NO);
	PROC_PRINT("%-20s: %-15d   \n", "u32RawLen",stStatus.u32RawLen);
	/* line 3 */
	PROC_PRINT("%-20s: %-15d  |",	"enParseErr",stStatus.enParseErr);
	PROC_PRINT("%-20s: %-15x  \n",	"u32ParseWarn",stStatus.u32ParseWarn);
	/* line 4 */
	PROC_PRINT("%-20s: %-15d  |",	"u32RawGetErrCnt",stStatus.u32RawGetErrCnt);
	PROC_PRINT("%-20s: %-15d  \n",  "u32CapGetErrCnt",stStatus.u32CapGetErrCnt);
	/* line 5 */
	PROC_PRINT("%-20s: %-15d  |",	"u32RawUpdateErrCnt",stStatus.u32RawUpdateErrCnt);
	PROC_PRINT("%-20s: %-15s  \n",	"bCapValid",stStatus.bCapValid ? STR_YES : STR_NO);

	s32RawLen = HDMI_EDID_TOTAL_SIZE;
	s32RawLen = DRV_HDMI_EdidRawForceGet(pstEdidInfo,pu8EdidRaw,s32RawLen);
	if (s32RawLen < 0)
	{
		HDMI_ERR("RawLen=%d\n",s32RawLen);
		PROC_PRINT("RawLen=%d\n",s32RawLen);
		HDMI_KFREE(pu8EdidRaw);
		return ;
	}
	
	eRet = DRV_HDMI_EdidCapabilityGet(pstEdidInfo,(const HDMI_SINK_CAPABILITY_S **)&pstCap);
	if (eRet == HDMI_EDID_DATA_INVALID || pstCap==HI_NULL)
	{
		HDMI_ERR("DATA_INVALID\n");
		PROC_PRINT("DATA_INVALID\n");
		HDMI_KFREE(pu8EdidRaw);
		return ;
	}

	/* Raw data */
	PROC_PRINT("---------------------------------- EDID Raw Data -------------------------------------");
	for (i = 0; i<s32RawLen && i<HDMI_EDID_TOTAL_SIZE ;i++)
	{
		if ((i % 4) == 0)
		{
			PROC_PRINT("  ");
		}
		if ((i % 16) == 0)
		{
			PROC_PRINT("\n[%08dD]%08xH:",i,i);
		}
		PROC_PRINT(" %02x",pu8EdidRaw[i]);
	}
	PROC_PRINT("\n");

	
	/* Detail Timing */
	for (i=0;i<pstCap->u32PerferTimingNum;i++)
	{
		PROC_PRINT("---------------------------- Support Detail Timing[%u] -----------------------------\n",i);
		/* line1 */
		PROC_PRINT("%-4s|%-4s|%-4s|%-4s|%-4s|%-4s|%-4s|%-4s|%-4s|%-4s|%-4s|%-4s|%-4s|%-4s|%-4s|%-4s|%-4s\n",
				"HACT","VACT","P/I","PClk","AspW","AspH","HFB","HPW","HBB","VFB","VPW","VBB","ImgW","ImgH","IHS","IVS","IDV");
		/* line2 */
		PROC_PRINT("%-4u|%-4u|%-4c|%-3uM|%-4u|%-4u|%-4u|%-4u|%-4u|%-4u|%-4u|%-4u|%-4u|%-4u|%-4s|%-4s|%-4s\n",
				pstCap->stPerferTiming[i].u32HACT,
				pstCap->stPerferTiming[i].u32VACT,
				pstCap->stPerferTiming[i].bInterlace ? 'i' : 'P',
				pstCap->stPerferTiming[i].u32PixelClk / 1000,
				pstCap->stPerferTiming[i].u32AspectRatioW,
				pstCap->stPerferTiming[i].u32AspectRatioH,
				pstCap->stPerferTiming[i].u32HFB,
				pstCap->stPerferTiming[i].u32HPW,
				pstCap->stPerferTiming[i].u32HBB,
				pstCap->stPerferTiming[i].u32VFB,
				pstCap->stPerferTiming[i].u32VPW,
				pstCap->stPerferTiming[i].u32VBB,
				pstCap->stPerferTiming[i].u32ImageWidth,
				pstCap->stPerferTiming[i].u32ImageHeight,
				pstCap->stPerferTiming[i].bIHS ? "Yes" : "No",
				pstCap->stPerferTiming[i].bIVS ? "Yes" : "No",
				pstCap->stPerferTiming[i].bIDV ? "Yes" : "No" );
		
		
	}

	/* format */
	PROC_PRINT("------------------------------- Support Vedio Format ----------------------------------\n");

	for (i=0;i<pstCap->u32SupportVICNum;i++)
	{


		pTmpFmt = Proc_Vic2Format(pstCap->au32SupportFormat[i]);


		if (pTmpFmt != HI_NULL)
		{
			PROC_PRINT("|%-13s ",pTmpFmt);
		}
		else
		{
			PROC_PRINT("|(VIC)%-8u ",pstCap->au32SupportFormat[i]);
		}

		j++;
		if ((j % 6)==0)
		{
			PROC_PRINT("\n");
		}
			
	}

	for (i=0;i<ARRAY_SIZE(pstCap->stStdTiming);i++)
	{
		pTmpFmt = Proc_StdTiming2Format(&pstCap->stStdTiming[i]);
		if (pTmpFmt != HI_NULL)
		{
			PROC_PRINT("|%-13s ",pTmpFmt);
			j++;
			if ((j % 6)==0)
			{
				PROC_PRINT("\n");
			}
		}
		else if (pstCap->stStdTiming[i].u32RefreshRate != 0)
		{
			snprintf(aTmpArray,19,"%dX%d_%d%c",pstCap->stStdTiming[i].u32HorActive,				
											pstCap->stStdTiming[i].u32VerActive,
											(pstCap->stStdTiming[i].u32RefreshRate / 100),'\0');
			PROC_PRINT("|%-14s",aTmpArray);
			j++;
			if ((j % 6)==0)
			{
				PROC_PRINT("\n");
			}
		}
		
	}
	for (i=0;i<pstCap->u32EstabNum && pstCap->au32EstabTiming[i]<ARRAY_SIZE(s_aStr_EstabTiming);i++)
	{
		PROC_PRINT("|%-13s ",s_aStr_EstabTiming[i]);
		j++;
		if ((j % 6)==0)
		{
			PROC_PRINT("\n");
		}
	}
	PROC_PRINT("\n");

	PROC_PRINT("---------------------------- Support 3D ---------------------------------\n");
	
	PROC_PRINT("%-20s: %-15s  |",	"bSupport3D",pstCap->st3DInfo.bSupport3D ? STR_YES : STR_NO);
	PROC_PRINT("%-20s: %-15s  \n",	"3dOsdDisparity",pstCap->bSupport3dOsdDisparity ? STR_YES : STR_NO);

	PROC_PRINT("%-20s: %-15s  |",	"3dDualView",pstCap->bSupport3dDualView ? STR_YES : STR_NO);
	PROC_PRINT("%-20s: %-15s  \n",	"3dIndependentView",pstCap->bSupport3dIndependentView ? STR_YES : STR_NO);

	PROC_PRINT("%-20s:",	"3D Type");
	for (i = 0 ;i < ARRAY_SIZE(pstCap->st3DInfo.bSupport3DType); i++)
	{
		if (pstCap->st3DInfo.bSupport3DType[i] && i<ARRAY_SIZE(s_aStr_3DType))
		PROC_PRINT(" %s", s_aStr_3DType[i]);	
	}
	PROC_PRINT("\n");

	
	/* video info */
	PROC_PRINT("---------------------------------- Support video -------------------------------------\n");
	pTmpFmt = Proc_Vic2Format(pstCap->u32NativeFormat);
	PROC_PRINT("%-15s: %-s(VIC %2d)",	"u32NativeFormat", pTmpFmt==HI_NULL ? "" : pTmpFmt,pstCap->u32NativeFormat);	
	PROC_PRINT("\n");

	/* ColorSpace */
	PROC_PRINT("%-15s:",	"ColorSpace");
	if (pstCap->stColorSpace.bRGB444)
	{
		PROC_PRINT(" %-s","RGB444");	
	}
	if (pstCap->stColorSpace.bYCbCr444)
	{
		PROC_PRINT(" %-s","YCbCr444");	
	}
	if (pstCap->stColorSpace.bYCbCr422)
	{
		PROC_PRINT(" %-s","YCbCr422");	
	}
	if (pstCap->u32OnlySupportY420VICNum || pstCap->u32SupportY420VICNum)
	{
		PROC_PRINT(" %-s","YCbCr420");	
	}
	PROC_PRINT("\n");

	/* ColorMetry */
	PROC_PRINT("%-15s:",	"ColorMetry");
	if (pstCap->stColorMetry.bxvYCC601)
	{
		PROC_PRINT(" %-s","bxvYCC601");	
	}
	if (pstCap->stColorMetry.bAdobleRGB)
	{
		PROC_PRINT(" %-s","bxvYCC709");	
	}
	if (pstCap->stColorMetry.bxvYCC709)
	{
		PROC_PRINT(" %-s","bsYCC601");	
	}
	if (pstCap->stColorMetry.bsYCC601)
	{
		PROC_PRINT(" %-s","bAdobleYCC601");	
	}
	if (pstCap->stColorMetry.bAdobleYCC601)
	{
		PROC_PRINT(" %-s","bAdobleRGB");	
	}
	if (pstCap->stColorMetry.bAdobleRGB)
	{
		PROC_PRINT(" %-s","bBT2020cYCC");	
	}
	if (pstCap->stColorMetry.bBT2020cYCC)
	{
		PROC_PRINT(" %-s","bBT2020cYCC");	
	}
	if (pstCap->stColorMetry.bBT2020YCC)
	{
		PROC_PRINT(" %-s","bBT2020YCC");	
	}
	if (pstCap->stColorMetry.bBT2020RGB)
	{
		PROC_PRINT(" %-s","bBT2020RGB");	
	}
	PROC_PRINT("\n");
	
	/* DeepColor */
	PROC_PRINT("%-15s:",	"DeepColor");
	if (pstCap->stDeepColor.bDeepColorY444)
	{
		PROC_PRINT(" %-s","Y444");	
	}	
	if (pstCap->stDeepColor.bDeepColor30Bit)
	{
		PROC_PRINT(" %-s","30Bit"); 
	}	
	if (pstCap->stDeepColor.bDeepColor36Bit)
	{
		PROC_PRINT(" %-s","36Bit");	
	}
	if (pstCap->stDeepColor.bDeepColor48Bit)
	{
		PROC_PRINT(" %-s","48Bit");	
	}
	PROC_PRINT("\n");
	
	/* DeepColorY420 */
	PROC_PRINT("%-15s:",	"DeepColorY420");
	if (pstCap->stDeepColorY420.bDeepColor30Bit)
	{
		PROC_PRINT(" %-s","30Bit"); 
	}	
	if (pstCap->stDeepColorY420.bDeepColor36Bit)
	{
		PROC_PRINT(" %-s","36Bit");	
	}
	if (pstCap->stDeepColorY420.bDeepColor48Bit)
	{
		PROC_PRINT(" %-s","48Bit");	
	}
	PROC_PRINT("\n");

	/* Y420Format[Also] */
	PROC_PRINT("%-15s:",	"Y420Format[Also]");
	for (i=0;i<pstCap->u32SupportY420VICNum;i++)
	{
		PROC_PRINT(" %u",pstCap->au32SupportY420Format[i]);
	}
	PROC_PRINT("\n");
	
	/* Y420Format[Olny] */
	PROC_PRINT("%-15s:",	"Y420Format[Olny]");
	for (i=0;i<pstCap->u32OnlySupportY420VICNum;i++)
	{
		PROC_PRINT(" %u",pstCap->au32OnlySupportY420Format[i]);
	}
	PROC_PRINT("\n");

	
  	/* audio info */
	for (i=0;i<pstCap->u32AudioInfoNum;i++)
	{
		PROC_PRINT("---------------------------------- Support Audio Type[%u] -------------------------------------\n",i);
		
		
		PROC_PRINT("%-20s: %-15s  |",	"Format Type:",	pstCap->stAudioInfo[i].enAudFmtCode < ARRAY_SIZE(s_aStrAudioCodingType) ? 
										s_aStrAudioCodingType[pstCap->stAudioInfo[i].enAudFmtCode]:STR_ERROR);
		PROC_PRINT("%-20s: %-15d \n",	"Channels",pstCap->stAudioInfo[i].u8AudChannel);	
		PROC_PRINT("%-20s: %-15d  |",	"Max Bit Rate",	 pstCap->stAudioInfo[i].u32MaxBitRate);

		PROC_PRINT("%-20s:","Bit Depth");
		if (pstCap->stAudioInfo[i].u32SupportBitDepthNum==0)
		{
			PROC_PRINT(" N/A");
		}
		for (j=0;j<pstCap->stAudioInfo[i].u32SupportBitDepthNum;j++)
		{
			PROC_PRINT(" %d",pstCap->stAudioInfo[i].enSupportBitDepth[j]);
		}
		PROC_PRINT("\n");
		PROC_PRINT("%-15s:","Sample Rate(Hz)");	
		for (j=0;j<pstCap->stAudioInfo[i].u32SupportSampleRateNum;j++)
		{
			PROC_PRINT(" %d",pstCap->stAudioInfo[i].enSupportSampleRate[j]);
		}
		PROC_PRINT("\n");
	}

	/* basic */
	PROC_PRINT("------------------------------- BASIC CAPABILITY ----------------------------------\n");
	PROC_PRINT("%-20s: %-15s  |",	"bSupportHdmi",pstCap->bSupportHdmi ? STR_YES : STR_NO);
	PROC_PRINT("%-20s: %-1d.%-1d\n","1st Block Version",pstCap->u8Version,pstCap->u8Revision);

	PROC_PRINT("%-20s: %-15s  |",	"bSupportHdmi_2_0",pstCap->bSupportHdmi_2_0 ? STR_YES : STR_NO);
	memset(aTmpArray,'\0',sizeof(aTmpArray));
	strncpy(aTmpArray,pstCap->stMfrsInfo.u8MfrsName,4);
	PROC_PRINT("%-20s: %-15s  \n",	"u8MfrsName",aTmpArray);
	
	PROC_PRINT("%-20s: %-15d  |",	"u32MaxTMDSClock",pstCap->u32MaxTMDSClock);
	PROC_PRINT("%-20s: %-15u  \n",	"u32ProductCode",pstCap->stMfrsInfo.u32ProductCode );

	PROC_PRINT("%-20s: %-15s  |",	"bSupportHDCP_2_2",pstCap->bSupportHDCP_2_2 ? STR_YES : STR_NO);
	PROC_PRINT("%-20s: %-15u  \n",	"u32SerialNumber",pstCap->stMfrsInfo.u32SerialNumber );

	PROC_PRINT("%-20s: %-15s  |",	"bSupportSCDC",pstCap->bSupportSCDC ? STR_YES : STR_NO);
	PROC_PRINT("%-20s: %-15u  \n",	"MfrWeek",pstCap->stMfrsInfo.u32Week );

	PROC_PRINT("%-20s: %-15s  |",	"bSupportDVIDual",pstCap->bSupportDVIDual ? STR_YES : STR_NO);
	PROC_PRINT("%-20s: %-15u  \n",	"MfrsYear",pstCap->stMfrsInfo.u32Year );

	PROC_PRINT("%-20s: %-15s  |",	"bSupportsAI",pstCap->bSupportsAI ? STR_YES : STR_NO);
	PROC_PRINT("%-20s: %-15s  \n",	"bPhyAddrValid",pstCap->stCECAddr.bPhyAddrValid ? STR_YES : STR_NO);


	PROC_PRINT("%-20s: %-15u  |",	"u8ExtBlockNum",pstCap->u8ExtBlockNum );
	PROC_PRINT("%-20s: %02x.%02x.%02x.%02x\n",	"CECAddr",pstCap->stCECAddr.u8PhyAddrA,pstCap->stCECAddr.u8PhyAddrB,
												pstCap->stCECAddr.u8PhyAddrC,pstCap->stCECAddr.u8PhyAddrD );
	/* speaker */
	PROC_PRINT("%-20s:","Support Speaker");
	for (i=0;i<ARRAY_SIZE(pstCap->bSupportAudioSpeaker) && i < ARRAY_SIZE(s_aStr_Speaker);i++)
	{
		PROC_PRINT(" %s",pstCap->bSupportAudioSpeaker[i] ? s_aStr_Speaker[i] : "");
	}
	PROC_PRINT("\n");

	HDMI_KFREE(pu8EdidRaw);
	return ;
}

HI_S32 DRV_HDMI_ProcSource0Read(struct seq_file *pFile, HI_VOID *pArg)
{

	PROC_PRINT("\n--------------- Hisi HDMI dev proc %s %s -----------------\n",__DATE__,__TIME__);

	ProcSrc_GlobleSoftStatusPrint(pFile,HDMI_DEVICE_ID0);
	ProcSrc_HardWareStatusPrint(pFile,HDMI_DEVICE_ID0);
	ProcSrc_EventInfoPrint(pFile,HDMI_DEVICE_ID0);

	
	return HI_SUCCESS;
}

HI_S32 DRV_HDMI_ProcSink0Read(struct seq_file *pFile, HI_VOID *pArg)
{

	PROC_PRINT("\n--------------- Hisi HDMI dev proc %s %s -----------------\n",__DATE__,__TIME__);

	ProcSrc_EdidInfoPrint(pFile,HDMI_DEVICE_ID0);
	
	return HI_SUCCESS;
}


