#include <linux/device.h>
#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/fs.h>
#include <asm/uaccess.h>
#include <asm/io.h>
#include <asm/delay.h>
#include <linux/poll.h>
#include <mach/hardware.h>
#include <linux/interrupt.h>
#include <linux/vmalloc.h>
#include <linux/slab.h>
#include <linux/timer.h>
#include <linux/delay.h>

#include "hdmi_hal.h"
#include "drv_hdmi_edid.h"
#include "drv_hdmi_event.h"
#include "drv_hdmi_common.h"
#include "drv_hdmi_platform.h"
#include "drv_hdmi_intf.h"
#include "drv_hdmi_ioctl.h"

#if defined(CONFIG_HDMI_STB_SDK)
#include "drv_hdmi_ext.h"
#include "hi_drv_hdmi.h"
#endif


static HI_S32 HdmiExtIoctl(unsigned int cmd, void *argp);
static HI_S32 HdmiExtIoctl(unsigned int cmd, void *argp)
{
    HI_S32   s32Ret = HI_FAILURE;
    s32Ret = DRV_HDMI_CmdProcess(cmd, argp, HI_FALSE);
    return s32Ret;
}

static HI_VOID HdmiHotPlugProcess(HDMI_DEVICE_ID_E enHdmiID)
{
    HI_S32          ret = HI_SUCCESS;
    HDMI_SINK_CAPABILITY_S *pstSinkCap;
    DRV_HDMI_APP_ATTR_S  stHDMIAttr;
    HDMI_APP_ATTR_S     *pstAppAttr;
    DRV_HDMI_STATUS_S   stDrvHdmiStatus;
    HDMI_EDID_STATUS_S  stStatus;

    HDMI_INFO("\n---HDMI kernel event(no UserCallBack): HOTPLUG. --- \n");

    DRV_HDMI_DefaultActionSet(GetHdmiDevice(enHdmiID), HDMI_DEFAULT_ACTION_HDMI);
    
    ret = DRV_HDMI_EdidCapabilityGet(&(GetHdmiDevice(enHdmiID)->stEdidInfo), (const HDMI_SINK_CAPABILITY_S **)&pstSinkCap);
    if (ret != HDMI_EDID_DATA_VALIDSINK)
    {
        HDMI_WARN("Get sink capability err!\n");
	    //return ;
    }

    memset(&stDrvHdmiStatus,0,sizeof(HDMI_STATUS_S));
    stDrvHdmiStatus.enHdmiID = enHdmiID;
    ret = HdmiExtIoctl(CMD_HDMI_GET_STATUS, &stDrvHdmiStatus);
    if (ret != HI_SUCCESS)
    {
        HDMI_ERR("Get HDMI Status err!\n");
	    return ;
    }

    if (HI_FALSE == stDrvHdmiStatus.stHdmiStatus.bConnected)
    {
       HDMI_ERR("No Connect!\n");
       return;
    }

    HDMI_INFO("Connect !\n");


    memset(&stHDMIAttr, 0, sizeof(stHDMIAttr));
    stHDMIAttr.enHdmiID = enHdmiID;
    ret = HdmiExtIoctl(CMD_HDMI_GET_ATTR, &stHDMIAttr);
    if (ret != HI_SUCCESS)
    {
	    HDMI_ERR("Get hdmi attr err!\n");
	    return ;
    }
    HDMI_INFO("HdmiExtIoctl CMD_HDMI_GET_ATTR ok! \n");


    pstAppAttr = &stHDMIAttr.stAPPAttr;
    DRV_HDMI_EdidStatusGet(&(GetHdmiDevice(enHdmiID)->stEdidInfo), &stStatus);
    if(stStatus.bCapValid)
    {
        pstAppAttr->enOutColorSpace = HDMI_COLORSPACE_YCbCr444;//HI_UNF_HDMI_VIDEO_MODE_YCBCR444;
        if(HI_TRUE == pstSinkCap->bSupportHdmi)
        {
            pstAppAttr->bEnableHdmi = HI_TRUE;
            if(HI_TRUE != pstSinkCap->stColorSpace.bYCbCr444)
            {
                pstAppAttr->enOutColorSpace = HDMI_COLORSPACE_RGB;//HI_UNF_HDMI_VIDEO_MODE_RGB444;
            }
        }
        else
        {
            pstAppAttr->enOutColorSpace = HDMI_COLORSPACE_RGB;//HI_UNF_HDMI_VIDEO_MODE_RGB444;

            //read real edid ok && sink not support hdmi,then we run in dvi mode
            pstAppAttr->bEnableHdmi = HI_FALSE;
        }
    }
    else
    {
        if(DRV_HDMI_DefaultActionGet(GetHdmiDevice(enHdmiID)) == HDMI_DEFAULT_ACTION_HDMI)
        {
            pstAppAttr->bEnableHdmi = HI_TRUE;
        }
        else
        {
            pstAppAttr->bEnableHdmi = HI_FALSE;
        }
    }

    if(HI_TRUE == pstAppAttr->bEnableHdmi)
    {
        pstAppAttr->bEnableAudio = HI_TRUE;
        pstAppAttr->bEnableVideo = HI_TRUE;
        pstAppAttr->bEnableAudInfoFrame = HI_TRUE;
        pstAppAttr->bEnableAviInfoFrame = HI_TRUE;
    }
    else
    {
        pstAppAttr->bEnableAudio = HI_FALSE;
        pstAppAttr->bEnableVideo = HI_TRUE;
        pstAppAttr->bEnableAudInfoFrame = HI_FALSE;
        pstAppAttr->bEnableAviInfoFrame = HI_FALSE;
        pstAppAttr->enOutColorSpace = HDMI_COLORSPACE_YCbCr444;//HI_UNF_HDMI_VIDEO_MODE_RGB444;
    }
    pstAppAttr->bHDCPEnable = HI_FALSE;
    ret = HdmiExtIoctl(CMD_HDMI_SET_ATTR, &stHDMIAttr);
    if (ret != HI_SUCCESS)
    {
	    HDMI_ERR("set attr err!:0x%x\n", ret);
    }
    HDMI_INFO("HdmiExtIoctl CMD_HDMI_SET_ATTR ok! \n");

    ret = HdmiExtIoctl(CMD_HDMI_START, &enHdmiID);
    if (ret != HI_SUCCESS)
    {
	    HDMI_ERR("hdmi start  err!:0x%x\n",ret);
	    return ;
    }
 
    HDMI_INFO("HdmiExtIoctl CMD_HDMI_START ok! \n");

    return;
}

static HI_VOID HdmiHotUnPlugProcess(HDMI_DEVICE_ID_E enHdmiID)
{
    HI_S32          ret = HI_SUCCESS;
    
    ret = HdmiExtIoctl(CMD_HDMI_STOP, &enHdmiID);
    if (ret != HI_SUCCESS)
    {
	    HDMI_ERR("hdmi stop  err!:0x%x\n",ret);
	    return ;
    }
    HDMI_INFO("HdmiExtIoctl CMD_HDMI_STOP ok! \n");
    return;
}

HI_S32 HI_DRV_HDMI_KernelEventCallback(HI_VOID* data, HDMI_EVENT_E enEvent)
{
    HDMI_DEVICE_ID_E enHdmiID = *(HDMI_DEVICE_ID_E*)data;
	HDMI_DEVICE_S *pstHdmiDev = GetHdmiDevice(enHdmiID); 
	
	if ((pstHdmiDev->enRunState & HDMI_RUN_STATE_START) || 
        (pstHdmiDev->enRunState & HDMI_RUN_STATE_STOP)) 
    {
        if (enEvent == HDMI_EVENT_HOTPLUG)
	    {
	        HdmiHotPlugProcess(enHdmiID);
	    }
	    else if (enEvent == HDMI_EVENT_HOTUNPLUG)
	    {
	        HdmiHotUnPlugProcess(enHdmiID);
	    }
    }
    
	printk("%s[%d]\n",__func__,__LINE__);
    return HI_SUCCESS;
}


