/**
 * ddr_training_boot.c
 *
 * Copyright (c) 2009-2014, HiSilicon Technologies Co., Ltd.
 * All rights reserved.
 *
 * Special function for ddr training when power up.
 */

#include "ddr_training_impl.h"
#include <ddr_interface.h>

#ifdef DDR_TRAINING_UART_CONFIG
extern void uart_early_put_hex(int hex);
extern void uart_early_putc(int chr);
#endif

/**
 * ddr_result_data_save
 * @ddrtr_result
 * @training
 * @mode
 *
 * Save DDR tarining result.
 */
void ddr_result_data_save(void *ddrtr_result,
		struct training_data *training, unsigned int mode)
{
	/* nothing to do when ddr training on power up */
}

/**
 * ddr_ddrt_get_test_addr
 * @void
 *
 * Get DDRT test address.
 */
int ddr_ddrt_get_test_addr(void)
{
	return DDRT_CFG_TEST_ADDR_BOOT;
}

#ifdef DDR_TRAINING_UART_CONFIG
/**
 * ddr_training_error
 * @mask
 * @phy
 * @byte
 * @dq
 *
 * Display DDR training error when boot.
 * NOTE: Can not use uart_early_puts() when boot, because (*.text) data.
 * Can not use char array for uart_early_putc when boot.
 */
void ddr_training_error(unsigned int mask, unsigned int phy, int byte, int dq)
{
	uart_early_putc('\r');
	uart_early_putc('\n');
	/* error type */
	switch (mask) {
	case DDR_ERR_WL:
		uart_early_putc('W');
		uart_early_putc('L');
		break;
	case DDR_ERR_HW_GATING:
		uart_early_putc('H');
		uart_early_putc('W');
		uart_early_putc(' ');
		uart_early_putc('G');
		uart_early_putc('a');
		uart_early_putc('t');
		uart_early_putc('e');
		break;
	case DDR_ERR_GATING:
		uart_early_putc('G');
		uart_early_putc('a');
		uart_early_putc('t');
		uart_early_putc('e');
		break;
	case DDR_ERR_DDRT_TIME_OUT:
		uart_early_putc('D');
		uart_early_putc('D');
		uart_early_putc('R');
		uart_early_putc('T');
		break;
	case DDR_ERR_HW_RD_DATAEYE:
		uart_early_putc('H');
		uart_early_putc('W');
		uart_early_putc(' ');
		uart_early_putc('D');
		uart_early_putc('a');
		uart_early_putc('t');
		uart_early_putc('a');
		uart_early_putc('e');
		uart_early_putc('y');
		uart_early_putc('e');
		break;
	case DDR_ERR_MPR:
		uart_early_putc('M');
		uart_early_putc('P');
		uart_early_putc('R');
		break;
	case DDR_ERR_DATAEYE:
		uart_early_putc('D');
		uart_early_putc('a');
		uart_early_putc('t');
		uart_early_putc('a');
		uart_early_putc('e');
		uart_early_putc('y');
		uart_early_putc('e');
		break;
	default:
		break;
	}

	/* error string */
	uart_early_putc(' ');
	uart_early_putc('E');
	uart_early_putc('r');
	uart_early_putc('r');
	uart_early_putc(':');

	/* error code */
	uart_early_put_hex(mask);

	/* error phy */
	if (0 != phy) {
		uart_early_putc(' ');
		uart_early_putc('P');
		uart_early_putc('h');
		uart_early_putc('y');
		uart_early_putc(':');
		uart_early_put_hex(phy);
	}

	/* error byte */
	if (-1 != byte) {
		uart_early_putc(' ');
		uart_early_putc('B');
		uart_early_putc('y');
		uart_early_putc('t');
		uart_early_putc('e');
		uart_early_putc(':');
		uart_early_put_hex(byte);
	}

	/* error dq */
	if (-1 != dq) {
		uart_early_putc(' ');
		uart_early_putc('D');
		uart_early_putc('Q');
		uart_early_putc(':');
		uart_early_put_hex(dq);
	}

	uart_early_putc('\r');
	uart_early_putc('\n');
}

/**
 * ddr_training_suc
 * @void
 *
 * Display DDR training result when boot.
 * NOTE: can not define char array.
 */
void ddr_training_suc(void)
{
	uart_early_putc('\r');
	uart_early_putc('\n');
	uart_early_putc('D');
	uart_early_putc('D');
	uart_early_putc('R');
	uart_early_putc(' ');
	uart_early_putc('T');
	uart_early_putc('r');
	uart_early_putc('a');
	uart_early_putc('i');
	uart_early_putc('n');
	uart_early_putc('i');
	uart_early_putc('n');
	uart_early_putc('g');
	uart_early_putc(' ');
	uart_early_putc('S');
	uart_early_putc('u');
	uart_early_putc('c');
	uart_early_putc('\r');
	uart_early_putc('\n');
}
#else
void ddr_training_error(unsigned int mask, unsigned int phy, int byte, int dq)
{
	return;
}
void ddr_training_suc(void) { return; }
#endif
