#ifndef __ASM_ARM_ARCH_IO_H
#define __ASM_ARM_ARCH_IO_H

#define IO_SPACE_LIMIT 0xffffffff

#define __io(a)		__typesafe_io(a)
#define __mem_pci(a)	(a)

#define IO_OFFSET_HIGH 0xEE000000
#define IO_OFFSET_MID 0xEC080000
#define IO_OFFSET_LOW 0xDE100000

/* 0xFE000000~0xFE070000 */
#define HI3535_IOCH1_VIRT (HI3535_IOCH1_PHYS + IO_OFFSET_HIGH)
#define HI3535_IOCH1_PHYS 0x10000000

#define HI3535_IOCH1_SIZE 0x70000

/* 0xFE080000~0xFE0C0000 */
#define HI3535_IOCH2_VIRT (HI3535_IOCH2_PHYS + IO_OFFSET_MID)
#define HI3535_IOCH2_PHYS 0x12000000

#define HI3535_IOCH2_SIZE 0x40000

/* 0xFE100000~0xFE910000 */
#define HI3535_IOCH3_VIRT (HI3535_IOCH3_PHYS + IO_OFFSET_LOW)
#define HI3535_IOCH3_PHYS 0x20000000

#define HI3535_IOCH3_SIZE 0x810000

#define __IO_ADDRESS(x) ((x) >= HI3535_IOCH2_PHYS ? ((x) + IO_OFFSET_MID) \
						: ((x) + IO_OFFSET_HIGH))

#define IO_ADDRESS(x) ((x) >= HI3535_IOCH3_PHYS ? ((x) + IO_OFFSET_LOW)\
						: (__IO_ADDRESS(x)))
#endif
