#ifndef FRONTPANEL_H_
#define FRONTPANEL_H_

#include <linux/ioctl.h> /* needed for the _IOW etc */ 

#undef PDEBUG
#ifdef FRNT_PNL_DEBUG
#  ifdef __KERNEL__
#    define PDEBUG(fmt, args...) printk( KERN_DEBUG "frnt_pnl: " fmt, ## args)
#  else
#    define PDEBUG(fmt, args...) fprintf(stderr, fmt, ## args)
#  endif
#else
#  define PDEBUG(fmt, args...) 
#endif

#define FRNT_PNL_MAJOR          0
#define FRNT_PNL_MINOR          0
#define FRNT_PNL_NR_DEVS        1
#define FRNT_PNL_SLAVE_ADDR     0x38
#define FRNT_PNL_MAX_REGS       29

typedef struct frnt_pnl_reg
{
    int index;
    int value;
}frontPanelReg;

/*
 * Ioctl definitions
 */

/* Use 'f' as magic number */
#define FRNT_PNL_IOC_MAGIC  'f'

#define FRNT_PNL_IOCSETADDR         _IOW(FRNT_PNL_IOC_MAGIC,  1, int)
#define FRNT_PNL_IOCGETREG          _IOWR(FRNT_PNL_IOC_MAGIC, 2, frontPanelReg)
#define FRNT_PNL_IOCSETREG          _IOW(FRNT_PNL_IOC_MAGIC,  3, frontPanelReg)
#define FRNT_PNL_IOCGETEXREG        _IOWR(FRNT_PNL_IOC_MAGIC, 4, frontPanelReg)

#define FRNT_PNL_IOC_MAXNR 4

/* Index of Registers */
/* 
 * LED Reg - R/W Registers
 *   <---- 8 bits -----> <------ 8 bits ------->
 *  +-------------------------------------------+
 *  |       Speed       |       Pattern         |
 *  +-------------------------------------------+
 */
#define REG_LED_CH1             0x00
#define REG_LED_CH2             0x01
#define REG_LED_CH3             0x02
#define REG_LED_CH4             0x03
#define REG_LED_CH5             0x04
#define REG_LED_CH6             0x05
#define REG_LED_CH7             0x06
#define REG_LED_CH8             0x07
#define REG_LED_CH9             0x08
#define REG_LED_CH10            0x09
#define REG_LED_CH11            0x0A
#define REG_LED_CH12            0x0B
#define REG_LED_CH13            0x0C
#define REG_LED_CH14            0x0D
#define REG_LED_CH15            0x0E
#define REG_LED_CH16            0x0F
#define REG_LED_POWER           0x10
#define REG_LED_STATUS          0x11
#define REG_LED_NETWORK         0x12
#define REG_LED_HDD_1           0x13
#define REG_LED_HDD_2           0x14
#define REG_LED_ALARM           0x15

#define LED_SPEED_FASTEST       0x01
#define LED_SPEED_FAST          0x02
#define LED_SPEED_MEDIUM        0x0F
#define LED_SPEED_SLOW          0x15
#define LED_SPEED_SLOWEST       0xFF

/*
 * Button Status - R/W Registers
 * 
 *  +-------------------------------------------+
 *  |  Key Sample Time   |      Key Status      |
 *  +-------------------------------------------+
 */
#define REG_RSTKEY_STATUS       0x16
#define REG_PWRKEY_STATUS       0x17
#define REG_ALRMKEY_STATUS      0x18

/*
 * Button Interrupt Status and Control - R/W Register
 *  1 Bit Flags showing which button raised the interrupt
 *  +-------------------------------------------+
 *  |           | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
 *  +-------------------------------------------+
 *  0: Reset button triggered
 *  1: Power button triggered
 *  2: Alarm button triggered
 *  3: Fan Control
 *  4: INTR enabled
 *  5: Alarm On/Off
 *  6: HW Reset
 *  7: Power On/Off
 */
#define REG_INTR_STATUS             0x19
    #define RESET_BUTTON_FLAG       0x01
    #define POWER_BUTTON_FLAG       0x02
    #define ALARM_BUTTON_FLAG       0x04
    #define FAN_CTRL_FLAG           0x08
    #define INTR_ENABLE_FLAG        0x10
    #define ALARM_CTRL_FLAG         0x20
    #define HW_RESET_CTRL           0x40
    #define POWER_CTRL_FLAG         0x80

#define BUTTON_MASK                 (RESET_BUTTON_FLAG | POWER_BUTTON_FLAG | ALARM_BUTTON_FLAG)

#define REG_RSTKEY_TRIGGER          0x1A
    #define RSTKEY_TRIGGER_VAL      0xFE00

#define REG_PWRKEY_TRIGGER          0x1B
    #define PWRKEY_TRIGGER_VAL      0xFE00

#define REG_ALRMKEY_TRIGGER         0x1C
    #define ALRMKEY_TRIGGER_VAL     0xFE00

/*
 *  Control Register - R/W Register
 *  1 Bit Control Flags
 *  +-------------------------------------------+
 *  |           |   | 6 |   |   |   |   |   |   |
 *  +-------------------------------------------+
 *  6: Reset HW Enable
 */
#define REG_EX_REG2                 0x1D
    #define HW_RESET_CTRL_ENABLE    0x40


#endif /*FRONTPANEL_H_*/
