/*******************************************************************************
Copyright (C) Marvell International Ltd. and its affiliates

This software file (the "File") is owned and distributed by Marvell 
International Ltd. and/or its affiliates ("Marvell") under the following
alternative licensing terms.  Once you have made an election to distribute the
File under one of the following license alternatives, please (i) delete this
introductory statement regarding license alternatives, (ii) delete the two
license alternatives that you have not elected to use and (iii) preserve the
Marvell copyright notice above.

********************************************************************************
Marvell Commercial License Option

If you received this File from Marvell and you have entered into a commercial
license agreement (a "Commercial License") with Marvell, the File is licensed
to you under the terms of the applicable Commercial License.

********************************************************************************
Marvell GPL License Option

If you received this File from Marvell, you may opt to use, redistribute and/or 
modify this File in accordance with the terms and conditions of the General 
Public License Version 2, June 1991 (the "GPL License"), a copy of which is 
available along with the File in the license.txt file or by writing to the Free 
Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 or 
on the worldwide web at http://www.gnu.org/licenses/gpl.txt. 

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE IMPLIED 
WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY 
DISCLAIMED.  The GPL License provides additional details about this warranty 
disclaimer.
********************************************************************************
Marvell BSD License Option

If you received this File from Marvell, you may opt to use, redistribute and/or 
modify this File under the following licensing terms. 
Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    *   Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer. 

    *   Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution. 

    *   Neither the name of Marvell nor the names of its contributors may be 
        used to endorse or promote products derived from this software without 
        specific prior written permission. 
    
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*******************************************************************************/

/*******************************************************************************
* ethDrv.h - Header File for : Marvell Fast Ethernet Controller header 
*
* DESCRIPTION:
*       This header file contains macros typedefs and function declaration for
*       the Marvell Fast Ethernet Controller. 
*
* DEPENDENCIES:
*       None.
*
*******************************************************************************/

#ifndef __INCethDrvh
#define __INCethDrvh

#include "mvOs.h"
#include "mvCtrlEnvLib.h"
#include "mvCtrlEnvSpec.h"
#include "mvUniMacRegs.h"

/* defines */
#define ADDRESS_TABLE_ALIGNMENT	0x4		/* Address filter table aligment */
#define RX_DESC_ALIGNMENT	    0x4		  
#define TX_DESC_ALIGNMENT	    0x4		  
#define RX_BUFF_ALIGNMENT	    0x3
#define TX_BUFF_ALIGNMENT	    0x3

#define RX_DESC_ALIGNED_SIZE	0x20
#define TX_DESC_ALIGNED_SIZE	0x20

/* Operation flags to MAC Address filtering operations */
#define ADD_MAC_ADDR	0
#define REMOVE_MAC_ADDR	1
#define CLEAR_MAC_ADDR	2

#define ETH_MAX_RX_QUEUE_NUM 	4
#define ETH_MAX_TX_QUEUE_NUM 	2
#define MV_MAC_ADDR_SIZE       	6
#define ETH_PORT_NUM		1
#define ETH_RX_BUFFER_MAX_SIZE  0x10000
#define ETH_TX_BUFFER_MAX_SIZE  0x10000

/* Ethernet port default configuration */

/* Default port configuration value */
#define PORT_CONFIG_VALUE        \
              ( PORT_ENABLE         |\
                ETH_HASH_SIZE_500 |\
		PCR_RES )

/* Default port configuration extended value */
#define PORT_CONFIG_EXTEND_VALUE  \
              ( FLOW_CTRL_DISABLE       |\
		PCER_RES )

/* Default port SDMA configuration value */
#ifdef MV_CPU_LE
#define PORT_SDMA_CONFIG_VALUE  \
      ( SDCR_BLMR_LITTLE    |\
        SDCR_BLMT_LITTLE     |\
        SDCR_BSZ_8x64 )
#else /* BE */
        #define PORT_SDMA_CONFIG_VALUE  \
                        SDCR_BSZ_8x64
#endif

/* Ethernet register read / write routines */
#define ETH_REG_READ(offset, pValue)	\
		(*pValue) = MV_REG_READ(offset )

#define ETH_REG_WRITE(offset, value)	\
		MV_REG_WRITE(offset , value)


#define ETH_CAUSE_READ(port)	        \
    MV_REG_READ( ETH_CAUSE_REG(port))

#define ETH_CAUSE_WRITE(port, val)	    \
	MV_REG_WRITE( ETH_CAUSE_REG(port), (val))

#define ETH_MASK_READ(port)		        \
    MV_REG_READ( ETH_MASK_REG(port))

#define ETH_MASK_WRITE(port, val)		\
    MV_REG_WRITE( ETH_MASK_REG(port), (val))

/* typedefs */
    
/* Unified struct for Rx/Tx queue. It describes queue resources. Use	*/
/* this struct to initialize Ethernet port.								*/
typedef struct _ethPortQueue
{
    MV_U32  descNum;     
    MV_U32  buffSize;    
    MV_U32  descBaseAddr;
    MV_U32  buffBaseAddr;
} ETH_PORT_QUEUE;

/* Ethernet port specific infomation */
typedef struct _ethPortInit
{
    MV_U32  portPhyAddr;	/* Port phy address     		*/
    MV_U32  portBase;		/* Port registers base address 	*/
    MV_U8   portMacAddr[6];	/* Port MAC address.			*/
    MV_U32  portConfig;
    MV_U32  portConfigExtend;
    MV_U32  portSdmaConfig;
    MV_U32  portAddrTblBase;

    ETH_PORT_QUEUE portRxQueue[ETH_MAX_RX_QUEUE_NUM]; 
    ETH_PORT_QUEUE portTxQueue[ETH_MAX_TX_QUEUE_NUM]; 

    /* User scratch pad for user specific data structures */
    void *portPrivate;

} ETH_PORT_INIT; 

  /* ETHERNET_CAUSE is an enumerator that moves between 0 and 31.This	*/
  /* enumerator describes the cause bits positions in the ETHERNET		*/
  /* facility cause register.											*/
  
typedef enum eth_cause{
    /* Ethernet Interrupt cause register bit description */

    ETH_CAUSE_START = -1  , /* Cause low boundry      */
    ETH_RX_BUFFER_RETURN  , /* Rx Buffer Return       */
    ETH_RSRVD_L01         ,
    ETH_TX_BUFFER_HIGH    , /* Tx Buffer for High priority Queue */
    ETH_TX_BUFFER_LOW     , /* Tx Buffer for low  priority Queue */
    ETH_RSRVD_L04         ,
    ETH_RSRVD_L05         ,
    ETH_TX_END_HIGH       , /* Tx End for High Priority Queue */
    ETH_TX_END_LOW        , /* Tx End for Low  Priority Queue */
    ETH_RX_ERROR          , /* Rx Resource Error */
    ETH_RSRVD_L09         ,
    ETH_TX_ERROR_HIGH     , /* Tx Resource Error for High Priority Queue */
    ETH_TX_ERROR_LOW      , /* Tx Resource Error for Low  Priority Queue */
    ETH_RX_OVERRUN        , /* Rx Overrun  */
    ETH_TX_UNDERRUN       , /* Tx Underrun */
    ETH_RSRVD_L14         ,
    ETH_RSRVD_L15         ,
    ETH_RX_BUFFER_QUEUE_0 , /* Rx Buffer  Return in Priority Queue[0] */
    ETH_RX_BUFFER_QUEUE_1 , /* Rx Buffer  Return in Priority Queue[1] */
    ETH_RX_BUFFER_QUEUE_2 , /* Rx Buffer  Return in Priority Queue[2] */
    ETH_RX_BUFFER_QUEUE_3 , /* Rx Buffer  Return in Priority Queue[3] */
    ETH_RX_ERROR_QUEUE_0  , /* Rx Resource Error in Priority Queue[0] */
    ETH_RX_ERROR_QUEUE_1  , /* Rx Resource Error in Priority Queue[1] */
    ETH_RX_ERROR_QUEUE_2  , /* Rx Resource Error in Priority Queue[2] */
    ETH_RX_ERROR_QUEUE_3  , /* Rx Resource Error in Priority Queue[3] */
    ETH_RSRVD_L24         ,
    ETH_RSRVD_L25         ,
    ETH_RSRVD_L26         ,
    ETH_RSRVD_L27         ,
    ETH_MII_PHY_STC       , /* MII PHY Status Change */
    ETH_SMI_DONE          , /* SMI Command Done      */
    ETH_RSRVD_L30         ,
    ETH_INT_SUM           , /* Ethernet Interrupt Summary */
    ETH_CAUSE_END
}ETH_CAUSE;


/* Ethenret driver API */

/* Ethernet Port routines */
MV_STATUS mvEthPortInit (int ethPortNum, ETH_PORT_INIT *pEthPortInit);
void	  mvEthPortStop (int ethPortNum);
MV_STATUS mvEthPortStart(int ethPortNum);

MV_STATUS mvEthPortSend       (int ethPortNum, int txQueue, BUF_INFO *pPktInfo);
MV_STATUS mvEthPortSendDone   (int ethPortNum, int txQueue, BUF_INFO *pPktInfo);
MV_STATUS mvEthPortReceive    (int ethPortNum, int rxQueue, BUF_INFO *pPktInfo);
MV_STATUS mvEthPortReceiveDone(int ethPortNum, int rxQueue, BUF_INFO *pPktInfo);

/* Address filtering routines */
MV_STATUS mvEthPortMacAddr	   (int ethPortNum, MV_U8 *pAddr,int opFlag);
MV_STATUS mvEthPortFilterEnable(int ethPortNum, MV_BOOL enabler);


#endif /* __INCetherneth */

