
#define MV_ASMLANGUAGE
#include "mvOsAsm.h"
#include <config.h>
#include <version.h>

#define confReg                 r7
#define tmpReg                  r8


#define MV_ASM_REG_WRITE(_addr,_data)   ldr r5, = (_data & 0xFF000000);        \
                                        add r5, r5, #(_data & 0x00FF0000);        \
                                        add r5, r5, #(_data & 0x0000FF00);        \
                                        add r5, r5, #(_data & 0x000000FF);        \
                                        HTOLL(r5,r6);   \
                                        ldr r6, = (_addr & 0xFF000000);        \
                                        add r6, r6, #(_addr & 0x00FF0000);        \
                                        add r6, r6, #(_addr & 0x0000FF00);        \
                                        add r6, r6, #(_addr & 0x000000FF);        \
                                        str r5,[r6]
                                        

#define DO_WAIT                ldr r6, =(0xFFFF0000 & 0xFF000000);    \
                                 add r6, r6, #(0xFFFF0000 & 0x00FF0000);    \
                                 add r6, r6, #(0xFFFF0000 & 0x0000FF00);    \
                                 add r6, r6, #(0xFFFF0000 & 0x000000FF);    \
                                 mov tmpReg, #0xFF000000
                                 1:ldr r5, [r6];    \
                                 ldr r5, [r6];    \
                                 ldr r5, [r6];    \
                                 ldr r5, [r6];    \
                                 ldr r5, [r6];    \
                                 ldr r5, [r6];    \
                                 ldr r5, [r6];    \
                                 ldr r5, [r6];    \
                                 ldr r5, [r6];    \
                                 sub tmpReg, tmpReg, #1;        \
                                 bne 1b




#undef MV_88F5181_PRPMC
#undef MV_88F5181_MNG
#undef MV_88F5181_PCI_PEX

#define ODT_CS0
#define ODT_CS0_CS2
#define UART                    
#define DDRI
#define DDRII
#define MV_88F5181_DDRI
#define MV_88F5181_DDRII
#define SOCRATES_BE



#define BIG_ENDIAN_BIT          0x00000001
#define DDRI_BIT                0x00000002
#define DDRII_BIT               0x00000004
#define MV_88F5181_DDRI_BIT     0x00000008
#define MV_88F5181_DDRII_BIT    0x00000010
#define SOCRATES_BE_BIT         0x00000020
#define ODT_CS0_CS2_BIT         0x00000040
#define ODT_CS0_BIT             0x00000080

.globl _twsiEEpromInit
_twsiEEpromInit:

                                 /* check if we are running after I2c init
                                 or not */
                                 

                                 
                                 ldr r6, =(0xf1010010 & 0xFF000000)
                                 add r6, r6, #(0xf1010010 & 0x00FF0000)
                                 add r6, r6, #(0xf1010010 & 0x0000FF00)
                                 add r6, r6, #(0xf1010010 & 0x000000FF)
                                 ldr r5, [r6]   /* r5 = [0xf1010010] */
                                 HTOLL(r5,tmpReg)
                                 tst r5, #0x1
                        
                                 beq do_i2c
                                 
                                 mov     PC, lr         /* r11 is saved link register */
                                 
do_i2c:

                                /* We will start with filling out confReg with 
                                the appropriate bits , to define the board type*/
                                
                                mov confReg, #0x0
                                
                                
                                /* first check if we are running in Big endian mode */
#if defined(__BE)
                                orr confReg, confReg, #BIG_ENDIAN_BIT
#if defined(MV_88F5181)
                                orr confReg, confReg, #SOCRATES_BE_BIT
#endif                                
#endif                                
                                
                                /* check if we are are DDRI or DDRII */
                                

                                 ldr r6, =(0xf1001400 & 0xFF000000)
                                 add r6, r6, #(0xf1001400 & 0x00FF0000)
                                 add r6, r6, #(0xf1001400 & 0x0000FF00)
                                 add r6, r6, #(0xf1001400 & 0x000000FF)
                                
                                ldr r5, [r6] /* r5 = [0xf1001400] */
                                HTOLL(r5,tmpReg)
                                tst r5, #0x10000
                                
                                bne 1f
                                /* --------DDRI ---------------*/
                                orr confReg, confReg, #DDRI_BIT
#if defined(MV_88F5181)
                                orr confReg, confReg, #MV_88F5181_DDRI_BIT
#endif
                                b 2f
                                /* --------DDRII ---------------*/
1:                              
                                orr confReg, confReg, #DDRII_BIT
                                orr confReg, confReg, #ODT_CS0_CS2_BIT
                                /*orr confReg, confReg, #ODT_CS0_BIT*/
#if defined(MV_88F5181)
                                orr confReg, confReg, #MV_88F5181_DDRII_BIT
#endif
                                
2:                              

                                /* Put the ARM CPU in reset */
                                /*MV_ASM_REG_WRITE(0xF1020104,0x00000003)*/

 
#if defined(MV_88F1181)
                             
                                /* Init device parameters  */
                                /* 8 Bit mvFlash and 8 bit Boot device */
                                /* MV_ASM_REG_WRITE(0xF101046c,0x068B0AEE) */
                                /* MV_ASM_REG_WRITE(0xF1010464,0x068B0AEE) */
                                
                                /* Initialize MPP */ 
                                /* The MPP must be initialize before the Uart,  */ 
                                /* MPP0 - BR_Gen (GPIO in), - 
                                   MPP1 - RTC_Int (GPIO in)
                                   MPP2,MPP3, MPP6, MPP7 - 7-SegA (GPIO out)
                                   MPP4 - SCK1 (GPIO in/out)
                                   MPP5 - SDA1 (GPIO in/out) 
                                   MPP8 - AU0_TX (GPIO out)
                                   MPP9 - AU0_RX (GPIO in)
                                   MPP10 - UA0_CTSn (GPIO in)
                                   MPP11 - UA0_RTSn (GPIO out)
                                   MPP12,MPP13, MPP14, MPP15 - 7-SegA (GPIO out)*/
                                MV_ASM_REG_WRITE(0xF1010000,0x00011000)
                                MV_ASM_REG_WRITE(0xF1010004,0x00001111)
                                /* Initialize GPIO */ 
                                MV_ASM_REG_WRITE(0xF1010104,0x0000F633)
                                MV_ASM_REG_WRITE(0xF101010C,0x00000002)

                                /*Setting the GPIO 7SegA and 7SegB leds to "0" */ 
                                 /*7SegA MPP[7,6,3,2] */ 
                                /*7SegB MPP[15:12] */ 
                                MV_ASM_REG_WRITE(0xF1010100,0x00000000)
                                MV_ASM_REG_WRITE(0xF1010104,0x00000F33)
#endif

#if defined(SOCRATES_BE)
                                tst confReg, #SOCRATES_BE_BIT
                                beq 1f
                                MV_ASM_REG_WRITE(0xF1020100,0x0000000b)
1:                                
                                
#endif

#if defined(MV_88F5181_DDRII)

                                tst confReg, #MV_88F5181_DDRII_BIT
                                beq 1f

                                /* Init device parameters */ 
                                /* 32Bit Sram, 8 Bit mvFlash, RTC and 8 bit Boot device */ 
                                 MV_ASM_REG_WRITE(0xF101045c,0x8fcfffff)
                                 MV_ASM_REG_WRITE(0xF1010460,0x8fefffff)
                                 MV_ASM_REG_WRITE(0xF1010464,0x8fcfffff)
                                 MV_ASM_REG_WRITE(0xF101046c,0x8fcfffff)
                                
                                /* MPP0 - BR_Gen (GPIO in), - 
                                 MV_ASM_REG_WRITE(0xF101046c,0x068B0AEE)     --MPP1 - RTC_Int (GPIO in)--
                                   MPP2 - PCI_REQn[3] (in)
                                   MPP3 - PCI_GNTn[3] (out)
                                   MPP4 - PCI_REQn[4] (in)
                                   MPP5 - PCI_GNTn[4] (out)
                                   MPP6, MPP7 - 7-SegA (GPIO out)
                                   MPP8 - TW1_SCK
                                   MPP9 - TW1_SDA
                                   MPP10 - P_CRS (in)
                                   MPP11 - P_TX_ERR(out)
                                   MPP12 - PCI_INT1(GPIO in)
                                   MPP13 - PCI_INT2(GPIO in)
                                   MPP14, MPP15 - 7-SegA (GPIO out)*/
                                MV_ASM_REG_WRITE(0xF1010000,0x00222203)
                                MV_ASM_REG_WRITE(0xF1010004,0X00001133)
                                MV_ASM_REG_WRITE(0xF1010050,0x00000000)
                                /* Initialize GPIO */ 
                                MV_ASM_REG_WRITE(0xF1010104,0xFFFF3717)
                                MV_ASM_REG_WRITE(0xF101010C,0x00003002)

                                /*Setting the GPIO 7SegA leds to "0" */ 
                                /*7SegA MPP[15,14,7,6] */ 
                                MV_ASM_REG_WRITE(0xF1010100,0x00000000)
                                MV_ASM_REG_WRITE(0xF1010104,0xFFFF3F3F)
1:                                
#endif

#if defined(MV_88F5181_DDRI)
                                tst confReg, #MV_88F5181_DDRI_BIT
                                beq 1f

                                /* set CS2 params for 7segment */
                                MV_ASM_REG_WRITE(0xF1010464,0x8FCFFFFF)
                                MV_ASM_REG_WRITE(0xF1020060,0x000F1B11)
                                MV_ASM_REG_WRITE(0xF1020064,0xf0000000)

                                
                                MV_ASM_REG_WRITE(0xF1010000,0x00332222)
                                MV_ASM_REG_WRITE(0xF1010004,0x11111111)
                                MV_ASM_REG_WRITE(0xF1010050,0x00001111)
                                MV_ASM_REG_WRITE(0xF101010C,0x000000c0)
1:                                
#endif

#if defined(MV_88F5181_PRPMC) || defined(MV_88F5181_MNG)
                                MV_ASM_REG_WRITE(0xF1010000,0x00000003)
                                MV_ASM_REG_WRITE(0xF1010004,0x10001111)
                                MV_ASM_REG_WRITE(0xF1010050,0x00001111)
         /* first define MONCARCH GPP2 as input and leds as output*/
         /* C code will later configure the rest of GPPs */
                                MV_ASM_REG_WRITE(0xF1010104,0xFFFF8FFC)
#endif 

#if defined(MV_88F5181_PCI_PEX)
                                MV_ASM_REG_WRITE(0xF1010000,0x00330000)
                                MV_ASM_REG_WRITE(0xF1010004,0x00000000)
                                MV_ASM_REG_WRITE(0xF1010050,0x00000000)
                                MV_ASM_REG_WRITE(0xF1010100,0x00000001)
                                MV_ASM_REG_WRITE(0xF1010104,0xFFFF0FFF) /*seting the leds as outputs */ 
#endif


                                
#if defined(UART)
                                /*Configuring Uart0 */ 
                                MV_ASM_REG_WRITE(0xF101200C,0x00000083) /*Enables reading and writing of the Divisor Latch, 8 bits per char and 1 stop bit */ 
                                MV_ASM_REG_WRITE(0xF1012000,0x0000005A) /* baud = (clock frequency) / (16 * divisor)  */ 
                                /* baud = 115200, Uart clock = 166Mhz => divisor = 90 */ 
                                MV_ASM_REG_WRITE(0xF101200C,0x00000003) /*Disable reading and writing of the Divisor */ 
                                                         
#endif
                                                                      
#if defined(MV_88F1181)
#if defined(DDRII)
                                tst confReg, #DDRII_BIT
                                beq 1f

                                /* Init DDR I/F */
                                MV_ASM_REG_WRITE(0xF1001400,0X03158400)/*DDR2, 32Bits, x16 */
                                MV_ASM_REG_WRITE(0xF1001404,0X04041040)/*CL=3 -> StBurstDel = 0x4 */
                                /*DDR SDRAM Address/Data Pads Calibration */
                                /*Enabling Write */
                                MV_ASM_REG_WRITE(0xF10014C0,0x806F000A) /*enable write */
                                MV_ASM_REG_WRITE(0xF10014C4,0x806F000A) /*enable write */
                                MV_ASM_REG_WRITE(0xF10014C0,0x006F100A) /*SR bits[13:12] = 0x1 */
                                MV_ASM_REG_WRITE(0xF10014C4,0x006F100A) /*SR bits[13:12] = 0x1 */

                                /*DDRII windows setting */
                                MV_ASM_REG_WRITE(0xF1001504,0x03ff0001) /*Window0, 64M, Enable */
                                MV_ASM_REG_WRITE(0xF100150C,0x00000000) /*Window1, Disable */
                                MV_ASM_REG_WRITE(0xF1001510,0x04000000) /*window2 base address 64M */
                                MV_ASM_REG_WRITE(0xF1001514,0x03ff0001)/*Window2, 64M, Enable */
                                MV_ASM_REG_WRITE(0xF100151C,0x00000000) /*Window3, Disable */




                                /*ODT configuration */
    #if defined(ODT_CS0_CS2)
                                tst confReg, #ODT_CS0_CS2_BIT
                                beq 2f
    
                                /* 2 slot Populated (accessing CS0 and CS2)  */
                                MV_ASM_REG_WRITE(0xF1001494,0x01020104)
                                MV_ASM_REG_WRITE(0xF1001498,0x00000022)
                                MV_ASM_REG_WRITE(0xF100149C,0x00000E05)/*Dunit set to 150 ohm */
                                MV_ASM_REG_WRITE(0xF1001420,0x00000404) /*Extended DDR SDRAM Mode - Setting to 75 ohm */
                                

2:                                
    #endif
    #if defined(ODT_CS0)
                                tst confReg, #ODT_CS0_BIT
                                beq 3f


                                /* Single slot Populated (Slot 1, far from the controller)  */
                               MV_ASM_REG_WRITE(0xF1001494,0x00010000)
                               MV_ASM_REG_WRITE(0xF1001498,0x00000002)
                               MV_ASM_REG_WRITE(0xF100149C,0x00000A01)/*Dunit set to 75 ohm */
                               MV_ASM_REG_WRITE(0xF1001420,0x00000440) /*Extended DDR SDRAM Mode - Setting to 150 ohm */
                               

3:                               
    #endif
    

    /*#if !defined(ODT_CS0_CS2) || !defined(ODT_CS0)*/
                                tst confReg, #ODT_CS0_CS2_BIT
                                beq 4f
                                b 6f
4:                                                              
                                tst confReg, #ODT_CS0_BIT
                                beq 5f
                                b 6f
5:                                    
                                MV_ASM_REG_WRITE(0xF1001494,0x00000000)
                                MV_ASM_REG_WRITE(0xF100149C,0x00000000)
                                

6:                                
    /*#endif*/
1:
#endif /*DDRII */

#if defined(DDRI)
                                tst confReg, #DDRI_BIT
                                beq 1f

                                /* Init DDR I/F */
                            
                                MV_ASM_REG_WRITE(0xF1001400,0X03248400)
                                MV_ASM_REG_WRITE(0xF1001404,0X04041040) /*CL=3 -> StBurstDel = 0x4 */
                                /*MV_ASM_REG_WRITE(0xF1001404,0X03041040)*/ /*CL=2 -> StBurstDel = 0x3 */ /*For gil */

                               

                                MV_ASM_REG_WRITE(0xF1001408,0x11602220)  
                                MV_ASM_REG_WRITE(0xF100140c,0x30F) 
                                

                                
1:
#endif                         

                                MV_ASM_REG_WRITE(0xF1001414,0x00000000)
                               /*Load Mode Reg */
                                MV_ASM_REG_WRITE(0xF100141c,0x00000032)
                                /*MV_ASM_REG_WRITE(0xF100141c,0x00000022)/*For Gil */
                                MV_ASM_REG_WRITE(0xF1001418,0x00000003) /*load mode reg in order to init the dimm*/
#if defined(DDRII)
                                tst confReg, #DDRII_BIT
                                beq 1f

                                /*Load Extended Mode Reg */
                                MV_ASM_REG_WRITE(0xF100141c,0x00000432)
                                MV_ASM_REG_WRITE(0xF1001418,0x00000004) 

                                MV_ASM_REG_WRITE(0xF1001408,0x11812220)  
                                MV_ASM_REG_WRITE(0xF100140c,0x30F) 
                                

                                
1:                                

#endif
#endif /*MV_88F1181 */

#if defined(MV_88F5181_DDRII)
                                tst confReg, #MV_88F5181_DDRII_BIT
                                beq 1f


                                /* Init DDR I/F */
                                MV_ASM_REG_WRITE(0xF1001400,0X03158400)/*DDR2, 32Bits, x16 */
                                MV_ASM_REG_WRITE(0xF1001404,0X04041040)/*CL=3 -> StBurstDel = 0x4 */
                                /*DDR SDRAM Address/Data Pads Calibration */
                                /*Enabling Write */
                                MV_ASM_REG_WRITE(0xF10014C0,0x806F000A) /*enable write */
                                MV_ASM_REG_WRITE(0xF10014C4,0x806F000A) /*enable write */
                                MV_ASM_REG_WRITE(0xF10014C0,0x006F100A) /*SR bits[13:12] = 0x1 */
                                MV_ASM_REG_WRITE(0xF10014C4,0x006F100A) /*SR bits[13:12] = 0x1 */

                                /*DDRII windows setting */
                                MV_ASM_REG_WRITE(0xF1001504,0x03ff0001) /*Window0, 64M, Enable */
                                MV_ASM_REG_WRITE(0xF100150C,0x00000000) /*Window1, Disable */
                                MV_ASM_REG_WRITE(0xF1001510,0x04000000) /*window2 base address 64M */
                                MV_ASM_REG_WRITE(0xF1001514,0x03ff0001)/*Window2, 64M, Enable */
                                MV_ASM_REG_WRITE(0xF100151C,0x00000000) /*Window3, Disable */


                                
                                /*ODT configuration */
    #if defined(ODT_CS0_CS2)
                                tst confReg, #ODT_CS0_CS2_BIT
                                beq 2f
    
                                /* 2 slot Populated (accessing CS0 and CS2)  */
                                MV_ASM_REG_WRITE(0xF1001494,0x01020104)
                                MV_ASM_REG_WRITE(0xF1001498,0x00000022)
                                MV_ASM_REG_WRITE(0xF100149C,0x00000E05)/*Dunit set to 150 ohm */
                                MV_ASM_REG_WRITE(0xF1001420,0x00000404) /*Extended DDR SDRAM Mode - Setting to 75 ohm */
                                

2:                                
    #endif
    #if defined(ODT_CS0)
                                tst confReg, #ODT_CS0_BIT
                                beq 3f
    

                                /* Single slot Populated (Slot 1, far from the controller)  */
                               MV_ASM_REG_WRITE(0xF1001494,0x00010000)
                               MV_ASM_REG_WRITE(0xF1001498,0x00000002)
                               MV_ASM_REG_WRITE(0xF100149C,0x00000A01)/*Dunit set to 75 ohm */
                               MV_ASM_REG_WRITE(0xF1001420,0x00000440) /*Extended DDR SDRAM Mode - Setting to 150 ohm */
                               

3:                               
    #endif
    

    /*#if !defined(ODT_CS0_CS2) || !defined(ODT_CS0)*/
                                tst confReg, #ODT_CS0_CS2_BIT
                                beq 4f
                                b 6f
4:                                                              
                                tst confReg, #ODT_CS0_BIT
                                beq 5f
                                b 6f
5:                                    
                                MV_ASM_REG_WRITE(0xF1001494,0x00000000)
                                MV_ASM_REG_WRITE(0xF100149C,0x00000000)
6:                                
    /*#endif*/



              

                                MV_ASM_REG_WRITE(0xF1001414,0x00000000)
                               /*Load Mode Reg */
                                MV_ASM_REG_WRITE(0xF100141c,0x00000032)
                                /*MV_ASM_REG_WRITE(0xF100141c,0x00000022)  */ /*For Gil */
                                MV_ASM_REG_WRITE(0xF1001418,0x00000003) /*load mode reg in order to init the dimm*/

                                /*Load Extended Mode Reg */
                                MV_ASM_REG_WRITE(0xF100141c,0x00000432)
                                MV_ASM_REG_WRITE(0xF1001418,0x00000004) 

                                MV_ASM_REG_WRITE(0xF1001408,0x11812220)  
                                MV_ASM_REG_WRITE(0xF100140c,0x30F) 
                                


1:
#endif /*MV_88F5181_DDRII */

#if defined(MV_88F5181_PRPMC) || defined(MV_88F5181_PCI_PEX) || defined(MV_88F5181_MNG)
    
                                /* CS0 is 256MB , CS1,CS2,CS3 all are disables */
                                /* disable all CS at first */
                                MV_ASM_REG_WRITE(0xF1001504,0x00000000) 
                                MV_ASM_REG_WRITE(0xF100150C,0x00000000) 
                                MV_ASM_REG_WRITE(0xF1001514,0x00000000) 
                                MV_ASM_REG_WRITE(0xF100151C,0x00000000)         
                                
                                /* open CS0 to 256 MB*/
                                MV_ASM_REG_WRITE(0xF1001504,0x0fff0001)         
                                
                                MV_ASM_REG_WRITE(0xF1001400,0x03248400)
                                
                                MV_ASM_REG_WRITE(0xF1001404,0x4041000)
                                
                                MV_ASM_REG_WRITE(0xF1001408,0x11602220)  
                                MV_ASM_REG_WRITE(0xF100140C,0x0000030F)  
                                MV_ASM_REG_WRITE(0xF1001410,0x00000020)          
                                MV_ASM_REG_WRITE(0xF100141C,0x00000062)
#endif/* (MV_88F5181_PRPMC || MV_88F5181_PCI_PEX) */

#if defined(MV_88F5181_DDRI)
                                tst confReg, #MV_88F5181_DDRI_BIT
                                beq 1f

 /* disable all CS at first */
                                MV_ASM_REG_WRITE(0xF1001504,0x00000000) 
                                MV_ASM_REG_WRITE(0xF100150C,0x00000000) 
                                MV_ASM_REG_WRITE(0xF1001514,0x00000000) 
                                MV_ASM_REG_WRITE(0xF100151C,0x00000000)         
                         
                         
                                 /*DDRI windows settig */
                                 MV_ASM_REG_WRITE(0xF1001504,0x03ff0001) /*Window0, 64M, Enable */
                                 MV_ASM_REG_WRITE(0xF1001510,0x04000000) /*window2 base address 64M */
                                 MV_ASM_REG_WRITE(0xF1001514,0x03ff0001)/*Window2, 64M, Enable */
                         
                                                        /* Init DDR I/F */
                                                    
                                 /*MV_ASM_REG_WRITE(MV_ASM_REG_WRITE(0xF1001400,0x03248400)*/
                                 MV_ASM_REG_WRITE(0xF1001400,0x03148400)
                                 MV_ASM_REG_WRITE(0xF1001404,0x04041040) /*CL=3 -> StBurstDel = 0x4 */
                                 /*MV_ASM_REG_WRITE(MV_ASM_REG_WRITE(0xF1001404,0X03041040)*/ /*CL=2 -> StBurstDel = 0x3 */ /*For gil */ 
                         
                                                       
                         
                                 MV_ASM_REG_WRITE(0xF1001408,0x11602220)  
                                 /*MV_ASM_REG_WRITE(MV_ASM_REG_WRITE(0xF100140c,0x30F) */
                                 MV_ASM_REG_WRITE(0xF100140c,0x0000040C)

1:                                 
#endif
                                
                                                                
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)/* delay by writing 0's */
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                                                      
                                /*DDR SDRAM Initialization Control */ 
                                MV_ASM_REG_WRITE(0xF1001480,0x00000001) 
                                
                                DO_WAIT;DO_WAIT;DO_WAIT;DO_WAIT;DO_WAIT
                                


                                
                                        

#if defined(ODT_CS0_CS2)
                                tst confReg, #ODT_CS0_CS2_BIT
                                beq 1f
          
                                /*SDRAM - Window0, Bar1, CS0, 64MB, Base 0x0 */ 
                                MV_ASM_REG_WRITE(0xF1041820,0x03ff0E01)
                                MV_ASM_REG_WRITE(0xF1041824,0x00000000)
                                /*SDRAM - Window2, Bar1, CS2, 64MB, Base 0x0 */ 
                                MV_ASM_REG_WRITE(0xF1041840,0x03ff0B01)
                                MV_ASM_REG_WRITE(0xF1041844,0x04000000)
                                

1:                                
          
#endif

#if defined(MV_88F1181)
          #if defined(ODT_CS0_CS2)
                                tst confReg, #ODT_CS0_CS2_BIT
                                beq 2f
          
                                /*SDRAM - Window0, Bar1, CS0, 64MB, Base 0x0 */ 
                                MV_ASM_REG_WRITE(0xF1031820,0x03ff0E01)
                                MV_ASM_REG_WRITE(0xF1031824,0x00000000)
                                /*SDRAM - Window2, Bar1, CS2, 64MB, Base 0x0 */ 
                                MV_ASM_REG_WRITE(0xF1031840,0x03ff0B01)
                                MV_ASM_REG_WRITE(0xF1031844,0x04000000)
2:                                        
          
          #endif
                                MV_ASM_REG_WRITE(0xF1041b00,0x0084cce5)
          
                                
#endif
                                
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000) /* delay by writing 0's */
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                                                      
#ifndef MV_88F1181 /*not feroceon -> socrates                          */ 
/*PCI                                                                  */ 
#if defined(MV_88F5181_PRPMC) || defined(MV_88F5181_PCI_PEX) || defined(MV_88F5181_MNG)
                                MV_ASM_REG_WRITE(0xF1031d00,0x00000030)
#else
                                MV_ASM_REG_WRITE(0xF1031d00,0x80000030)
#endif



                                /* Open SDRAM PCI BARs */ 
                                MV_ASM_REG_WRITE(0xF1030c08,0xffff000)       /* CS[0] size 256MB */ 
                                MV_ASM_REG_WRITE(0xF1030c3c,0xffff780e)      /* Enable BARs CS[0],  */ 
/*Gunit */ 
                                /* PHY 0 initialization */ 
                                MV_ASM_REG_WRITE(0xF1072004,0x28a0ce2)
#if defined(SOCRATES_BE)  /*Swap mode = 0x1 */ 
                                tst confReg, #SOCRATES_BE_BIT
                                beq 1f

                                MV_ASM_REG_WRITE(0xF107241c,0x1000078)
1:
#endif 

                                
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000) /* delay by writing 0's */
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000)
                                                                      
                                MV_ASM_REG_WRITE(0xF1072004,0x3084111) /*turning on link leds */ 
/*Usb                                                                  */ 
                                MV_ASM_REG_WRITE(0xF1050440,0xff000016)/*Setting PLVDD12 = 2'b10 */ 
                                MV_ASM_REG_WRITE(0xF1050430,0xf31d0285)/*Setting RX_DATA_BLOCK_LENGTH = 2'b11 (rev1.6) */ 




                              
#endif/*not feroceon -> socrates */ 


#if defined(MV_88F1181)
                                /*Setting the GPIO 7SegA and 7SegB leds to "1" */ 
                                /*7SegA MPP[7,6,3,2] */ 
                                /*7SegB MPP[15:12] */ 
                                MV_ASM_REG_WRITE(0xF1010100,0x00001004)
                                MV_ASM_REG_WRITE(0xF1010104,0x00000F33)

                                /*Setting the GPIO 7SegA and 7SegB leds to "5" */ 
                                /*7SegA MPP[7,6,3,2] */
                                /*7SegB MPP[15:12] */
                                /*MV_ASM_REG_WRITE(0xF1010100,0x00005014) */ 
                                /*MV_ASM_REG_WRITE(0xF1010104,0x00000F33) */ 



#endif
#if defined(MV_88F5181_DDRII)
                                tst confReg, #MV_88F5181_DDRII_BIT
                                beq 1f

                                /*Setting the GPIO 7SegA leds to "1" */ 
                                /*7SegA MPP[7,6,15,14] */ 
                                MV_ASM_REG_WRITE(0xF1010100,0x00004000)
                                MV_ASM_REG_WRITE(0xF1010104,0xFFFF3F3F)
1:                                
#endif

#if defined(MV_88F5181_PRPMC) || defined(MV_88F5181_PCI_PEX) || defined(MV_88F5181_MNG)
                                /*Setting the GPIO 7SegA leds to "1" */ 
                                MV_ASM_REG_WRITE(0xF1010100,0x00006000,
#endif /*(MV_88F5181_PRPMC || MV_88F5181_PCI_PEX) */ 
#if defined(MV_88F5181_DDRI)
                                tst confReg, #MV_88F5181_DDRI_BIT
                                beq 1f

                                /*Setting the GPIO 7SegA leds to "1" */ 
                                MV_ASM_REG_WRITE(0xF0000010,0x00000010)
                                
                                MV_ASM_REG_WRITE(0xF1020204,0x00000000) /* delay by writing 0's */
1:                                
#endif


                                /*Release the ARM CPU from reset (by clearing bit[1] */ 
                                /*Enabling PCI express accessing 88F1181/88F5181 (by clearing bit[0])  */ 
                                /*MV_ASM_REG_WRITE(0xF1020104,0x00000000)*/
                                
                                DO_WAIT;DO_WAIT;DO_WAIT;DO_WAIT;DO_WAIT
                                
                                mov     PC, lr         /* r11 is saved link register */                                

