/*******************************************************************************
Copyright (C) Marvell International Ltd. and its affiliates

********************************************************************************
Marvell GPL License Option

If you received this File from Marvell, you may opt to use, redistribute and/or 
modify this File in accordance with the terms and conditions of the General 
Public License Version 2, June 1991 (the "GPL License"), a copy of which is 
available along with the File in the license.txt file or by writing to the Free 
Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 or 
on the worldwide web at http://www.gnu.org/licenses/gpl.txt. 

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE IMPLIED 
WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY 
DISCLAIMED.  The GPL License provides additional details about this warranty 
disclaimer.

*******************************************************************************/

#define MV_ASMLANGUAGE
#include "mvOsAsm.h"
#include <config.h>
#include <version.h>
#include "mvBoardEnvSpec.h"
#include "mvCtrlEnvSpec.h"
#include "mvCpuIfConfig.h"
#include "mvPexRegs.h"
#include "mvDramIfRegs.h"

#define MAGIC_BYTE0	((MV_BOARD_I2C_MAGIC >> 24 )& 0xff)
#define MAGIC_BYTE1	((MV_BOARD_I2C_MAGIC >> 16 )& 0xff)
#define MAGIC_BYTE2	((MV_BOARD_I2C_MAGIC >> 8)& 0xff)
#define MAGIC_BYTE3	((MV_BOARD_I2C_MAGIC >> 0)& 0xff)

#ifdef CONFIG_KUROBOX_PLATFORM
/*Saito changed 2006/03/15*/
/*Uart1 must be active*/
/*MPP2 MPP3 must be GPIO */
/*MPP14 MPP15 must be SATA0 SATA1 Active LED */
/* LS-GL */ 
/* orginal #define RD_88F5182_KUROBOX_MPP0_7		0x55220000*/
/*NAND CHIP & PEX Enable*/
#define RD_88F5182_KUROBOX_MPP0_7		0x44220003
#define RD_88F5182_KUROBOX_MPP8_15		0x55550000
#define RD_88F5182_KUROBOX_MPP16_23		0x0
/*******/
#define KUROBOX_BOARD_XXXXXXXXXX_MPP0_7	    	0x44440000
#define KUROBOX_BOARD_XXXXXXXXXX_MPP8_15	   	0x00000000
#define KUROBOX_BOARD_XXXXXXXXXX_MPP16_23  		0x0
/* defines */
#define	 UART1_RBR_REG	0x12100
#define	 UART1_THR_REG	0x12100
#define	 UART1_DLL_REG	0x12100
#define	 UART1_IER_REG	0x12104
#define	 UART1_DLH_REG	0x12104
#define	 UART1_IIR_REG	0x12108
#define	 UART1_FCR_REG	0x12108
#define	 UART1_LCR_REG	0x1210C
#define	 UART1_MCR_REG	0x12110
#define	 UART1_LSR_REG	0x12114
#define	 UART1_MSR_REG	0x12118
#define	 UART1_SCR_REG	0x1211C
#define	 UART1_LSR_THRE	0x00020

#define	 UART0_RBR_REG	0x12000
#define	 UART0_THR_REG	0x12000
#define	 UART0_DLL_REG	0x12000
#define	 UART0_IER_REG	0x12004
#define	 UART0_DLH_REG	0x12004
#define	 UART0_IIR_REG	0x12008
#define	 UART0_FCR_REG	0x12008
#define	 UART0_LCR_REG	0x1200C
#define	 UART0_MCR_REG	0x12010
#define	 UART0_LSR_REG	0x12014
#define	 UART0_MSR_REG	0x12018
#define	 UART0_SCR_REG	0x1201C
#define	 UART0_LSR_THRE	0x00020

/*saitochange*/
#define	CPU_TIME_CONTROL	0x20300
#define	CPU_TIMER_0			0x20314
#define CPU_TIMER_DATA		0xFFFFFFFF
#define CPU_400_BENCH		0xFFEBFFFF
#define DRAM_BUF_REG1	0x20318	/* sdram config			        */
#define DRAM_BUF_REG5	0x2040c	/* sdram timing control low     */
#define STATIC_SDRAM_TIME_CTRL_LOW_600	0x22d24440
#define STATIC_SDRAM_TIME_CTRL_LOW_500	0x11b13330
#define STATIC_SDRAM_TIME_CTRL_LOW_400	0x11812220

#define STATIC_SDRAM_CONFIG_ORION1		0x3158618
#define STATIC_SDRAM_CONFIG_ORION2		0x7158618


#define CHARA_CPU						0x20435055  /*" CPU"*/
#define CHARA_eq						0x203d2020  /*" =  "*/
#define CHARA_High						0x48696768  /*"High"*/
#define CHARA_Low						0x4C6f7720  /*"Low "*/


#define CHARA_Orio						0x4f72696f  /*"Orio"*/
#define CHARA_n1						0x6e312020  /*"n1  "*/
#define CHARA_n2						0x6e322020  /*"n2  "*/
#define CHARA_unkn						0x756e6b6e  /*"unkn"*/
#define CHARA_own						0x6f776e20  /*"own "*/


/**** Cache****/
#define Region_256K	0x11
#define Region_4G	0x1f

#define Region_Enable	1



#endif
                  
/*
  get_board_id - get board id from twsi eeprom
  input : r5 - board id data start offset in the eeprom
        
*/
.globl platformsetup

/************************************************/
/*              platformsetup                   *
/************************************************/

platformsetup:

  /* if we are DDRI board then we
  should open the CS2 for only 1 MB 
  to turn the 7segement and not to overlap with the
  internal registers and we will do it always
  */

  ldr  r4, =0x000f1b11
  MV_DV_REG_WRITE_ASM(r4, r1, 0x20060)

  /* change reg base to 0xf1000000 */
  ldr     r4, =CFG_MV_REGS
  MV_DV_REG_WRITE_ASM(r4, r1, 0x20080)


  /* save Link Registers */
  mov  r2, lr

  bl      _i2cInit


/*****************************************************************************/
/*Read Panel Flag */
  mov     r7,#0x1e
  bl      _PanelRead

  and     r7,r7,#0x03
  cmp     r7,#0x01
  beq     ExtPowerON
  cmp     r7,#0x02
  beq     IntPowerON

ExtPowerON:
  mov     r4,#0x50
  mov     r7,#0xff         /* Power Status*/
  bl      _i2cRead
  and     r7,r7,#03
  cmp     r7,#3
  bne     Power_Check_done

/*Power Off*/
  mov     r7,#0x19
  mov     r7,r7,LSL #8
  mov     r6,#0x00
  orr     r7,r6,r7
  mov     r7,r7,LSL #8
  mov     r6,#0x02
  orr     r7,r6,r7

  bl      _PanelWrite

  b       Power_Check_done
IntPowerON:

  mov     r4,#0x50
  mov     r7,#0xff         /* Power Status*/
  bl      _i2cRead
  and     r7,r7,#03
  cmp     r7,#3
  bne     Power_Check_done


  /*Write EEprom flag*/
  mov     r4,#0x50       /*EEPROM SubAddr*/
  mov     r7,#0xfe

  mov     r7,r7,LSL #8
  mov     r6,#0x00
  orr     r7,r6,r7

  mov     r7,r7,LSL #8
  mov     r6,#0x01
  orr     r7,r6,r7

  bl      _i2cWrite

  mov     r4, #0x900000
1:
  subs    r4, r4, #1
  bne     1b

  b       Power_Check_done

Power_Check_done:



/*****************************************************************************/

        /* Initialize BUS-L to DDR configuration parameters     */
        /* Must be done prior to DDR operation                  */
        bl      _mvCpuIfPreInit


#if defined(CONFIG_KUROBOX_PLATFORM) && defined(RD_88F5182)

     /*   b   done*/

        /* Initialize UART configuration parameters     */
	b	buffalo_platform      
#endif

#if defined(MV_88F5181) 


#ifndef CONFIG_KUROBOX_PLATFORM


#if defined(RD_88F5182) 

	/* init MPP */
	ldr	r6, =RD_88F5182_2XSATA_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =RD_88F5182_2XSATA_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =RD_88F5182_2XSATA_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	
	/* init GPP , Out enable */
	ldr	r6, =0xFFF0F0C8
	MV_REG_WRITE_ASM (r6, r1, 0x10104) 
	
	/* turn Led to 1 */
	ldr	r6, =0x00000402
	MV_REG_WRITE_ASM (r6, r1, 0x10100) 	

     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480) 

	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)

	bl	_mvDramIfStaticInit

	b	done

#elif defined(RD_88F5182_3)

	/* init MPP */
	ldr	r6, =RD_88F5182_2XSATA3_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =RD_88F5182_2XSATA3_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =RD_88F5182_2XSATA3_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	
	/* init GPP , Out enable */
	ldr	r6, =0xFFCF0EF8
	MV_REG_WRITE_ASM (r6, r1, 0x10104) 
	
	/* turn Led to 1 */
         MV_REG_READ_ASM (r6, r1, 0x10100)
         orr   r6, r6, #1
	MV_REG_WRITE_ASM (r6, r1, 0x10100)     
         

     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480) 

	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)

	bl	_mvDramIfStaticInit

	b	done

#elif defined(RD_88W8660)

	/* init MPP */
	ldr	r6, =RD_88W8660_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =RD_88W8660_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	
	/* init GPP , Out enable */
	ldr	r6, =0xFFF1C 
	MV_REG_WRITE_ASM (r6, r1, 0x10104) 
	
	/* turn Led to 1 */
	ldr	r6, =0xa0	
	MV_REG_WRITE_ASM (r6, r1, 0x10100) 	

     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480) 

	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)

	bl	_mvDramIfStaticInit

	b	done

#elif defined(RD_88W8660_AP82S)

	/* init MPP */
	ldr	r6, =RD_88W8660_AP82S_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =RD_88W8660_AP82S_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	
	/* init GPP , Out enable */
	ldr	r6, =RD_88W8660_AP82S_MPP_OUT_EN 
	MV_REG_WRITE_ASM (r6, r1, 0x10104) 
	
     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480) 


	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)

	bl	_mvDramIfStaticInit

	b	done

#elif defined(RD_88F5181L_FE) 

	/* init MPP */
	ldr	r6, =RD_88F5181L_VOIP_FE_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =RD_88F5181L_VOIP_FE_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =RD_88F5181L_VOIP_FE_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	ldr	r6, =RD_88F5181L_VOIP_FE_MPP_DEV
	MV_REG_WRITE_ASM (r6, r1, 0x10008) 
	
	/* init GPP , Out enable */
	ldr	r6, =0xFFFF0F3C
	MV_REG_WRITE_ASM (r6, r1, 0x10104) 
	
	/* turn Led to 1 -turn off leds0 0,15 wireless indication-*/
	ldr	r6, =0xE001
	MV_REG_WRITE_ASM (r6, r1, 0x10100) 	

     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480) 

	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)

	bl	_mvDramIfStaticInit

	b	done

#elif defined(RD_88F5181L_GE) 

	/* init MPP */
	ldr	r6, =RD_88F5181L_VOIP_GE_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =RD_88F5181L_VOIP_GE_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =RD_88F5181L_VOIP_GE_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	ldr	r6, =RD_88F5181L_VOIP_GE_MPP_DEV
	MV_REG_WRITE_ASM (r6, r1, 0x10008) 
	
	/* init GPP , Out enable */
	ldr	r6, =0xFFFF0330
	MV_REG_WRITE_ASM (r6, r1, 0x10104) 
	
	/* turn Led to 1 -turn off leds 10 wireless indication-*/
	ldr	r6, =0xC
	MV_REG_WRITE_ASM (r6, r1, 0x10100) 	

     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480) 

	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)

	bl	_mvDramIfStaticInit

	b	done

#elif defined(MV_POS_NAS) 

        /* init MPP */
        ldr     r6, =RD_88F5181_POS_NAS_MPP0_7
        MV_REG_WRITE_ASM (r6, r1, 0x10000)
        ldr     r6, =RD_88F5181_POS_NAS_MPP8_15
        MV_REG_WRITE_ASM (r6, r1, 0x10004)
        ldr     r6, =RD_88F5181_POS_NAS_MPP16_23
        MV_REG_WRITE_ASM (r6, r1, 0x10050)
        ldr     r6, =RD_88F5181_POS_NAS_MPP_DEV
        MV_REG_WRITE_ASM (r6, r1, 0x10008)

        /* init GPP , Out enable */
        ldr     r6, =0x00000BDF
        MV_REG_WRITE_ASM (r6, r1, 0x10104)

        /* turn Led to 1 */
        ldr     r6, =0x0000e000
        MV_REG_WRITE_ASM (r6, r1, 0x10100)

        /*DDR SDRAM Initialization Control */
        ldr     r6, =0x00000001
        MV_REG_WRITE_ASM (r6, r1, 0x1480)

        /* PCI ARBITER */
        ldr     r6, =0x80000030
        MV_REG_WRITE_ASM (r6, r1, 0x31d00)

        bl      _mvDramIfStaticInit

        b       done

#elif defined(MV_VOIP)

	/* init MPP */
	ldr	r6, =RD_88F5181_VOIP_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =RD_88F5181_VOIP_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =RD_88F5181_VOIP_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	ldr	r6, =RD_88F5181_VOIP_MPP_DEV
	MV_REG_WRITE_ASM (r6, r1, 0x10008) 
	
	/* init GPP , Out enable */
	ldr	r6, =0x000005F5
	MV_REG_WRITE_ASM (r6, r1, 0x10104) 
	
	/* turn Led to 1 */
	ldr	r6, =0x0000D000
	MV_REG_WRITE_ASM (r6, r1, 0x10100) 	

     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480) 

	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)

	bl	_mvDramIfStaticInit

	b	done

#elif defined(DB_PRPMC)

	/* init MPP */
	ldr	r6, =DB_88F5181_DDR1_PRPMC_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =DB_88F5181_DDR1_PRPMC_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =DB_88F5181_DDR1_PRPMC_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	ldr	r6, =DB_88F5181_DDR1_PRPMC_MPP_DEV
	MV_REG_WRITE_ASM (r6, r1, 0x10008) 
	
	/* init GPP , Out enable */
	ldr	r6, =0xFFFF8FFC
	MV_REG_WRITE_ASM (r6, r1, 0x10104) 
	
	/* turn Led to 1 */
	ldr	r6, =0x00006000
	MV_REG_WRITE_ASM (r6, r1, 0x10100) 	

     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480) 

	bl	_mvDramIfStaticInit

	b	done

#elif defined(DB_MNG)

	/* init MPP */
	ldr	r6, =DB_88F5181_DDR1_MNG_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =DB_88F5181_DDR1_MNG_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =DB_88F5181_DDR1_MNG_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	ldr	r6, =DB_88F5181_DDR1_MNG_MPP_DEV
	MV_REG_WRITE_ASM (r6, r1, 0x10008) 
	
	/* init GPP , Out enable */
	ldr	r6, =0xFFFF8FFC
	MV_REG_WRITE_ASM (r6, r1, 0x10104) 
	
	/* turn Led to 1 */
	ldr	r6, =0x00006000
	MV_REG_WRITE_ASM (r6, r1, 0x10100) 	

     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480) 

	bl	_mvDramIfStaticInit

	b	done

#elif defined(DB_PEX_PCI)


	/* init MPP */
	ldr	r6, =DB_88F5181_DDR1_PEXPCI_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =DB_88F5181_DDR1_PEXPCI_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =DB_88F5181_DDR1_PEXPCI_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	ldr	r6, =DB_88F5181_DDR1_PEXPCI_MPP_DEV
	MV_REG_WRITE_ASM (r6, r1, 0x10008) 
	
	/* init GPP , Out enable */
	ldr	r6, =0xFFFF0FFF
	MV_REG_WRITE_ASM (r6, r1, 0x10104) 
	
	/* turn Led to 1 */
	ldr	r6, =0x00001000
	MV_REG_WRITE_ASM (r6, r1, 0x10100) 	

     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480) 

	bl	_mvDramIfStaticInit

	b	done
         
#endif  /*RD_88F5182*/

        /* First Try : see if we have somthing on MV_BOARD_ID_EEPROM_OFFSET0*/
        
        mov     r5, #(0xff & (MV_BOARD_ID_EEPROM_OFFSET0 ))
        orr     r5, r5, #(0xff00 & (MV_BOARD_ID_EEPROM_OFFSET0))
        
        /*get_board_id*/
        
        mov     r4, #MV_BOARD_ID_EEPROM 
        mov     r7, r5

        bl      _i2cRead                /* result in r7 */

        and	 r7, r7, #0xff
        cmp     r7, #MAGIC_BYTE0 
        bne	offset1

        mov     r4, #MV_BOARD_ID_EEPROM 
        mov     r7, r5
        add     r7, r7, #1
        bl      _i2cRead                /* result in r7 */
        and	r7, r7, #0xff
        cmp     r7, #MAGIC_BYTE1 
        bne	offset1


        mov     r4, #MV_BOARD_ID_EEPROM 
        mov     r7, r5
        add     r7, r7, #2
        bl      _i2cRead                /* result in r7 */
        and	r7, r7, #0xff
        cmp     r7, #MAGIC_BYTE2 
        bne	offset1


        mov     r4, #MV_BOARD_ID_EEPROM 
        mov     r7, r5
        add     r7, r7, #3
        bl      _i2cRead                /* result in r7 */
        and	r7, r7, #0xff
        cmp     r7, #MAGIC_BYTE3 
        bne	offset1


        mov     r4, #MV_BOARD_ID_EEPROM 
        mov     r7, r5
        add     r7, r7, #5
        bl      _i2cRead                /* result in r7 */
        and	r7, r7, #0xff

        
        cmp    r7, #DB_88F5181_5281_DDR1     
        beq	db_88f5181_5281_ddr1
        cmp    r7, #DB_88F5181_5281_DDR2     
        beq	db_88f5181_5281_ddr2
        cmp    r7, #DB_88F5X81_DDR2
        beq    db_88f5x81_ddrx          
        cmp    r7, #DB_88F5X81_DDR1
        beq    db_88f5x81_ddrx          
        cmp    r7, #DB_88F5182_DDR2
        beq	db_88f5182_ddr2
        cmp    r7, #DB_88F5181L_DDR2_2XTDM
        beq	db_88f5181L_ddr2
	cmp    r7, #DB_88W8660_DDR2
	beq	db_88w8660_ddr2        

offset1:
        
        /* Second Try : see if we have somthing on MV_BOARD_ID_EEPROM_OFFSET1*/
        
        mov     r5, #(0xff & (MV_BOARD_ID_EEPROM_OFFSET1))
        orr     r5, r5, #(0xff00 & (MV_BOARD_ID_EEPROM_OFFSET1))
        
        /* now indicate it is address that is bigger than 256 */
        orr     r5, r5, #0x80000000
        
        /*get_board_id*/
        
        mov     r4, #MV_BOARD_ID_EEPROM 
        mov     r7, r5

        bl      _i2cRead                /* result in r7 */

        and	 r7, r7, #0xff
        cmp     r7, #MAGIC_BYTE0 
        bne	others

        mov     r4, #MV_BOARD_ID_EEPROM 
        mov     r7, r5
        add     r7, r7, #1
        bl      _i2cRead                /* result in r7 */
        and	r7, r7, #0xff
        cmp     r7, #MAGIC_BYTE1 
        bne	others


        mov     r4, #MV_BOARD_ID_EEPROM 
        mov     r7, r5
        add     r7, r7, #2
        bl      _i2cRead                /* result in r7 */
        and	r7, r7, #0xff
        cmp     r7, #MAGIC_BYTE2 
        bne	others


        mov     r4, #MV_BOARD_ID_EEPROM 
        mov     r7, r5
        add     r7, r7, #3
        bl      _i2cRead                /* result in r7 */
        and	r7, r7, #0xff
        cmp     r7, #MAGIC_BYTE3 
        bne	others


        mov     r4, #MV_BOARD_ID_EEPROM 
        mov     r7, r5
        add     r7, r7, #5
        bl      _i2cRead                /* result in r7 */
        and	r7, r7, #0xff

        
        cmp    r7, #DB_88F5181_5281_DDR1     
        beq	db_88f5181_5281_ddr1
        cmp    r7, #DB_88F5181_5281_DDR2     
        beq	db_88f5181_5281_ddr2
        cmp    r7, #DB_88F5X81_DDR2
        beq    db_88f5x81_ddrx          
        cmp    r7, #DB_88F5X81_DDR1
        beq    db_88f5x81_ddrx          
        cmp    r7, #DB_88F5182_DDR2
        beq	db_88f5182_ddr2
        cmp    r7, #DB_88F5181L_DDR2_2XTDM
        beq	db_88f5181L_ddr2
        cmp    r7, #DB_88W8660_DDR2
        beq	db_88w8660_ddr2
        
        b	others
        




db_88w8660_ddr2:

	/* init MPP */
	ldr	r6, =DB_88W8660_DDR2_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =DB_88W8660_DDR2_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
         
	/* turn 7segment to val 1 - Set DevCS0- window 6 is the default*/
	ldr	r6, =0x8FCFFFFF
	MV_REG_WRITE_ASM (r6, r1, 0x1045C)
	ldr	r6, =0x000F1E11
	MV_REG_WRITE_ASM (r6, r1, 0x20050)
	ldr	r6, =0xE0000000
	MV_REG_WRITE_ASM (r6, r1, 0x20054)
        
         
         ldr	r6, =0xE0000010 /* DevCS0 Default base address +0x10 */
         ldr   r6, [r6]
         

	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)


     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480)
         
1:	MV_REG_READ_ASM (r6, r1, 0x1480)
         cmp    r6, #0
         bne 1b

	/* Load r3 with the size to open SDRAM bank 0 */
	mov	r3, #0x04000000   /* Open DRAM bank 0 to 64MB */

        /* Call DRAM basic initialization to allow C runtime stack */
	bl	_mvDramIfBasicInit 
         
         ldr	r6, =0xE0000020 /* DevCS0 Default base address +0x20 */
         ldr   r6, [r6]
         
	b	done


db_88f5181_5281_ddr1: /*old board*/

	/* init MPP */
	ldr	r6, =DB_88F5181_5281_DDR1_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =DB_88F5181_5281_DDR1_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =DB_88F5181_5281_DDR1_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	ldr	r6, =DB_88F5181_5281_DDR1_MPP_DEV
	MV_REG_WRITE_ASM (r6, r1, 0x10008)
         
         
         /* turn 7segment to val 1 - Set DevCS2- window 6 is the default*/
	ldr	r6, =0x8FCFFFFF
	MV_REG_WRITE_ASM (r6, r1, 0x10464)
	ldr	r6, =0x000F1B11
	MV_REG_WRITE_ASM (r6, r1, 0x20060)
	ldr	r6, =0xF0000000
	MV_REG_WRITE_ASM (r6, r1, 0x20064)
        
         
         ldr	r6, =0xF0000010 /* DevCS2 Default base address +0x10 */
         ldr   r6, [r6]
         
        /* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)


     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480)
         
1:	MV_REG_READ_ASM (r6, r1, 0x1480)
         cmp    r6, #0
         bne 1b

	/* Load r3 with the size to open SDRAM bank 0 */
	mov	r3, #0x04000000   /* Open DRAM bank 0 to 64MB */

        /* Call DRAM basic initialization to allow C runtime stack */
	bl	_mvDramIfBasicInit 
         #if 0
         ldr	r6, =0xF0000020 /* DevCS2 Default base address +0x20 */
         ldr   r6, [r6]
         #endif
         
	b	done
         
db_88f5181_5281_ddr2: /*old board*/

	/* init MPP */
	ldr	r6, =DB_88F5181_5281_DDR2_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =DB_88F5181_5281_DDR2_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =DB_88F5181_5281_DDR2_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	ldr	r6, =DB_88F5181_5281_DDR2_MPP_DEV
	MV_REG_WRITE_ASM (r6, r1, 0x10008)
         
	/* init GPP , Out enable */
	ldr	r6, =0xFFFF3F3F 
	MV_REG_WRITE_ASM (r6, r1, 0x10104) 
	
	/* turn Led to 1 */
	ldr	r6, =0x00004000
	MV_REG_WRITE_ASM (r6, r1, 0x10100) 	
         

	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)


     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480)
         
1:	MV_REG_READ_ASM (r6, r1, 0x1480)
         cmp    r6, #0
         bne 1b

	/* Load r3 with the size to open SDRAM bank 0 */
	mov	r3, #0x04000000   /* Open DRAM bank 0 to 64MB */

        /* Call DRAM basic initialization to allow C runtime stack */
	bl	_mvDramIfBasicInit 
         
	/* turn Led to 2 */
	ldr	r6, =0x00008000
	MV_REG_WRITE_ASM (r6, r1, 0x10100) 	
         
	b	done

db_88f5x81_ddrx:

	/* init MPP */
	ldr	r6, =DB_88F5X81_DDRX_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =DB_88F5X81_DDRX_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =DB_88F5X81_DDRX_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	ldr	r6, =DB_88F5X81_DDRX_MPP_DEV
	MV_REG_WRITE_ASM (r6, r1, 0x10008)
         
         /* turn 7segment to val 1 - Set DevCS0- window 6 is the default*/
	ldr	r6, =0x8FCFFFFF
	MV_REG_WRITE_ASM (r6, r1, 0x1045C)
	ldr	r6, =0x000F1E11
	MV_REG_WRITE_ASM (r6, r1, 0x20050)
	ldr	r6, =0xE0000000
	MV_REG_WRITE_ASM (r6, r1, 0x20054)
        
         
         ldr	r6, =0xE0000010 /* DevCS0 Default base address +0x10 */
         ldr   r6, [r6]
         

	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)


     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480)
         
1:	MV_REG_READ_ASM (r6, r1, 0x1480)
         cmp    r6, #0
         bne 1b

	/* Load r3 with the size to open SDRAM bank 0 */
	mov	r3, #0x04000000   /* Open DRAM bank 0 to 64MB */

        /* Call DRAM basic initialization to allow C runtime stack */
	bl	_mvDramIfBasicInit 
         
         ldr	r6, =0xE0000020 /* DevCS0 Default base address +0x20 */
         ldr   r6, [r6]
         
	b	done

         
db_88f5182_ddr2:

	/* init MPP */
	ldr	r6, =DB_88F5182_DDR2_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =DB_88F5182_DDR2_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =DB_88F5182_DDR2_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
         
#if defined(MV_88F5082) 
	MV_REG_READ_ASM (r6, r1, 0x1400)
	bic	r6, r6, #0xc000
	orr	r6, r6, #0x4000
	MV_REG_WRITE_ASM (r6, r1, 0x1400)
#endif
         /* turn 7segment to val 1 - Set DevCS0- window 6 is the default*/
	ldr	r6, =0x8FCFFFFF
	MV_REG_WRITE_ASM (r6, r1, 0x1045C)
	ldr	r6, =0x000F1E11
	MV_REG_WRITE_ASM (r6, r1, 0x20050)
	ldr	r6, =0xE0000000
	MV_REG_WRITE_ASM (r6, r1, 0x20054)
        
         
         ldr	r6, =0xE0000010 /* DevCS0 Default base address +0x10 */
         ldr   r6, [r6]
         

	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)


     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480)
         
1:	MV_REG_READ_ASM (r6, r1, 0x1480)
         cmp    r6, #0
         bne 1b

	/* Load r3 with the size to open SDRAM bank 0 */
	mov	r3, #0x04000000   /* Open DRAM bank 0 to 64MB */

        /* Call DRAM basic initialization to allow C runtime stack */
	bl	_mvDramIfBasicInit 
         
         ldr	r6, =0xE0000020 /* DevCS0 Default base address +0x20 */
         ldr   r6, [r6]
         
	b	done



db_88f5181L_ddr2:

	/* init MPP */
	ldr	r6, =DB_88F5181L_DDR2_2XTDM_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =DB_88F5181L_DDR2_2XTDM_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =DB_88F5181L_DDR2_2XTDM_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 
	ldr	r6, =DB_88F5181L_DDR2_2XTDM_MPP_DEV
	MV_REG_WRITE_ASM (r6, r1, 0x10008)
         
         /* turn 7segment to val 1 - Set DevCS0- window 6 is the default*/
	ldr	r6, =0x8FCFFFFF
	MV_REG_WRITE_ASM (r6, r1, 0x1045C)
	ldr	r6, =0x000F1E11
	MV_REG_WRITE_ASM (r6, r1, 0x20050)
	ldr	r6, =0xE0000000
	MV_REG_WRITE_ASM (r6, r1, 0x20054)
        
         
         ldr	r6, =0xE0000010 /* DevCS0 Default base address +0x10 */
         ldr   r6, [r6]
         

	/* PCI ARBITER */
	ldr	r6, =0x80000030
	MV_REG_WRITE_ASM (r6, r1, 0x31d00)


     	/*DDR SDRAM Initialization Control */
	ldr	r6, =0x00000001
	MV_REG_WRITE_ASM (r6, r1, 0x1480)
         
1:	MV_REG_READ_ASM (r6, r1, 0x1480)
         cmp    r6, #0
         bne 1b

	/* Load r3 with the size to open SDRAM bank 0 */
	mov	r3, #0x04000000   /* Open DRAM bank 0 to 64MB */

        /* Call DRAM basic initialization to allow C runtime stack */
	bl	_mvDramIfBasicInit 
         
         ldr	r6, =0xE0000020 /* DevCS0 Default base address +0x20 */
         ldr   r6, [r6]
         
	b	done
#endif
#if defined(CONFIG_KUROBOX_PLATFORM) && defined(RD_88F5182)

/*****************************************************************************/
/*****************************************************************************/
/*************   Saito changed at 2006/03/16                         *********/
/*****************************************************************************/
/*****************************************************************************/
buffalo_platform:
/*
#define RD_88F5182_KUROBOX_MPP0_7		0x55220000
#define RD_88F5182_KUROBOX_MPP8_15		0x55550000
#define RD_88F5182_KUROBOX_MPP16_23		0x0


#define KUROBOX_BOARD_XXXXXXXXXX_MPP0_7	    	0x44440000
#define KUROBOX_BOARD_XXXXXXXXXX_MPP8_15	   	0x00000000
#define KUROBOX_BOARD_XXXXXXXXXX_MPP16_23  		0x0
*/

  /* init MPP  for LS-GL*/
  ldr	r6, =RD_88F5182_KUROBOX_MPP0_7
  MV_REG_WRITE_ASM (r6, r1, 0x10000) 
  ldr	r6, =RD_88F5182_KUROBOX_MPP8_15
  MV_REG_WRITE_ASM (r6, r1, 0x10004) 
  ldr	r6, =RD_88F5182_KUROBOX_MPP16_23
  MV_REG_WRITE_ASM (r6, r1, 0x10050) 

  /* init GPP , Out enable */
  ldr	r6, =0x1000C
  MV_REG_WRITE_ASM (r6, r1, 0x10104) 

  /*DDR SDRAM Initialization Control */
  ldr	r6, =0x00000001
  MV_REG_WRITE_ASM (r6, r1, 0x1480) 
  /* PCI ARBITER */
  ldr	r6, =0x80000030
  MV_REG_WRITE_ASM (r6, r1, 0x31d00)

#if 0
  bl   _buMiconUartInit 
  bl	_preamble_mcon

/**********    send booting start to micon    ****/
  mov	r4,#0x00
  bl	_PutUart1
  mov	r4,#0x02
  bl	_PutUart1
  mov	r4,#0xfe
  bl	_PutUart1
/*************************************************/
#endif
/*
#define	CPU_TIME_CONTROL	0x20300
#define	CPU_TIMER_0			0x20314
#define CPU_TIMER_DATA		0xFFFFFFFF
#define CPU_400_BENCH		0xFFEBFFFF

#define DRAM_BUF_REG5	0x2040c	 (sdram timing control low)
#define STATIC_SDRAM_TIME_CTRL_LOW_500	0x11b13330
#define STATIC_SDRAM_TIME_CTRL_LOW_400	0x11812220
#define CHARA_CPU						0x0a435055
#define CHARA_eq						0x203d2020
#define CHARA_High						0x48696768
#define CHARA_Low						0x4C6f7720
*/


  bl	_buUart0Init


/******  Orion1 or Orion2   **********/
        /* Read device ID  */
        MV_REG_READ_ASM(r4, r5, PEX_CFG_DIRECT_ACCESS(0,PEX_DEVICE_AND_VENDOR_ID))
        mov     r4, r4, LSR #16         /* r4 = r4 >> 16 */
        
        /* Return if Orion1 */
        ldr     r5, =MV_5181_DEV_ID
        cmp     r4, r5
        beq     1f
           
        /* Return if Orion1 */
        ldr     r5, =MV_5182_DEV_ID
        cmp     r4, r5
        beq     1f

        /* Return if Shark */
        ldr     r5, =MV_8660_DEV_ID
        cmp     r4, r5
        beq     1f
           
        /* goto calcConfigReg if bigger than Orion2*/     
        ldr     r5, =MV_5281_DEV_ID
        cmp     r4, r5
        beq     2f
	ldr	r6, = STATIC_SDRAM_CONFIG_ORION1
	MV_REG_WRITE_ASM(r6, r5, DRAM_BUF_REG1)
	ldr	r7, = CHARA_unkn
	bl _chraout
	ldr	r7, = CHARA_own
	bl _chraout		
1:
	ldr	r6, =KUROBOX_BOARD_XXXXXXXXXX_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =KUROBOX_BOARD_XXXXXXXXXX_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =KUROBOX_BOARD_XXXXXXXXXX_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 

	ldr	r6, = STATIC_SDRAM_CONFIG_ORION1
	MV_REG_WRITE_ASM(r6, r5, DRAM_BUF_REG1)
	ldr	r7, = CHARA_Orio
	bl _chraout
	ldr	r7, = CHARA_n1
	bl _chraout		
	b	3f
2:
	/* init MPP  for LS-GL*/
	ldr	r6, =RD_88F5182_KUROBOX_MPP0_7
	MV_REG_WRITE_ASM (r6, r1, 0x10000) 
	ldr	r6, =RD_88F5182_KUROBOX_MPP8_15
	MV_REG_WRITE_ASM (r6, r1, 0x10004) 
	ldr	r6, =RD_88F5182_KUROBOX_MPP16_23
	MV_REG_WRITE_ASM (r6, r1, 0x10050) 

	ldr	r6, = STATIC_SDRAM_CONFIG_ORION2
	MV_REG_WRITE_ASM(r6, r5, DRAM_BUF_REG1)
	ldr	r7, = CHARA_Orio
	bl _chraout
	ldr	r7, = CHARA_n2
	bl _chraout		

3:
/***** Timer Start ******/
	ldr	r6, =CPU_TIMER_DATA
	MV_REG_WRITE_ASM (r6, r1, CPU_TIMER_0)
	mov	r6,	#1
	MV_REG_WRITE_ASM (r6, r1, CPU_TIME_CONTROL)


        mov     r10, #0x100000 
 _freq_Loop:
        subs    r10, r10, #1
        bne     _freq_Loop
/***** Timer Stop ******/
	mov	r6,	#0
	MV_REG_WRITE_ASM (r6, r1, CPU_TIME_CONTROL)
	MV_REG_READ_ASM(r6, r1,CPU_TIMER_0)

	ldr	r1,=CPU_400_BENCH
	cmp r6,r1
	bls	1f
#ifdef cpu_600_300
	ldr	r6, = STATIC_SDRAM_TIME_CTRL_LOW_600
#else
	ldr	r6, = STATIC_SDRAM_TIME_CTRL_LOW_500
#endif
	MV_REG_WRITE_ASM(r6, r5, DRAM_BUF_REG5)
/*****************************/
	ldr	r7, = CHARA_CPU
	bl _chraout
	ldr	r7, = CHARA_eq
	bl _chraout		
	ldr	r7, = CHARA_High
	bl _chraout
/*****************************/
	b	2f
1:
	ldr	r6, = STATIC_SDRAM_TIME_CTRL_LOW_400
	MV_REG_WRITE_ASM(r6, r5, DRAM_BUF_REG5)
	ldr	r7, = CHARA_CPU
	bl _chraout
	ldr	r7, = CHARA_eq
	bl _chraout		
	ldr	r7, = CHARA_Low
	bl _chraout		
2:
	bl	_mvDramIfStaticInit
#if 0
/**********    send DRAM TEST START    ****/
	mov	r4,#0x00
	bl	_PutUart1
	mov	r4,#0x08
	bl	_PutUart1
	mov	r4,#0xf8
	bl	_PutUart1
/*************************************************/
#endif




#if 0
/*****************************************************************************/
/*Read Panel Flag */
  mov     r7,#0x1e
  bl      _PanelRead

  and     r7,r7,#0x03
  cmp     r7,#0x01
  beq     ExtPowerON
  cmp     r7,#0x02
  beq     IntPowerON

ExtPowerON:

  mov     r4,#0x50
  mov     r7,#0xff         /* Power Status*/
  bl      _i2cRead
  and     r7,r7,#03
  cmp     r7,#3
  bne     Power_Check_done

/*Power Off*/
  mov     r7,#0x19
  mov     r7,r7,LSL #8
  mov     r6,#0x00
  orr     r7,r6,r7
  mov     r7,r7,LSL #8
  mov     r6,#0x02
  orr     r7,r6,r7

  bl      _PanelWrite

  b       Power_Check_done
IntPowerON:
  mov     r4,#0x50
  mov     r7,#0xff         /* Power Status*/
  bl      _i2cRead
  and     r7,r7,#03
  cmp     r7,#3
  bne     Power_Check_done


  /*Write EEprom flag*/
  mov     r4,#0x50       /*EEPROM SubAddr*/
  mov     r7,#0xfe

  mov     r7,r7,LSL #8
  mov     r6,#0x00
  orr     r7,r6,r7

  mov     r7,r7,LSL #8
  mov     r6,#0x01
  orr     r7,r6,r7

  bl      _i2cWrite

  mov     r4, #0x900000
1:
  subs    r4, r4, #1
  bne     1b

  b       Power_Check_done

Power_Check_done:
#endif




_memory_test:
          
/***********************************************************************/
/**************     DRAM TEST   ****************************************/
/***********************************************************************/
            mov                  r3, #0x04000000   /* [BB] Open DRAM bank 0 to 128MB */
            mov                  r0, #1
            mov                  r6,        #0
            mov                  r1,        #0

/**** Checking DATA BUS ***/
/* write */
1:
            str                    r0,[r1]
            cmp                 r0,#0x40000000     /**[BB]**/
            beq                   2f
            mov                  r0,r0,LSL #1
            add                   r1,r1,#4
            b                      1b
2:
/* COMP  read */
            mov                  r0, #1
            mov                  r1, #0
3:
            ldr                  r4,[r1]   
            cmp                  r4,r0
            bne                   _dram_dt_error
            cmp                 r1,#0x6c
            beq                   1f
            mov                  r0,r0,     LSL      #1
            add                   r1,r1,#4
            b                      3b
/**** Checking ADDRESS BUS ***/
/****** Write ***********/
1:
            mov                  r0, #0
            mov                  r1,        #0
2:
            str                    r0,[r1]
            add                   r0,r0,#1
            add                   r1,r1,#4
            cmp                  r1,r3
            bne                   2b
/****** Read ***********/

            mov                  r0, #0
            mov                  r1,        #0
            mov                  r6,        #0
3:
            ldr                     r6,[r1]
            cmp                  r0,r6
            bne                   _dram_ads_error
            add                   r0,r0,#1
            add                   r1,r1,#4
            cmp                  r1,r3
            bne                   3b
#if 0
/**********    send DRAM TEST START    ****/
	mov	r4,#0x00
	bl	_PutUart1
	mov	r4,#0x09
	bl	_PutUart1
	mov	r4,#0xf7
	bl	_PutUart1
/*************************************************/
#endif
		b	done

/*********0xFFFC3098******/
/**********    send error to micon    ****/
_dram_dt_error:
            mov                  r4,#0x00
            bl                      _PutUart1
            mov                  r4,#0x04
            bl                      _PutUart1
            mov                  r4,#0xfc
            bl                      _PutUart1
            b          _hang
/*************************************************/

_dram_ads_error:
            mov                  r4,#0x00
            bl                      _PutUart1
            mov                  r4,#0x05
            bl                      _PutUart1
            mov                  r4,#0xfb
            bl                      _PutUart1
            b          _hang
_hang:
	b	_hang

#endif
/* CONFIG_KUROBOX_PLATFORM */

#ifndef CONFIG_KUROBOX_PLATFORM

others:

        /* If we didn't read a valid board ID then:
           if Orion2 B0 we will detect the board as new
           board else the U-Boot will detect it as old board */
        
        /* Read device ID  */
        MV_REG_READ_ASM(r6, r1, PEX_CFG_DIRECT_ACCESS(0,PEX_DEVICE_AND_VENDOR_ID))
        mov     r6, r6, LSR #16         /* r6 = r6 >> 16 */

	/* if Orion NAS default board is DB, rd must have special compilation flag */
        ldr     r1, =MV_5182_DEV_ID
        cmp     r1, r6
        beq     db_88f5182_ddr2

	/* if Orion Shark default board is DB, rd must have special compilation flag */
        ldr     r1, =MV_8660_DEV_ID
        cmp     r1, r6
        beq     db_88w8660_ddr2
        
        ldr     r1, =MV_5281_DEV_ID
        cmp     r1, r6
        bne     pre_orion2_b0_xxx

        /* Read REvision  */
        MV_REG_READ_ASM(r6, r1, PEX_CFG_DIRECT_ACCESS(0,PEX_CLASS_CODE_AND_REVISION_ID));
        ldr    r1, =0x000000FF                  /* Mask for calss ID */
        and    r6, r6, r1
        cmp    r6, #0
        beq    pre_orion2_b0_xxx
        
orion2_b0_xxx:

        b       db_88f5x81_ddrx

pre_orion2_b0_xxx:

        /* Get SDRAM Config value */
        MV_REG_READ_ASM (r6, r1, SDRAM_CONFIG_REG)
        
        tst     r6, #SDRAM_DTYPE_DDR2
        
        /* jump to ddr2 board */
        bne     db_88f5181_5281_ddr2
        
        /* if not ddr2 board then jump to ddr1 board */
        b       db_88f5181_5281_ddr1

#endif
/* NOT CONFIG_KUROBOX_PLATFORM */
done:
	mov	lr, r2	



#elif defined(MV_88F1181)

	/* Load r3 with the size to open SDRAM bank 0 */
	mov	r3, #0x04000000   /* Open DRAM bank 0 to 64MB */

        /* Call DRAM basic initialization to allow C runtime stack */
	mov	r2, lr
	bl	_mvDramIfBasicInit 
	mov	lr, r2	

#endif	/*MV_88F5181*/

	/* All done by Integrator's boot monitor! */
	mov pc, lr
         
#if defined(CONFIG_KUROBOX_PLATFORM) && defined(RD_88F5182)

/*******************************************************************************
* _buMiconUartInit - Initialize Micon interface
*
* DESCRIPTION:
*
* INPUT:
*       None.
*
* OUTPUT:
*       None.
*
* RETURN:
*       None.
*
*******************************************************************************/
_buMiconUartInit:        
        mov     r9, LR     /* Save link register */

        /* Initializing the Uart1 mechanism. Assuming Tclock frequency          */
        /* of 166MHz. The UART baudrate in that case will be 38400.      */
        /* For this settings,(CPU Freq(166MHz)/16)/38400 . Set the baud-rate with the     */
        /* value of 325.52  0x10F                                      */
        /* see spec for more details about the calculation of this value)     */
		mov		r6,#0
        MV_REG_WRITE_ASM (r6, r1, UART1_LCR_REG)
        /*disable interrupt*/
		mov		r6,#0
        MV_REG_WRITE_ASM (r6, r1, UART1_IER_REG)
		/*Access baud rate*/
   		mov		r6,#0x80
        MV_REG_WRITE_ASM (r6, r1, UART1_LCR_REG)
   		mov		r6,#0x0f
        MV_REG_WRITE_ASM (r6, r1, UART1_DLL_REG)
   		mov		r6,#1
        MV_REG_WRITE_ASM (r6, r1, UART1_DLH_REG)

        /* Set mode 8 data 2 stop Even parity AND Access FiFO */
   		mov		r6,#0x1F
        MV_REG_WRITE_ASM (r6, r1, UART1_LCR_REG)

		/* Clear & enable FIFOs */
   		mov		r6,#0x7
        MV_REG_WRITE_ASM (r6, r1, UART1_FCR_REG)



        /* Let the slow  machine get used to the idea that it is enabled  */
        bl		_Uart_Delay
        
        
        mov     PC, r9         /* r9 is saved link register */

/*******************************************************************************
* _Uart_Delay - Perform delay.
*
* DESCRIPTION:
*       The function performs a delay to enable TWSI logic to stable.
*
* INPUT:
*       None.
*
* OUTPUT:
*       None.
*
* RETURN:
*       None.
*
*******************************************************************************/

_Uart_Delay:
        mov     r10, #0x200 
    
_UartDelayLoop:
        subs    r10, r10, #1
        bne     _UartDelayLoop
        
        mov     PC, LR


/*******************************************************************************
* _preamble_mcon 
*
* DESCRIPTION:
*       
*
* INPUT:
*       None.
*
* OUTPUT:
*       None.
*
* RETURN:
*       None.
*
*******************************************************************************/
_preamble_mcon:
        mov     r11, LR     /* Save link register */
        mov     r8, #0x20 
    	mov		r4,	#0xFF
_preambleLoop:
		bl		_PutUart1
        subs    r8, r8, #1
        bne     _preambleLoop

		mov		LR, r11
        mov     PC, LR

/*******************************************************************************
* mvUartInit - Init a uart port.
*
* DESCRIPTION:
*       This routine puts one charachetr on one of the uart ports.
*
* INPUT:
*       
*	r4 - character.
*
* OUTPUT:
*       None.
*
* RETURN:
*	None.
*
*******************************************************************************/
_PutUart1:
        mov     r9, LR     /* Save link register */

_PutUart1_loop:
        MV_REG_READ_ASM (r6, r1, UART1_LSR_REG)
		tst		r6,#UART1_LSR_THRE
		beq	_PutUart1_loop

        mov		r6,	r4
        MV_REG_WRITE_ASM (r6, r1, UART1_THR_REG)

        bl      _Uart_Delay

		mov		LR, r9
        mov     PC, LR





/*******************************************************************************/
_buUart0Init:        
        mov     r9, LR     /* Save link register */

        /* Initializing the Uart1 mechanism. Assuming Tclock frequency          */
        /* of 166MHz. The UART baudrate in that case will be 115200.      */
        /* For this settings,(CPU Freq(166MHz)/16)/115200 . Set the baud-rate with the     */
        /* value of 325.52  0x5A  
        /* see spec for more details about the calculation of this value)     */
		mov		r6,#0
        MV_REG_WRITE_ASM (r6, r1, UART0_LCR_REG)
        /*disable interrupt*/
		mov		r6,#0
        MV_REG_WRITE_ASM (r6, r1, UART0_IER_REG)
		/*Access baud rate*/
   		mov		r6,#0x80
        MV_REG_WRITE_ASM (r6, r1, UART0_LCR_REG)
   		mov		r6,#0x5A
        MV_REG_WRITE_ASM (r6, r1, UART0_DLL_REG)
   		mov		r6,#0
        MV_REG_WRITE_ASM (r6, r1, UART0_DLH_REG)

        /* Set mode 8 data 2 stop Even parity AND Access FiFO */
   		mov		r6,#0x03
        MV_REG_WRITE_ASM (r6, r1, UART0_LCR_REG)

		/* Clear & enable FIFOs */
   		mov		r6,#0x7
        MV_REG_WRITE_ASM (r6, r1, UART0_FCR_REG)



        /* Let the slow  machine get used to the idea that it is enabled  */
        bl		_Uart_Delay
        
        
        mov     PC, r9         /* r9 is saved link register */
/********************* r4 chara **********************************************/
_PutUart0:
        mov     r11, LR     /* Save link register */

_PutUart0_loop:
        MV_REG_READ_ASM (r6, r1, UART0_LSR_REG)
		tst		r6,#UART0_LSR_THRE
		beq	_PutUart0_loop

        mov		r6,	r4
        MV_REG_WRITE_ASM (r6, r1, UART0_THR_REG)

        bl      _Uart_Delay

		mov		LR, r11
        mov     PC, LR


/*****************************************************************************/
/***********************      r7 -> UART0                *********************/
/************************ r7�@�̓��e(�����j���R���\�[���ɏo��*****************/
/*****************************************************************************/
_chraout:        
        mov     r9, LR     /* Save link register */
		mov		r5,#0
_start_loop:
		mov		r4,	r7,LSR #24
		bl		_PutUart0
		add		r5,#1
		cmp		r5,#4
		beq		_end_loop
		mov		r7,r7,LSL #8
		b	_start_loop
_end_loop:
		mov		LR, r9
        mov     PC, r9         /* r9 is saved link register */

#endif

#if 0  /*for test*/

/*****************************************************************************/
/***********************      r7 -> UART0(HEX)           *********************/
/************************ r7�@�̓��e���R���\�[���ɏo��************************/
/*****************************************************************************/
_bintohex:        
        mov     r9, LR     /* Save link register */
		mov		r5,#0
_start_loop:
		mov		r6,	r7,LSR #28
		cmp		r6, #9
		bls		1f
		add		r4,r6, #0x37
		b		2f
	1:
		add		r4,r6,#0x30
	2:
		bl		_PutUart0
		add		r5,#1
		cmp		r5,#8
		beq		_end_loop
		mov		r7,r7,LSL #4
		b	_start_loop
_end_loop:
        mov		LR, r9
		mov     PC, r9         /* r9 is saved link register */
/*******************************************************************************/
/*****************  Cache Enable flash   **************************************/
/*******************************************************************************/
_cache_on:
/*Region Set*/
	mov	r1, lr
	MRS	r0,CPSR
	orr	r0,#0x1f
	MSR	CPSR,r0
	mov	r0,#((Region_4G	<<1) | Region_Enable) 
	MCR	p15,0,r0,c6,c0,0
	ldr	r0,= 0xFFFC0000 | (Region_256K << 1) | Region_Enable
	MCR	p15,0,r0,c6,c1,0
/* cache atribute*/
	mov	r0,#2
	MCR	p15,0,r0,c2,c0,0
	mov	r0,#2
	MCR	p15,0,r0,c2,c0,1
	mov	r0,#0
	MCR	p15,0,r0,c3,c0,0
/*permission*/
	mov	r0,#(0x6 << 4)
	MCR	p15,0,r0,c5,c0,2
	MCR	p15,0,r0,c5,c0,3
	
/* Ser Core */
	MRC	p15,0,r0,c1,c0,0
	orr	r0,r0,#(0x1 <<12) /*I Cache ON*/
	orr	r0,r0,#(0x1 <<2)  /*D Cache ON*/
	bl	_Uart_Delay
/*	orr	r0,r0,#0x1*/
	MCR	p15,0,r0,c1,c0,0
	MRS	r0,CPSR
	and	r0,#0xfffffff0
	orr	r0,#0xd3
	MSR	CPSR,r0

	mov	lr, r1
			
	mov	pc,lr

#endif
