/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */
/*******************************************************************************
Copyright (C) Marvell International Ltd. and its affiliates

********************************************************************************
Marvell GPL License Option

If you received this File from Marvell, you may opt to use, redistribute and/or 
modify this File in accordance with the terms and conditions of the General 
Public License Version 2, June 1991 (the "GPL License"), a copy of which is 
available along with the File in the license.txt file or by writing to the Free 
Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 or 
on the worldwide web at http://www.gnu.org/licenses/gpl.txt. 

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE IMPLIED 
WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY 
DISCLAIMED.  The GPL License provides additional details about this warranty 
disclaimer.

*******************************************************************************/

#include <common.h>
#include "mvTypes.h"
#include "mvBoardEnvLib.h"
#include "mvCpuIf.h"
#include "mvCtrlEnvLib.h"
#include "mv_mon_init.h"
#include "mvDS1339.h"
#include "mvDebug.h"
#include "mvCpuArm.h"
#include "mvDevice.h"
#include "mvTwsi.h"
#include "mvEthPhy.h"

#ifdef CONFIG_KUROBOX_PLATFORM
#include "mvUart.h"
#include "kurobox_ver.h"
#endif

#if defined(MV_88F5181)

#if defined(MV_88F5182)
#include "mvXor.h"
#endif
#include "mvIdma.h"
#include "mvUsb.h"
#endif
#include "mvCpu.h"

#ifdef CONFIG_PCI
#   include <pci.h>
#endif
#include "mvPciRegs.h"

#include <asm/arch/vfpinstr.h>
#include <asm/arch/vfp.h>

#ifdef CONFIG_KUROBOX_PLATFORM
#include "mvBoardEnvSpec.h"
#define SWAP_LONG(x) \
        ((__u32)( \
                (((__u32)(x) & (__u32)0x000000ffUL) << 24) | \
                (((__u32)(x) & (__u32)0x0000ff00UL) <<  8) | \
                (((__u32)(x) & (__u32)0x00ff0000UL) >>  8) | \
                (((__u32)(x) & (__u32)0xff000000UL) >> 24) ))

#endif
void mv_cpu_init(void);

	unsigned long totlen;


void print_mvBanner(void)
{
MV_U32 boardId ;
boardId = mvBoardIdGet() ;
#if defined(CONFIG_KUROBOX_PLATFORM) && !defined(ORG_PCB)
	printf("\n\n");
		 /*saito change*/
if(KURO_BOX_BOARD_ID == boardId)
{
	printf("=== KURO U-Boot. ===\n");
}else
{
	printf("===  Unknown U-Boot. ===\n");
}

#else
	printf("\n");
	printf("         __  __                      _ _\n");
	printf("        |  \\/  | __ _ _ ____   _____| | |\n");
	printf("        | |\\/| |/ _` | '__\\ \\ / / _ \\ | |\n");
	printf("        | |  | | (_| | |   \\ V /  __/ | |\n");
	printf("        |_|  |_|\\__,_|_|    \\_/ \\___|_|_|\n");
	printf(" _   _     ____              _\n");
	printf("| | | |   | __ )  ___   ___ | |_ \n");
	printf("| | | |___|  _ \\ / _ \\ / _ \\| __| \n");
	printf("| |_| |___| |_) | (_) | (_) | |_ \n");
	printf(" \\___/    |____/ \\___/ \\___/ \\__| ");
#endif
	if(enaMonExt())
		printf(" ** MONITOR **");
	else
		printf(" ** LOADER **"); 


	return;
}

void print_dev_id(void){
	static char boardName[30];

	mvBoardNameGet(boardName);
	
#ifdef CONFIG_KUROBOX_PLATFORM
#if defined(MV_CPU_BE)
	printf("\n ** KUROBOX BOARD: %s BE ",boardName);
#else
	printf("\n ** KUROBOX BOARD: %s LE ",boardName);
#endif
#else
#if defined(MV_CPU_BE)
	printf("\n ** MARVELL BOARD: %s BE ",boardName);
#else
	printf("\n ** MARVELL BOARD: %s LE ",boardName);
#endif
#endif

#ifdef CONFIG_KUROBOX_PLATFORM
	printf("(CFG_ENV_ADDR=%x)\n",CFG_ENV_ADDR);
#endif
    return;
}


#define CPU_MAIN_IRQ_MASK 0x20204
#define CPU_MAIN_FIQ_MASK 0x20208
#define CPU_END_POIN_MASK 0x2020c
void maskAllInt(void)
{
        /* mask all external interrupt sources */
        MV_REG_WRITE(CPU_MAIN_IRQ_MASK, 0);
        MV_REG_WRITE(CPU_MAIN_FIQ_MASK, 0);
        MV_REG_WRITE(CPU_END_POIN_MASK, 0);
}

/* init for the Master*/
void misc_init_r_dec_win(void)
{
    /* update all the windows BARS */
#ifdef MV_88F5181
    char *env;
    mvDmaInit();
#if defined(CONFIG_KUROBOX_PLATFORM) && !defined(ORG_PCB)

				printf("USB 0: host mode\n");	
				mvUsbInit(0, MV_TRUE);
				if(KURO_BOX_BOARD_ID == mvBoardIdGet())
					{
						printf("USB 1: host mode\n");	
						mvUsbInit(1, MV_TRUE);
					}


#else
	if ((DB_88F5181_DDR1_PRPMC != mvBoardIdGet()) &&
	    (DB_88F5181_DDR1_MNG != mvBoardIdGet()))
	{
		env = getenv("usb0Mode");
		if((!env) || (strcmp(env,"device") == 0) || (strcmp(env,"Device") == 0) )
		{
			printf("USB 0: device mode\n");	
			mvUsbInit(0, MV_FALSE);
		}
		else
		{
			printf("USB 0: host mode\n");	
			mvUsbInit(0, MV_TRUE);
		}
			
		
		if (mvCtrlUsbMaxGet() == 2)
		{
			env = getenv("usb1Mode");
			if((!env) || (strcmp(env,"device") == 0) || (strcmp(env,"Device") == 0) )
			{
				printf("USB 1: device mode\n");	
				mvUsbInit(1, MV_FALSE);
			}
			else
			{
				printf("USB 1: host mode\n");	
				mvUsbInit(1, MV_TRUE);
			}
				

		}

	}
#endif

#endif /* MV_88F5181 */
#if defined(MV_88F5182) && defined (MV_88F5181) && !defined(MV_88F5082)
	mvXorInit();
#endif

    return;
}


/*
 * Miscellaneous platform dependent initialisations
 */

extern	MV_STATUS mvEthPhyRegRead(MV_U32 phyAddr, MV_U32 regOffs, MV_U16 *data);
extern	MV_STATUS mvEthPhyRegWrite(MV_U32 phyAddr, MV_U32 regOffs, MV_U16 data);

/* golabal mac address for yukon EC */
unsigned char yuk_enetaddr[6];
extern int interrupt_init (void);
extern void i2c_init(int speed, int slaveaddr);


int board_init (void)
{
	DECLARE_GLOBAL_DATA_PTR;
	MV_TWSI_ADDR slave;
	unsigned int i;

	maskAllInt();
	/* must initialize the int in order for udelay to work */
	interrupt_init();
   
	slave.type = ADDR7_BIT;
	slave.address = 0;
	mvTwsiInit(CFG_I2C_SPEED, CFG_TCLK, &slave, 0);

 
	/* Init the Board environment module (device bank params init) */
	mvBoardEnvInit();

#ifdef MV_88F5181


#if defined(CONFIG_KUROBOX_PLATFORM) && !defined(ORG_PCB)
        mvEthE111xPhyBasicInit(0);


#else

	if ((DB_88F5181_5281_DDR2 == mvBoardIdGet())||
	    (DB_88F5181_DDR1_PEXPCI == mvBoardIdGet()) ||
	    (RD_88F5181_POS_NAS == mvBoardIdGet()) ||
	    (DB_88F5X81_DDR2 == mvBoardIdGet()) ||
	    (DB_88F5X81_DDR1 == mvBoardIdGet())||
	    (DB_88F5182_DDR2 == mvBoardIdGet())||
	    (RD_88F5182_2XSATA == mvBoardIdGet())||
	    (DB_88F5181L_DDR2_2XT88DM == mvBoardIdGet()) ||
	    (DB_88W8660_DDR2 == mvBoardIdGet()) )
	{
		mvEthE1111PhyBasicInit(0);
	
	}else if (RD_88F5182_2XSATA3 == mvBoardIdGet())
	{
		mvEthE1116PhyBasicInit(0);

	}else if (DB_88F5181_5281_DDR1 == mvBoardIdGet())
	{
		mvEthE1011PhyBasicInit(0);

	}else if ((RD_88F5181_VOIP == mvBoardIdGet())|| (RD_88F5181L_VOIP_FE == mvBoardIdGet()))
	{
		mvEthE6063PhyBasicInit(0);

	}else if ((RD_88W8660_DDR1 == mvBoardIdGet()) || (RD_88W8660_AP82S_DDR1 == mvBoardIdGet()))
	{
		mvEthE6065_61PhyBasicInit(0);
	
	}else if (RD_88F5181L_VOIP_GE == mvBoardIdGet())
	{
		mvEthE6131PhyBasicInit(0);
	}

#endif /* KUROBOX_PLATFORM */
#endif /* MV_88F5181 */
   	/* Init the Controlloer environment module (MPP init) */
	mvCtrlEnvInit();
/* saito change*/
#ifndef CONFIG_KUROBOX_PLATFORM
	mvBoardDebug7Seg(3);
#endif
        /* Init the Controller CPU interface */
	mvCpuIfInit(); 
                                                                                                                                     
        /* arch number of Integrator Board */
        gd->bd->bi_arch_number = 526;
 
        /* adress of boot parameters */
        gd->bd->bi_boot_params = 0x00000100;

	/* relocate the exception vectors */
	for(i = 0; i < 0x100; i+=4)
	{
#if defined(RD_88F5182) && defined(MV_TINY_IMAGE)
		*(unsigned int *)(0x0 + i) = *(unsigned int*)(0xfffc0000 +i );
#elif defined(RD_88F5182_3) && defined(MV_TINY_IMAGE)        
		*(unsigned int *)(0x0 + i) = *(unsigned int*)(0xfffc0000 +i );
#elif defined(RD_88W8660_AP82S) && defined(MV_TINY_IMAGE)        
		*(unsigned int *)(0x0 + i) = *(unsigned int*)(0xfffc0000 +i );
#elif defined(RD_88F5181L_FE) && defined(MV_TINY_IMAGE)        
		*(unsigned int *)(0x0 + i) = *(unsigned int*)(0xfffc0000 +i );
#elif defined(RD_88F5181L_GE) && defined(MV_TINY_IMAGE)        
		*(unsigned int *)(0x0 + i) = *(unsigned int*)(0xfffc0000 +i );
#else
		*(unsigned int *)(0x0 + i) = *(unsigned int*)(0xfff90000 +i );
#endif


	}

	/* i cache can work without MMU,
	   d cache can not work without MMU:
	 i cache already enable in start.S */
/* saito change*/
#ifndef CONFIG_KUROBOX_PLATFORM
	mvBoardDebug7Seg(4);
#endif	
	return 0;
}

void misc_init_r_env(void){
        char *env;
        char tmp_buf[10];
        unsigned int malloc_len;
                                                                                                                                               
        /* update the CASset env parameter */
        env = getenv("CASset");
        if(!env )
        {
#ifdef MV_MIN_CAL
                setenv("CASset","min");
#else
                setenv("CASset","max");
#endif
        }
        /* Monitor extension */
        env = getenv("enaMonExt");
        if(/* !env || */ ( (strcmp(env,"yes") == 0) || (strcmp(env,"Yes") == 0) ) )
                setenv("enaMonExt","yes");
        else
                setenv("enaMonExt","no");


        env = getenv("enaFlashBuf");
        if( ( (strcmp(env,"no") == 0) || (strcmp(env,"No") == 0) ) )
                setenv("enaFlashBuf","no");
        else
                setenv("enaFlashBuf","yes");
#if defined(CONFIG_KUROBOX_PLATFORM) && !defined(ORG_PCB)
	/* CPU streaming */
        env = getenv("enaCpuStream");
        if(!env || ( (strcmp(env,"no") == 0) || (strcmp(env,"No") == 0) ) )
                setenv("enaCpuStream","no");
        else
                setenv("enaCpuStream","yes");
		if(mvCtrlModelGet() == MV_5281_DEV_ID) /* Orion 2 */
		{
			if (mvCtrlRevGet() >= MV_5281_C0_REV) /* Orion 2 >= C0 */
			{
				env = getenv("enaVFP");
				if( !env )
				setenv("enaVFP","yes");
			if (mvCtrlRevGet() >= MV_5281_D0_REV) /* Orion 2 >= D0 */
				{
#if 0 /* if OLD kernel  (before 2006 Nov. */
					env = getenv("enaWrAllo");
					if( !env)
							setenv("enaWrAllo","yes");
					/* ICache Prefetch */
					env = getenv("enaICPref");
					if( !env )
							setenv("enaICPref","yes");
					/* DCache Prefetch */
					env = getenv("enaDCPref");
					if( !env)
							setenv("enaDCPref","yes");
				}else
				{
					env = getenv("enaWrAllo");
					if( !env)
							setenv("enaWrAllo","no");
					/* ICache Prefetch */
					env = getenv("enaICPref");
					if( !env )
							setenv("enaICPref","no");
					/* DCache Prefetch */
					env = getenv("enaDCPref");
					if( !env)
							setenv("enaDCPref","no");
#endif
					setenv("enaWrAllo","yes");
					/* ICache Prefetch */
					setenv("enaICPref","yes");
					/* DCache Prefetch */
					setenv("enaDCPref","yes");
				}
			}
		}
#else
	/* CPU streaming */
        env = getenv("enaCpuStream");
        if(!env || ( (strcmp(env,"no") == 0) || (strcmp(env,"No") == 0) ) )
                setenv("enaCpuStream","no");
        else
                setenv("enaCpuStream","yes");

		if(mvCtrlModelGet() == MV_5281_DEV_ID) /* Orion 2 */
		{
			/* VFP */
			env = getenv("enaVFP");
			if (mvCtrlRevGet() == MV_5281_C0_REV)
			{
				if( env && ( ((strcmp(env,"yes") == 0) || (strcmp(env,"Yes") == 0) )))
						setenv("enaVFP","yes");
				else
						setenv("enaVFP","no");

			}
			else
			{
				if( env && ( ((strcmp(env,"no") == 0) || (strcmp(env,"No") == 0) )))
						setenv("enaVFP","no");
				else
						setenv("enaVFP","yes");

			}
			
			

			if ((mvCtrlRevGet() == MV_5281_A0_REV) || 
				(mvCtrlRevGet() == MV_5281_C0_REV))
			{
				/* Write allocation */
				env = getenv("enaWrAllo");
				if( env && ( ((strcmp(env,"yes") == 0) || (strcmp(env,"Yes") == 0) )))
						setenv("enaWrAllo","yes");
				else
						setenv("enaWrAllo","no");

			}
			else if (mvCtrlRevGet() >= MV_5281_B0_REV) /* Orion 2 >= B0 */
			{
				/* Write allocation */
				env = getenv("enaWrAllo");
				if( env && ( ((strcmp(env,"no") == 0) || (strcmp(env,"No") == 0) )))
						setenv("enaWrAllo","no");
				else
						setenv("enaWrAllo","yes");

				/* ICache Prefetch */
				env = getenv("enaICPref");
				if( env && ( ((strcmp(env,"no") == 0) || (strcmp(env,"No") == 0) )))
						setenv("enaICPref","no");
				else
						setenv("enaICPref","yes");
		
		
				/* DCache Prefetch */
				env = getenv("enaDCPref");
				if( env && ( ((strcmp(env,"no") == 0) || (strcmp(env,"No") == 0) )))
						setenv("enaDCPref","no");
				else
						setenv("enaDCPref","yes");
			}
		}
#endif

        /* Malloc length */
        env = getenv("MALLOC_len");
        malloc_len =  simple_strtoul(env, NULL, 10) << 20;
        if(malloc_len == 0){
                sprintf(tmp_buf,"%d",CFG_MALLOC_LEN>>20);
                setenv("MALLOC_len",tmp_buf);}
         
        /* primary network interface */
        env = getenv("ethprime");

#ifdef CONFIG_KUROBOX_PLATFORM
  setenv("ethprime","egiga0");
#else

  if (DB_88F5181_DDR1_PRPMC != mvBoardIdGet())
  {
    if(!env) 
    {
      if((DB_88W8660_DDR2 == mvBoardIdGet()) || 
         (RD_88W8660_DDR1 == mvBoardIdGet()) ) 			
        setenv("ethprime","efast0");
      else
        setenv("ethprime","egiga0");
    }
  }
  else
  {
    if(!env)
      setenv("ethprime","SK98#0");
  }

#endif

/* linux boot arguments */
  env = getenv("bootargs_root");
  if(!env)  setenv("bootargs_root","root=/dev/nfs rw");

  env = getenv("bootargs_end");
  if(!env)  setenv("bootargs_end",CFG_BOOTARGS_END);

#ifdef CONFIG_KUROBOX_PLATFORM
  #if (CONFIG_COMMANDS & CFG_CMD_NAND)
  env = getenv("buffalo_ver");
  if (!env || strcmp(env,KUROBOX_VER)!=0|| 
      strcmp(getenv("build_time"),__TIME__)!=0 )
  {
    MV_U32  bid=mvBoardIdGet();
    printf("-- initialize Env for KUROBOX\n");
    setenv("need_saveenv", "1");
    setenv("buffalo_ver", KUROBOX_VER);				// verstion information
    setenv("build_time", __TIME__);				// verstion information
    setenv("initrd","rootfs");                      /*[BB]*/
    setenv("kernel","uImage");                      /*[BB]*/
#if (CFG_DUART_CHAN==0)
    setenv("bootargs_base","console=ttyS0,115200");
#elif (CFG_DUART_CHAN==1)
    setenv("bootargs_base","console=ttyS1,115200");
#else
    setenv("bootargs_base","console=null");
#endif
    setenv("bootargs_root","root=/dev/ram");      /*[BB]*/
    setenv("bootargs_mtdparts","mtdparts=cfi_flash:2M(uImage),8M(rootfs),2688K(web),768K(SVRConf),2M(bkfs),-(uboot)ro");
    setenv("bootargs","$(bootargs_base) $(bootargs_root) $(buffalo_ver) $(bootargs_mtdparts)");
    setenv("nor_uImage_offset", "0xff000000");
    setenv("nor_uImage_size", "0x200000");
    setenv("nor_initrd_offset", "0xff200000");
    setenv("nor_initrd_size", "0x800000");
    setenv("nor_altinitrd_offset", "0xffd60000");
    setenv("nor_altinitrd_size", "0x200000");
    setenv("bootfcmd", "cp.b $(nor_initrd_offset) $(default_initrd_addr) $(nor_initrd_size); setenv bootargs $(bootargs_base) $(bootargs_root) rw $(bootargs_mtdparts) initrd=$(default_initrd_addr); bootm $(nor_uImage_offset) $(default_initrd_addr)");
    setenv("altbootfcmd", "cp.b $(nor_altinitrd_offset) $(default_initrd_addr) $(nor_altinitrd_size); setenv bootargs $(bootargs_base) $(bootargs_root) rw $(bootargs_mtdparts) initrd=$(default_initrd_addr); bootm $(nor_uImage_offset) $(default_initrd_addr)");
    setenv("nand_uImage_offset", "20000");
    setenv("default_kernel_addr","0x00100000");
    setenv("default_initrd_addr","0x00700000");				
    setenv("bootcmd","nboot $(default_kernel_addr)  0 $(nand_uImage_offset) ;setenv bootargs $(bootargs_base) $(bootargs_root) $(buffalo_ver); bootm $(default_kernel_addr)");
    setenv("def_tftp","tftp $(default_kernel_addr) $(kernel); tftp $(default_initrd_addr) $(initrd); setenv bootargs $(bootargs_base) $(bootargs_root) rw $(bootargs_mtdparts) initrd=$(default_initrd_addr); bootm $(default_kernel_addr) $(default_initrd_addr)");
    setenv("nand_boot","no");
    setenv("nor_boot","yes");
    setenv("alt_boot","yes");
  }
  #endif /* (CONFIG_COMMANDS & CFG_CMD_NAND) */
#else
  env = getenv("image_name");
  if(!env)  setenv("image_name","uImage");
#endif
#ifndef CONFIG_KUROBOX_PLATFORM
        env = getenv("standalone");
        if(!env)
                setenv("standalone","fsload 0x400000 $(image_name);setenv bootargs $(bootargs) root=/dev/mtdblock0 rw \
ip=$(ipaddr):$(serverip)$(bootargs_end); bootm 0x400000;");
#endif
                 
#if defined(DB_PRPMC)
		env = getenv("vx_boot"); 
		if(!env)
				setenv("vx_boot","tftpboot $(default_load_addr) $(image_name);setenv bootargs sgi(0,0) host:VxWorks h=$(serverip) \
e=$(ipaddr):FFFF0000 u=anonymous pw=target; setenv bootaddr 0x700; bootvx $(default_load_addr);");

		env = getenv("dhcp_boot");
		if(!env)
				setenv("dhcp_boot","dhcp;setenv bootargs $(bootargs) $(bootargs_root) nfsroot=$(serverip):$(rootpath) \
ip=$(ipaddr):$(serverip)$(bootargs_end);  bootm $(default_load_addr);");
#endif /* DB_PRPMC */

       /* Set boodelay to 3 sec, if Monitor extension are disabled */
        if(!enaMonExt()){
                setenv("bootdelay","3");
		setenv("disaMvPnp","no");
	}

	/* Disable PNP config of Marvel memory controller devices. */
        env = getenv("disaMvPnp");
        if(!env)
                setenv("disaMvPnp","no");

 
#ifdef CONFIG_DB88F5181
        
	/* MAC addresses */
        env = getenv("ethaddr");
        if(!env){
                setenv("ethaddr",ETHADDR);
#ifdef CONFIG_KUROBOX_PLATFORM
			printf("*** set ethaddr to initial value\n");
#endif
		}
	/* Signal the Linux wether to override the MAC address or to respect the Linux MAC. */
        env = getenv("overEthAddr");
        if(!env|| ( (strcmp(env,"no") == 0) || (strcmp(env,"No") == 0) ) )
                setenv("overEthAddr","no");
        else
                setenv("overEthAddr","yes");
#if defined(CONFIG_KUROBOX_PLATFORM) && !defined(ORG_PCB)
				setenv("usb0Mode","host");
				if(KURO_BOX_BOARD_ID == mvBoardIdGet())
					{
						setenv("usb1Mode","host");
					}
#else
	if (DB_88F5181_DDR1_PRPMC != mvBoardIdGet())
	{

        /* USB Host */
        env = getenv("usb0Mode");

        if(!env)
		{
			if ((RD_88F5182_2XSATA == mvBoardIdGet())||
				(RD_88F5182_2XSATA3 == mvBoardIdGet())||
				(RD_88F5181_POS_NAS == mvBoardIdGet())||
				(RD_88F5181L_VOIP_FE == mvBoardIdGet())||
				(RD_88F5181L_VOIP_GE == mvBoardIdGet())||
				(RD_88W8660_DDR1 == mvBoardIdGet())||
				(RD_88W8660_AP82S_DDR1 ==  mvBoardIdGet()) )
			{
				setenv("usb0Mode","host");

			} else setenv("usb0Mode","device");
		}

		if (mvCtrlUsbMaxGet() == 2)
		{
			env = getenv("usb1Mode");

			if(!env)
			{
				if ((RD_88F5182_2XSATA == mvBoardIdGet())||
					(RD_88F5182_2XSATA3 == mvBoardIdGet())||
           			(RD_88F5181_POS_NAS == mvBoardIdGet()) 
					)
				{
					setenv("usb1Mode","host");

				}else setenv("usb1Mode","device");
			}

		}

		
	}
	else
	{
        env = getenv("yuk_ethaddr");
        if(!env)
                setenv("yuk_ethaddr",YUK_ETHADDR);

		{
			int i;

			char *tmp = getenv ("yuk_ethaddr");
			char *end;

			for (i=0; i<6; i++) {
				yuk_enetaddr[i] = tmp ? simple_strtoul(tmp, &end, 16) : 0;
				if (tmp)
					tmp = (*end) ? end+1 : end;

			}

		}


	}
#endif /*  CONFIG_KUROBOX_PLATFORM */
#endif 
        return;
}
#ifdef CONFIG_KUROBOX_PLATFORM
void tftp_mode_set(void)
{
/*
        char *env;
        env = getenv("def_tftp") ;
		if(env){
	    	setenv("bootcmd",env) ;
	    }
*/
	setenv("force_tftp","1");
	tftp_alarm() ;
}
#endif

#ifdef BOARD_LATE_INIT
int board_late_init (void)
{
#if defined(CONFIG_KUROBOX_PLATFORM) && !defined(ORG_PCB)
	rtc_reset();
	setenv("force_tftp",NULL);
    char *env;
    int tmp_i ;
	char max_drv ;
	size_t offset ;
	unsigned char * addr ;

/*
    printf("CFG_MONITOR_BASE %x \n",CFG_MONITOR_BASE) ;
    printf("CFG_MONITOR_LEN  %x \n",CFG_MONITOR_LEN) ;
    printf("CFG_ENV_ADDR     %x \n",CFG_ENV_ADDR) ;
    printf("CFG_ENV_SECT_SIZE     %x \n",CFG_ENV_SECT_SIZE) ;
    printf("CFG_MONITOR_IMAGE_OFFSET     %x \n",CFG_MONITOR_IMAGE_OFFSET) ;
 */
        
    tmp_i = Is_mvEthE111xPhy(0) ;
	if(tmp_i == MV_FAIL)
	{
	    phy_ng();
		printf("Eht phy is not found \n");	
		for(;;) ; /*hung */
	}else if(tmp_i ==  0x1111)
	{
		printf("Using 88E1111 phy\n") ;
	}else if(tmp_i ==  0x1118)
	{
		printf("Using 88E1118 phy\n") ;
	}else
	{
		printf("Using Unknown phy\n") ;
	}
#if (CONFIG_COMMANDS & CFG_CMD_NAND)
		if( totlen > 0)
			{
				env = getenv("nand_boot");
				if(env && ((strcmp(env,"yes") == 0) ||  (strcmp(env,"Yes") == 0)))
				{
			        env = getenv("default_kernel_addr");
			        addr =  simple_strtoul(env, NULL, 16) ;
			        env = getenv("nand_uImage_offset");
			        offset =  simple_strtoul(env, NULL, 16) ;
								if(serch_boot_nand( offset , addr ) == MV_FAIL)
								{
									printf ("NAND Boot Fail. Change Tftp booting\n");
											tftp_mode_set() ;
								}
				}
			}
#else
	if(ide_init() == MV_FALSE)
	{
		printf("HDD is not found \n");	
		if(is_em_mode() != 0x00 )
		{
			tftp_mode_set() ;
		}
	}
#endif	/*(CONFIG_COMMANDS & CFG_CMD_NAND)*/
	
#ifdef USE_EM_TFTP_SWITCH
// not used TFTP change rule.
	if(is_em_mode() != 0x00 )
	{
		printf("EM_MODE_Detect \n");
					udelay (30000);	
		if(Is_link_mvEthE1111Phy(0) == MV_OK) /*LINK is UP*/
		{
			printf("Detect EM_MODE ,TFTP Booting \n");	
			tftp_mode_set() ;
		}
		else
		{
			printf("Detect EM_MODE Nomal Booting \n");	
		}
	}
#endif
	/*display booting animetion*/

	//mv_rtc.c
/*	rtc_reset();

    env = getenv("User_Didkpass");
     if(!env)
     {
     	return 0;
     }
     else
		{
			
		}
*/
#else
 /* in the RD_88F5181L_VOIP_FE and RD_88F5181L_VOIP_GE boards
    we use the phone indication leds for debug leds and we want
	to turn the leds off after U-Boot start
 */
 /* saito change*/
#ifndef CONFIG_KUROBOX_PLATFORM

 if (   (RD_88F5181L_VOIP_FE == mvBoardIdGet())||
	(RD_88F5181L_VOIP_GE == mvBoardIdGet()) 
	 )
 {
	mvBoardDebug7Seg(0);
 }
  return 0;
#endif
#endif

}
#endif

int misc_init_r (void)
{
	char name[15];
	char *env;
	volatile unsigned int temp;

/* saito change*/
#ifndef CONFIG_KUROBOX_PLATFORM
	mvBoardDebug7Seg(5);
#endif


	/* set as 946 */
	env = getenv("cpuName");
	if(!env)
			setenv("cpuName","926");
	else
	{
		if (strcmp(env,"946") == 0)
		{
			/* set as 946 */
			unsigned int regVal;

			regVal = MV_REG_READ(CPU_CONFIG_REG);
			regVal |= CCR_MMU_DISABLED;
			MV_REG_WRITE(CPU_CONFIG_REG, regVal);
		}

	}

	mvCtrlModelRevNameGet(name);
	printf("\nSoc: %s\n",  name);

	mvCpuNameGet(name);
	printf("CPU: %s running @ %dMhz \n",  name,mvCpuPclkGet()/1000000);
	
	/* init special env variables */
	misc_init_r_env();

	mv_cpu_init();
	printf("SysClock = %dMhz , TClock = %dMhz \n\n", CFG_BUS_CLK/1000000, CFG_TCLK/1000000);

	if(enaMonExt()){
			printf("\n      Marvell monitor extension:\n");
			mon_extension_after_relloc();
	}
	printf("\n");		

	/* Init Debug module */
	mvDebugInit();

	/* init the units decode windows */
	misc_init_r_dec_win();


#ifdef CONFIG_PCI
        pci_init();
#endif
/* saito change*/
#ifndef CONFIG_KUROBOX_PLATFORM

	mvBoardDebug7Seg(6);
#endif
	if(mvCtrlModelGet() == MV_5281_DEV_ID) /* Orion 2 */
	{

		__asm__ __volatile__("mrc    p15, 0, %0, c14, c0, 0" : "=r" (temp):: "memory");
		if (temp & 0x10000000)
		{
			printf("CPU: Write allocate enabled\n");
		}
		else
		{
			printf("CPU: Write allocate Disabled\n");
		}
	}

#if defined(RD_88F5182_3)
	/* if (RD_88F5182_2XSATA3 == mvBoardIdGet()) */
	{
		#include "mvGpp.h"
		/* GPIO / Leds / and Power button handling */
			
		/* Every value is Zero */
		MV_REG_WRITE(GPP_DATA_OUT_REG(0),0);
	
		/* Clear Interrupt cause */
		MV_REG_WRITE(GPP_INT_CAUSE_REG(0),0);
	
		/* Enable interrupt as edge */
		MV_REG_BIT_SET(GPP_INT_MASK_REG(0),(1 << 6) );
	
		printf("\nPlease Press power button to continue ... \n");
		do
		{
			if ( MV_REG_READ(GPP_INT_CAUSE_REG(0)) & (1 << 6)) break;
		}while (1);


		/* Clear Interrupt cause */
		MV_REG_BIT_RESET(GPP_INT_CAUSE_REG(0),(1 << 6));

		/* Disable interrupt */
		MV_REG_BIT_RESET(GPP_INT_MASK_REG(0),(1 << 6) );
		
		/* SATA 0 power on */
		MV_REG_BIT_SET(GPP_DATA_OUT_REG(0),(1<<2));

		/* Insert delay between HDD0 power on and HDD1 power on to prevent power noise */
		udelay(1000000);

		/* SATA 1 power on */
		MV_REG_BIT_SET(GPP_DATA_OUT_REG(0),(1<<8));
	}
#endif /* #if defined(RD_88F5182_3) */

/* saito change*/
#ifndef CONFIG_KUROBOX_PLATFORM
	mvBoardDebug7Seg(7);
#endif	
	return 0;
}

MV_U32 mvTclkGet(void)
{
        DECLARE_GLOBAL_DATA_PTR;
                                                                                                                                               
        /* get it only on first time */
        if(gd->tclk == 0)
                gd->tclk = mvBoardTclkGet();
                                                                                                                                               
        return gd->tclk;
}
                                                                                                                                               
MV_U32 mvSysClkGet(void)
{
        DECLARE_GLOBAL_DATA_PTR;
                                                                                                                                               
        /* get it only on first time */
        if(gd->bus_clk == 0)
                gd->bus_clk = mvBoardSysClkGet();
                                                                                                                                               
        return gd->bus_clk;
}
 
#ifndef MV_TINY_IMAGE
/* exported for EEMBC */
MV_U32 mvGetRtcSec(void)
{
        MV_RTC_TIME time;
        mvRtcDS1339TimeGet(&time);
	return (time.minutes * 60) + time.seconds;
}
#endif

void reset_cpu(void)
{
	MV_REG_BIT_SET( CPU_RSTOUTN_MASK_REG , BIT2);
	MV_REG_BIT_SET( CPU_SYS_SOFT_RST_REG , BIT0);
}


void mv_cpu_init(void)
{
	char *env;
	volatile unsigned int temp;

	/*CPU streaming */
    if( (mvCtrlModelGet() == MV_5181_DEV_ID) ||
		(mvCtrlModelGet() == MV_5182_DEV_ID) ||
		(mvCtrlModelGet() == MV_8660_DEV_ID) ||
		(mvCtrlModelGet() == MV_5082_DEV_ID) ) /* orion 1 */
	{ 
		
			__asm__ __volatile__("mrc    p15, 0, %0, c1, c0, 0" : "=r" (temp):: "memory");

			env = getenv("enaCpuStream");
			if(!env || (strcmp(env,"no") == 0) ||  (strcmp(env,"No") == 0) )
			{
				printf("Orion 1 streaming disabled \n");
				temp &= 0xefffffff;
			}
			else
			{
				printf("Orion 1 streaming enabled \n");
				 temp |= 0xefffffff;
			}

			__asm__ __volatile__("mcr    p15, 0, %0, c1, c0, 0" : "=r" (temp):: "memory");
	}
	else if(mvCtrlModelGet() == MV_5281_DEV_ID) /* orion 2*/
	{ 
		
			__asm__ __volatile__("mrc    p15, 0, %0, c14, c0, 0" : "=r" (temp):: "memory");

			env = getenv("enaCpuStream");
			if(!env || (strcmp(env,"no") == 0) ||  (strcmp(env,"No") == 0) )
			{
				printf("Orion 2 streaming disabled \n");
				temp &= 0xdfffffff;
			}
			else
			{
				printf("Orion 2 streaming enabled \n");
				temp |= 0xdfffffff;
			}
				
			__asm__ __volatile__("mcr    p15, 0, %0, c14, c0, 0" : "=r" (temp):: "memory");
	}

	if(mvCtrlModelGet() == MV_5281_DEV_ID){ /* Orion 2 */

		if (mvCtrlRevGet() == MV_5281_A0_REV) /* Orion 2 A0 */
		{
			env = getenv("enaVFP");
			if(env && ((strcmp(env,"yes") == 0) ||  (strcmp(env,"Yes") == 0)))  
			{
				/* init VFP to Run Fast Mode */
				printf("VFP initialized to Run Fast Mode.\n");
					temp = fmrx(FPSCR);
					temp |= (FPSCR_DEFAULT_NAN | FPSCR_FLUSHTOZERO);
					fmxr(FPSCR, temp);

			}
			else
			{
				printf("VFP not initialized\n");

			}


		} else 	if (mvCtrlRevGet() >= MV_5281_B0_REV) /* Orion 2 >= B0 */
		{

			env = getenv("enaVFP");
			if(env && ((strcmp(env,"yes") == 0) ||  (strcmp(env,"Yes") == 0)))  
			{
				/* init and Enable VFP to Run Fast Mode */
				printf("VFP initialized to Run Fast Mode.\n");
				/* Enable */
				temp = FPEXC_ENABLE;
				fmxr(FPEXC, temp);

				/* Run Fast Mode */
				temp = fmrx(FPSCR);
				temp |= (FPSCR_DEFAULT_NAN | FPSCR_FLUSHTOZERO);

				fmxr(FPSCR, temp);

			}
			else
			{
				printf("VFP not initialized\n");
				/* Disable */
				temp = fmrx(FPEXC);
				temp &= ~FPEXC_ENABLE;
				fmxr(FPEXC, temp);
			}

							
			/* DCache Pref  */
			env = getenv("enaDCPref");
			if(env && ((strcmp(env,"yes") == 0) ||  (strcmp(env,"Yes") == 0)))
			{
				MV_REG_BIT_SET( CPU_CONFIG_REG , CCR_DCACH_PREF_BUF_ENABLE);
			}
			if(env && ((strcmp(env,"no") == 0) ||  (strcmp(env,"No") == 0)))
            {
				MV_REG_BIT_RESET( CPU_CONFIG_REG , CCR_DCACH_PREF_BUF_ENABLE);
			}

			/* ICache Pref  */
			env = getenv("enaICPref");
            if(env && ((strcmp(env,"yes") == 0) ||  (strcmp(env,"Yes") == 0)))
			{
				MV_REG_BIT_SET( CPU_CONFIG_REG , CCR_ICACH_PREF_BUF_ENABLE);
			}
			if(env && ((strcmp(env,"no") == 0) ||  (strcmp(env,"No") == 0)))
            {
				MV_REG_BIT_RESET( CPU_CONFIG_REG , CCR_ICACH_PREF_BUF_ENABLE);

			}

		}

		/* write allocate */
		env = getenv("enaWrAllo");
		if(env && ((strcmp(env,"yes") == 0) ||  (strcmp(env,"Yes") == 0)))  
		{
			__asm__ __volatile__("mrc    p15, 0, %0, c14, c0, 0" : "=r" (temp):: "memory");
			temp |= 0x10000000;
			__asm__ __volatile__("mcr    p15, 0, %0, c14, c0, 0" : "=r" (temp):: "memory");
		}
		else
		{
			__asm__ __volatile__("mrc    p15, 0, %0, c14, c0, 0" : "=r" (temp):: "memory");
			temp &= 0xEFFFFFFF;
			__asm__ __volatile__("mcr    p15, 0, %0, c14, c0, 0" : "=r" (temp):: "memory");
		}

	}

}


#if (CONFIG_COMMANDS & CFG_CMD_NAND)
/*
#include "mvNflash.h"
extern MV_STATUS mvNflashInit(MV_NFLASH_INFO *pFlash);
*/
#include <linux/mtd/nand.h>

extern ulong nand_probe(ulong physadr);
extern int nand_rw (struct nand_chip* nand, int cmd,
	    size_t start, size_t len,
	    size_t * retlen, u_char * buf);
extern struct nand_chip nand_dev_desc[CFG_MAX_NAND_DEVICE];
#define NANDRW_READ	0x01
void nand_init(void)
{
	unsigned long nflashBase;
     nflashBase = mvBoardGetDeviceBaseAddr(0, BOARD_DEV_NAND_FLASH);

	totlen = nand_probe(nflashBase);
	printf ("%4lu MB\n", totlen >> 20);
/*
	MV_NFLASH_INFO *pFlash ;
		pFlash->nflashHwIf.devBaseAddr = mvBoardGetDeviceBaseAddr(0, BOARD_DEV_NAND_FLASH);
		pFlash->nflashHwIf.devWidth = mvBoardGetDeviceBusWidth(0, BOARD_DEV_NAND_FLASH);*/

/*		printf("addr = %x width = %x \n",pFlash->nflashHwIf.devBaseAddr ,pFlash->nflashHwIf.devWidth);*/
}

MV_STATUS serch_boot_nand(size_t offset ,unsigned char * addr )
{
	image_header_t *hdr;
/*	printf("offset = %x addr = %x \n",offset,addr) ;*/
	if (nand_rw (nand_dev_desc, NANDRW_READ, offset,
		    SECTORSIZE, NULL, (u_char *)addr)) {
		printf ("** Read error on NAND\n");
		}
			hdr = (image_header_t *)addr;
	if ((hdr->ih_magic) ==SWAP_LONG(IH_MAGIC)) {
		printf("Found boot image \n");
		return MV_OK;
	} else {
		printf ("\n** Bad Magic Number 0x%x **\n", hdr->ih_magic);
		return MV_FAIL;
	}


}

#if 0  /* saito*/
#include <linux/mtd/nand.h>

extern ulong nand_probe(ulong physadr);
extern struct nand_chip nand_dev_desc[CFG_MAX_NAND_DEVICE];

void nand_init(void)
{
	unsigned long totlen;
	unsigned long nflashBase;

	/* Check if NAND base is boot device */
    if (MV_REG_READ(DEV_NAND_CTRL_REG) & 0x1)
    {
        nflashBase = CFG_RESET_ADDRESS;
    }
    else
    {
        nflashBase = mvBoardGetDeviceBaseAddr(0, BOARD_DEV_NAND_FLASH);
    }
    
    totlen = nand_probe(nflashBase);
	printf ("%4lu MB\n", totlen >> 20);
}
#endif
#endif
