/*******************************************************************************
Copyright (C) Marvell International Ltd. and its affiliates

********************************************************************************
Marvell GPL License Option

If you received this File from Marvell, you may opt to use, redistribute and/or 
modify this File in accordance with the terms and conditions of the General 
Public License Version 2, June 1991 (the "GPL License"), a copy of which is 
available along with the File in the license.txt file or by writing to the Free 
Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 or 
on the worldwide web at http://www.gnu.org/licenses/gpl.txt. 

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE IMPLIED 
WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY 
DISCLAIMED.  The GPL License provides additional details about this warranty 
disclaimer.

*******************************************************************************/

#include <config.h>
#include <common.h>

#include "mvDramIf.h"
#include "mvCpuIfRegs.h"

#ifdef DEBUG
#define DB(x) x
#else
#define DB(x)
#endif

extern void i2c_init(int speed, int slaveaddr);
extern void _start(void);
extern unsigned int  mvCpuPclkGet(void);
extern void reset_cpu(void);
extern int dramBoot;


MV_VOID sizePrint(MV_U32 size)
{
    printf("size ");

    if(size >= _1G)
    {
        printf("%3dGB ", size / _1G);
        size %= _1G;
        if(size)
            printf("+");
    }
    if(size >= _1M )
    {
        printf("%3dMB ", size / _1M);
        size %= _1M;
        if(size)
            printf("+");
    }
    if(size >= _1K)
    {
        printf("%3dKB ", size / _1K);
        size %= _1K;
        if(size)
            printf("+");
    }
    if(size > 0)
    {
        printf("%3dB ", size);
    }
}


int dram_init (void)
{

	DECLARE_GLOBAL_DATA_PTR;
	unsigned int i, dramTotalSize=0;
    MV_U32 boardId = mvBoardIdGet();


#ifdef CONFIG_KUROBOX_PLATFORM

		for(i = 0; i< CONFIG_NR_DRAM_BANKS; i++)
		{
			gd->bd->bi_dram[i].start = mvDramIfBankBaseGet(i);
			gd->bd->bi_dram[i].size = mvDramIfBankSizeGet(i);
			dramTotalSize += gd->bd->bi_dram[i].size;
			if (gd->bd->bi_dram[i].size)
			{
				printf("DRAM CS[%d] base 0x%08x   ",i, gd->bd->bi_dram[i].start);
				mvSizePrint(gd->bd->bi_dram[i].size);
				printf("\n");
			}
		}
 
		printf("DRAM Total ");
		sizePrint(dramTotalSize);
		printf("\n");

#else




	if ((DB_88F1181_DDR1 == boardId)||
	    (DB_88F1181_DDR2 == boardId)||
		(DB_88F5181_5281_DDR2 == boardId)||
		(DB_88F5181_5281_DDR1 == boardId)||
		(DB_88F5X81_DDR2 == boardId)||
		(DB_88F5X81_DDR1 == boardId)||
	    (DB_88F5182_DDR2 == boardId)||
	    (DB_88F5181L_DDR2_2XTDM == boardId) ||
	    (DB_88W8660_DDR2 == boardId)
        )
		
		
	{
		if (0 == (dramTotalSize = initdram(0)))
		{
			printf("DRAM Initialization Failed\n");
			reset_cpu();
			return (1);
		}

			/* Call dramInit */
		for(i = 0; i< CONFIG_NR_DRAM_BANKS; i++)
		{
			gd->bd->bi_dram[i].start = mvDramIfBankBaseGet(i);
			gd->bd->bi_dram[i].size = mvDramIfBankSizeGet(i);
			if (gd->bd->bi_dram[i].size)
			{
				printf("DRAM CS[%d] base 0x%08x   ",i, gd->bd->bi_dram[i].start);
				mvSizePrint(gd->bd->bi_dram[i].size);
				printf("\n");
			}
		}
	 
		printf("DRAM Auto Detection... Done\n");
		printf("DRAM Total ");
		mvSizePrint(dramTotalSize);
		printf("\n");

	}
	else if ((DB_88F5181_DDR1_PRPMC == boardId)||
		 (DB_88F5181_DDR1_MNG == boardId)||
		 (DB_88F5181_DDR1_PEXPCI == boardId) || 
		 (RD_88F5181_VOIP == boardId) || 
		 (RD_88F5181_POS_NAS == boardId)||
		 (RD_88F5182_2XSATA == boardId)||
		 (RD_88F5182_2XSATA3 == boardId)||
		 (RD_88F5181L_VOIP_FE == boardId)||
		 (RD_88F5181L_VOIP_GE == boardId) ||
		 (RD_88W8660_DDR1 == boardId) ||
		 (RD_88W8660_AP82S_DDR1 == boardId) ) 
	{

		for(i = 0; i< CONFIG_NR_DRAM_BANKS; i++)
		{
			gd->bd->bi_dram[i].start = mvDramIfBankBaseGet(i);
			gd->bd->bi_dram[i].size = mvDramIfBankSizeGet(i);
			dramTotalSize += gd->bd->bi_dram[i].size;
			if (gd->bd->bi_dram[i].size)
			{
				printf("DRAM CS[%d] base 0x%08x   ",i, gd->bd->bi_dram[i].start);
				mvSizePrint(gd->bd->bi_dram[i].size);
				printf("\n");
			}
		}
 
		printf("DRAM Total ");
		sizePrint(dramTotalSize);
		printf("\n");

	}
#endif /* CONFIG_KUROBOX_PLATFORM */
 
        return 0;
}
#ifndef CONFIG_KUROBOX_PLATFORM
/* u-boot interface function to SDRAM init - this is where all the
 * controlling logic happens */
long int initdram(int board_type)
{
    MV_VOIDFUNCPTR pRom; 
    MV_U32 forcedCl;    /* Forced CAS Latency */
    MV_U32 totalSize;
    MV_U32 temp;
    char * env;
    MV_TWSI_ADDR slave;

    /* If we are booting from DRAM, memory is already configured.   */
    /* This is why we skip DRAM dynamic detection                   */
	/*dramBoot = 1;*/

    if(0 == dramBoot)
    {
    slave.type = ADDR7_BIT;
    slave.address = 0;
    mvTwsiInit(CFG_I2C_SPEED, CFG_TCLK, &slave, 0);

    /* Calculating MIN/MAX CAS latency according to user settings */
    env = getenv("CASset");
	
    if(env && (strcmp(env,"1.5") == 0))
    {
        forcedCl = 15;
    }
    else if(env && (strcmp(env,"2") == 0))
    {
        forcedCl = 20;
    }
    else if(env && (strcmp(env,"2.5") == 0))
    {
        forcedCl = 25;
    }
    else if(env && (strcmp(env,"3") == 0))
    {
        forcedCl = 30;
    }
    else if(env && (strcmp(env,"4") == 0))
    {
        forcedCl = 40;
    }
    else
    {
        forcedCl = 0;
    }
    
     /* detect the dram configuartion parameters */
	if (MV_OK != mvDramIfDetect(forcedCl))
    {
        printf("DRAM Auto Detection Failed! System Halt!\n");
        return 0;
    }

    /* set the dram configuration */
    /* Calculate jump address of _mvDramIfConfig() */
    pRom = (MV_VOIDFUNCPTR)((_mvDramIfConfig - _start) + CFG_MONITOR_BASE);

    
    (*pRom) (); /* Jump to _mvDramIfConfig*/
    }
    
    totalSize = mvDramIfSizeGet();

    printf("DRAM");
    if(MV_REG_READ(SDRAM_CONFIG_REG) & SDRAM_DTYPE_DDR2)
    {
    	switch((MV_REG_READ(0x141c) >> 4) & 0x7)
    	{
                case 0x3: printf(" CAS Latency = 3");
                        break;
                case 0x4: printf(" CAS Latency = 4");
                        break;
                case 0x5: printf(" CAS Latency = 1.5");
                        break;
                default: printf(" unknown CAL ");
                        break;
	}
    }
    else
    {
    	switch((MV_REG_READ(0x141c) >> 4) & 0x7)
    	{
                case 0x2: printf(" CAS Latency = 2");
                        break;
                case 0x3: printf(" CAS Latency = 3");
                        break;
                case 0x4: printf(" CAS Latency = 4");
                        break;
                case 0x5: printf(" CAS Latency = 1.5");
                        break;
                case 0x6: printf(" CAS Latency = 2.5");
                        break;
		default: printf(" unknown CAL ");
                        break;
	}
    }

    temp = MV_REG_READ(0x1408);
    printf(" tRP = %d tRAS = %d tRCD=%d\n",
           ((temp >> 8) & 0xf) + 1, ((temp >> 20) & 0xf) + 1, ((temp >> 4) & 0xf) + 1);

    return(totalSize);
}
#endif /*ifndef CONFIG_KUROBOX_PLATFORM*/

