#!/bin/sh

daemonize=0

#date +%x-%T >> /var/usb.status

if [ $1 == 1 ]; then
    #echo "      USB1 device connect event" >> /var/usb.status
    if [ ! -e /mnt/usb1 ]; then
        mkdir /mnt/usb1
    fi
    mount -t vfat /dev/usb1msc /mnt/usb1

    if [ -e /mnt/usb1/firmware.tar.gz ]; then
        tar xvzf /mnt/usb1/firmware.tar.gz -C /tmp/
        if [ -e /tmp/updatek.bin ]; then
            /usr/local/sbin/update_d -rq -tusb -f/tmp/updatek.bin
        fi
        if [ -e /tmp/updatefs.bin ]; then
            /usr/local/sbin/update_d -rq -tusb -f/tmp/updatefs.bin
        fi
        if [ -e /tmp/web.bin ]; then
            /usr/local/sbin/update_d -rq -tusb -f/tmp/web.bin
        fi
        if [ -e /tmp/backup.tar.gz ]; then
            echo "DO A part"
            /usr/local/sbin/prof_mag /tmp/backup.tar.gz
        fi
        exit
    fi
    if [ $daemonize == 1 ]; then
        if [ -e /mnt/usb1/updatek.bin -o -e /mnt/usb1/updatefs.bin -o -e /mnt/usb1/web.bin ]; then
            /usr/local/sbin/update_d -d -tusb -f/mnt/usb1/updatek.bin -f/mnt/usb1/updatefs.bin -f/mnt/usb1/web.bin
        fi
    else
        if [ -e /mnt/usb1/updatek.bin ]; then
            cp /mnt/usb1/updatek.bin /tmp/
            /usr/local/sbin/update_d -rq -tusb -f/tmp/updatek.bin
        fi
        if [ -e /mnt/usb1/updatefs.bin ]; then
            cp /mnt/usb1/updatefs.bin /tmp/
            /usr/local/sbin/update_d -rq -tusb -f/tmp/updatefs.bin
        fi
        if [ -e /mnt/usb1/web.bin ]; then
            cp /mnt/usb1/web.bin /tmp/
            /usr/local/sbin/update_d -rq -tusb -f/tmp/web.bin
        fi
        if [ -e /mnt/usb1/backup.tar.gz ]; then
            echo "DO B part"
            cp /mnt/usb1/backup.tar.gz /tmp/
            /usr/local/sbin/prof_mag /tmp/backup.tar.gz
        fi
    fi
elif [ $1 == 2 ]; then
    #echo "      USB2 device connect event" >> /var/usb.status
    if [ ! -e /mnt/usb2 ]; then
        mkdir /mnt/usb2
    fi
    mount -t vfat /dev/usb2msc /mnt/usb2

    if [ -e /mnt/usb2/firmware.tar.gz ]; then
        tar xvzf /mnt/usb2/firmware.tar.gz -C /tmp/
        if [ -e /tmp/updatek.bin ]; then
            /usr/local/sbin/update_d -rq -tusb -f/tmp/updatek.bin
        fi
        if [ -e /tmp/updatefs.bin ]; then
            /usr/local/sbin/update_d -rq -tusb -f/tmp/updatefs.bin
        fi
        if [ -e /tmp/web.bin ]; then
            /usr/local/sbin/update_d -rq -tusb -f/tmp/web.bin
        fi
        if [ -e /tmp/backup.tar.gz ]; then
            echo "DO C part"
            /usr/local/sbin/prof_mag /tmp/backup.tar.gz
        fi
        exit
    fi
    if [ $daemonize == 1 ]; then
        if [ -e /mnt/usb2/updatek.bin -o -e /mnt/usb2/updatefs.bin -o -e /mnt/usb2/web.bin ]; then
            /usr/local/sbin/update_d -d -tusb -f/mnt/usb2/updatek.bin -f/mnt/usb2/updatefs.bin -f/mnt/usb2/web.bin
        fi
    else
        if [ -e /mnt/usb2/updatek.bin ]; then
            cp /mnt/usb2/updatek.bin /tmp/
            /usr/local/sbin/update_d -rq -tusb -f/tmp/updatek.bin
        fi
        if [ -e /mnt/usb2/updatefs.bin ]; then
            cp /mnt/usb2/updatefs.bin /tmp/
            /usr/local/sbin/update_d -rq -tusb -f/tmp/updatefs.bin
        fi
        if [ -e /mnt/usb2/web.bin ]; then
            cp /mnt/usb2/web.bin /tmp/
            /usr/local/sbin/update_d -rq -tusb -f/tmp/web.bin
        fi
        if [ -e /mnt/usb2/backup.tar.gz ]; then
            echo "DO D part"
            cp /mnt/usb2/backup.tar.gz /tmp/
            /usr/local/sbin/prof_mag /tmp/backup.tar.gz
        fi
    fi
else
    #echo "      USB device disconnect event" >> /var/usb.status
    if [ $1 == -1 ]; then
        umount -f /mnt/usb1/
    fi
    if [ $1 == -2 ]; then
        umount -f /mnt/usb2/
    fi
fi

