#!/bin/sh

APPS_DIR=apps
PJPROJ_DIR=pjproject-0.8.0
LOCALS_MK=locals.mk
OEM_DIR=oem
ROOTFS_DIR=rootfs
FS_DIR=fsdir
BKFS_DIR=bkfsdir


CONFIG_FILE=".config"
PJDBG=`cat $CONFIG_FILE | awk -F"=" '/CONFIG_PJPOOL_DBG/ {print $2}'`
MEMDBG=`cat $CONFIG_FILE | awk -F"=" '/CONFIG_MALLOC_DBG/ {print $2}'`

if [ $MEMDBG == "y" ]; then
    OPTCFLAGS="-g -DUSE_MTRACE "
else
    OPTCFLAGS="-O2 "
fi
OPTCFLAGS+="-D__LINUX__ "
if [ $PJDBG == "y" ]; then
    OPTCFLAGS+="-DPJ_POOL_DEBUG=1 "
fi

if [ ! -e rootfs/home/ ]; then
    mkdir -p rootfs/home/
fi
if [ ! -e rootfs/usr/local/sbin/ ]; then
    mkdir -p rootfs/usr/local/sbin/
fi

if [ $1 == "arm" ]; then
    echo "export NVR_BASE_DIR = `pwd`"/$APPS_DIR > $APPS_DIR/$LOCALS_MK
    echo "export JSPLAT = mvl" >> $APPS_DIR/$LOCALS_MK

    if [ ! -e $APPS_DIR/$PJPROJ_DIR/build.mak ]; then
        cd $APPS_DIR/$PJPROJ_DIR/
        chmod 755 *configure
    else
        cd $APPS_DIR/$PJPROJ_DIR/
    fi
    CFLAGS=$OPTCFLAGS ./aconfigure --target=armv5tejl-linux-gnu --host=arm_v5t_le
fi

if [ $1 == "x86" ]; then
    echo "export NVR_BASE_DIR = `pwd`"/$APPS_DIR > $APPS_DIR/$LOCALS_MK
    echo "export JSPLAT = x86" >> $APPS_DIR/$LOCALS_MK

    if [ ! -e $APPS_DIR/$PJPROJ_DIR/build.mak ]; then
        cd $APPS_DIR/$PJPROJ_DIR/
        chmod 755 *configure
    else
        cd $APPS_DIR/$PJPROJ_DIR/
    fi
    CFLAGS=$OPTCFLAGS ./aconfigure
fi

#
# OEM
#
if [ $1 == "oem" ]; then
    if [ -d $OEM_DIR ]; then
        if [ -d $APPS_DIR ]; then
	    if [ -f $OEM_DIR/ver.txt ]; then
                cp $OEM_DIR/ver.txt $APPS_DIR/ver.txt
	    fi

	    OLD_PATH=$PWD
	    cd $OEM_DIR/include
	    ls -1 | xargs cp -rft ../../$APPS_DIR/include
	    cd $OLD_PATH

	    OLD_PATH=$PWD
	    cd $OEM_DIR/web
	    ls -1 | xargs cp -rft ../../$APPS_DIR/web
	    cd $OLD_PATH
	fi
	if [ -d $ROOTFS_DIR ]; then
	    if [ -f $OEM_DIR/OEM ]; then
                cp $OEM_DIR/OEM $ROOTFS_DIR/home
	    fi

	    if [ -f $OEM_DIR/Info ]; then
                cp $OEM_DIR/Info $ROOTFS_DIR/home
	    fi

            if [ -f $OEM_DIR/SearchFilter ]; then
                cp $OEM_DIR/SearchFilter $ROOTFS_DIR/home
	    fi
	fi
    fi
fi


#
# OEM DHCP default IP
#
if [ $1 == "set_dhcp_defip" ]; then
    if [ -d $OEM_DIR ]; then
        if [ -f $OEM_DIR/S51dhcp_start ]; then
            install -m755 $OEM_DIR/S51dhcp_start $FS_DIR/etc/rc.d/rcS.d
            install -m755 $OEM_DIR/S51dhcp_start $BKFS_DIR/etc/rc.d/rcS.d
        fi
    fi
fi

