/*
 * include/asm-arm/arch-feroceon/debug-marco.S
 *
 * Debugging macro include header
 *
 */

#include <asm/hardware.h>
#include <linux/serial_reg.h>

#define PORT0_BASE	(0xf1000000 + 0x12000)

	.macro	addruart, rx
	ldr	\rx, =PORT0_BASE

	.endm

	.macro	senduart, rd, rx
	strb	\rd, [\rx]

	.endm

	.macro	waituart, rd, rx
1001:	ldr	\rd, [\rx, #UART_LSR << 2]
	tst	\rd, #UART_LSR_THRE

	beq	1001b
	.endm

	.macro	busyuart, rd, rx
1001:	ldr	\rd, [\rx, #UART_LSR << 2]
	tst	\rd, #UART_LSR_TEMT

	beq	1001b
	.endm
