/*
 *	Suppliment to iwpriv 
 *
 *		Jane Chang, Inprocomm, Inc.
 *      jane@inprocomm.com
 */

/******************************************************************************
Copyright (c) 2000-2003 Integrated Programmable Communications, Inc.

All rights reserved. Copying, compilation, modification, distribution
or any other use whatsoever of this material is strictly prohibited
except in accordance with a Software License Agreement with
Integrated Programmable Communications, Inc.
******************************************************************************/
/* Compile: 
     1. make wireless_tools
     2. gcc iwsta.c libiw.a -lm     (libiw.a is provided by wireless_tools)
*/

/************************************************************************
*                E X T E R N A L   R E F E R E N C E S
*************************************************************************
*/

#include "iwlib.h"
/************************************************************************
*                          C O N S T A N T S
*************************************************************************
*/

/* Backward compatibility */
#ifndef IW_PRIV_TYPE_ADDR
#define IW_PRIV_TYPE_ADDR	0x6000
#endif	/* IW_PRIV_TYPE_ADDR */

#ifndef MAC2STR
#define MAC2STR(a) (a)[0], (a)[1], (a)[2], (a)[3], (a)[4], (a)[5]
#define MACSTR "%02x:%02x:%02x:%02x:%02x:%02x"
#endif

#define IOCTL_GET_STRUCT	SIOCIWFIRSTPRIV + 9
static SS_STATUS_Tp pStatus=NULL;
/************************************************************************
*                         D A T A   T Y P E S
*************************************************************************
*/
/************************************************************************
*                          F U N C T I O N S
*************************************************************************
*/
int get_wireless_sitesurvey_request(char *ifname)
{
	int skfd;
	struct iwreq iwr;
	unsigned char result;

       /* Create a channel to the NET kernel. */
        if((skfd = iw_sockets_open()) < 0)
        {
                printf("open socket fail\n");
                return FALSE;
        }



    strcpy(iwr.ifr_name, ifname);
    iwr.u.data.pointer = (caddr_t)&result;
    iwr.u.data.length = sizeof(result);

    if (ioctl(skfd, SIOCGIWRTLSCANREQ, &iwr) < 0)
	{
		perror("Can't run sitesurvey request");
	        return FALSE;
	}
	
	close (skfd);

    if ( result == 0xff )
	return	FALSE;
    else
	return (int)result; 
}

int get_wireless_bss_information(char *ifname)
{
	int skfd, j;
	FILE	*fp, *wlanfp;
	struct iwreq iwr;
	struct _bss_info bss_info;
	unsigned char tmpbuf[48];
	struct _wlanstruct wlanstruct;

        system ("/bin/flash get AP_MODE > /tmp/wlanfunction.inc");
	system ("/bin/flash get WEP >> /tmp/wlanfunction.inc");
	
	/* Create a channel to the NET kernel. */
        if((skfd = iw_sockets_open()) < 0)
        {
                printf("open socket fail\n");
                return FALSE;
        }
	
	if ((fp = fopen ("/tmp/config_result.inc", "w")) == NULL)
	{
		printf ("Can't open file config_result.inc\n");
		return FALSE;
	}
	
	if ((wlanfp = fopen ("/tmp/wlanfunction.inc", "r")) == NULL)
	{
		printf ("Can't open file wlanfunction.inc\n");
		return FALSE;
	}

	
	strcpy(iwr.ifr_name, ifname);
	iwr.u.data.pointer = (caddr_t)&bss_info;
	iwr.u.data.length = sizeof(bss_info);
	
	if (ioctl(skfd, SIOCGIWRTLGETBSSINFO, &iwr) < 0)
	{
                fputs ("MODE=Unknown\n", fp);
                fputs ("ESSID=Unknown\n", fp);
                fputs ("CHANNEL=Unknown\n", fp);
                fputs ("WEP=Unknown\n", fp);
                fputs ("STATE=Disconnected\n", fp);
                fputs ("BSSID=Unknown\n", fp);
		fclose(fp);
        	return FALSE;
	}
	memset (&wlanstruct, 0, sizeof (wlanstruct));
	
	fgets (tmpbuf, 48, wlanfp);
	if (! memcmp (tmpbuf, "AP_MODE=0", 9))
		sprintf (tmpbuf, "MODE=Infrastructure\n");
	else
		sprintf (tmpbuf, "MODE=Ad-hoc\n");
	fputs (tmpbuf, fp);
	
	sprintf (tmpbuf, "ESSID=%s\n", bss_info.ssid);
	fputs (tmpbuf, fp);
	
	sprintf (tmpbuf, "CHANNEL=%d\n", bss_info.channel);
	fputs (tmpbuf, fp);
/*	
	if (bss_info.state & cPrivacy)
		sprintf (tmpbuf, "WEP=Yes\n");
	else
		sprintf (tmpbuf, "WEP=No\n");
	fputs (tmpbuf, fp);
*/
	fgets (tmpbuf, 48, wlanfp);
	if (!memcmp (tmpbuf, "WEP=0", 5))
		sprintf (tmpbuf, "WEP=off\n");
	else
		sprintf (tmpbuf, "WEP=on\n");
	fputs (tmpbuf, fp);

        switch (bss_info.state) {
                case STATE_DISABLED:
                        sprintf (tmpbuf, "STATE=Disabled\n");
                        break;
                case STATE_IDLE:
                        sprintf (tmpbuf, "STATE=Idle\n");
                        break;
                case STATE_STARTED:
                        sprintf (tmpbuf, "STATE=Started\n");
                        break;
                case STATE_CONNECTED:
                        sprintf (tmpbuf, "STATE=Connected\n");
                        break;
                case STATE_SCANNING:
                        sprintf (tmpbuf, "STATE=Scanning\n");
                        break;
                default:
                        sprintf (tmpbuf, "STATE=Unknow\n");
                }
	
	fputs (tmpbuf, fp);

	sprintf (tmpbuf, "BSSID=%2x:%2x:%2x:%2x:%2x:%2x\n", bss_info.bssid[0], bss_info.bssid[1], bss_info.bssid[2], bss_info.bssid[3], bss_info.bssid[4], bss_info.bssid[5]);
	
	for (j = 0; tmpbuf[j] != '\n'; j++)
	{
		if (tmpbuf[j] == '\x20')
			tmpbuf[j] = '\x30';
	}

	fputs (tmpbuf, fp);
	
	fclose(fp);
	fclose(wlanfp);
	close( skfd );

	return 0;
}

int get_wireless_sitesurvey_result(char *ifname, SS_STATUS_Tp pStatus )
{
	int skfd;
	struct iwreq iwr;

       /* Create a channel to the NET kernel. */
        if((skfd = iw_sockets_open()) < 0)
        {
                printf("open socket fail\n");
                return FALSE;
        }
	strcpy (iwr.ifr_name, ifname);
	iwr.u.data.pointer = (caddr_t)pStatus;

	if ( pStatus->number == 0 )
		iwr.u.data.length = sizeof(SS_STATUS_T);
	else
	iwr.u.data.length = sizeof(pStatus->number);

	if (ioctl(skfd, SIOCGIWRTLGETBSSDB, &iwr) < 0)
	{
		printf ("sitesurvey fail!! \n");
		return FALSE;
	}	
    	
	close(skfd);
	return TRUE;
}

int save_sitesurvey_result()
{
        FILE    *fp;
	int wait_time, i;
	unsigned char tmpbuf[48], j;
	unsigned char res;
	BssDscr *pBss;
	struct _wlanstruct wlanstruct;

	if (pStatus==NULL)
	{
		pStatus = calloc(1, sizeof(SS_STATUS_T));
		if ( pStatus == NULL )
		{
			printf("Allocate buffer failed!\n");
			return FALSE;
		}
	}
	
	wait_time = 0;
	while (1)
	{
		if (get_wireless_sitesurvey_request("wlan0") == TRUE)
		{
			printf ("Sitesurvey request success!!\n");
			break;
		}
		else
		{
			if (wait_time++ > 5)
			{
				printf ("Sitesurvey request fail!!\n");
				return FALSE;
			}
		}
		sleep(1);
	}
	
	if ( (fp = fopen ("/tmp/sitesurvey_result.inc", "w")) == NULL)
	{
		printf ("Can't open file sitesurvey_result.inc\n");
		return FALSE;
	}
	
	wait_time = 0;
	while (1)
	{
		res = 1;
		if (  get_wireless_sitesurvey_result ("wlan0", (SS_STATUS_Tp)&res) < 0)
		{
			printf ("sitesurvey fail!! \n");
			free(pStatus);
			pStatus = NULL;
			return FALSE;
		}
		if (res == 0xff)
		{
			if (wait_time++ > 10)						//working not complete
			{
				printf ("Sitesurvey fail!!\n");
				free(pStatus);
				pStatus = NULL;
				return FALSE;
			}
			sleep(1);
		}
		else									//complete
			break;
	}
	
	if ( get_wireless_sitesurvey_result ("wlan0", pStatus) < 0 )
	{
		printf("Read site-survey status failed!\n");
		free(pStatus);
		pStatus = NULL;
		return FALSE;
	}
	
	printf("sitesurvey_number = %d\n", pStatus->number);
	
	for (i=0; i < pStatus->number && pStatus->number != 0xff; i++)
	{
		memset (&wlanstruct, 0, sizeof (wlanstruct));
		
		pBss = &pStatus->bssdb[i];
		if (pBss->bdCap & cIBSS)								//MODE
			memcpy (wlanstruct.mode, "Ad-hoc", 6);
		else
			memcpy (wlanstruct.mode, "Infrastructure", 14);
		memcpy(wlanstruct.ssid, pStatus->bssdb[i].bdSsIdBuf, pStatus->bssdb[i].bdSsId.Length);	//SSID
		
		sprintf (tmpbuf, "%d", pBss->ChannelNumber);						//CHANNEL
		memcpy (wlanstruct.channel, tmpbuf, strlen(tmpbuf));
		
		if (pBss->bdCap & cPrivacy)								//WEP
			memcpy (wlanstruct.encryption, "on", 2);
		else
			memcpy (wlanstruct.encryption, "off", 3);
		sprintf (tmpbuf, "%d", pBss->sq);
		memcpy (wlanstruct.state, tmpbuf, strlen (tmpbuf));
		
		sprintf (tmpbuf, "%2x:%2x:%2x:%2x:%2x:%2x", pBss->bdBssId[0], pBss->bdBssId[1], pBss->bdBssId[2], pBss->bdBssId[3], pBss->bdBssId[4], pBss->bdBssId[5]);							   //BSSID
		tmpbuf[17] = '\x0';
		for (j = 0; j < strlen(tmpbuf); j++)
		{
			if (tmpbuf[j] == '\x20')
				tmpbuf[j] = '\x30';
		}
		memcpy (wlanstruct.bssid, tmpbuf, strlen(tmpbuf));
		
		fwrite (&wlanstruct, sizeof(wlanstruct), 1, fp);
	}
	fclose (fp);
	return TRUE;
}

int main(int argc, char **argv)
{
        if ( argc > 1 )
        {
                if ( !(strcmp (argv[1], CONFIGCMD)))
                {
			if ( get_wireless_bss_information("wlan0") == TRUE  )
			{
				printf ("Get wireless information success!\n");
				return TRUE;
			}
			else
			{
				printf ("Get wireless information fail!\n");
				return FALSE;
			}
				
                }

                else if( !(strcmp (argv[1], SITESURVEYCMD)))
                {
			if (save_sitesurvey_result("wlan0") == TRUE)
			{
				printf ("Get sitesurvey success!\n");
				return TRUE;
			}
			else
			{
				printf ("Get sitedurvey fail!\n");
				return FALSE;
			}
		}

		else
			printf("wlan {config;sitesurvey;start;stop}\n");
			
	}
	else
		printf("wlan {config;sitesurvey;start;stop}\n");
        return TRUE;
}
