/*
 *	Suppliment to iwpriv 
 *
 *		Jane Chang, Inprocomm, Inc.
 *      jane@inprocomm.com
 */

/******************************************************************************
Copyright (c) 2000-2003 Integrated Programmable Communications, Inc.

All rights reserved. Copying, compilation, modification, distribution
or any other use whatsoever of this material is strictly prohibited
except in accordance with a Software License Agreement with
Integrated Programmable Communications, Inc.
******************************************************************************/
/* Compile: 
     1. make wireless_tools
     2. gcc iwsta.c libiw.a -lm     (libiw.a is provided by wireless_tools)
*/

/************************************************************************
*                E X T E R N A L   R E F E R E N C E S
*************************************************************************
*/

#include "iwlib.h"
/************************************************************************
*                          C O N S T A N T S
*************************************************************************
*/

/* Backward compatibility */
#ifndef IW_PRIV_TYPE_ADDR
#define IW_PRIV_TYPE_ADDR	0x6000
#endif	/* IW_PRIV_TYPE_ADDR */

#ifndef MAC2STR
#define MAC2STR(a) (a)[0], (a)[1], (a)[2], (a)[3], (a)[4], (a)[5]
#define MACSTR "%02x:%02x:%02x:%02x:%02x:%02x"
#endif

#define IOCTL_GET_STRUCT	SIOCIWFIRSTPRIV + 9
static SS_STATUS_Tp pStatus=NULL;


/************************************************************************
*                         D A T A   T Y P E S
*************************************************************************
*/
typedef struct sta_status_ {
        short           aid;         /* STA's unique AID (1 .. 2007) or 0 if not yet assigned */
        unsigned char   adAddr[6];      /* address of associated station */
        unsigned char   auth_state;  /* station status */
        unsigned char   ps_state;    /* station power save status */
        unsigned long assoc_time;
} sta_status_t;

/*
 * Structure used by wlan to store the log.
 */
struct net_stat
{
        unsigned long   txunicastframes;
        unsigned long   txmulticastframes;
        unsigned long   txfragments	;
        unsigned long   txsingleretryframes;
        unsigned long   txmultipleretryframes;
        unsigned long   txretrylimitexceeded;
        unsigned long   txdiscards;
	unsigned long   txbytes;
        unsigned long   rxmulticastframes;
	unsigned long   rxbytes;
        unsigned long   rxfragments	;
        unsigned long   rxfcserrors;
        unsigned long   rxdiscardsnobuffer;
        unsigned long   rxdiscardswepundecr;
};

/************************************************************************
*                          F U N C T I O N S
*************************************************************************
*/
int st_info_ioctl(int skfd,  char *	ifname)
{
        struct iwreq iwr;
        sta_status_t *staS;
        int i=0, n=10; /* Default number of station--10 should be enough */

        staS = malloc(sizeof(sta_status_t)*n);
	memset(staS,0,sizeof(sta_status_t)*n);
        memset(&iwr, 0, sizeof(iwr));

        strcpy(iwr.ifr_name,ifname);
        iwr.u.data.flags = 1; /* subcmd = StaList*/
        iwr.u.data.pointer = (caddr_t)staS;
        iwr.u.data.length = sizeof(sta_status_t)*n;

        if (ioctl(skfd, IOCTL_GET_STRUCT, &iwr) < 0) {
              perror("ioctl[IOCTL_GET_STRUCT]");
              return -1;
        }

        for(i=0;i<n;i++)
        {
                if (staS[i].aid) {
                        printf("MAC Addr:"MACSTR"\n",MAC2STR(staS[i].adAddr));
                }
                else
                        break;
        }
        return 0;
}

int ap_stat_ioctl(int skfd,  char *ifname)
{
	struct iwreq iwr;
        struct net_stat tmp_stat;
        memset(&tmp_stat,0,sizeof(tmp_stat));
        memset(&iwr, 0, sizeof(iwr));

        strcpy(iwr.ifr_name,ifname);
        iwr.u.data.flags = 50; /* subcmd = ap_statistic*/
        iwr.u.data.pointer = (caddr_t)&tmp_stat;
        iwr.u.data.length = sizeof(tmp_stat);

        if (ioctl(skfd, IOCTL_GET_STRUCT, &iwr) < 0) {
              perror("ioctl[IOCTL_GET_STRUCT]");
              return -1;
        }

        printf("txbyes: %d\n",tmp_stat.txbytes);
        printf("txunicastframes: %d\n",tmp_stat.txunicastframes);
        printf("txmulticastframes: %d\n",tmp_stat.txmulticastframes);
        printf("txfragments: %d\n",tmp_stat.txfragments);
        printf("txsingleretryframes: %d\n",tmp_stat.txsingleretryframes);
        printf("txmultipleretryfram: %d\n",tmp_stat.txmultipleretryframes);
        printf("txretrylimitexceede: %d\n",tmp_stat.txretrylimitexceeded);
        printf("txdiscards: %d\n",tmp_stat.txdiscards);
        printf("rxbyes: %d\n",tmp_stat.rxbytes);
        printf("rxmulticastframes: %d\n",tmp_stat.rxmulticastframes);
        printf("rxfragments: %d\n",tmp_stat.rxfragments);
        printf("rxfcserrors: %d\n",tmp_stat.rxfcserrors);
        printf("rxdiscardswepundecr: %d\n",tmp_stat.rxdiscardswepundecr);

        return 0;
}

int get_wireless_sitesurvey_request(char *ifname)
{
	int skfd;
	struct iwreq iwr;
	unsigned char result;

       /* Create a channel to the NET kernel. */
        if((skfd = iw_sockets_open()) < 0)
        {
                printf("open socket fail\n");
                return(-1);
        }



    strcpy(iwr.ifr_name, ifname);
    iwr.u.data.pointer = (caddr_t)&result;
    iwr.u.data.length = sizeof(result);

    if (ioctl(skfd, SIOCGIWRTLSCANREQ, &iwr) < 0)
	{
		perror("Can't run sitesurvey request");
	        return FALSE;
	}
	
	close (skfd);

    if ( result == 0xff )
	return	FALSE;
    else
	return (int)result; 
}

int get_wireless_bss_information(char *ifname)
{
	int skfd, j;
	FILE	*fp;
	struct iwreq iwr;
	struct _bss_info bss_info;
	unsigned char tmpbuf[48];
	struct _wlanstruct wlanstruct;

       /* Create a channel to the NET kernel. */
        if((skfd = iw_sockets_open()) < 0)
        {
                printf("open socket fail\n");
                return(-1);
        }
	
	if ((fp = fopen ("/tmp/config_result.inc", "w")) == NULL)
	{
		printf ("Can't open file config_result.inc\n");
		return -1;
	}
	
	strcpy(iwr.ifr_name, ifname);
	iwr.u.data.pointer = (caddr_t)&bss_info;
	iwr.u.data.length = sizeof(bss_info);
	
	if (ioctl(skfd, SIOCGIWRTLGETBSSINFO, &iwr) < 0)
	{
                fputs ("MODE=\n", fp);
                fputs ("ESSID=\n", fp);
                fputs ("CHANNEL=\n", fp);
                fputs ("WEP=\n", fp);
                fputs ("STATE=Disconnected\n", fp);
                fputs ("BSSID=\n", fp);
		fclose(fp);
        	return -1;
	}
	memset (&wlanstruct, 0, sizeof (wlanstruct));
	
//	sprintf (buffer, "MODE=%s", wlanstruct.mode);
//	fputs (buffer, tfp);
//	sprintf (buffer, "ESSID=%s\n", bss_info.ssid);
//	fputs (buffer, fp);
//	memcpy (wlanstruct.ssid, bss_info.ssid, strlen(bss_info.ssid));
	if (bss_info.state & cIBSS)                                                        //MODE
		sprintf (tmpbuf, "MODE=Infrastructure\n");
	else
		sprintf (tmpbuf, "MODE=Ad-hoc\n"); 
	fputs (tmpbuf, fp);
	
	sprintf (tmpbuf, "ESSID=%s\n", bss_info.ssid);
	fputs (tmpbuf, fp);
	
	sprintf (tmpbuf, "CHANNEL=%d\n", bss_info.channel);
	fputs (tmpbuf, fp);
	
	if (bss_info.state & cPrivacy)
		sprintf (tmpbuf, "WEP=Yes\n");
	else
		sprintf (tmpbuf, "WEP=No\n");
	fputs (tmpbuf, fp);
	
	sprintf (tmpbuf, "STATE=Connect\n");
	fputs (tmpbuf, fp);

	sprintf (tmpbuf, "BSSID=%2x:%2x:%2x:%2x:%2x:%2x\n", bss_info.bssid[0], bss_info.bssid[1], bss_info.bssid[2], bss_info.bssid[3], bss_info.bssid[4], bss_info.bssid[5]);
	
	for (j = 0; tmpbuf[j] != '\n'; j++)
	{
		if (tmpbuf[j] == '\x20')
			tmpbuf[j] = '\x30';
	}

	fputs (tmpbuf, fp);
	
	fclose(fp);
	close( skfd );

	return 0;
}

int get_wireless_sitesurvey_result(char *ifname, SS_STATUS_Tp pStatus )
{
	int skfd;
	struct iwreq iwr;

       /* Create a channel to the NET kernel. */
        if((skfd = iw_sockets_open()) < 0)
        {
                printf("open socket fail\n");
                return(-1);
        }
	strcpy (iwr.ifr_name, ifname);
	iwr.u.data.pointer = (caddr_t)pStatus;

	if ( pStatus->number == 0 )
		iwr.u.data.length = sizeof(SS_STATUS_T);
	else
	iwr.u.data.length = sizeof(pStatus->number);

	if (ioctl(skfd, SIOCGIWRTLGETBSSDB, &iwr) < 0)
	{
		printf ("sitesurvey fail!! \n");
		return -1;
	}	
    	
	close(skfd);
	return TRUE;
}

int main(int argc, char **argv)
{
	FILE	*fp;
        int goterr = 0, i;
	unsigned char tmpbuf[48], j;
	int wait_time;
	unsigned char res;
	BssDscr *pBss;
	struct _wlanstruct wlanstruct;

        if ( argc > 1 )
        {
                if ( !(strcmp (argv[1], CONFIGCMD)))
                {
			if ( get_wireless_bss_information("wlan0") < 0  )
			{
				printf ("Get wireless information fail!\n");
				return FALSE;
			}
			else
			{
				printf ("Get wireless information success!\n");
				return TRUE;
			}
				
                }

                else if( !(strcmp (argv[1], SITESURVEYCMD)))
                {
			if (pStatus==NULL)
			{
				pStatus = calloc(1, sizeof(SS_STATUS_T));
				if ( pStatus == NULL ) 
				{
					printf("Allocate buffer failed!\n");
					return FALSE;
				}
			}
			
			wait_time = 0;
			while (1)
			{
				if (get_wireless_sitesurvey_request("wlan0") == TRUE)
				{
					printf ("Sitesurvey request success!!\n");
					break;
				}
				else
				{
					if (wait_time++ > 5)
					{
						printf ("Sitesurvey request fail!!\n");
						return FALSE;
					}
				}
				sleep(1);
			}
			
			if ( (fp = fopen ("/tmp/sitesurvey_result.inc", "w")) == NULL)
			{
				printf ("Can't open file sitesurvey_result.inc\n");
				return FALSE;
			}

			wait_time = 0;
			while (1)
			{
				res = 1;
				if (  get_wireless_sitesurvey_result ("wlan0", (SS_STATUS_Tp)&res) < 0)
				{
					printf ("sitesurvey fail!! \n");
					free(pStatus);
					pStatus = NULL;
					return FALSE;
				}
				if (res == 0xff)
				{
					if (wait_time++ > 10)
					{
						printf ("Sitesurvey result fail!!\n");
						free(pStatus);
						pStatus = NULL;
						return FALSE;
					}
					sleep(1);
				}
				else
				{
					printf ("res = %d\n", res);
					break;
				}
			}
			
			if ( get_wireless_sitesurvey_result ("wlan0", pStatus) < 0 )
			{
				printf("Read site-survey status failed!\n");
				free(pStatus);
				pStatus = NULL;
				return FALSE;
			}

        		printf("number = %d\n", pStatus->number);

        		for (i=0; i<pStatus->number && pStatus->number!=0xff; i++)
			{
				memset (&wlanstruct, 0, sizeof (wlanstruct));

		                pBss = &pStatus->bssdb[i];
				if (pBss->bdCap & cIBSS)							//MODE
					memcpy (wlanstruct.mode, "Infrastructure", 14);
				else
					memcpy (wlanstruct.mode, "Ad-hoc", 6);
				
				memcpy(wlanstruct.ssid, pStatus->bssdb[i].bdSsIdBuf, pStatus->bssdb[i].bdSsId.Length); //SSID
				
				sprintf (tmpbuf, "%d", pBss->ChannelNumber);					//CHANNEL
				memcpy (wlanstruct.channel, tmpbuf, strlen(tmpbuf));
				
				if (pBss->bdCap & cPrivacy)
					memcpy (wlanstruct.encryption, "Yes", 3);
				else
					memcpy (wlanstruct.encryption, "No", 2);

				sprintf (tmpbuf, "%d", pBss->sq);
				memcpy (wlanstruct.state, tmpbuf, strlen (tmpbuf));
				
				sprintf (tmpbuf, "%2x:%2x:%2x:%2x:%2x:%2x", pBss->bdBssId[0], pBss->bdBssId[1], pBss->bdBssId[2], pBss->bdBssId[3], pBss->bdBssId[4], pBss->bdBssId[5]);
				tmpbuf[17] = '\x0';
				for (j = 0; j < strlen(tmpbuf); j++)
				{
					if (tmpbuf[j] == '\x20')
						tmpbuf[j] = '\x30';
				}
				memcpy (wlanstruct.bssid, tmpbuf, strlen(tmpbuf));
				
				fwrite (&wlanstruct, sizeof(wlanstruct), 1, fp);
				
				printf ("MODE = %s***", wlanstruct.mode);
				printf ("SSID = %s***", wlanstruct.ssid);
				printf ("Channel = %s***", wlanstruct.channel);
				printf ("WEP = %s***", wlanstruct.wep);
				printf ("Single = %s***", wlanstruct.state);
				printf ("BSSID=%s\n", wlanstruct.bssid);
			}
			fclose (fp);
		}

		else
			printf("wlan {config;sitesurvey;start;stop}\n");
			
	}
	else
		printf("wlan {config;sitesurvey;start;stop}\n");
        exit(0);
}
