/*****************************************************************************
;
;   (C) Unpublished Work of ADMtek Incorporated.  All Rights Reserved.
;
;       THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
;       PROPRIETARY AND TRADESECRET INFORMATION OF ADMTEK INCORPORATED.
;       ACCESS TO THIS WORK IS RESTRICTED TO (I) ADMTEK EMPLOYEES WHO HAVE A
;       NEED TO KNOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR ASSIGNMENTS
;       AND (II) ENTITIES OTHER THAN ADMTEK WHO HAVE ENTERED INTO APPROPRIATE
;       LICENSE AGREEMENTS.  NO PART OF THIS WORK MAY BE USED, PRACTICED,
;       PERFORMED, COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,
;       ABBRIDGED, CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST,
;       TRANSFORMED OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT OF ADMTEK.
;       ANY USE OR EXPLOITATION OF THIS WORK WITHOUT AUTHORIZATION COULD
;       SUBJECT THE PERPERTRATOR TO CRIMINAL AND CIVIL LIABILITY.
;
;------------------------------------------------------------------------------
;
;    Project : ADM5120
;    Creator : 
;    File    : include/asm/am5120/mx29lv320b.h
;    Date    : 2003.07.30
;    Abstract: 
;
;Modification History:
; 
;
;*****************************************************************************/


#ifndef  __MX29LV320B_H__
#define  __MX29LV320B_H__

#include <linux/mtd/mtd.h>
#include <linux/mtd/map.h>
#include <linux/mtd/partitions.h>
#include <asm/io.h>

#define FLASH_PHYS_ADDR 0xFFE00000
#define FLASH_SIZE 		0x200000  

#define FLASH_PARTITION1_ADDR 0x00000000
#define FLASH_PARTITION1_SIZE 0x00200000


__u8 mx29lv320b_read8(struct map_info *map, unsigned long ofs)
{
	return __raw_readb(map->map_priv_2 + ofs);
}

__u16 mx29lv320b_read16(struct map_info *map, unsigned long ofs)
{
	return __raw_readw(map->map_priv_2 + ofs);
}

__u32 mx29lv320b_read32(struct map_info *map, unsigned long ofs)
{
	return __raw_readl(map->map_priv_2 + ofs);
}

void mx29lv320b_copy_from(struct map_info *map, void *to, unsigned long from, ssize_t len)
{
	memcpy_fromio(to, (void *)(map->map_priv_2 + from), len);
}

void mx29lv320b_write8(struct map_info *map, __u8 d, unsigned long adr)
{
	//__raw_writeb((map->map_priv_2 + adr), d);
	((*(volatile unsigned char *)(map->map_priv_2 + adr)) = (d));
}

void mx29lv320b_write16(struct map_info *map, __u16 d, unsigned long adr)
{
	//__raw_writew(map->map_priv_2 + adr, d);
	((*(volatile unsigned short *)(map->map_priv_2 + adr)) = (d));
}

void mx29lv320b_write32(struct map_info *map, __u32 d, unsigned long adr)
{
	//__raw_writebl(map->map_priv_2 + adr, d);
	((*(volatile unsigned int *)(map->map_priv_2 + adr)) = (d));
}

void mx29lv320b_copy_to(struct map_info *map, unsigned long to, const void *from, ssize_t len)
{
	memcpy_toio((void *)(map->map_priv_2 + to), from, len);
}



struct map_info mx29lv320b_map = {
		.name =		"MX29LV320B flash device",
		.size =		FLASH_SIZE,
		.buswidth =	2,
		read8:		mx29lv320b_read8,
		read16:		mx29lv320b_read16,
		read32:		mx29lv320b_read32,
		copy_from:	mx29lv320b_copy_from,
		write8:		mx29lv320b_write8,
		write16:	mx29lv320b_write16,
		write32:	mx29lv320b_write32,
		copy_to:	mx29lv320b_copy_to
};

struct mtd_partition mx29lv320b_parts[] = {
	{
		.name =		"Flash Disk 1",
		.offset =	FLASH_PARTITION1_ADDR,
		.size =		FLASH_PARTITION1_SIZE
	}
};

#define PARTITION_COUNT (sizeof(mx29lv320b_parts)/sizeof(struct mtd_partition))

#endif /* __MX29LV320B_H__ */

