/*
 *  Copyright  2001 Flaga hf. Medical Devices, Kri Davsson <kd@flaga.is>
 *
 *  $Id: mx29lv320b.c,v 1.1.1.1 2005/03/09 04:59:26 rex Exp $
 *  
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <linux/module.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <asm/io.h>
#include <asm/mx29lv320b.h>


static struct mtd_info *mymtd;

int __init init_mx29lv320b(void)
{	
	printk(KERN_NOTICE "MX29LV320B flash device: %x at %x\n",
			FLASH_SIZE, FLASH_PHYS_ADDR);
	
	mx29lv320b_map.map_priv_1 = FLASH_PHYS_ADDR; //phy
	mx29lv320b_map.map_priv_2 = (unsigned long)ioremap_nocache(FLASH_PHYS_ADDR, //virt
					FLASH_SIZE);

	if (!mx29lv320b_map.map_priv_2) {
		printk("Failed to ioremap\n");
		return -EIO;
	}

	//simple_map_init(&mx29lv320b_map);

	mymtd = do_map_probe("cfi_probe", &mx29lv320b_map);
	if (mymtd) {
		//mymtd->owner = THIS_MODULE;
		add_mtd_partitions(mymtd, mx29lv320b_parts, PARTITION_COUNT);
		printk(KERN_NOTICE "MX29LV320B flash device initialized\n");
		return 0;
	}

	iounmap((void *)mx29lv320b_map.map_priv_2);
	mx29lv320b_map.map_priv_2 = 0;

	return -ENXIO;
}

static void __exit cleanup_mx29lv320b(void)
{
	if (mymtd) {
		del_mtd_partitions(mymtd);
		map_destroy(mymtd);
	}
	if (mx29lv320b_map.map_priv_2) {
		iounmap((void *)mx29lv320b_map.map_priv_2);
		mx29lv320b_map.map_priv_2 = 0;
	}
}

module_init(init_mx29lv320b);
module_exit(cleanup_mx29lv320b);


MODULE_LICENSE("GPL");
MODULE_AUTHOR("Jeanson Hung <jeansonh@admtek.com.tw>");
MODULE_DESCRIPTION("MTD map driver for MX29Lv320B");
