/* ------------------------------------------------------------------------- */
/* tftp.c                                                                    */
/*                                                                           */
/* A simple tftp client for busybox.                                         */
/* Tries to follow RFC1350.                                                  */
/* Only "octet" mode and 512-byte data blocks are supported.                 */
/*                                                                           */
/* Copyright (C) 2001 Magnus Damm <damm@opensource.se>                       */
/*                                                                           */
/* Parts of the code based on:                                               */
/*                                                                           */
/* atftp:  Copyright (C) 2000 Jean-Pierre Lefebvre <helix@step.polymtl.ca>   */
/*                        and Remi Lefebvre <remi@debian.org>                */
/*                                                                           */
/* utftp:  Copyright (C) 1999 Uwe Ohse <uwe@ohse.de>                         */
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */

/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU          */
/* General Public License for more details.                                  */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA   */
/*                                                                           */
/* ------------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <fcntl.h>

#include "busybox.h"

#include <sys/ioctl.h>

#include <linux/fs.h>
#include <linux/mtd/mtd.h>
//#define BB_FEATURE_TFTP_DEBUG

#define UPGRADE_ONLY

#ifdef UPGRADE_ONLY

#define	UP_DEBUG
#define	SIZE_PER_SEC		512
/* This signature is the MD5 of 'Edimax' (user md5sum) */
//#define	SIGNATURE		"c6524631c89cc4e28ef9d8a765a180df"

#define FLASHDEV "/dev/mtd"

#ifdef _ADM5120_
	#define START_ADDR	0x10000
	#define IMAGE_ADDR	0x20000
#elif defined (_RDC3210_)
	#define START_ADDR	0x8000
	#define IMAGE_ADDR	0x8000
#endif

#define TFTP_FILE "/etc/tftp_file"

// Lance 2003.08.06
int IsGW = 0;
//#define HEADER	((char *)"WEBP")
//#define HEADERGW  ((char *)"WBWB")
// End Lance 2003.08.06

#define HEADER_LEN	4
//J01 - start
//#define HAWKING		1				
//#define EDIMAX		1				
//#define GENERAL		1
//J01 - end
int	_flashfd;
int 	_tftpfd;				//J01
unsigned long 	filebuff=0xffffffff;

#endif

/* we don't need #ifdefs with these constants and optimization... */

//#ifdef BB_FEATURE_TFTP_GET
//#define BB_TFTP_GET (1 << 0)
//#else
//#define BB_TFTP_GET 0
//#endif

//#ifdef BB_FEATURE_TFTP_PUT
//#define BB_TFTP_PUT (1 << 1)
//#else
//#define BB_TFTP_PUT 0
//#endif

#define BB_TFTP_GET 1
#define BB_TFTP_PUT 0

#ifdef BB_FEATURE_TFTP_DEBUG
#define BB_TFTP_DEBUG 1
#else
#define BB_TFTP_DEBUG 0
#endif

#define BB_TFTP_NO_RETRIES 5
#define BB_TFTP_TIMEOUT    5	/* seconds */

#define	RRQ	1			/* read request */
#define	WRQ	2			/* write request */
#define	DATA	3		/* data packet */
#define	ACK	4			/* acknowledgement */
#define	ERROR	5		/* error code */

#define BUFSIZE (512+4)

static const char *tftp_error_msg[] = {
	"Undefined error",
	"File not found",
	"Access violation",
	"Disk full or allocation error",
	"Illegal TFTP operation",
	"Unknown transfer ID",
	"File already exists",
	"No such user"
};

static inline int tftp(int cmd, struct hostent *host,
					   char *serverfile, int localfd, int port)
{
	struct sockaddr_in sa;
	int socketfd;
	struct timeval tv;
	fd_set rfds;
	struct sockaddr_in from;
	socklen_t fromlen;
	char *cp;
	unsigned short tmp;
	int len, opcode, finished;
	int timeout, block_nr;
	unsigned long counter=0, offset=START_ADDR, image_addr=START_ADDR;
	
	unsigned char webHEADER[HEADER_LEN];	// Rex

#ifdef UPGRADE_ONLY
	int	need_erase;
#endif

	//RESERVE_BB_BUFFER(buf, BUFSIZE);

    char *buf=xmalloc(BUFSIZE + 4);
	
#ifdef UPGRADE_ONLY

	if((_flashfd = open(FLASHDEV, O_RDWR))<0)
	{
		printf("\ncan not open flash device ");
		exit(1);
	}
	lseek(_flashfd,START_ADDR,SEEK_SET);
	
	read(_flashfd, webHEADER, HEADER_LEN);	// Rex
#if 1
	printf("HEADER: %c%c%c%c\n", webHEADER[0], webHEADER[1], webHEADER[2], webHEADER[3]);
#endif
	
	lseek(_flashfd,START_ADDR,SEEK_SET);
							
	need_erase = 1;
	
#endif

	opcode = finished = timeout = 0;
	block_nr = 1;

	if ((socketfd = socket(PF_INET, SOCK_DGRAM, 0)) < 0) {
		printf("socket");
		return EXIT_FAILURE;
	}

	len = sizeof(sa);

	memset(&sa, 0, len);
	bind(socketfd, (struct sockaddr *)&sa, len);

	sa.sin_family = host->h_addrtype;
	sa.sin_port = htons(port);
	memcpy(&sa.sin_addr, (struct in_addr *) host->h_addr,
		   sizeof(sa.sin_addr));

	/* build opcode */

	if (cmd & BB_TFTP_GET) {
		opcode = RRQ;
	}

	if (cmd & BB_TFTP_PUT) {
		opcode = WRQ;
	}

	while (1) {


		/* build packet of type "opcode" */

		cp = buf;

		*((unsigned short *) cp) = htons(opcode);

		cp += 2;

		/* add filename and mode */

		if ((BB_TFTP_GET && (opcode == RRQ)) ||
			(BB_TFTP_PUT && (opcode == WRQ))) {

			while (cp != &buf[BUFSIZE - 1]) {
				if ((*cp = *serverfile++) == '\0')
					break;
				cp++;
			}

			if ((*cp != '\0') || (&buf[BUFSIZE - 1] - cp) < 7) {
				printf("too long server-filename");
				break;
			}

			memcpy(cp + 1, "octet", 6);
			cp += 7;
		}

		/* add ack and data */

		if ((BB_TFTP_GET && (opcode == ACK)) ||
			(BB_TFTP_PUT && (opcode == DATA))) {

			*((unsigned short *) cp) = htons(block_nr);

			cp += 2;

			block_nr++;

			if (BB_TFTP_PUT && (opcode == DATA)) {
				
				len = read(_flashfd, cp, BUFSIZE - 4);

				if (len < 0) {
					printf("read");
					break;
				}

				if (len != (BUFSIZE - 4)) {
					finished++;
				}

				cp += len;
				
			} else if (finished) {
				printf("\nfinished break");
				//break;   //Jason(2003/08/05)
			}
		}


		/* send packet */


		do {

			len = cp - buf;

			if (BB_TFTP_DEBUG) {
				printf("\nsending %u bytes", len);

				for (cp = buf; cp < &buf[len]; cp++)
					printf("%02x ", *cp);
			}				

			if (sendto(socketfd, buf, len, 0,
					   (struct sockaddr *) &sa, sizeof(sa)) < 0) {
				printf("send");
				len = -1;
				break;
			}


			if (finished) {
				printf("\nfinished break");
				break;
			}
			
			/* receive packet */
			
			memset(&from, 0, sizeof(from));
			fromlen = sizeof(from);

			tv.tv_sec = BB_TFTP_TIMEOUT;
			tv.tv_usec = 0;

			FD_ZERO(&rfds);
			FD_SET(socketfd, &rfds);

			switch (select(FD_SETSIZE, &rfds, NULL, NULL, &tv)) {
			case 1:
				len = recvfrom(socketfd, buf,
							   BUFSIZE, 0,
							   (struct sockaddr *) &from, &fromlen);

				if (len < 0) {
					printf("case 1 (len<0)");
					break;
				}

				timeout = 0;

				if (sa.sin_port == htons(port)) {
					sa.sin_port = from.sin_port;
					break;
				}

				if (sa.sin_port == from.sin_port) {
					break;
				}

				/* fall-through for bad packets! */
				/* discard the packet - treat as timeout */

			case 0:
				printf("\ntimeout ");
				if (!timeout) {
					timeout = BB_TFTP_NO_RETRIES;
				} 
				else {
					timeout--;
				}

				if (!timeout) {
					len = -1;
					printf("last timeout");
				}
				break;

			default:
				printf("select");
				len = -1;
			}

		} while (timeout && (len >= 0));

		if (len < 0) {
			printf("\nlen < 0");
			break;
		}

		//===> Break immediately after the last ack is send
		if (finished) {
			printf("\nfinished break");
			break;
		}//<<=== Jason(2003/08/05)
		
		/* process received packet */


		opcode = ntohs(*((unsigned short *) buf));
		tmp = ntohs(*((unsigned short *) &buf[2]));
	
		if (BB_TFTP_DEBUG) {
			printf("\nreceived %d bytes: %04x %04x", len, opcode, tmp);
		}

		if (BB_TFTP_GET && (opcode == DATA)) {

			if (tmp == block_nr) {
#ifdef UPGRADE_ONLY
				if (need_erase) {
//J01					
					if((_tftpfd = open(TFTP_FILE, O_RDONLY)) == -1)
					{
						if( memcmp(&buf[4], webHEADER, HEADER_LEN) )
						{
							printf("\nincorrect signature!\n");
							exit(1);
						}
						image_addr = IMAGE_ADDR;
					}
					else{
						close(_tftpfd);
						image_addr = START_ADDR;
					}
					system ("killall lpsched");
					system ("/etc/psrun.sh stop all");
					system ("killall telnetd");
					system ("killall atalkd");
					system ("killall snmpd");
					system ("killall monitor.sh");
					system ("killall udhcpc");
					system ("killall udhcpd");
					system ("killall webs");
					sleep(2);
					lseek(_flashfd, image_addr, SEEK_SET);		
					need_erase = 0;
				}
				counter++;
#if 1
				if (offset < image_addr){
					offset += (len - 4);
					len = len - 4;
				}
				else{
					len = write(_flashfd, &buf[4],len -4);
					offset += (len - 4);
				}
#else
				len =len - 4;
#endif
				if(counter == 512)
				{	
					ioctl(_flashfd,BLKFLSBUF,0);
					counter=0;
				}	
				printf(".");
#else
				len = write(localfd, &buf[4], len - 4);
#endif

				if (len < 0) {
					printf("\nwrite error");
					break;
				}

				if (len != (BUFSIZE - 4)) {
					printf("\nlen != BUFSIZE-4");
					finished++;
				}

				opcode = ACK;

				continue;
			}
		}

		if (BB_TFTP_PUT && (opcode == ACK)) {

			if (tmp == (block_nr - 1)) {
				if (finished) {
					break;
				}

				opcode = DATA;
				continue;
			}
		}

		if (opcode == ERROR) {
			char *msg = NULL;

			if (buf[4] != '\0') {
				msg = &buf[4];
				buf[BUFSIZE - 1] = '\0';
			} else if (tmp < (sizeof(tftp_error_msg) / sizeof(char *))) {
				msg = (char *) tftp_error_msg[tmp];
			}

			if (msg) {
				printf("server says: %s", msg);
			}

			break;
		}
	}

#ifdef UPGRADE_ONLY
	close(_flashfd);
{
	unsigned short checksum, checksum_org;
	unsigned long readLen = 0;
	unsigned char readBuf[1024];
	unsigned long i;
	
	if((_flashfd = open(FLASHDEV, O_RDWR))<0)
	{
		printf("\ncan not open flash device ");
		exit(1);
	}

#ifdef _ADM5120_	
	for(i=0; i < 0x40000; i+=0x10000)
	{
		lseek(_flashfd, START_ADDR + i, SEEK_SET);
		read(_flashfd, readBuf, 12);
		if(memcmp(readBuf, "CSYS", 4))
			continue;
		readLen = *((unsigned long *)&readBuf[8]);
		printf("\n\nFound CSYS image in %lx, Len = %lx\n", START_ADDR + i, readLen);
		break;
	}

	if ( i == 0x40000)
	{    
		close(_flashfd);
		printf("\n\nUpgrade Failed\n");
		return EXIT_FAILURE;
	}
#elif defined (_RDC3210_)
	lseek(_flashfd, START_ADDR, SEEK_SET);
	read(_flashfd, readBuf, 12);
	if(!memcmp(readBuf, webHEADER, HEADER_LEN)){
		readLen = *((unsigned long *)&readBuf[4]);
		printf("\n\nFound Linux kernel in %lx, Len = %lx\n", START_ADDR, readLen);
	}
	else{
		close(_flashfd);
		printf("\n\nUpgrade Failed\n");
		system("echo > /etc/tftp_fail");
		return EXIT_FAILURE;
	}
#endif	

	checksum = 0;

	for(i=0 ;i < (readLen); i += 2)
	{
		read(_flashfd, readBuf, 2);
		checksum += *(unsigned short*)readBuf;
	}
	
	checksum_org = *(unsigned short*)readBuf;
	
	printf("\n checksum_org = %x, checksum=%x\n", checksum_org, checksum);
	close(_flashfd);

	if(checksum != 0)
		return EXIT_FAILURE;
}	
#endif
	close(socketfd);
	return finished ? EXIT_SUCCESS : EXIT_FAILURE;
}

int tftp_main(int argc, char **argv)
{
	char *cp, *s;
	char *serverstr;
	struct hostent *host;
	char *serverfile;
	char *localfile;
	int cmd, flags, fd, bad;
#if 1	/* SJC */
	u_short	port=69;
#endif

	host = (void *) serverstr = serverfile = localfile = NULL;
	flags = cmd = 0;
	bad = 1;

#ifdef UPGRADE_ONLY
	if (argc > 3) {
			
		if( !strcmp(argv[1], "gw") )
		{
			IsGW = 1;
			printf("tftp get gw\n");
		}
		else
		{
			if( !strcmp(argv[1], "ap") )
			{
				IsGW = 0;
				printf("tftp get ap\n");
			}
//			else
//				show_usage();
		}
				
		if (BB_TFTP_GET && (strcmp(argv[2], "get") == 0)) {
			cmd = BB_TFTP_GET;
			flags = O_WRONLY | O_CREAT;
			serverstr = argv[3];
			localfile = NULL;
		}
		port = 69;
		if (argc > 4) {
			port = atoi(argv[4]);
			if (port == 0)
				port = 69;
		}
	}
#else
	if (argc > 3) {
		if (BB_TFTP_GET && (strcmp(argv[1], "get") == 0)) {
			cmd = BB_TFTP_GET;
			flags = O_WRONLY | O_CREAT;
			serverstr = argv[2];
			localfile = argv[3];
		}

		if (BB_TFTP_PUT && (strcmp(argv[1], "put") == 0)) {
			cmd = BB_TFTP_PUT;
			flags = O_RDONLY;
			localfile = argv[2];
			serverstr = argv[3];
		}

	}
#endif

	if (!(cmd & (BB_TFTP_GET | BB_TFTP_PUT))) {
;//		show_usage();
	}

	for (cp = serverstr; *cp != '\0'; cp++)
		if (*cp == ':')
			break;

	if (*cp == ':') {

		serverfile = cp + 1;

//		s = xstrdup(serverstr);
		s = strdup(serverstr);
		s[cp - serverstr] = '\0';

		host = xgethostbyname(s);

		free(s);
	}

	if (BB_TFTP_DEBUG) {
		printf("using server \"%s\", serverfile \"%s\","
			   "localfile \"%s\".\n",
			   inet_ntoa(*((struct in_addr *) host->h_addr)),
			   serverfile, localfile);
	}

#ifdef UPGRADE_ONLY
	fd = -1;
#else
	if ((fd = open(localfile, flags, 0644)) < 0) {
		perror_msg_and_die("local file");
	}
#endif

#if 1	/* SJC */
	flags = tftp(cmd, host, serverfile, fd, port);
#else
	flags = tftp(cmd, host, serverfile, fd, 69);
	close(fd);
#endif
	printf("\ntftp ok ! ");
//	system("reboot");	

	return flags;
}
