/*
 * Copyright (C) 1997-2002  Internet Software Consortium.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM
 * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * INTERNET SOFTWARE CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/* $Id: mem.c,v 1.1.1.1 2005/08/17 06:37:11 johnsoncheng Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>

#include <isc/mem.h>
#include <isc/util.h>

void *
isc_mem_get(isc_mem_t *ctx, size_t size) {
	UNUSED(ctx);
	if(size == 0)
		size = 1;
	return (malloc(size));
}

void
isc_mem_put(isc_mem_t *ctx, void *ptr, size_t size)
{
	UNUSED(ctx);
	UNUSED(size);
	free(ptr);
}

