Summary: A program for executing specified programs at set times.
Name: hc-cron
Version: 0.13
Release: 1
Copyright: GPL
Group: System Environment/Base
Source0: ftp://metalab.unc.edu/pub/Linux/system/daemons/hc-cron-0.13.tar.gz
Buildroot: /var/tmp/%{name}-root
Obsoletes: vixie-cron
Prereq: /sbin/chkconfig

%description
This is a cron daemon for ``home computers'' that don't run all the time.
Cron is a standard UNIX daemon that runs specified programs at scheduled
times. hc-cron is a drop-in replacement for vixie-cron that remembers when
it is shut down. On startup it checks whther any jobs have occurred during
downtime and catches these up.

%prep
%setup

%build
make CFLAGS="$RPM_OPT_FLAGS"

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr/{bin,man/man{1,5,8},sbin}
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/{init.d,rc{0,1,2,3,4,5,6}.d}
make install DESTDIR=$RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/var/spool/cron
chmod 700 $RPM_BUILD_ROOT/var/spool/cron
mkdir -p $RPM_BUILD_ROOT/etc/cron.d
chmod 755 $RPM_BUILD_ROOT/etc/cron.d
mkdir -p $RPM_BUILD_ROOT/etc/logrotate.d
install -m644 redhat/cron.log $RPM_BUILD_ROOT/etc/logrotate.d/cron
mkdir -p $RPM_BUILD_ROOT/var/lib
touch $RPM_BUILD_ROOT/var/lib/cron.lastrun

install -m755 redhat/hc-cron.init $RPM_BUILD_ROOT/etc/rc.d/init.d/crond
cd $RPM_BUILD_ROOT/etc/rc.d
ln -sf ../init.d/crond rc0.d/K60crond
ln -sf ../init.d/crond rc1.d/K60crond
ln -sf ../init.d/crond rc2.d/S40crond
ln -sf ../init.d/crond rc3.d/S40crond
ln -sf ../init.d/crond rc5.d/S40crond
ln -sf ../init.d/crond rc6.d/K60crond

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/chkconfig --add crond

%preun
if [ $1 = 0 ]; then
    /sbin/chkconfig --del crond
fi

%postun
if [ $1 = 0 ]; then 
    rm -fr /var/log/cron.*
fi

%files

%defattr(-,root,root)
/usr/sbin/crond
/usr/bin/crontab
/usr/man/man8/crond.8
/usr/man/man8/cron.8
/usr/man/man5/crontab.5
/usr/man/man1/crontab.1
/var/lib/cron.lastrun

%dir /var/spool/cron
%dir /etc/cron.d

%config(missingok) /etc/rc.d/rc0.d/K60crond
%config(missingok) /etc/rc.d/rc1.d/K60crond
%config(missingok) /etc/rc.d/rc2.d/S40crond
%config(missingok) /etc/rc.d/rc3.d/S40crond
%config(missingok) /etc/rc.d/rc5.d/S40crond
%config(missingok) /etc/rc.d/rc6.d/K60crond
%config /etc/rc.d/init.d/crond
%config /etc/logrotate.d/cron

%changelog
* Fri Sep 10 1999 Bill Nottingham <notting@redhat.com>
- chkconfig --del in %preun, not %postun
