/* Reimplementation of Daniel J. Bernsteins readclose library.
 * (C) 2001 Uwe Ohse, <uwe@ohse.de>.
 *   Report any bugs to <uwe@ohse.de>.
 * Placed in the public domain.
 */
/* @(#) $Id: readclose_app.c,v 1.1.1.1 2005/08/17 06:37:29 johnsoncheng Exp $ */
#include "readwrite.h"
#include "error.h"
#include "readclose.h"
#include "close.h"

int
readclose_append (int fd, stralloc * sa, unsigned int blocksize)
{
	int r;
	while (1) {
		if (!stralloc_readyplus (sa, blocksize)) {
			r=-1;
			break;
		}
		r = read (fd, sa->s + sa->len, blocksize);
		if (r == -1)
			if (errno == error_intr)
				continue;
		if (r <= 0)
			break;
		sa->len += r;
	}
	close (fd);
	return r;
}
