/* Reimplementation of Daniel J. Bernsteins readclose library.
 * (C) 2001 Uwe Ohse, <uwe@ohse.de>.
 *   Report any bugs to <uwe@ohse.de>.
 * Placed in the public domain.
 */
/* @(#) $Id: openreadclose.c,v 1.1.1.1 2005/08/17 06:37:29 johnsoncheng Exp $ */
#include "error.h"
#include "open.h"
#include "readclose.h"
#include "openreadclose.h"

int openreadclose(const char *fn,stralloc *sa,unsigned int blocksize)
{
  int fd;
  fd = open_read(fn);
  if (fd == -1) {
    if (errno == error_noent) return 0;
    return -1;
  }
  if (readclose(fd,sa,blocksize) == -1) return -1;
  return 1;
}
