/* Reimplementation of Daniel J. Bernsteins unix library.
 * (C) 2001 Uwe Ohse, <uwe@ohse.de>.
 *   Report any bugs to <uwe@ohse.de>.
 * Placed in the public domain.
 */
/* @(#) $Id: ndelay_on.c,v 1.1.1.1 2005/08/17 06:37:29 johnsoncheng Exp $ */
#include <sys/types.h>
#include <fcntl.h>
#include "ndelay.h"

/* love portability */
#ifndef O_NONBLOCK
#define O_NONBLOCK O_NDELAY
#endif

int
ndelay_on(int fd)
{
	int st;
	st=fcntl(fd,F_GETFL);
	if (st==-1)
		return -1;
	if (st & O_NONBLOCK)	
		return 0;
	return fcntl(fd,F_SETFL, st | O_NONBLOCK);
}
