/* @(#) $Id: api_utimes.c,v 1.1.1.1 2005/08/17 06:37:29 johnsoncheng Exp $ */
#include <time.h>
#include "api_utimes.h"
#include "have_utimes.h"
#ifdef HAVE_UTIMES
#include <sys/time.h>
int 
api_utimes(const char *fname,
	unsigned long at_sec, unsigned long at_usec,
	unsigned long mt_sec, unsigned long mt_usec
	)
{
	struct timeval tv[2];
	tv[0].tv_sec=at_sec;
	tv[0].tv_usec=at_usec;
	tv[1].tv_sec=mt_sec;
	tv[1].tv_usec=mt_usec;
	if (-1==utimes(fname,tv))
		return -1;
	return 0;
}
#else
#include <utime.h>
int 
api_utimes(const char *fname,
	unsigned long at_sec, unsigned long at_usec,
	unsigned long mt_sec, unsigned long mt_usec
	)
{
	struct utimbuf x;
	(void) at_usec;
	(void) mt_usec;
	x.actime=at_sec;
	x.modtime=mt_sec;
	if (-1==utime(fname, &x))
		return -1;
	return 0;
}
#endif
