#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "util.h"

void erase_char(char *origin, char erase)
{
	char *start, *ptr;

	if (strlen(origin)==0)
		return;
        start=ptr=origin;
	ptr=origin+strlen(origin);
	while (*start==erase || *start=='	' || *start==0x0d || *start==0x0a)
		start++;
	ptr--;
	while (*ptr==erase || *ptr=='	' || *ptr==0x0d || *ptr==0x0a)
		ptr--;
	*(ptr+1)=0x0;
	ptr=origin;
	while (*start)
		*ptr++=*start++;
	*ptr=0x0;
}

int read_status(char *filename)
{
	FILE *fptr;
	char str[80];
	int ret;

	if ((fptr=fopen(filename, "r"))==NULL)
		return 0;
	fgets(str, 80, fptr);
	ret=atoi(str);
	fclose(fptr);
	return ret;
}

void write_status(char *file, int percent)
{
        FILE *fptr;

        fptr=fopen(file, "w");
        fprintf(fptr, "%d", percent);
        fclose(fptr);
}

int read_tag_from_conf(char *filename, char *tag, char *value)
{
	FILE *fptr;
	char str[255], *name, *tmpvalue;
	int err;

        if ((fptr=fopen(filename, "r"))==NULL)
        {
		err=CONF_NOT_EXIST;
                return err;
        }
        else
        {
                while (1)
                {
                        fgets(str, 255, fptr);
                        if (feof(fptr))
			{
				err=FLAG_NOT_FOUND;
                                break;
			}
                        name=strtok(str, "=");
			erase_char(name, ' ');
                        if (!strcmp(name, tag))
                        {
                                tmpvalue=strtok(NULL,"\t\n");
				erase_char(tmpvalue, ' ');
				err=SUCCESS;
				break;
                        }
		}
		fclose(fptr);
	}
	if (err==SUCCESS)
		strcpy(value, tmpvalue);
	else
		strcpy(value, "");
	return err;
}

void load_html_lang(char *file, int counter, char *lang)
{
        unsigned char line[1024];
        FILE *fptr;

        fptr = fopen(LOAD_HTML, "r");
        while (fgets(line, 1024, fptr) != NULL)
        {
		if (strstr(line, "window.location"))
//                if (strstr(line, "location.href"))
                {
			sprintf(line, "window.location.replace(\"%s&lang=%s&count=%d\")", file, lang, counter);
/*			strcpy(line, "location.href='");
                        strcat(line, file);
			strcat(line, "&lang='+mainkey+'");
			sprintf(line, "%s&count=%d';", line, counter);*/
                        printf("%s", line);
                }
                else
                        printf("%s", line);
        }
        fclose(fptr);
}

void load_html_lang_v3(char *file, int counter, char *lang)
{
        unsigned char line[1024];
        FILE *fptr;

        fptr = fopen(LOAD_HTML, "r");
        while (fgets(line, 1024, fptr) != NULL)
        {
		if (strstr(line, "window.location"))
//                if (strstr(line, "location.href"))
                {
			sprintf(line, "window.location.replace(\"%s&lang=%s&count=%d&ComboBox=ON\")", file, lang, counter);
/*			strcpy(line, "location.href='");
                        strcat(line, file);
			strcat(line, "&lang='+mainkey+'");
			sprintf(line, "%s&count=%d';", line, counter);*/
                        printf("%s", line);
                }
                else
                        printf("%s", line);
        }
        fclose(fptr);
}

void load_html(char *file)
{
        unsigned char line[1000];
        FILE *fptr;

        fptr = fopen(LOAD_HTML, "r");
        while (fgets(line, 1000, fptr) != NULL)
        {
                if (strstr(line, "window.location"))
                {
			sprintf(line, "window.location.replace(\"%s\")", file);
/*                        strcpy(line, "location.href=\"");
                        strcat(line, file);
                        strcat(line, "\"");*/
                        printf("%s", line);
                }
                else
                        printf("%s", line);
        }
        fclose(fptr);
}

char *strfind(char *origin, char *pattern)
{
	char *ptr, *val;
	int len_origin, len_pattern, i, find;

	len_pattern=strlen(pattern);
	len_origin=strlen(origin);
	if (len_origin<len_pattern)
		return NULL;
	ptr=origin;
	while (len_origin>len_pattern)
	{
		find=1;
		for (i=0;i<len_pattern;i++)
		{
			if (ptr[i]!=pattern[i])
			{
				find=0;
				break;
			}
		}
		if (find==1)
			break;
		len_origin--;
		ptr++;
	}
	if (find==1)
	{
		val=ptr+len_pattern;
		ptr+=len_pattern;
		while (len_origin>len_pattern)
		{
			find=1;
			for (i=0;i<len_pattern;i++)
			{
				if (ptr[i]!=pattern[i])
				{
					find=0;
					break;
				}
			}
			if (find==1)
			{
				*ptr=0x0;
				return val;
			}
			ptr++;
			len_origin--;
		}
	}
	return NULL;
}

