#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "cgi_util.h"
#include "Util.h"

static char* hex[256] = {
    "%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07",
    "%08", "%09", "%0a", "%0b", "%0c", "%0d", "%0e", "%0f",
    "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17",
    "%18", "%19", "%1a", "%1b", "%1c", "%1d", "%1e", "%1f",
    "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27",
    "%28", "%29", "%2a", "%2b", "%2c", "%2d", "%2e", "%2f",
    "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37",
    "%38", "%39", "%3a", "%3b", "%3c", "%3d", "%3e", "%3f",
    "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47",
    "%48", "%49", "%4a", "%4b", "%4c", "%4d", "%4e", "%4f",
    "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57",
    "%58", "%59", "%5a", "%5b", "%5c", "%5d", "%5e", "%5f",
    "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67",
    "%68", "%69", "%6a", "%6b", "%6c", "%6d", "%6e", "%6f",
    "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77",
    "%78", "%79", "%7a", "%7b", "%7c", "%7d", "%7e", "%7f",
    "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87",
    "%88", "%89", "%8a", "%8b", "%8c", "%8d", "%8e", "%8f",
    "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97",
    "%98", "%99", "%9a", "%9b", "%9c", "%9d", "%9e", "%9f",
    "%a0", "%a1", "%a2", "%a3", "%a4", "%a5", "%a6", "%a7",
    "%a8", "%a9", "%aa", "%ab", "%ac", "%ad", "%ae", "%af",
    "%b0", "%b1", "%b2", "%b3", "%b4", "%b5", "%b6", "%b7",
    "%b8", "%b9", "%ba", "%bb", "%bc", "%bd", "%be", "%bf",
    "%c0", "%c1", "%c2", "%c3", "%c4", "%c5", "%c6", "%c7",
    "%c8", "%c9", "%ca", "%cb", "%cc", "%cd", "%ce", "%cf",
    "%d0", "%d1", "%d2", "%d3", "%d4", "%d5", "%d6", "%d7",
    "%d8", "%d9", "%da", "%db", "%dc", "%dd", "%de", "%df",
    "%e0", "%e1", "%e2", "%e3", "%e4", "%e5", "%e6", "%e7",
    "%e8", "%e9", "%ea", "%eb", "%ec", "%ed", "%ee", "%ef",
    "%f0", "%f1", "%f2", "%f3", "%f4", "%f5", "%f6", "%f7",
    "%f8", "%f9", "%fa", "%fb", "%fc", "%fd", "%fe", "%ff"
};

char* UTF8_to_URLencode(char* s)
{/* Shone marked the judgement 'cause TS-101 uses UTF-8 as system lananguage and code page number no more refer to that. 2005,09,23
	if(Get_System_Codepage() == 999)
	{*/
		char sbuf[1024] = {0};
		int len = strlen(s);
		int num = 0;
		int i;
 		unsigned int ch;
 		
		for (i = 0; i < len; i++) {
			ch = s[i];
			ch &= 0xffff;
			if (ch <= 0x007f) {		// other ASCII
				sbuf[num++] = (char)ch;
			}
			else
			{
				strcat(sbuf, hex[ch & 0xff]);
				num += 3;
			}
		}
		return sbuf;
/*	}
	else
		return s;*/
}
	


char *ReadStdin(FILE *f, char stop, int *len)
{
	int wsize;
	char *word;
	int x;

	wsize = 128;
	x = 0;
	word = (char *) malloc(sizeof(char)*(wsize+1));
	if (word==NULL)
		return NULL;
	while (1)
	{
		word[x] = (char)fgetc(f);
		if (x==wsize)
		{
			word[x+1] = '\0';
			wsize+=128;
			word = (char *) realloc(word, sizeof(char)*(wsize+1));
		}
		--(*len);
		if ((word[x]==stop) || (feof(f)) || (!(*len)))
		{
			if (word[x]!=stop)
				x++;
			word[x] ='\0';
			return word;
		}
		++x;
	}
}

char *ReadData(char *line, char stop)
{
	int i=0, j;
	char *word = (char *) malloc(sizeof(char)*(strlen(line)+5));

	if (word==NULL)
		return NULL;
	for (i =0;((line[i]) && (line[i]!=stop));i++)
		word[i]=line[i];
	word[i]='\0';
	if (line[i])
		++i;
	j=0;
//	while (line[j++]=line[i++]);
	while (line[j])
		line[j++]=line[i++];
	return word;
}

char trans_http_char(char *pattern)
{
	char ret;
	long asciicode;

	asciicode=strtol(pattern, NULL, 16);
	ret=(char)asciicode;
//	if (	(ret>=' ' && ret<='/') || ((int)ret>=':' && (int)ret<='@') || ret<0 ||
//		(ret>='[' && ret<='`') || (ret>='{' && ret<='~'))
//Modify by Ken Chen 20050924
	if (	(ret>=' ' && ret<='/') || ((int)ret>=':' && (int)ret<='@') || ret>=128 ||
		(ret>='[' && ret<='`') || (ret>='{' && ret<='~'))
		return ret;
	else
		return 0x0;
}

void trans_http_special_str(char *new, char *origin)
{
	char *ptr, *start;

	ptr=origin;
	start=new;
	while (*ptr!=0)
	{
		if (*ptr=='#')
		{
			*start++='%';
			*start++='2';
			*start++='3';
			ptr++;
		}
		else
		if (*ptr=='&')
		{
			*start++='%';
			*start++='2';
			*start++='6';
			ptr++;
		}
		else
			*start++=*ptr++;
	}
	*start=0x0;
}

void trans_to_DBC_str(char *new, char *origin)
{
	char *ptr, *start, tmp[10];
	int len;

	ptr=origin;
	start=new;
	while (*ptr!=0)
	{
		if (Is_Mb_Word(ptr))
//		if ((unsigned char)*ptr>=0xA1 && (unsigned char)*(ptr-1)<=0xFE)		/* chinese first byte	*/
		{
			/* first byte	*/
			*start++='%';
			sprintf(tmp, "%X", *ptr++);
			len=strlen(tmp);
			*start++=tmp[len-2];
			*start++=tmp[len-1];

			/* second byte	*/
			if (*ptr & 0x80 || *ptr=='\\')
			{
				*start++='%';
				sprintf(tmp, "%X", *ptr++);
				len=strlen(tmp);
				*start++=tmp[len-2];
				*start++=tmp[len-1];
			}
			else
			{
				*start++=*ptr++;
			}
		}
		else
		if (*ptr=='#')
		{
			*start++='%';
			*start++='2';
			*start++='3';
			ptr++;
		}
		else
		if (*ptr=='&')
		{
			*start++='%';
			*start++='2';
			*start++='6';
			ptr++;
		}
		else
			*start++=*ptr++;
	}
	*start=0x0;
}

void trans_to_netscape_str(char *new, char *origin)
{
	char *ptr, *start;

	ptr=origin;
	start=new;
	while (*ptr!=0x0)
	{
		if (*ptr==' ')
		{
			*start++='%';
			*start++='2';
			*start++='0';
		}

		else
		if (*ptr=='#')
		{
			*start++='%';
			*start++='2';
			*start++='3';
		}
		else
		if (*ptr=='&')
		{
			*start++='%';
			*start++='2';
			*start++='6';
		}

		else
		if (*ptr=='%')
		{
			*start++='%';
			*start++='2';
			*start++='5';
		}
		else
		if (*ptr=='\'')
		{
			*start++='%';
			*start++='2';
			*start++='7';
		}
		else
			*start++=*ptr;
		ptr++;
	}
	*start=0x0;
}

void trans_http_str(char *new, char *origin, int bform)
{
	char *ptr, *start;
	char pattern[3];

	ptr=origin;
	start=new;
	while (*ptr!=0x0)
	{
		if (*ptr=='%')
		{
			pattern[0]=ptr[1];
			pattern[1]=ptr[2];
			pattern[2]=0x0;
			*start=trans_http_char(pattern);
			if (*start==0x0)
			{
				*start++='%';
				ptr++;
			}
			else
			{
				start++;
				ptr+=3;
			}
		}
		else
		if (*ptr=='+')
		{
			if (bform)
			{
				ptr++;
				*start++=' ';
			}
			else
				*start++=*ptr++;
		}
		else
		{
			*start++=*ptr++;
		}
	}
	*start=0x0;
}

void free_input(int num, input *form)
{
	int i;
	input *head, *tail;

	tail=form;
	if (tail->next==NULL)
		return;
	tail=(input *)tail->next;
	for (i=0;i<num;i++)
	{
		if (tail->val!=NULL)
			free(tail->val);
		if (tail->name!=NULL)
			free(tail->name);
		head=tail;
		if (tail->next==NULL)
		{
			free(tail);
			break;
		}
		tail=(input *)tail->next;
		if (head!=NULL)
			free(head);
	}
}

int parser_input_form(input *form)
{
	char *ptr;
	int len, i, num=0;
	input *ptrinput;

	if ((ptr=getenv("CONTENT_LENGTH"))==NULL)
	{
//                printf("No input data !!\n<br>");
		return 0;
	}
	len=atoi(ptr);

	num=0;
	ptrinput=form;
	for (i=0;len && !feof(stdin);i++)          // Read data from stdin
	{
		if ((ptrinput->next=calloc(1, sizeof(input)))==NULL)
		{
			free_input(i-1, form);
			return -1;
		}
		ptrinput=(input *)ptrinput->next;
		if ((ptrinput->val = ReadStdin(stdin, '&', &len))==NULL)
		{
			free_input(i, form);
			return -1;
		}
		 if ((ptrinput->name = ReadData(ptrinput->val,'='))==NULL)
		{
			free_input(i, form);
			return -1;
		}
		trans_http_str(ptrinput->val, ptrinput->val, 1);
		trans_http_str(ptrinput->name, ptrinput->name, 1);
		num++;
	}
	return num;
}

//============================================================
//      this function is parser the parameter of cgi
//      the separate char is "&"
//      ex: xxx.cgi?name1=value1&name2=value2&name3=value3
//      result: arg[0].name=name1, arg[0].val=value1
//              arg[1].name=name2, arg[1].val=value2
//              arg[2].name=name3, arg[2].val=value3
//============================================================
int parser_input_URL(input *arg)
{
	int i=0;
	unsigned char *item, *token, *ptr;
	unsigned char tokensep[]="&";

	ptr=(unsigned char *)getenv("QUERY_STRING");

	if (ptr==NULL)
		return 0;
	item=NULL;
	token=strtok(ptr, tokensep);
	i=0;
	while (token!=NULL)
	{
		arg[i].name=token;
		token=strstr(token,"=");
		if (token==NULL)
			return 0;
		*token=0x0;
		token++;
		arg[i].val=token;
		trans_http_str(arg[i].val, arg[i].val, 0);
		token=strtok(NULL, tokensep);
		i++;
	}

/*	if (i==1)
		return 0;*/
	return i;
}

//add by Ken Chen 20050924
char* URLdecode_to_UTF8(char* s)
{
	char sbuf[2048] = {0};
	int l  = strlen(s);
	int ch = -1 ;
	int i, b, sumb = 0, num = 0, more;
	for (i = 0, more = -1 ; i < l ; i++) {
	/* Get next byte b from URL segment s */
		int hb, lb;
		switch (ch = s[i]) {   	
			case '%':
				ch = s[++i];
				hb = (isdigit ((char) ch) ? ch - '0' : 10+tolower((char) ch) - 'a') & 0xF ;
				ch = s[++i];
				lb = (isdigit ((char) ch) ? ch - '0' : 10+tolower((char) ch) - 'a') & 0xF ;
				b = (hb << 4) | lb ;
				break ;
			case '+':
				b = ' ' ;
				break ;
			default:
				b = ch ;
		}
		sbuf[num++] = (char)b;

#if 0		
		/* Decode byte b as UTF-8, sumb collects incomplete chars */
		if ((b & 0xc0) == 0x80) {			// 10xxxxxx (continuation byte)
			sumb = (sumb << 6) | (b & 0x3f) ;	// Add 6 bits to sumb
			if (--more == 0)  
			{
				//sbuf[num++] = (char)sumb; //sbuf.append((char) sumb) ; // Add char to sbuf
				sbuf[num++] = (char)(sumb & 0xFF);
				sbuf[num++] = (char)((sumb & 0xFF00) >> 8);
			}
		} else if ((b & 0x80) == 0x00) {		// 0xxxxxxx (yields 7 bits)
			//sbuf.append((char) b) ;			// Store in sbuf
			sbuf[num++] = (char)b;
		} else if ((b & 0xe0) == 0xc0) {		// 110xxxxx (yields 5 bits)
			sumb = b & 0x1f;
			more = 1;				// Expect 1 more byte
		} else if ((b & 0xf0) == 0xe0) {		// 1110xxxx (yields 4 bits)
			sumb = b & 0x0f;
			more = 2;				// Expect 2 more bytes
		} else if ((b & 0xf8) == 0xf0) {		// 11110xxx (yields 3 bits)
			sumb = b & 0x07;
			more = 3;				// Expect 3 more bytes
		} else if ((b & 0xfc) == 0xf8) {		// 111110xx (yields 2 bits)
			sumb = b & 0x03;
			more = 4;				// Expect 4 more bytes
		} else /*if ((b & 0xfe) == 0xfc)*/ {	// 1111110x (yields 1 bit)
			sumb = b & 0x01;
			more = 5;				// Expect 5 more bytes
		}
#endif
		/* No need to test if the UTF-8 encoding is well-formed */
	}
	return strdup(sbuf);
}
//end here
