#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include "config.h"
/* NAS include file */
#include <cgi.h>
#include <v2_menu.h>
#include <cfg_nic.h>
/* local include */
#include "uLinux.h"
#include "sata.h"
#include "server.h"
#include "server01.h"
#include "server04.h"
#include "codepage.h"

extern char Parameter[MAX_PARAMETER_NUMBER][BUF_SIZE];

//common.c
extern int GetProfileString(char *, char *, char *, char *, int);

int server04_replace(FILE *fptr, char *name, void *arg)
{
        if (strncasecmp(name, "PARAMETER_", strlen("PARAMETER_")) == 0) {
		int i = atoi(&(name[strlen("PARAMETER_")]));
                if (i > 0 && i < MAX_PARAMETER_NUMBER) {
                        fprintf(fptr, "%s", Parameter[i - 1]);
                }
	}
	else
		return CGI_REPLACE_FAIL;
        return CGI_REPLACE_OK;
}

void view_server_settings()
{
	char buf[BUF_SIZE], test[BUF_SIZE];
	int i=0, cp=0, ampm=0;
	int day, year, hour, minute, second, month;
	char build[64] = "";

	for (i = 0; i < 8; i++)
		strcpy(Parameter[i], "");
	Get_Server_Name(Parameter[0], sizeof(Parameter[0]));
	Get_Workgroup_Name(Parameter[1], sizeof(Parameter[1]));
	Get_Server_Comment(Parameter[2], sizeof(Parameter[2]));
	Get_Current_Date_Time(buf);
	memcpy(test, &(buf[0]), 2);
	test[2] = '\0';
	month = atoi(test);
	//sprintf(test, "IDS_STRING%d", month);
	memcpy(test, &(buf[2]), 2);
	test[2] = '\0';
	day = atoi(test);
	memcpy(test, &(buf[4]), 4);
	test[4] = '\0';
	year = atoi(test);
	sprintf(Parameter[3], "<SCRIPT Language=\"JavaScript\">document.write(IEI_IDS_STRING%d + \'  %d\'+ IEI_NAS_SERVER5_DATE+ \', %d\')</SCRIPT>\n", month, day, year);
	//sprintf(Parameter[3], "%s %d, %d", p, day, year);
	//free(p);
	memcpy(test, &(buf[8]), 2);
	test[2] = '\0';
	hour = atoi(test);
	if (hour >= 12) {
		ampm = 14;
		if (hour > 12)
			hour -= 12;
	}
	else {
		ampm = 13;
		if (hour == 0)
			hour = 12;
	}
	memcpy(test, &(buf[10]), 2);
 	test[2] = '\0';
	minute = atoi(test);
	memcpy(test, &(buf[12]), 2);
	test[2] = '\0';
	second = atoi(test);
	sprintf(Parameter[4], "<SCRIPT Language=\"JavaScript\">document.write(\'%d:%d:%d \' + IEI_NAS_SERVER5_DOT + IEI_IDS_STRING%d)</SCRIPT>\n", hour, minute, second, ampm);
	//sprintf(Parameter[4], "%d:%d:%d %s", hour, minute, second, p);
	//free(p);
	Get_System_Time_Zone(Parameter[5], sizeof(Parameter[5]));
	cp = Get_System_Codepage();
	for (i = 0; i < MAX_CODEPAGE_NO; i++) {
		if (cp == atoi(codepage_value[i])) {
			sprintf(Parameter[6], "<SCRIPT Language=\"JavaScript\">document.write(IEI_IDS_STRING%d + ' (%d)')</SCRIPT>\n", cp, cp);
			break;
		}
	}
	Get_System_Version(Parameter[7], sizeof(Parameter[7]));
	GetProfileString("System", "Build Number", "", build, sizeof(build));
	if (strlen(build) > 0) {
		strcat(Parameter[7], " Build ");
		strcat(Parameter[7], build);
	}

	for (i = 0; i < 8; i++) {
		if (strlen(Parameter[i]) == 0)
			strcpy(Parameter[i], "N/A");
	}

}


int show_server04_header(int server_select)
{
        HEADER_ITEM     header;
	//static char* 	server_defs[]={SERVER_DEFS};
	
        CGI_Output_Html1(SERVER_HEADER_HTML, "$", server04_replace, NULL);
        header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;
        CGI_Get_Help(header.help, "help_server.html#help_serverview");

        CGI_Show_Menu_V3_1(FUNC_SYSTEM, &header);
        CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", server04_replace, NULL);
        CGI_Show_Menu_V3_2(SERVER_DEF, server_select);
        CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", server04_replace, NULL);
        return 1;
}

int show_server04_tail()
{
        CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", server04_replace, NULL);
        CGI_Output_Html1(SERVER_TAIL_HTML, "$", server04_replace, NULL);
        return 1;
}

int do_server04_main(INPUT *input, int server_select)
{
	show_server04_header(server_select);
	/* put your code here */
	view_server_settings();
	if(!strncmp(SATA_Get_Model_Name(),"NAS-410T",8))
		CGI_Output_Html1(SERVER04_MAIN_HTML_410T, "$", server04_replace, NULL);
	else
		CGI_Output_Html1(SERVER04_MAIN_HTML, "$", server04_replace, NULL);
	show_server04_tail();
	return SERVER_SUCCESS;
}

int do_server04_main_submit(INPUT *input, int server_select)
{
	int	btn;
	int	ret=SERVER_SUCCESS;

	btn=get_btn(input);
	switch (btn)
	{
		case SERVER_BTN_CONTINUE:
			do_server01_main(input, server_select);
			break;

	}
	return ret;
}
