#include <stdio.h>
#include <v2_menu.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <stdarg.h>
#include "cgi.h"
#include "uLinux.h"
#include "config.h"
#include "quick.h"
#include "quick02.h"
#include "quick03.h"
//#include "quick04.h"
#include "quick03_1.h"
#include "timezone.h"
#include "cfg_ntp.h"

char Parameter[MAX_PARAMETER_NUMBER][BUF_SIZE];
extern char *timezone_Windows[];

char Selected_Timezone[BUF_SIZE] = "";
int test_status = 0;

int quick03_replace(FILE *fptr, char *name, void *arg)
{
	char On_Load[128] = "";
	int ret = ERROR_FAIL;
        INPUT *input = (INPUT *)arg;

	if(!strcasecmp(name, "ON_LOAD")) 
	{
		fprintf(fptr, "%s", On_Load);
        }
        else if (!strncasecmp(name, "PARAMETER_", strlen("PARAMETER_"))) 
	{
                int i = atoi(&(name[strlen("PARAMETER_")]));

                if (i > 0 && i < MAX_PARAMETER_NUMBER) {
                        fprintf(fptr, "%s", Parameter[i - 1]);
                }
        }
        else if (!strcasecmp(name, "TIMEZONE_LIST")) 
	{
		int i;
                for (i = 0; i < (WINDOWS_TIMEZONE_MAX-1); i++) {
                        if (!strcmp(timezone_Windows[i], Selected_Timezone))
                                fprintf(fptr, "<OPTION VALUE=\"%d\" SELECTED>%s</OPTION>\n", i, timezone_Windows[i]);
                        else
                                fprintf(fptr, "<OPTION VALUE=\"%d\">%s</OPTION>\n", i, timezone_Windows[i]);
                }
        }
	else if(!strcmp(name, "TEST_STATUS")) 
	{
		switch(test_status) 
		{
			case -1:
				fprintf(fptr, "%s", "QUICK03_STR17");
				break;
			case 0:
				fprintf(fptr, "%s", "QUICK03_STR15");
				break;
			case 1:
				fprintf(fptr, "%s", "QUICK03_STR16");
				break;
			default:
				fprintf(fptr, "%s", "QUICK03_STR15");
		}
	}
        else if (!strcasecmp(name, "ntp_checked")) 
	{
		if(CGI_Find_Parameter(input, "TEST_BTN") != NULL)
			fprintf(fptr, "%s", "checked");
		else if(NTP_Is_Server_Used())
			fprintf(fptr, "%s", "checked");
	}
	else if(!strcmp(name, "ntp_server_addr")) 
	{
		char ip_address[IP_ADDRESS_LENGTH];
		INPUT *tmp = NULL;

		if(CGI_Find_Parameter(input, "TEST_BTN") != NULL) 
		{
			if((tmp=CGI_Find_Parameter(input, "SPECIFIC_SERVER")) != NULL) 
				fprintf(fptr, "%s", tmp->val);
		}
		else 
		{
			ret = NTP_Get_Server_IP(ip_address, sizeof(ip_address));
			if(ret == SUCCESS) 
				fprintf(fptr, "%s", ip_address);
		}
	}	
        else if (!strcasecmp(name, "ntp_sync_interval")) 
	{
		int interval = 0;
		INPUT *tmp = NULL;
		char str_interval[3] = "\"\"";
			 
		if(CGI_Find_Parameter(input, "TEST_BTN") != NULL) 
		{
			if((tmp=CGI_Find_Parameter(input, "INTERVAL")) != NULL) 
			{
				if(!strcmp(tmp->val, "")) 
					fprintf(fptr, "%s", str_interval);
				else 
					fprintf(fptr, "%s", tmp->val);
			}
		}
		else 
		{
			if(NTP_Get_Interval(&interval))
				sprintf(str_interval, "%d", interval);
			fprintf(fptr, "%s", str_interval);
		}
	}
	else if(!strcmp(name, "MIN_SELECT")||!strcmp(name, "HOUR_SELECT")||!strcmp(name, "DAY_SELECT")) 
	{
		char time_unit[10] = "";
		INPUT *tmp = NULL;
			 
		if(CGI_Find_Parameter(input, "TEST_BTN") != NULL) 
		{
			if((tmp=CGI_Find_Parameter(input, "INTERVAL_TYPE")) != NULL) 
			{
				if(0 == atoi(tmp->val)&&!strcmp(name, "MIN_SELECT")) 
					fprintf(fptr, "%s", "Selected");
				else if(1 == atoi(tmp->val)&&!strcmp(name, "HOUR_SELECT")) 
					fprintf(fptr, "%s", "Selected");
				else if(2 == atoi(tmp->val)&&!strcmp(name, "DAY_SELECT")) 
					fprintf(fptr, "%s", "Selected");
			}
		}
		else 
		{
			if(NTP_Get_Interval_Unit(time_unit, sizeof(time_unit))) 
			{
				if(!strcasecmp(time_unit, "MINUTE")&&!strcmp(name, "MIN_SELECT")) 
					fprintf(fptr, "%s", "Selected");
				else if(!strcasecmp(time_unit, "HOUR")&&!strcmp(name, "HOUR_SELECT")) 
					fprintf(fptr, "%s", "Selected");
				else if(!strcasecmp(time_unit, "DAY")&&!strcmp(name, "DAY_SELECT")) 
					fprintf(fptr, "%s", "Selected");
			}
		}
	}
	else
		return CGI_REPLACE_FAIL;
        return CGI_REPLACE_OK;
}




int show_quick03_header(int quick_select)
{
        HEADER_ITEM     header;
	static char*    quick_defs[]={QUICK_DEFS};

        CGI_Output_Html1(QUICK03_MAIN_HEADER, "$", quick03_replace, NULL);
        header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;
	if(Is_Version_22())
	        CGI_Get_Help(header.help, "help_quick.html#help_qconfig_step3");
	else
		CGI_Get_Help(header.help, "help_qconfig_step3.html");
        CGI_Show_Menu_V3_1(FUNC_QUICK, &header);
        CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", quick03_replace, NULL);
        CGI_Show_Menu_V3_2(quick_defs[get_quick_def()], quick_select);
        CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", quick03_replace, NULL);

        return 1;
}



int show_quick03_tail()
{
        CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", quick03_replace, NULL);
        CGI_Output_Html1(QUICK_TAIL_HTML, "$", quick03_replace, NULL);
        return 1;
}



void show_server_time()
{
	char date_time[BUF_SIZE];
	int year, day;
	int hour, minute, second;
	int Selected_AMPM = 0;
	int Selected_Month = 0;


	Get_Current_Date_Time(date_time);
	memcpy(Parameter[0], &(date_time[2]), 2);
	Parameter[0][2] = '\0';
	day = atoi(Parameter[0]);
	sprintf(Parameter[0], "%d", day);
	memcpy(Parameter[1], &(date_time[4]), 4);
	Parameter[1][4] = '\0';
	year = atoi(Parameter[1]);
	sprintf(Parameter[1], "%d", year);
	memcpy(Parameter[2], &(date_time[8]), 2);
	Parameter[2][2] = '\0';
	hour = atoi(Parameter[2]);
	if (hour >= 12) {
		Selected_AMPM = 1;
		if (hour > 12) hour -= 12;
	}
	else {
		Selected_AMPM = 0;
		if (hour == 0) hour = 12;
	}
	sprintf(Parameter[2], "%d", hour);
	memcpy(Parameter[3], &(date_time[10]), 2);
	Parameter[3][2] = '\0';
	minute = atoi(Parameter[3]);
	sprintf(Parameter[3], "%d", minute);
	memcpy(Parameter[4], &(date_time[12]), 2);
	Parameter[4][2] = '\0';
	second = atoi(Parameter[4]);
	sprintf(Parameter[4], "%d", second);
	sprintf(Parameter[5], "%d", Selected_AMPM);
	date_time[2] = '\0';
	Selected_Month = atoi(date_time);
	sprintf(Parameter[6], "%d", Selected_Month);
	Get_System_Time_Zone(Selected_Timezone, sizeof(Selected_Timezone));
}

int do_quick03_main(INPUT *input, int quick_select)
{

	show_quick03_header(quick_select);

//      CGI_Debug_Input(input);
	show_server_time();
	/* put your code here */
	CGI_Output_Html1(QUICK03_MAIN_HTML, "$", quick03_replace, input);
	show_quick03_tail();
	return QUICK_SUCCESS;
}


void do_quick03_next(INPUT *input)
{
	char date_time[BUF_SIZE] = "";
	char Selected_Timezone_tmp[BUF_SIZE] = "";
	INPUT *p;
	int i;
	int year, month, day, hour, minute, second;

	Get_Current_Date_Time(date_time);

	p = CGI_Find_Parameter(input, "TIMEZONE");
	i = atoi(p->val);
	//Set_System_Time_Zone(timezone_Windows[i]);//Shone
	
	Get_System_Time_Zone(Selected_Timezone_tmp, sizeof(Selected_Timezone_tmp));
	if(strcmp(Selected_Timezone_tmp,timezone_Windows[i]))
	{
		Set_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_TIME_ZONE, timezone_Windows[i], QUICK_CONF_FILE);//Shone modified 2005,09,29
		set_initial_flag(1);
	}
	else
		clear_tmp_field(QUICK_SETUP_SECTION,FIELD_QS_TIME_ZONE);
	
	if((p = CGI_Find_Parameter(input, "CHANGE_DATE")) != NULL) 
	{
		p = (INPUT *) CGI_Find_Parameter(input, "YEAR");
		year = atoi(p->val);
		p = (INPUT *) CGI_Find_Parameter(input, "MONTH");
		month = atoi(p->val);
		p = (INPUT *) CGI_Find_Parameter(input, "DAY");
		day = atoi(p->val);
		p = (INPUT *) CGI_Find_Parameter(input, "AMPM");
		i = atoi(p->val);
		p = (INPUT *) CGI_Find_Parameter(input, "HOUR");
		hour = atoi(p->val);
		if (i == 1) {
			if (hour < 12) hour += 12;
		}
		else {
			if (hour == 12) hour = 0;
		}
		p = CGI_Find_Parameter(input, "MINUTE");
		minute = atoi(p->val);
		p = CGI_Find_Parameter(input, "SECOND");
		second = atoi(p->val);
		sprintf(date_time, "%02d%02d%04d%02d%02d%02d", month, day, year, hour, minute, second);
		
		Set_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_TIME, date_time, QUICK_CONF_FILE);//Shone 2005,09,29
		set_initial_flag(1);
		//Set_Current_Date_Time(date_time);
	}
	else 
	{
		clear_tmp_field(QUICK_SETUP_SECTION,FIELD_QS_TIME);
		//if (strlen(date_time) > 0)
		//	Set_Current_Date_Time(date_time);
	}
	if((p = CGI_Find_Parameter(input, "CONFIGURE_NTP")) != NULL)
        {
		int interval = 0;
		char ip_address[IP_ADDRESS_LENGTH]="";
		char time_unit[10] = "",server_addr_origin[IP_ADDRESS_LENGTH]="",interval_origin[10]="";
		int  record_flag=0;

		if(!NTP_Is_Server_Used())
			record_flag=1;
		p = (INPUT *) CGI_Find_Parameter(input, "SPECIFIC_SERVER");
		if(p!=NULL)
		{
			NTP_Get_Server_IP(ip_address, sizeof(ip_address));
			if(strcasecmp(ip_address,p->val))
				record_flag=1;
			else
				clear_tmp_field(QUICK_SETUP_SECTION,FIELD_QS_TIME_NTP);

			strcpy(server_addr_origin,p->val);
		}

		p = (INPUT *) CGI_Find_Parameter(input, "INTERVAL");
		if(p!=NULL)
		{
			NTP_Get_Interval(&interval);
			if(atoi(p->val)!=interval || record_flag==1)
				record_flag=1;
			else
				clear_tmp_field(QUICK_SETUP_SECTION,FIELD_QS_TIME_GAP);

			strcpy(interval_origin,p->val);
		}
		
		p = (INPUT *) CGI_Find_Parameter(input, "INTERVAL_TYPE");
		if(p!=NULL)
		{
			NTP_Get_Interval_Unit(time_unit, sizeof(time_unit));
			
			switch(atoi(p->val))
			{
				case 0:	if(strcasecmp(time_unit, "MINUTE"))
					{
						strcpy(time_unit,"MINUTE");
						record_flag=1;
					}
					else
						clear_tmp_field(QUICK_SETUP_SECTION,FIELD_QS_TIME_UNIT);
					break;
				case 1:	if(strcasecmp(time_unit, "HOUR"))
                                        {
						strcpy(time_unit,"HOUR");
						record_flag=1;
					}
					else
                                                clear_tmp_field(QUICK_SETUP_SECTION,FIELD_QS_TIME_UNIT);
					break;
				case 2:	if(strcasecmp(time_unit, "DAY"))
                                        {
						strcpy(time_unit,"DAY");
						record_flag=1;
					}
					else
						clear_tmp_field(QUICK_SETUP_SECTION,FIELD_QS_TIME_UNIT);
					break;
				default : 
					//Set_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_TIME_UNIT, "MINUTE");
					break;
			}
		}	
		if(record_flag)
		{
			Set_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_TIME_NTP, server_addr_origin, QUICK_CONF_FILE);//Shone 2005,09,29
			Set_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_TIME_GAP, interval_origin, QUICK_CONF_FILE);
			Set_Private_Profile_String(QUICK_SETUP_SECTION, FIELD_QS_TIME_UNIT,time_unit, QUICK_CONF_FILE);
			set_initial_flag(1);
		}
	}
	else
	{
		clear_tmp_field(QUICK_SETUP_SECTION,FIELD_QS_TIME_NTP);
		clear_tmp_field(QUICK_SETUP_SECTION,FIELD_QS_TIME_GAP);
		clear_tmp_field(QUICK_SETUP_SECTION,FIELD_QS_TIME_UNIT);
	}
}


int do_quick03_main_submit(INPUT *input, int quick_select)
{
	int	btn;
	int	ret=QUICK_SUCCESS;
	INPUT *p = NULL;
	char ip_address[IP_ADDRESS_LENGTH];

	btn=get_btn(input);
	switch (btn)
	{
		case QUICK_BTN_NEXT:
			/* put your "next button" code here */

			do_quick03_next(input);
			do_quick03_1_main(input, quick_select+1);
			break;
		case QUICK_BTN_TEST:
			if((p = (INPUT *) CGI_Find_Parameter(input, "SPECIFIC_SERVER")) != NULL) {
				strncpy(ip_address, p->val, sizeof(ip_address));
				if(SUCCESS == NTP_Test_Server(ip_address)) {
					test_status = 1;
				}
				else {
					test_status = -1;
				}
			}
			do_quick03_main(input, quick_select);
			break;

		case QUICK_BTN_BACK:
			/* put your "back button" code here */
			do_quick02_main(input, quick_select-1);
			break;
	}
	return ret;
}
