#include <stdio.h>
#include <string.h>

/* NAS include file */
#include <cgi.h>
#include <v2_menu.h>
#include <cfg_nic.h>

/* local include */
#include "quick.h"
#include "quick00.h"
#include "quick01.h"

int quick00_replace(FILE *fptr, char *name, void *arg)
{
	if (!strcmp(name, "quick00_str")){
		if ( ((2==NIC_Count_Interface()) && (!NIC_Is_Bonding_Support())) || ((3==NIC_Count_Interface()) && (!NIC_Is_Bonding_Support())))
			fprintf(fptr, "QUICK00_STR06");
		else
			fprintf(fptr, "QUICK00_STR061");
	}
        else
        	return CGI_REPLACE_FAIL;
        return CGI_REPLACE_OK;
}

int show_quick00_header(int quick_select)
{
        HEADER_ITEM     header;
	static char* 	quick_defs[]={QUICK_DEFS};

        CGI_Output_Html1(QUICK_HEADER_HTML, "$", quick00_replace, NULL);
        header.back[0]=0x0;
        header.home[0]=0x0;
        header.logout[0]=0x0;
	if(Is_Version_22())
	        CGI_Get_Help(header.help, "help_quick.html#help_qconfig_welcome");
	else
		CGI_Get_Help(header.help, "help_qconfig_welcome.html");
        CGI_Show_Menu_V3_1(FUNC_QUICK, &header);
        CGI_Output_Html1(MENU_V3_HEADER_HTML, "$", quick00_replace, NULL);
        CGI_Show_Menu_V3_2(quick_defs[get_quick_def()], quick_select);
        CGI_Output_Html1(MENU_V3_MIDDLE_HTML, "$", quick00_replace, NULL);
        return 1;
}

int show_quick00_tail()
{
        CGI_Output_Html1(MENU_V3_TAIL_HTML, "$", quick00_replace, NULL);
        CGI_Output_Html1(QUICK_TAIL_HTML, "$", quick00_replace, NULL);
        return 1;
}

int do_quick00_main(INPUT *input, int quick_select)
{
	show_quick00_header(quick_select);

	/* put your code here */
	CGI_Output_Html1(QUICK00_MAIN_HTML, "$", quick00_replace, NULL);

	show_quick00_tail();
	return QUICK_SUCCESS;
}




int do_quick00_main_submit(INPUT *input, int quick_select)
{
	int	btn;
	int	ret=QUICK_SUCCESS;
	btn=get_btn(input);
	switch (btn)
	{
		case QUICK_BTN_CONTINUE:
			/* put your "next button" code here */
			do_quick01_main(input, quick_select+1);
			break;

	}
	return ret;
}
